/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.data.readservice.ReadParmsDelimitedAPI;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;

public class SetLoadFormat
extends CommandListener
implements IShowCommand,
IShowPrefixNameNewline {
    private static final String CSV = "csv";
    private static final String DSV = "dsv";
    private static final String DELIMITED = "delimited";
    private static final String HTML = "html";
    private static final String INSERT = "insert";
    private static final String JSON = "json";
    private static final String JSON_FORMATTED = "json-formatted";
    private static final String JSON_FORMATTED_ALIAS = "json_formatted";
    private static final String LOADER = "loader";
    private static final String T2 = "t2";
    private static final String XML = "xml";
    private static final String DELIMITER = "delimiter";
    private static final String DELIM = "delim";
    private static final String ENCLOSURE_LEFT = "enclosure_left";
    private static final String ENCLOSURELEFT = "enclosureleft";
    private static final String LEFT = "left";
    private static final String ENCLOSURE_RIGHT = "enclosure_right";
    private static final String ENCLOSURERIGHT = "enclosureright";
    private static final String RIGHT = "right";
    private static final String ENCLOSURES = "enclosures";
    private static final String ENCODING = "encoding";
    private static final String ROW_LIMIT = "row_limit";
    private static final String ROWLIMIT = "rowlimit";
    private static final String LIMIT = "limit";
    private static final String FORMAT = "format";
    private static final String HEADER = "column_names";
    private static final String HEADER_ALIAS = "columnnames";
    private static final String HEAD = "names";
    private static final String HEADER_AFTER = "skip_before_names";
    private static final String HEADERAFTER = "skipbeforenames";
    private static final String HEADER_BEFORE = "skip_after_names";
    private static final String HEADERBEFORE = "skipafternames";
    private static final String AFTER = "after";
    private static final String BEFORE = "before";
    private static final String IS_ROW_LIMIT = "is_row_limit";
    private static final String ISROWLIMIT = "isrowlimit";
    private static final String ISLIMIT = "islimit";
    private static final String TERM = "term";
    private static final String LINE_TERMINATOR = "row_terminator";
    private static final String LINETERMINATOR = "rowterminator";
    private static final String MAX_LENGTH = "max_length";
    private static final String MAXLENGTH = "maxlength";
    private static final String SKIP_ROWS = "skip_rows";
    private static final String SKIPROWS = "skiprows";
    private static final String SKIP = "skip";
    private static final String DEFAULT = "default";
    private static final String DQUOTE = "\"";
    private static final String SQUOTE = "'";
    private static final String ON = "on";
    private static final String OFF = "off";
    private static final String NL = "\n";
    private static final String CR = "\r";
    private static final String CRLF = "\r\n";
    private static final String LF = "\n";
    private static final String SCR = "CR";
    private static final String SLF = "LF";
    private static final String SCRLF = "CRLF";
    private static final String SPACE = " ";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("setloadformat")) {
            return false;
        }
        String[] parts = cmd.getSQLOrig().split(SPACE);
        if (parts.length < 3 || parts.length == 3 && parts[2].equalsIgnoreCase(DEFAULT)) {
            ctx.write(Messages.getString("LOADFORMATCLEARED"));
            ctx.putProperty("load.format.options", null);
            ctx.putProperty("load.format", CSV);
            return true;
        }
        ReadParmsDelimitedAPI.Builder delimParmsBuilder = (ReadParmsDelimitedAPI.Builder)ctx.getProperty("load.format.options");
        if (delimParmsBuilder == null) {
            delimParmsBuilder = new ReadParmsDelimitedAPI.Builder();
            ctx.putProperty("load.format", CSV);
        }
        String[] bits = cmd.getSql().split("\\s+");
        int skip = 2;
        while (bits != null && bits.length > 0) {
            try {
                switch (bits[skip].toLowerCase()) {
                    case "csv": 
                    case "dsv": 
                    case "delimited": {
                        ctx.putProperty("load.format", CSV);
                        ctx.putProperty("load.format.options", delimParmsBuilder);
                        bits = this.nextBits(bits, skip + 1);
                        break;
                    }
                    case "delimiter": 
                    case "delim": {
                        if (bits.length < skip + 2) {
                            if (cmd.getStatementTerminator() == null) {
                                this.writeFormatMissing(ctx, bits[2]);
                                return true;
                            }
                            delimParmsBuilder.delimiter(cmd.getStatementTerminator());
                        } else {
                            delimParmsBuilder.delimiter(bits[skip + 1]);
                        }
                        ctx.putProperty("load.format.options", delimParmsBuilder);
                        bits = this.nextBits(bits, skip + 2);
                        break;
                    }
                    case "enclosure_left": 
                    case "enclosureleft": 
                    case "left": {
                        if (bits.length < skip + 2) {
                            this.writeFormatMissing(ctx, bits[skip]);
                            return true;
                        }
                        if (bits[skip + 1].equalsIgnoreCase(OFF)) {
                            delimParmsBuilder.enclosureLeft(null);
                        } else {
                            delimParmsBuilder.enclosureLeft(bits[skip + 1]);
                        }
                        ctx.putProperty("load.format.options", delimParmsBuilder);
                        bits = this.nextBits(bits, skip + 2);
                        break;
                    }
                    case "enclosure_right": 
                    case "enclosureright": 
                    case "right": {
                        if (bits.length < skip + 2) {
                            this.writeFormatMissing(ctx, bits[skip]);
                            return true;
                        }
                        if (bits[skip + 1].equalsIgnoreCase(OFF)) {
                            delimParmsBuilder.enclosureRight(null);
                        } else {
                            delimParmsBuilder.enclosureRight(bits[skip + 1]);
                        }
                        ctx.putProperty("load.format.options", delimParmsBuilder);
                        bits = this.nextBits(bits, skip + 2);
                        break;
                    }
                    case "enclosures": {
                        if (bits.length < skip + 2) {
                            this.writeFormatMissing(ctx, bits[skip]);
                            return true;
                        }
                        if (bits[skip + 1].equalsIgnoreCase(OFF)) {
                            delimParmsBuilder.enclosures(null);
                        } else if (bits[skip + 1].length() == 1) {
                            delimParmsBuilder.enclosureLeft(bits[skip + 1]);
                            delimParmsBuilder.enclosureRight(bits[skip + 2]);
                        } else {
                            delimParmsBuilder.enclosureLeft(bits[skip + 1].substring(0, 1));
                            delimParmsBuilder.enclosureRight(bits[skip + 1].substring(1, 2));
                        }
                        ctx.putProperty("load.format.options", delimParmsBuilder);
                        bits = this.nextBits(bits, skip + 2);
                        break;
                    }
                    case "encoding": {
                        if (bits.length < skip + 2) {
                            this.writeFormatMissing(ctx, bits[skip]);
                            return true;
                        }
                        if (bits[skip + 1].equals("\"\"")) {
                            delimParmsBuilder.encoding(null);
                        } else if (bits[skip + 1].equalsIgnoreCase(OFF)) {
                            delimParmsBuilder.encoding(null);
                        } else {
                            delimParmsBuilder.encoding(bits[skip + 1]);
                        }
                        ctx.putProperty("load.format.options", delimParmsBuilder);
                        bits = this.nextBits(bits, skip + 2);
                        break;
                    }
                    case "html": {
                        ctx.putProperty("load.format", bits[skip]);
                        bits = this.nextBits(bits, skip + 1);
                        break;
                    }
                    case "insert": {
                        ctx.putProperty("load.format", bits[skip]);
                        bits = this.nextBits(bits, skip + 1);
                        break;
                    }
                    case "json": {
                        ctx.putProperty("load.format", bits[skip]);
                        bits = this.nextBits(bits, skip + 1);
                        break;
                    }
                    case "json-formatted": {
                        ctx.putProperty("load.format", bits[skip]);
                        bits = this.nextBits(bits, skip + 1);
                        break;
                    }
                    case "json_formatted": {
                        ctx.putProperty("load.format", JSON_FORMATTED);
                        bits = this.nextBits(bits, skip + 1);
                        break;
                    }
                    case "loader": {
                        ctx.putProperty("load.format", bits[skip]);
                        bits = this.nextBits(bits, skip + 1);
                        break;
                    }
                    case "row_limit": 
                    case "rowlimit": 
                    case "limit": {
                        int val;
                        if (bits.length < skip + 2) {
                            this.writeFormatMissing(ctx, bits[skip]);
                            return true;
                        }
                        try {
                            if (bits[skip + 1].equals("\"\"")) {
                                delimParmsBuilder.limitRows(new Integer(-1));
                            } else if (bits[skip + 1].equalsIgnoreCase(OFF)) {
                                delimParmsBuilder.limitRows(new Integer(-1));
                            } else {
                                val = new Integer(bits[skip + 1]);
                                if (val < 0) {
                                    this.writeFormatBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                    return true;
                                }
                                delimParmsBuilder.limitRows(val);
                            }
                            ctx.putProperty("load.format.options", delimParmsBuilder);
                        }
                        catch (Exception e) {
                            this.writeFormatBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                            return true;
                        }
                        bits = this.nextBits(bits, skip + 2);
                        break;
                    }
                    case "column_names": 
                    case "columnnames": 
                    case "names": {
                        if (bits.length < skip + 2) {
                            this.writeFormatMissing(ctx, bits[skip]);
                            return true;
                        }
                        if (!bits[skip + 1].equalsIgnoreCase(ON) && !bits[skip + 1].equalsIgnoreCase(OFF)) {
                            this.writeFormatBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                            return true;
                        }
                        delimParmsBuilder.header(bits[skip + 1].equalsIgnoreCase(ON));
                        ctx.putProperty("load.format.options", delimParmsBuilder);
                        bits = this.nextBits(bits, skip + 2);
                        break;
                    }
                    case "skip_after_names": 
                    case "skipafternames": 
                    case "before": {
                        delimParmsBuilder.headerBeforeSkip(true);
                        ctx.putProperty("load.format.options", delimParmsBuilder);
                        bits = this.nextBits(bits, skip + 1);
                        break;
                    }
                    case "skip_before_names": 
                    case "skipbeforenames": 
                    case "after": {
                        delimParmsBuilder.headerBeforeSkip(false);
                        ctx.putProperty("load.format.options", delimParmsBuilder);
                        bits = this.nextBits(bits, skip + 1);
                        break;
                    }
                    case "row_terminator": 
                    case "rowterminator": 
                    case "term": {
                        if (bits.length < skip + 2) {
                            if (cmd.getStatementTerminator() == null) {
                                this.writeFormatMissing(ctx, bits[2]);
                                return true;
                            }
                            delimParmsBuilder.lineEnd(cmd.getStatementTerminator());
                        } else {
                            String str = bits[skip + 1];
                            if (str.equalsIgnoreCase("\"\"") || str.equalsIgnoreCase(DEFAULT)) {
                                delimParmsBuilder.lineEnd(null);
                            } else if (str.equalsIgnoreCase(SCR)) {
                                delimParmsBuilder.lineEnd(CR);
                            } else if (str.equalsIgnoreCase(SCRLF)) {
                                delimParmsBuilder.lineEnd(CRLF);
                            } else if (str.equalsIgnoreCase(SLF)) {
                                delimParmsBuilder.lineEnd("\n");
                            } else {
                                delimParmsBuilder.lineEnd(str);
                            }
                        }
                        ctx.putProperty("load.format.options", delimParmsBuilder);
                        bits = this.nextBits(bits, skip + 2);
                        break;
                    }
                    case "max_length": 
                    case "maxlength": {
                        int val;
                        if (bits.length < skip + 2) {
                            this.writeFormatMissing(ctx, bits[skip]);
                            return true;
                        }
                        try {
                            val = new Integer(bits[skip + 1]);
                            if (val < 0) {
                                this.writeFormatBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                return true;
                            }
                            delimParmsBuilder.lineMax(val);
                            ctx.putProperty("load.format.options", delimParmsBuilder);
                        }
                        catch (Exception e) {
                            this.writeFormatBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                            return true;
                        }
                        bits = this.nextBits(bits, skip + 2);
                        break;
                    }
                    case "skip_rows": 
                    case "skiprows": 
                    case "skip": {
                        int val;
                        if (bits.length < skip + 2) {
                            this.writeFormatMissing(ctx, bits[skip]);
                            return true;
                        }
                        try {
                            if (bits[skip + 1].equals("\"\"")) {
                                delimParmsBuilder.skipRows(0);
                            } else if (bits[skip + 1].equalsIgnoreCase(OFF)) {
                                delimParmsBuilder.skipRows(0);
                            } else {
                                val = new Integer(bits[skip + 1]);
                                if (val < 0) {
                                    this.writeFormatBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                    return true;
                                }
                                delimParmsBuilder.skipRows(val);
                            }
                            ctx.putProperty("load.format.options", delimParmsBuilder);
                        }
                        catch (Exception e) {
                            this.writeFormatBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                            return true;
                        }
                        bits = this.nextBits(bits, skip + 2);
                        break;
                    }
                    case "t2": {
                        ctx.putProperty("load.format", bits[skip]);
                        bits = this.nextBits(bits, skip + 1);
                        break;
                    }
                    case "xml": {
                        ctx.putProperty("load.format", bits[skip]);
                        bits = this.nextBits(bits, skip + 1);
                        break;
                    }
                    default: {
                        ctx.write(MessageFormat.format(Messages.getString("LOADOPTIONINVALID"), bits[skip].toLowerCase()) + "\n");
                        return true;
                    }
                }
            }
            catch (Exception e) {
                this.writeFormatBad(ctx, bits.length > 0 ? bits[skip] : "");
                return true;
            }
            skip = 0;
        }
        return true;
    }

    private void writeFormatMissing(ScriptRunnerContext ctx, String option) {
        ctx.write(MessageFormat.format(Messages.getString("LOADMISSINGVALUE"), option) + "\n");
    }

    private void writeFormatBad(ScriptRunnerContext ctx, String option) {
        ctx.write(MessageFormat.format(Messages.getString("LOADFORMATBAD"), option) + "\n");
    }

    private String unQuote(String word) {
        if (word.startsWith(SQUOTE) && word.endsWith(SQUOTE)) {
            return word.substring(1, word.length() - 1);
        }
        if (word.startsWith(DQUOTE) && word.endsWith(DQUOTE)) {
            return word.substring(1, word.length() - 1);
        }
        return word;
    }

    private String[] nextBits(String[] bits, int skip) {
        if (bits.length > skip) {
            String[] rtn = new String[bits.length - skip];
            for (int j = 0; rtn.length > j; ++j) {
                rtn[j] = bits[j + skip];
            }
            return rtn;
        }
        return null;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("show") && cmd.getSql().trim().toLowerCase().replaceAll(SPACE, "").startsWith("showloadformat")) {
            ReadParmsDelimitedAPI.Builder delimParmsBuilder = null;
            if (ctx.getProperties().get("load.format") == null) {
                ctx.putProperty("load.format", CSV);
            }
            delimParmsBuilder = ctx.getProperties().containsKey("load.format.options") && ctx.getProperties().get("load.format.options") != null ? (ReadParmsDelimitedAPI.Builder)ctx.getProperty("load.format.options") : new ReadParmsDelimitedAPI.Builder();
            ReadParmsDelimitedAPI delimParms = delimParmsBuilder.build();
            SetLoadFormat.showParms(ctx, delimParms);
            return true;
        }
        return false;
    }

    public static String getParmsAsSet(ScriptRunnerContext ctx) {
        return SetLoadFormat.getParms(ctx, SetLoadFormat.getParmsAPI(ctx), "set loadformat ");
    }

    public static void showParms(ScriptRunnerContext ctx) {
        SetLoadFormat.showParms(ctx, SetLoadFormat.getParmsAPI(ctx), "");
    }

    public static void showParms(ScriptRunnerContext ctx, ReadParmsDelimitedAPI delimParms, String cmdPrefix) {
        ctx.write(SetLoadFormat.getParms(ctx, delimParms, cmdPrefix));
        ctx.write("");
    }

    public static void showParms(ScriptRunnerContext ctx, ReadParmsDelimitedAPI delimParms) {
        ctx.write(SetLoadFormat.getParms(ctx, delimParms, ""));
        ctx.write("");
    }

    public static String getParms(ScriptRunnerContext ctx, ReadParmsDelimitedAPI delimParms, String cmdPrefix) {
        boolean isPretty = cmdPrefix == null && !cmdPrefix.isEmpty();
        String f = isPretty ? "format " : "";
        String fmt = (String)ctx.getProperty("load.format");
        String format = "\n" + cmdPrefix + f + fmt + "\n" + (isPretty ? "\n" : "");
        if (fmt.equals(CSV) || fmt.equals(DSV)) {
            format = format + cmdPrefix + HEADER + SPACE + (delimParms.isHeader() ? ON : OFF) + "\n";
            format = format + cmdPrefix + DELIMITER + SPACE + delimParms.getDelimiter() + "\n";
            format = delimParms.getEnclosureLeft() == null || delimParms.getEnclosureLeft().equals("") ? format + cmdPrefix + ENCLOSURES + SPACE + OFF + "\n" : format + cmdPrefix + ENCLOSURES + SPACE + delimParms.getEnclosureLeft() + (delimParms.getEnclosureRight() == null || delimParms.getEnclosureRight() == "" ? delimParms.getEnclosureLeft() : delimParms.getEnclosureRight()) + "\n";
            format = format + cmdPrefix + ENCODING + SPACE + delimParms.getEncoding() + "\n";
            format = format + cmdPrefix + ROW_LIMIT + SPACE + (delimParms.getLimitRows() == -1 ? OFF : new Integer(delimParms.getLimitRows()).toString()) + "\n";
            String term = SetLoadFormat.getTerm(delimParms);
            format = format + cmdPrefix + LINE_TERMINATOR + SPACE + term + "\n";
            format = format + cmdPrefix + SKIP_ROWS + SPACE + new Integer(delimParms.getSkipRows()).toString() + "\n";
            format = delimParms.isHeaderBeforeSkip() ? format + cmdPrefix + HEADER_BEFORE + "\n" : format + cmdPrefix + HEADER_AFTER + "\n";
        }
        return format;
    }

    public static void showParmsUnload(ScriptRunnerContext ctx, ReadParmsDelimitedAPI delimParms) {
        String fmt = (String)ctx.getProperty("load.format");
        String format = "\nformat " + fmt + "\n";
        if (fmt.equals(CSV) || fmt.equals(DSV)) {
            format = format + "\ncolumn_names " + (delimParms.isHeader() ? ON : OFF) + "\n";
            format = format + "delimiter " + delimParms.getDelimiter() + "\n";
            format = delimParms.getEnclosureLeft() == null || delimParms.getEnclosureLeft().equals("") ? format + "enclosures off\n" : format + "enclosures " + delimParms.getEnclosureLeft() + (delimParms.getEnclosureRight() == null || delimParms.getEnclosureRight() == "" ? delimParms.getEnclosureLeft() : delimParms.getEnclosureRight() + "\n");
            format = format + "encoding " + delimParms.getEncoding() + "\n";
            String term = SetLoadFormat.getTerm(delimParms);
            format = format + "row_terminator " + term + "\n";
        } else if (fmt.equals(INSERT)) {
            String term = SetLoadFormat.getTerm(delimParms);
            format = format + "row_terminator " + term + "\n";
        }
        ctx.write(format);
        ctx.write("");
    }

    public static ReadParmsDelimitedAPI getParmsAPI(ScriptRunnerContext ctx) {
        ReadParmsDelimitedAPI.Builder delimParmsBuilder = null;
        if (ctx.getProperties().get("load.format") == null) {
            ctx.putProperty("load.format", CSV);
        }
        delimParmsBuilder = ctx.getProperties().containsKey("load.format.options") && ctx.getProperties().get("load.format.options") != null ? (ReadParmsDelimitedAPI.Builder)ctx.getProperty("load.format.options") : new ReadParmsDelimitedAPI.Builder();
        ReadParmsDelimitedAPI delimParms = delimParmsBuilder.build();
        return delimParms;
    }

    private static String getTerm(ReadParmsDelimitedAPI delimParms) {
        String term = delimParms.getTerminator();
        if (term == null) {
            term = DEFAULT;
        } else if (term.equals(CR)) {
            term = SCR;
        } else if (term.equals(CRLF)) {
            term = SCRLF;
        } else if (term.equals("\n")) {
            term = SLF;
        }
        return term;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"loadformat"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

