/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Stack;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.util.Logger;

public class SetErrorLogging
extends AForAllStmtsCommand
implements IHelp,
Connected {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_ERROR_LOGGING;
    private static final String TRUNCATE = "truncate";
    private static final String TABLE = "table";
    private static final String IDENTIFIER = "identifier";
    private static final String SP2_1507 = "SP2-1507: Errorlogging table, role or privilege is missing or not accessible if its not\n";
    private static final String SP2_1509 = "SP2-1509: Invalid option for SET ERRORLOGGING ON\n";
    private static final String SP2_1508 = "SP2-1508: Invalid option for SET ERRORLOGGING OFF\n";
    private static final String SP2_0640 = "SP2-0640: Not connected\n";
    private static String defaultErrorTableName = "SPERRORLOG";
    private static String spErrorLogDDl = "CREATE TABLE SPERRORLOG ( \"USERNAME\" VARCHAR2(256),\"TIMESTAMP\" TIMESTAMP (6),\t\"SCRIPT\" CLOB,  \"IDENTIFIER\" VARCHAR2(256),\t\"MESSAGE\" CLOB, \"STATEMENT\" CLOB   ) ";
    private static String TABLEEXISTSSQL = "SELECT TABLE_NAME FROM ALL_TABLES WHERE UPPER(OWNER)=UPPER(:OWNER) AND UPPER(TABLE_NAME)=UPPER(:TABLENAME)";
    private static String VIEWEXISTSSQL = "SELECT VIEW_NAME FROM ALL_VIEWS WHERE UPPER(OWNER)=UPPER(:OWNER) AND UPPER(VIEW_NAME)=UPPER(:VIEWNAME)";
    private static String TABLETRUNCATE = "TRUNCATE TABLE {0}.{1}";
    private boolean cmdState;
    private String errorTableName = "";
    private boolean errorTableTruncate = false;
    private String errorIdentifier = "";
    private int nosParams = 0;

    public SetErrorLogging() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getSql().toLowerCase().contains("errorl")) {
            boolean on = (Boolean)ctx.getProperty("sqlplus.error.logging");
            try {
                if (conn != null && !conn.isClosed()) {
                    boolean parseCommand = this.parseCommand(ctx, cmd.getSql());
                    if (parseCommand) {
                        if (!this.cmdState && this.nosParams > 3) {
                            ctx.write(SP2_1508);
                            return true;
                        }
                        if (!this.cmdState) {
                            ctx.putProperty("sqlplus.error.logging", Boolean.FALSE);
                            ctx.removeProperty("sqlplus.error.logging.identifier");
                            ctx.removeProperty("sqlplus.error.logging.schema");
                            ctx.removeProperty("sqlplus.error.logging.table");
                            ctx.removeProperty("sqlplus.error.logging.displayschematable");
                            return true;
                        }
                        if (this.errorIdentifier.length() > 0) {
                            ctx.putProperty("sqlplus.error.logging.identifier", this.errorIdentifier);
                        } else if (!on) {
                            ctx.putProperty("sqlplus.error.logging.identifier", "");
                        }
                        String schema = conn.getSchema();
                        String displaySchemaTable = this.errorTableName;
                        if (this.errorTableName.contains(".")) {
                            schema = this.errorTableName.substring(0, this.errorTableName.indexOf(46));
                            this.errorTableName = this.errorTableName.substring(this.errorTableName.indexOf(46) + 1);
                        }
                        if (!on && this.errorTableName.equals("")) {
                            this.errorTableName = defaultErrorTableName;
                        }
                        HashMap<String, String> binds = new HashMap<String, String>();
                        binds.put("OWNER", schema);
                        binds.put("TABLENAME", this.errorTableName);
                        String tablename = DBUtil.getInstance(conn).executeReturnOneCol(TABLEEXISTSSQL, binds);
                        binds.put("VIEWNAME", this.errorTableName);
                        if (tablename == null) {
                            tablename = DBUtil.getInstance(conn).executeReturnOneCol(VIEWEXISTSSQL, binds);
                        }
                        if (tablename == null && this.errorTableName.equalsIgnoreCase(defaultErrorTableName)) {
                            DBUtil.getInstance(conn).execute(spErrorLogDDl);
                            if (DBUtil.getInstance(conn).getLastException() != null) {
                                ctx.write(SP2_1507);
                                return true;
                            }
                            ctx.putProperty("sqlplus.error.logging", Boolean.TRUE);
                            ctx.putProperty("sqlplus.error.logging.table", defaultErrorTableName);
                            ctx.putProperty("sqlplus.error.logging.schema", conn.getSchema());
                            ctx.putProperty("sqlplus.error.logging.displayschematable", displaySchemaTable);
                        } else if (tablename != null && tablename.equalsIgnoreCase(this.errorTableName)) {
                            ctx.putProperty("sqlplus.error.logging", Boolean.TRUE);
                            ctx.putProperty("sqlplus.error.logging.table", tablename);
                            ctx.putProperty("sqlplus.error.logging.schema", schema.toUpperCase());
                            ctx.putProperty("sqlplus.error.logging.displayschematable", displaySchemaTable);
                        } else if (!on) {
                            ctx.write(SP2_1507);
                            ctx.putProperty("sqlplus.error.logging", Boolean.FALSE);
                            return true;
                        }
                        if (this.errorTableTruncate) {
                            String tschema = conn.getSchema();
                            if (ctx.getProperty("sqlplus.error.logging.schema") != null) {
                                tschema = ctx.getProperty("sqlplus.error.logging.schema").toString();
                            }
                            String sql = MessageFormat.format(TABLETRUNCATE, tschema, ctx.getProperty("sqlplus.error.logging.table"));
                            DBUtil.getInstance(conn).execute(sql);
                        }
                    } else if (this.cmdState) {
                        ctx.write(SP2_1509);
                        ctx.write(this.getHelp());
                    } else {
                        ctx.write(SP2_1508);
                    }
                } else {
                    ctx.write(SP2_0640);
                }
            }
            catch (SQLException e) {
                Logger.fine(this.getClass(), e);
            }
            this.resetParams();
            return true;
        }
        this.resetParams();
        return false;
    }

    private boolean parseCommand(ScriptRunnerContext ctx, String sql) {
        int i;
        boolean on = (Boolean)ctx.getProperty("sqlplus.error.logging");
        String[] tokens = sql.split("\\s+");
        Stack<String> st = new Stack<String>();
        for (i = tokens.length - 1; i >= 0; --i) {
            st.add(tokens[i]);
        }
        block5: for (i = 0; i < tokens.length; ++i) {
            String token = null;
            switch (i) {
                case 0: 
                case 1: {
                    st.pop();
                    continue block5;
                }
                case 2: {
                    token = (String)st.pop();
                    if (tokens[2].equalsIgnoreCase("on")) {
                        this.cmdState = true;
                        continue block5;
                    }
                    if (tokens[2].equalsIgnoreCase("off")) {
                        this.cmdState = false;
                        continue block5;
                    }
                    return false;
                }
                default: {
                    token = (String)st.pop();
                    if (token.equalsIgnoreCase(TABLE) && !st.isEmpty()) {
                        this.errorTableName = (String)st.pop();
                        ++i;
                        continue block5;
                    }
                    if (token.equalsIgnoreCase(TRUNCATE)) {
                        this.errorTableTruncate = true;
                        continue block5;
                    }
                    if (token.equalsIgnoreCase(IDENTIFIER) && !st.isEmpty()) {
                        this.errorIdentifier = (String)st.pop();
                        ++i;
                        continue block5;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean needsConnection() {
        return true;
    }

    @Override
    public String getCommand() {
        return "SETERRORL";
    }

    @Override
    public String getHelp() {
        String help = "SET ERRORL[OGGING] {ON | OFF} [TABLE [schema.]tablename] [TRUNCATE] [IDENTIFIER identifier]\n";
        return help;
    }

    @Override
    public boolean isSqlPlus() {
        return true;
    }

    private void resetParams() {
        this.errorTableName = "";
        this.errorTableTruncate = false;
        this.errorIdentifier = "";
    }
}

