/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class Help
extends CommandListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String command = (cmd.getLoweredTrimmedSQL() + " ").substring((cmd.getLoweredTrimmedSQL() + " ").indexOf(" ")).trim();
        try {
            String[] lines;
            String[] sets = command.split("\\s+");
            if (sets.length == 2 && sets[0].toLowerCase().equals("set")) {
                command = sets[0] + sets[1];
            }
            for (String line : lines = this.HelpOnOrIndex(command, ctx).split("\n")) {
                ctx.write(line + "\n");
            }
        }
        catch (Exception e) {
            ctx.write(e.getLocalizedMessage());
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return true;
    }

    private String HelpOnOrIndex(String in, ScriptRunnerContext ctx) throws Exception {
        if (in == null || in.equals("") || in.equalsIgnoreCase("help") || in.equalsIgnoreCase("index") || in.equalsIgnoreCase("all") || in.equalsIgnoreCase("?")) {
            return this.getHelpProperties("", ctx);
        }
        String help = "";
        help = help + this.getHelpProperties(in, ctx);
        return help;
    }

    private String getHelpProperties(String in, ScriptRunnerContext ctx) throws Exception {
        String retVal = null;
        Enumeration<String> tagsEnumeration = HelpMessages.getKeys();
        if (tagsEnumeration == null) {
            throw new Exception(Messages.getString("NO_HELP_KEYS"));
        }
        ArrayList<String> tags = Collections.list(tagsEnumeration);
        this.removeSetDetails(tags);
        for (IHelp h : CommandRegistry.getCommandsWithHelp()) {
            if (!h.isSqlPlus()) {
                tags.add(h.getCommand() + "*");
                continue;
            }
            tags.add(h.getCommand());
        }
        ArrayList<String> depdupeCommands = new ArrayList<String>(new LinkedHashSet<String>(tags));
        Collections.sort(depdupeCommands);
        if (in.equals("")) {
            depdupeCommands.remove("\n");
            depdupeCommands.remove("\n\n");
            depdupeCommands.remove(" ");
            retVal = this.getIndexList(ctx, depdupeCommands);
        } else if (in.length() > 0 && !tags.contains(in.toUpperCase()) && !in.startsWith("set")) {
            retVal = Messages.getString("LIST_OF_HELP_TOPICS");
            StringBuilder returnMeBuff = new StringBuilder();
            for (String mytag : tags) {
                String name = mytag.replace("_", " ");
                if (name.toUpperCase().equals(in.trim().toUpperCase()) || name.toUpperCase().equals(in.trim().toUpperCase() + "*")) {
                    IHelp localHelp;
                    retVal = HelpMessages.getString(in.replace(" ", "_").toUpperCase());
                    if (this.wasError(retVal)) {
                        retVal = HelpMessages.getString(in.replace(" ", "_").toUpperCase() + "*");
                    }
                    if (this.wasError(retVal) && (localHelp = CommandRegistry.getCommandWithHelp(in)) != null) {
                        retVal = localHelp.getHelp();
                    }
                    return retVal;
                }
                if (!name.toUpperCase().startsWith(in.toUpperCase())) continue;
                returnMeBuff.append("    ").append(name).append("\n");
            }
            if (returnMeBuff.length() > 0) {
                retVal = retVal + returnMeBuff.toString();
            } else {
                retVal = retVal + MessageFormat.format(Messages.getString("Help.ObjectNotFound"), in);
                retVal = retVal + this.getIndexList(ctx, depdupeCommands);
            }
        } else {
            IHelp localHelp;
            retVal = HelpMessages.getString(in.replace(" ", "_").toUpperCase());
            if (this.wasError(retVal)) {
                retVal = HelpMessages.getString(in.replace(" ", "_").toUpperCase() + "*");
            }
            if (this.wasError(retVal) && (localHelp = CommandRegistry.getCommandWithHelp(in)) != null) {
                retVal = localHelp.getHelp();
            }
            if (this.wasError(retVal)) {
                if (in != null && in.toUpperCase().startsWith("set")) {
                    retVal = HelpMessages.getString(in.replace(" ", "_").toUpperCase());
                    if (this.wasError(retVal)) {
                        retVal = HelpMessages.getString(in.replace(" ", "_").toUpperCase() + "*");
                    }
                    retVal = Messages.getString("Help.1") + retVal;
                } else {
                    retVal = this.getIndexList(ctx, depdupeCommands);
                }
            }
        }
        return retVal;
    }

    private boolean wasError(String retval) {
        return retval == null || retval.startsWith("!") && retval.endsWith("!");
    }

    private String getIndexList(ScriptRunnerContext ctx, List<String> depdupeCommands) throws IOException {
        String retVal = "";
        retVal = Messages.getString("LIST_OF_HELP_TOPICS");
        StringBuilder returnMeBuff = new StringBuilder();
        if (ctx.getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(ctx.getProperty("sqlplus.classic.mode").toString())) {
            int cols = 120;
            int maxlen = 0;
            for (String item : depdupeCommands) {
                if (item.length() <= maxlen) continue;
                maxlen = item.length();
            }
            int noscols = cols % (maxlen + 1);
            String output = "";
            String line = "";
            int col = 0;
            for (String item : depdupeCommands) {
                if (col >= noscols) {
                    output = output + line + "\n";
                    line = "";
                    col = 0;
                }
                String pad = new String(new char[maxlen - item.length()]).replace('\u0000', ' ');
                line = line + item + pad;
                ++col;
            }
            if (line.length() > 0) {
                output = output + line + "\n";
            }
            retVal = retVal + output;
        } else {
            for (String mytag : depdupeCommands) {
                String name = mytag.replace("_", " ");
                if (name.endsWith("*")) {
                    name = this.highlightBold(name.replace("*", ""));
                }
                returnMeBuff.append("    ").append(name).append("\n");
            }
            retVal = retVal + this.printColumns(depdupeCommands, ctx);
            if (ctx.isCommandLine()) {
                retVal = retVal + "";
            }
        }
        return retVal;
    }

    public String highlightBold(String text) {
        return text;
    }

    private void removeSetDetails(ArrayList<String> tags) {
        Iterator<String> it = tags.iterator();
        ArrayList<String> tags2 = new ArrayList<String>();
        while (it.hasNext()) {
            String x = it.next();
            if (x.toLowerCase().startsWith("set")) continue;
            tags2.add(x);
        }
        tags2.add("SET");
        tags.clear();
        for (String tag : tags2) {
            tags.add(tag);
        }
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public String printColumns(Collection<? extends CharSequence> items, ScriptRunnerContext ctx) throws IOException {
        StringBuilder s = new StringBuilder();
        if (items == null || items.isEmpty()) {
            return "";
        }
        int width = 82;
        if (ctx.isCommandLine() && ctx.getSQLPlusConsoleReader().getWidth() > width) {
            width = ctx.getSQLPlusConsoleReader().getWidth();
        }
        int maxWidth = 0;
        for (CharSequence charSequence : items) {
            maxWidth = Math.max(maxWidth, charSequence.length());
        }
        StringBuilder buff = new StringBuilder();
        int n = width / (maxWidth += 3);
        int col = 0;
        for (CharSequence charSequence : items) {
            int i;
            String name = charSequence.toString();
            if (name.endsWith("*")) {
                name = this.highlightBold(name.replace("*", " "));
            }
            if (col < n) {
                buff.append(name);
                for (i = 0; i < maxWidth - charSequence.length(); ++i) {
                    buff.append(' ');
                }
                ++col;
                continue;
            }
            s.append(buff.toString() + "\n");
            buff.setLength(0);
            col = 0;
            buff.append(name);
            for (i = 0; i < maxWidth - charSequence.length(); ++i) {
                buff.append(' ');
            }
            ++col;
        }
        if (buff.length() > 0) {
            s.append(buff.toString());
        }
        return s.toString();
    }
}

