/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class Compute
extends CommandListener {
    private static final String m_lineSeparator = System.getProperty("line.separator");
    private static final List<String> m_cmptFuncSequence = Arrays.asList("AVG", "COUNT", "MINIMUM", "MAXIMUM", "NUMBER", "SUM", "STD", "VARIANCE");
    private static final String COMPUTE = "\\b(?i:comp(?:|u|ut|ute))\\b";
    private static final String FUNCTION = "\\b(?i:avg|cou(?:|nt)|min(?:|i|im|imu|imum)|max(?:|i|im|imu|imum)|num(?:|b|be|ber)|sum|std|var(?:|i|ia|ian|ianc|iance))\\b";
    private static final String LABEL = "\\s*((?i:lab(|e|el))\\s+(([^(\\p{Punct})(\\p{Space})]{1,500})|(\\\"[^\\\"]{1,498}\\\")|(\\'[^\\']{1,498}\\')))?(?:(\\r\\n|\\n|\\r|\\-|\\s)*)";
    private static final String OF = "(?i:of)";
    private static final String EXCEPT_ONOF = "(((\"((?!(?i:(on|of))).)*\")|('((?!(?i:(on|of))).)*')|([^\\s]+\\b(?<!\\b(?i:(on|of)))\\b))(\\s+)?)+";
    private static final String CMPT_ELEMENT = "(((\"((?!(?i:(on|of))).)*\")|('((?!(?i:(on|of))).)*')|([^\\s]+\\b(?<!\\b(?i:(on|of)))\\b))(\\s+)?)+";
    private static final String FUNC_EXPR = "(\\b(?i:avg|cou(?:|nt)|min(?:|i|im|imu|imum)|max(?:|i|im|imu|imum)|num(?:|b|be|ber)|sum|std|var(?:|i|ia|ian|ianc|iance))\\b\\s*((?i:lab(|e|el))\\s+(([^(\\p{Punct})(\\p{Space})]{1,500})|(\\\"[^\\\"]{1,498}\\\")|(\\'[^\\']{1,498}\\')))?(?:(\\r\\n|\\n|\\r|\\-|\\s)*))+";
    private static final String CMPT_EXPR = "(\\b(?i:avg|cou(?:|nt)|min(?:|i|im|imu|imum)|max(?:|i|im|imu|imum)|num(?:|b|be|ber)|sum|std|var(?:|i|ia|ian|ianc|iance))\\b\\s*((?i:lab(|e|el))\\s+(([^(\\p{Punct})(\\p{Space})]{1,500})|(\\\"[^\\\"]{1,498}\\\")|(\\'[^\\']{1,498}\\')))?(?:(\\r\\n|\\n|\\r|\\-|\\s)*))+(?i:of)\\s+(((\"((?!(?i:(on|of))).)*\")|('((?!(?i:(on|of))).)*')|([^\\s]+\\b(?<!\\b(?i:(on|of)))\\b))(\\s+)?)+";
    private static final String ON = "(?i:(?:on|by|across))";
    private static final String REPORT_ELEMENT = "((\\s+)?(?:(?i:report)|(?i:row)|(?!(?i:report)|(?i:row)|(?i:on))(((\"((?!(?i:(on|of))).)*\")|('((?!(?i:(on|of))).)*')|([^\\s]+\\b(?<!\\b(?i:(on|of)))\\b))(\\s+)?)+))";
    private static final String REPORT_EXPR = "((?i:(?:on|by|across))\\s+((\\s+)?(?:(?i:report)|(?i:row)|(?!(?i:report)|(?i:row)|(?i:on))(((\"((?!(?i:(on|of))).)*\")|('((?!(?i:(on|of))).)*')|([^\\s]+\\b(?<!\\b(?i:(on|of)))\\b))(\\s+)?)+))+)";
    private static final String CMD = "\\b(?i:comp(?:|u|ut|ute))\\b\\s+(\\b(?i:avg|cou(?:|nt)|min(?:|i|im|imu|imum)|max(?:|i|im|imu|imum)|num(?:|b|be|ber)|sum|std|var(?:|i|ia|ian|ianc|iance))\\b\\s*((?i:lab(|e|el))\\s+(([^(\\p{Punct})(\\p{Space})]{1,500})|(\\\"[^\\\"]{1,498}\\\")|(\\'[^\\']{1,498}\\')))?(?:(\\r\\n|\\n|\\r|\\-|\\s)*))+(?i:of)\\s+(((\"((?!(?i:(on|of))).)*\")|('((?!(?i:(on|of))).)*')|([^\\s]+\\b(?<!\\b(?i:(on|of)))\\b))(\\s+)?)+((?i:(?:on|by|across))\\s+((\\s+)?(?:(?i:report)|(?i:row)|(?!(?i:report)|(?i:row)|(?i:on))(((\"((?!(?i:(on|of))).)*\")|('((?!(?i:(on|of))).)*')|([^\\s]+\\b(?<!\\b(?i:(on|of)))\\b))(\\s+)?)+))+)";
    TreeMap<String, ArrayList<TreeMap<String, HashMap<String, String>>>> m_storedComputecmds = null;
    private static final HashMap<String, String> m_orafunc_to_compfunc = new HashMap();

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String cmptcmd = cmd.getSql().trim();
        ArrayList cmptdElements = new ArrayList();
        TreeMap<String, ArrayList<TreeMap<String, HashMap<String, String>>>> storedComputecmds = ctx.getStoredComputeCmds();
        this.m_storedComputecmds = storedComputecmds;
        ArrayList<String> funcregExpList = new ArrayList<String>();
        funcregExpList.add("(?i:avg)");
        funcregExpList.add("(?i:cou(?:|nt))");
        funcregExpList.add("(?i:min(?:|i|im|imu|imum))");
        funcregExpList.add("(?i:max(?:|i|im|imu|imum))");
        funcregExpList.add("(?i:num(?:|b|be|ber))");
        funcregExpList.add("(?i:sum)");
        funcregExpList.add("(?i:std)");
        funcregExpList.add("(?i:var(?:|i|ia|ian|ianc|iance))");
        if (cmptcmd.matches(COMPUTE)) {
            if (storedComputecmds.size() > 0) {
                for (String repCol : storedComputecmds.keySet()) {
                    String compute = "COMPUTE ";
                    String on = " ON " + repCol;
                    String function = "";
                    ArrayList<TreeMap<String, HashMap<String, String>>> cmptColKeyList = storedComputecmds.get(repCol);
                    for (TreeMap<String, HashMap<String, String>> cmptColKey : cmptColKeyList) {
                        Iterator<String> cckeysIter = cmptColKey.keySet().iterator();
                        while (cckeysIter.hasNext()) {
                            function = "";
                            String cmptCol = cckeysIter.next();
                            String of = " OF " + cmptCol;
                            HashMap<String, String> func_to_label = cmptColKey.get(cmptCol);
                            Iterator<String> funcIter = func_to_label.keySet().iterator();
                            while (funcIter.hasNext()) {
                                String func = funcIter.next();
                                String labelTxt = func_to_label.get(func);
                                function = function + m_orafunc_to_compfunc.get(func.toUpperCase()).toLowerCase() + " LABEL " + labelTxt + (funcIter.hasNext() ? " " : "");
                                if (funcIter.hasNext()) continue;
                                function = function + of;
                            }
                        }
                        String computeCmd = compute + function + on + m_lineSeparator;
                        ctx.write(computeCmd);
                    }
                }
            } else {
                ctx.write(Messages.getString("NOCOMPUTES") + m_lineSeparator);
            }
        } else {
            Pattern ptrn = Pattern.compile(CMD, 8);
            Matcher m = ptrn.matcher(cmptcmd);
            m_orafunc_to_compfunc.put("AVG", "AVG");
            m_orafunc_to_compfunc.put("COUNT", "COUNT");
            m_orafunc_to_compfunc.put("MIN", "MINIMUM");
            m_orafunc_to_compfunc.put("MAX", "MAXIMUM");
            m_orafunc_to_compfunc.put("NUMBER", "NUMBER");
            m_orafunc_to_compfunc.put("SUM", "SUM");
            m_orafunc_to_compfunc.put("STDDEV", "STD");
            m_orafunc_to_compfunc.put("VARIANCE", "VARIANCE");
            boolean matches = m.matches();
            if (matches) {
                cmptcmd = cmptcmd.replaceFirst("\\b(?i:comp(?:|u|ut|ute))\\b\\s+", "");
                String repElements = cmptcmd.replaceFirst(CMPT_EXPR, "").trim().replaceFirst(ON, "").trim();
                Pattern rep = Pattern.compile(REPORT_ELEMENT);
                Matcher rem = rep.matcher(repElements);
                Pattern cep = Pattern.compile("(((\"((?!(?i:(on|of))).)*\")|('((?!(?i:(on|of))).)*')|([^\\s]+\\b(?<!\\b(?i:(on|of)))\\b))(\\s+)?)+");
                String cmptElements = cmptcmd.replaceFirst(FUNC_EXPR, "").trim().replaceFirst(REPORT_EXPR, "").trim().replaceFirst(OF, "").trim();
                String funcExps = cmptcmd.replaceFirst("(?i:of)\\s+(((\"((?!(?i:(on|of))).)*\")|('((?!(?i:(on|of))).)*')|([^\\s]+\\b(?<!\\b(?i:(on|of)))\\b))(\\s+)?)++", "").trim().replaceFirst(REPORT_EXPR, "").trim();
                String warnmsg = "";
                String funcOnly = funcExps.replaceAll(LABEL, "");
                for (String fn : funcregExpList) {
                    Pattern p = Pattern.compile(fn);
                    Matcher fm = p.matcher(funcOnly);
                    int cnt = 0;
                    String fname = "";
                    while (fm.find()) {
                        ++cnt;
                        fname = fm.group();
                    }
                    if (cnt <= 1) continue;
                    warnmsg = warnmsg + MessageFormat.format(Messages.getString("CMPT_FNMULTIOCCUR"), fname, String.valueOf(cnt)) + System.getProperty("line.separator");
                }
                if (warnmsg.length() > 0) {
                    ctx.write(warnmsg);
                }
                String[] repEleArr = repElements.split("\\s+");
                String[] cmptEleArr = null;
                ArrayList<String> matchList = new ArrayList<String>();
                Pattern regex = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'");
                Matcher regexMatcher = regex.matcher(cmptElements);
                while (regexMatcher.find()) {
                    matchList.add(regexMatcher.group());
                }
                cmptEleArr = new String[matchList.size()];
                matchList.toArray(cmptEleArr);
                for (int i = 0; i < repEleArr.length; ++i) {
                    String repElement = repEleArr[i].replaceAll("^(\\\"|')|(\\\"|')$", "");
                    TreeMap<String, HashMap<String, String>> cmptEle_to_func = null;
                    for (int j = 0; j < cmptEleArr.length; ++j) {
                        String cmptElement = cmptEleArr[j];
                        cmptEle_to_func = this.processFunction(funcExps, cmptElement);
                        this.storeCompute(repElement, cmptElement, cmptEle_to_func);
                    }
                }
            } else {
                String ccmd = cmptcmd;
                String[] patterns = new String[]{"\\b(?i:comp(?:|u|ut|ute))\\b\\s+", CMPT_EXPR, REPORT_EXPR};
                boolean innerBreak = false;
                for (int i = 0; i < patterns.length; ++i) {
                    int idx;
                    String report;
                    Pattern rptp;
                    Matcher rptm;
                    int idx2;
                    String pattern = "^" + patterns[i];
                    Pattern p = Pattern.compile(pattern);
                    Matcher ma = p.matcher(ccmd);
                    if (ma.find()) {
                        if (i < patterns.length - 2) {
                            ccmd = ccmd.replaceAll(patterns[i], "").trim();
                            continue;
                        }
                        ccmd = ccmd.replaceFirst(patterns[i], "").trim();
                        continue;
                    }
                    if (patterns[i].equals(CMPT_EXPR)) {
                        Pattern pof = Pattern.compile(OF);
                        Matcher mof = pof.matcher(ccmd);
                        int ofonfind = -1;
                        String funclabel = "";
                        while (mof.find()) {
                            ofonfind = mof.start();
                        }
                        if (ofonfind == -1) {
                            Pattern pon = Pattern.compile(ON);
                            Matcher mon = pof.matcher(ccmd);
                            while (mon.find()) {
                                ofonfind = mon.start();
                            }
                        }
                        if (ofonfind > 0) {
                            funclabel = ccmd.substring(0, ofonfind);
                            if (funclabel.length() > 0) {
                                ccmd = ccmd.replaceFirst(funclabel, "");
                            }
                        } else {
                            funclabel = ccmd;
                            if (funclabel.length() > 0) {
                                ccmd = ccmd.replaceFirst(funclabel, "");
                            }
                        }
                        while (funclabel.length() > 0) {
                            if (funclabel.matches(FUNC_EXPR)) {
                                funclabel = funclabel.replaceAll(funclabel, "");
                            } else {
                                String labelRp = "^\\b(?i:lab(|e|el))\\b";
                                Pattern lblp = Pattern.compile(labelRp);
                                Matcher lm = lblp.matcher(funclabel);
                                if (lm.find()) {
                                    ctx.write(Messages.getString("CMPT_LBL") + m_lineSeparator);
                                    innerBreak = true;
                                    break;
                                }
                                if (funclabel.matches("\\s+")) {
                                    ctx.write(Messages.getString("CMPT_LBLBLANK") + m_lineSeparator);
                                    innerBreak = true;
                                    break;
                                }
                                String grpstr = "";
                                Pattern funexpr = Pattern.compile("(\\b(?i:avg|cou(?:|nt)|min(?:|i|im|imu|imum)|max(?:|i|im|imu|imum)|num(?:|b|be|ber)|sum|std|var(?:|i|ia|ian|ianc|iance))\\b\\s*((?i:lab(|e|el))\\s+(([^(\\p{Punct})(\\p{Space})]{1,500})|(\\\"[^\\\"]{1,498}\\\")|(\\'[^\\']{1,498}\\')))?(?:(\\r\\n|\\n|\\r|\\-|\\s)*)?)");
                                Matcher fm = funexpr.matcher(funclabel);
                                if (fm.matches()) {
                                    grpstr = fm.group();
                                    funclabel = funclabel.replaceFirst(grpstr, "").replaceAll("^\\s+", "");
                                } else {
                                    String splitExp = "[^\\s\"']+|\"([^\"]*)\"|'([^']*)'|\"([^\"]*)|'([^']*)|\\s+$";
                                    Pattern splPat = Pattern.compile(splitExp);
                                    Matcher splm = splPat.matcher(funclabel);
                                    int x = 0;
                                    String ftoken = "";
                                    while (splm.find()) {
                                        ftoken = splm.group();
                                        if (++x == 1 && !ftoken.matches(FUNCTION)) {
                                            if (ftoken.matches("\\b(?i:lab(|e|el))\\b")) {
                                                ctx.write(Messages.getString("CMPT_LBL") + m_lineSeparator);
                                            } else {
                                                ctx.write(MessageFormat.format(Messages.getString("CMPT_UNK1"), ftoken.substring(0, 10)) + m_lineSeparator);
                                            }
                                            innerBreak = true;
                                            break;
                                        }
                                        if (x == 2) {
                                            if (!ftoken.matches("\\b(?i:lab(|e|el))\\b")) {
                                                if (ftoken.length() > 0 && !ftoken.matches(FUNCTION)) {
                                                    ctx.write(MessageFormat.format(Messages.getString("CMPT_UNK"), ftoken) + m_lineSeparator);
                                                    innerBreak = true;
                                                    x = 0;
                                                    break;
                                                }
                                                x = 0;
                                            } else if (ftoken.matches("\\s+")) {
                                                ctx.write(Messages.getString("CMPT_LBLBLANK") + m_lineSeparator);
                                                innerBreak = true;
                                                break;
                                            }
                                        } else if (x == 3) {
                                            x = 0;
                                            if (ftoken.matches("^\"[^\"]*")) {
                                                if (ftoken.length() > 1) {
                                                    ctx.write(MessageFormat.format(Messages.getString("CMPT_MISSINGTERM1"), ftoken.substring(0, 10), "\"") + m_lineSeparator);
                                                } else {
                                                    ctx.write(MessageFormat.format(Messages.getString("CMPT_MISSINGTERM"), "\"", "\"") + m_lineSeparator);
                                                }
                                                innerBreak = true;
                                                break;
                                            }
                                            if (ftoken.matches("^'[^']*")) {
                                                if (ftoken.length() > 1) {
                                                    ctx.write(MessageFormat.format(Messages.getString("CMPT_MISSINGTERM1"), ftoken.substring(0, 10), "'") + m_lineSeparator);
                                                } else {
                                                    ctx.write(MessageFormat.format(Messages.getString("CMPT_MISSINGTERM"), "'", "'") + m_lineSeparator);
                                                }
                                                innerBreak = true;
                                                break;
                                            }
                                            if (ftoken.matches("\\s+$")) {
                                                ctx.write(Messages.getString("CMPT_LBLBLANK") + m_lineSeparator);
                                                innerBreak = true;
                                                break;
                                            }
                                        }
                                        funclabel = funclabel.replaceFirst(ftoken, "").replaceAll("^\\s+", "");
                                    }
                                    if (x == 2) {
                                        ctx.write(Messages.getString("CMPT_LBLTXT") + m_lineSeparator);
                                        innerBreak = true;
                                        break;
                                    }
                                }
                            }
                            if (!innerBreak) continue;
                        }
                        if (innerBreak) break;
                        if (ccmd.matches("^(?i:of)(.*)?")) {
                            if ((ccmd = ccmd.replaceFirst(OF, "").replaceAll("^\\s+", "")).matches("^(((\"((?!(?i:(on|of))).)*\")|('((?!(?i:(on|of))).)*')|([^\\s]+\\b(?<!\\b(?i:(on|of)))\\b))(\\s+)?)+")) {
                                ccmd = ccmd.replaceFirst("(((\"((?!(?i:(on|of))).)*\")|('((?!(?i:(on|of))).)*')|([^\\s]+\\b(?<!\\b(?i:(on|of)))\\b))(\\s+)?)+", "").replaceAll("^\\s+", "");
                                continue;
                            }
                            ctx.write(Messages.getString("CMPT_COLS") + m_lineSeparator);
                            innerBreak = true;
                            break;
                        }
                        ctx.write(Messages.getString("CMPT_OF") + m_lineSeparator);
                        innerBreak = true;
                        break;
                    }
                    if (!patterns[i].equals(REPORT_EXPR)) continue;
                    if (ccmd.length() == 0) {
                        ctx.write(Messages.getString("CMPT_ON") + m_lineSeparator);
                        innerBreak = true;
                        break;
                    }
                    if (ccmd.matches("(?i:(?:on|by|across))$")) {
                        ctx.write(Messages.getString("REPT_COLS") + m_lineSeparator);
                        innerBreak = true;
                        break;
                    }
                    String on = "(?i:(?:on|by|across))\\s+";
                    Pattern onp = Pattern.compile(on);
                    Matcher onm = onp.matcher(ccmd);
                    if (onm.matches() && (idx2 = m.start()) == 0) {
                        ccmd = ccmd.replaceAll(on, "").trim();
                    }
                    if (!(rptm = (rptp = Pattern.compile(report = "((\\s+)?(?:(?i:report)|(?i:row)|(?!(?i:report)|(?i:row)|(?i:on))(((\"((?!(?i:(on|of))).)*\")|('((?!(?i:(on|of))).)*')|([^\\s]+\\b(?<!\\b(?i:(on|of)))\\b))(\\s+)?)+))+")).matcher(ccmd)).matches() || (idx = m.start()) != 0) continue;
                    ccmd = ccmd.replaceAll(report, "").trim();
                }
                if (!innerBreak && ccmd.length() > 0) {
                    if (ccmd.matches("^(?i:(?:on|by|across)).*")) {
                        ctx.write(Messages.getString("CMPT_ONALREADY") + m_lineSeparator);
                    } else if (ccmd.matches("^(?i:of).*")) {
                        ctx.write(Messages.getString("CMPT_OFALREADY") + m_lineSeparator);
                    }
                }
            }
        }
        return false;
    }

    private void storeCompute(String repElement, String cmptElement, TreeMap<String, HashMap<String, String>> cmptEle_to_func) {
        ArrayList<TreeMap<String, HashMap<String, String>>> maps = this.m_storedComputecmds.get(repElement);
        if (maps == null) {
            maps = new ArrayList();
            maps.add(cmptEle_to_func);
            this.m_storedComputecmds.put(repElement, maps);
        } else {
            for (int i = 0; i < maps.size(); ++i) {
                TreeMap<String, HashMap<String, String>> cmpcol_to_func = maps.get(i);
                if (!cmpcol_to_func.containsKey(cmptElement)) continue;
                maps.remove(cmpcol_to_func);
                break;
            }
            maps.add(cmptEle_to_func);
        }
    }

    private TreeMap<String, HashMap<String, String>> processFunction(String funcExps, String cmpElement) {
        TreeMap<String, HashMap<String, String>> retval = new TreeMap<String, HashMap<String, String>>(String.CASE_INSENSITIVE_ORDER);
        LinkedHashMap<String, String> func_to_label = null;
        Pattern fp = Pattern.compile("(\\b(?i:avg|cou(?:|nt)|min(?:|i|im|imu|imum)|max(?:|i|im|imu|imum)|num(?:|b|be|ber)|sum|std|var(?:|i|ia|ian|ianc|iance))\\b\\s*((?i:lab(|e|el))\\s+(([^(\\p{Punct})(\\p{Space})]{1,500})|(\\\"[^\\\"]{1,498}\\\")|(\\'[^\\']{1,498}\\')))?(?:(\\r\\n|\\n|\\r|\\-|\\s)*))");
        Matcher fm = fp.matcher(funcExps);
        while (fm.find()) {
            String funcExp = fm.group().trim();
            String func = funcExp.replaceAll(LABEL, "").trim();
            String lblandtxt = funcExp.replaceFirst(FUNCTION, "");
            String preval = "";
            if (func.matches(FUNCTION)) {
                if (func.matches("\\b(?i:avg)\\b")) {
                    preval = func;
                    func = "avg";
                }
                if (func.matches("\\b(?i:cou(?:|nt))\\b")) {
                    preval = func;
                    func = "count";
                } else if (func.matches("\\b(?i:min(?:|i|im|imu|imum))\\b")) {
                    preval = func;
                    func = "min";
                } else if (func.matches("\\b(?i:max(?:|i|im|imu|imum))\\b")) {
                    preval = func;
                    func = "max";
                } else if (func.matches("\\b(?i:num(?:|b|be|ber))\\b")) {
                    preval = "number";
                    func = "number";
                } else if (func.matches("\\b(?i:sum)\\b")) {
                    preval = func;
                    func = "sum";
                } else if (func.matches("\\b(?i:std)\\b")) {
                    preval = func;
                    func = "stddev";
                } else if (func.matches("\\b(?i:var(?:|i|ia|ian|ianc|iance))\\b")) {
                    preval = func;
                    func = "variance";
                }
            }
            if (lblandtxt.isEmpty()) {
                lblandtxt = func.equals("max") ? "'maximum'" : (func.equals("min") ? "'minimum'" : (func.equals("stddev") ? "'std'" : (func.equals("count") ? "'count'" : "'" + func.toLowerCase() + "'")));
            } else {
                lblandtxt = funcExp.replaceFirst(FUNCTION, "").trim().replaceFirst("\\b(?i:lab(?:|e|el))\\b\\s+", "");
                int idx = lblandtxt.lastIndexOf("-");
                if (idx > -1) {
                    lblandtxt = lblandtxt.substring(0, idx - 1).trim();
                }
                lblandtxt = lblandtxt.replaceAll("''", "'");
                lblandtxt = lblandtxt.replaceAll("\"\"", "\"");
                idx = (lblandtxt = lblandtxt.replaceAll("\"", "'")).indexOf("'");
                if (idx == -1) {
                    lblandtxt = "'" + lblandtxt + "'";
                }
            }
            if (func_to_label == null) {
                func_to_label = new LinkedHashMap<String, String>();
            }
            func_to_label.put(func, lblandtxt);
        }
        String cmpElm = cmpElement.startsWith("\"") || cmpElement.startsWith("'") ? cmpElement.substring(1, cmpElement.length()) : cmpElement;
        cmpElm = cmpElm.endsWith("\"") || cmpElm.endsWith("'") ? cmpElm.substring(0, cmpElm.length() - 1) : cmpElm;
        retval.put(cmpElm, func_to_label);
        return retval;
    }

    public static void sort(ArrayList<TreeMap<String, HashMap<String, String>>> list) {
        Collections.sort(list, new Comparator<TreeMap<String, HashMap<String, String>>>(){

            @Override
            public int compare(TreeMap<String, HashMap<String, String>> o1, TreeMap<String, HashMap<String, String>> o2) {
                HashMap<String, String> func1_to_lbl1 = o1.get(o1.keySet().toArray()[0]);
                String func1 = (String)m_orafunc_to_compfunc.get(((String)func1_to_lbl1.keySet().toArray()[0]).toUpperCase());
                HashMap<String, String> func2_to_lbl2 = o2.get(o2.keySet().toArray()[0]);
                String func2 = (String)m_orafunc_to_compfunc.get(((String)func2_to_lbl2.keySet().toArray()[0]).toUpperCase());
                return Integer.valueOf(m_cmptFuncSequence.indexOf(func1)).compareTo(m_cmptFuncSequence.indexOf(func2));
            }
        });
    }

    public static void sortFunctions(ArrayList<TreeMap<String, HashMap<String, String>>> list) {
        for (int i = 0; i < list.size(); ++i) {
            TreeMap<String, HashMap<String, String>> colMap = list.get(i);
            for (String colKey : colMap.keySet()) {
                HashMap<String, String> func_to_lbl = colMap.get(colKey);
                HashMap<String, String> srtdfunc_to_lbl = Compute.sort(func_to_lbl);
                colMap.put(colKey, srtdfunc_to_lbl);
            }
        }
    }

    public static HashMap<String, String> sort(HashMap<String, String> map) {
        LinkedList<Map.Entry<String, String>> list = new LinkedList<Map.Entry<String, String>>(map.entrySet());
        Collections.sort(list, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String func1 = ((Map.Entry)o1).getValue().toString().toUpperCase().replaceAll("'", "");
                func1 = func1 == null ? ((Map.Entry)o1).getKey().toString().toUpperCase() : func1;
                func1 = (String)m_orafunc_to_compfunc.get(func1);
                String func2 = ((Map.Entry)o2).getValue().toString().toUpperCase().replaceAll("'", "");
                func2 = func2 == null ? ((Map.Entry)o2).getKey().toString().toUpperCase() : func2;
                func2 = (String)m_orafunc_to_compfunc.get(func2);
                int val1 = m_cmptFuncSequence.indexOf(func1);
                int val2 = m_cmptFuncSequence.indexOf(func2);
                return Integer.valueOf(val1).compareTo(val2);
            }
        });
        LinkedHashMap<String, String> sortedMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : list) {
            sortedMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return sortedMap;
    }

    public static int getIndexofFunction(String func) {
        return m_cmptFuncSequence.indexOf(func.toUpperCase());
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

