/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.apex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.rowset.serial.SerialClob;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.raptor.newscriptrunner.apex.APEXExportSplitter;
import oracle.dbtools.raptor.newscriptrunner.apex.ApexExportInterface;
import oracle.dbtools.raptor.newscriptrunner.apex.ApexMessages;
import oracle.dbtools.raptor.newscriptrunner.apex.InvalidParameterException;
import oracle.dbtools.raptor.newscriptrunner.commands.ApexCmd;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleDriver;
import oracle.sql.CLOB;

public class APEXExportV1
implements ApexExportInterface {
    public boolean debug = false;
    public boolean skipDate = false;
    public boolean instance = false;
    public boolean pubReports = false;
    public boolean savedReports = false;
    public boolean IRNotifications = false;
    public boolean expWorkspace = false;
    public boolean expMinimal = false;
    public boolean expTeamdevdata = false;
    public boolean expFeedback = false;
    public boolean expTranslations = false;
    public boolean expFiles = false;
    public boolean expOriginalIds = false;
    public boolean expLocked = false;
    private Connection gConn;
    private BigDecimal workspaceID;
    private String deploymentSystem;
    private Date expFeedbackSince;
    private java.util.Date expFeedbackSinceU;
    private String url;
    private String userName;
    private String password;
    private BigDecimal appID;
    private APEXExportSplitter splitter = null;
    private boolean _splitFlat = false;
    private boolean _split = false;
    private boolean _splitUpdate;
    private boolean _splitNoCheckSum;
    private String _cwd;
    private boolean _noFileStoreClob = false;
    private final LinkedHashMap<String, Clob> _clobData = new LinkedHashMap();
    private static OutputStream _out;
    private QueryXMLSupport _queries = null;

    private synchronized QueryXMLSupport getXMLQueries() {
        if (this._queries == null) {
            this._queries = QueryXMLSupport.getQueryXMLSupport(new MetaResource(ApexCmd.class.getClassLoader(), "oracle/dbtools/raptor/newscriptrunner/commands/commands.xml"));
        }
        return this._queries;
    }

    public APEXExportV1() {
    }

    public APEXExportV1(boolean noFileStoreClob) {
        this._noFileStoreClob = noFileStoreClob;
    }

    private APEXExportSplitter getSplitter() {
        if (this.splitter == null) {
            this.splitter = new APEXExportSplitter();
        }
        this.splitter.setOptions(this._cwd, this._splitFlat, this._splitNoCheckSum, this.debug, this._splitUpdate);
        return this.splitter;
    }

    @Override
    public void setCWD(String cwd) {
        this._cwd = cwd;
    }

    private static void write(Object o) {
        if (_out != null && o != null) {
            try {
                _out.write(o.toString().getBytes("UTF8"));
                _out.write("\n".getBytes("UTF8"));
            }
            catch (IOException e) {
                System.out.println(o.toString());
            }
        } else {
            System.out.println(o.toString());
        }
    }

    @Override
    public void setOutStream(OutputStream out) {
        _out = out;
    }

    @Override
    public void setConnection(Connection conn) {
        this.gConn = conn;
    }

    private void exportFiles(BigDecimal appIDToExport, BigDecimal workspaceID, String userName) throws Exception {
        if (this.instance) {
            String appName = null;
            PreparedStatement stmt = this.gConn.prepareStatement(this.getXMLQueries().getQuery("gStmtInstance", this.gConn).getSql());
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                java.util.Date now;
                BigDecimal appID = result.getBigDecimal(1);
                appName = result.getString(2);
                APEXExportV1.write("Exporting Application " + appID + ":'" + appName + "' \n");
                if (this.debug) {
                    now = new java.util.Date();
                    APEXExportV1.write(" Start " + now + "\n");
                }
                this.exportFile(appID, true);
                now = new java.util.Date();
                APEXExportV1.write("  Completed at " + now + "\n");
            }
            result.close();
            stmt.close();
        } else if (workspaceID != null && workspaceID.longValue() != 0L) {
            BigDecimal securityGroupID = new BigDecimal(0);
            String appName = null;
            PreparedStatement stmt = this.gConn.prepareStatement(this.getXMLQueries().getQuery("gStmtSetSGID", this.gConn).getSql());
            stmt.setBigDecimal(1, workspaceID);
            stmt.executeUpdate();
            stmt.close();
            stmt = this.gConn.prepareStatement(this.getXMLQueries().getQuery("gStmtGetSGID", this.gConn).getSql());
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                securityGroupID = result.getBigDecimal(1);
            }
            result.close();
            stmt.close();
            if (!securityGroupID.equals(workspaceID)) {
                APEXExportV1.write("Invalid Workspace ID '" + workspaceID + "' for User '" + userName + "'\n");
                System.exit(1);
            }
            stmt = !this.expLocked ? this.gConn.prepareStatement(this.getXMLQueries().getQuery("gStmt", this.gConn).getSql()) : this.gConn.prepareStatement(this.getXMLQueries().getQuery("gStmt2", this.gConn).getSql());
            stmt.setBigDecimal(1, workspaceID);
            stmt.setBigDecimal(2, workspaceID);
            result = stmt.executeQuery();
            while (result.next()) {
                java.util.Date now;
                BigDecimal appID = result.getBigDecimal(1);
                appName = result.getString(2);
                APEXExportV1.write("Exporting Application " + appID + ":'" + appName + "' \n");
                if (this.debug) {
                    now = new java.util.Date();
                    APEXExportV1.write(" Start " + now + "\n");
                }
                this.exportFile(appID, true);
                now = new java.util.Date();
                APEXExportV1.write("  Completed at " + now + "\n");
            }
            result.close();
            stmt.close();
        } else {
            java.util.Date now;
            APEXExportV1.write("Exporting application " + appIDToExport);
            if (this.debug) {
                now = new java.util.Date();
                APEXExportV1.write(" Start " + now + "\n");
            }
            this.exportFile(appIDToExport, false);
            now = new java.util.Date();
            APEXExportV1.write("  Completed at " + now + "\n");
        }
    }

    private void exportWorkspaces(BigDecimal workspaceID, boolean teamdevdata, boolean minimal) throws SQLException, IOException {
        if (workspaceID != null && workspaceID.longValue() != 0L) {
            String wkspName = null;
            PreparedStatement stmt = this.gConn.prepareStatement(this.getXMLQueries().getQuery("gStmtWorkspace", this.gConn).getSql());
            stmt.setBigDecimal(1, workspaceID);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                java.util.Date now;
                wkspName = result.getString(1);
                APEXExportV1.write("Exporting Workspace " + workspaceID + ":'" + wkspName + "' \n");
                if (this.debug) {
                    now = new java.util.Date();
                    APEXExportV1.write(" Start " + now + "\n");
                }
                this.exportWorkspace(workspaceID, teamdevdata, minimal);
                now = new java.util.Date();
                APEXExportV1.write("  Completed at " + now + "\n");
            }
            result.close();
            stmt.close();
        } else {
            String wkspName = null;
            PreparedStatement stmt = this.gConn.prepareStatement(this.getXMLQueries().getQuery("gStmtWorkspaces", this.gConn).getSql());
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                java.util.Date now;
                BigDecimal wkspID = result.getBigDecimal(1);
                wkspName = result.getString(2);
                APEXExportV1.write("Exporting Workspace " + wkspID + ":'" + wkspName + "' \n");
                if (this.debug) {
                    now = new java.util.Date();
                    APEXExportV1.write(" Start " + now + "\n");
                }
                this.exportWorkspace(wkspID, teamdevdata, minimal);
                now = new java.util.Date();
                APEXExportV1.write("  Completed at " + now + "\n");
            }
            result.close();
            stmt.close();
        }
    }

    private void ExpFeed(BigDecimal workspaceID, String deploymentSystem, Date expFeedbackSince) throws SQLException, IOException {
        if (workspaceID != null && workspaceID.longValue() != 0L) {
            String wkspName = null;
            PreparedStatement stmt = this.gConn.prepareStatement(this.getXMLQueries().getQuery("gStmtWorkspace", this.gConn).getSql());
            stmt.setBigDecimal(1, workspaceID);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                java.util.Date now;
                wkspName = result.getString(1);
                APEXExportV1.write("Exporting Feedback for Workspace " + workspaceID + ":'" + wkspName + "' \n");
                if (this.debug) {
                    now = new java.util.Date();
                    APEXExportV1.write(" Start " + now + "\n");
                }
                this.exportFeedback(workspaceID, deploymentSystem, expFeedbackSince);
                now = new java.util.Date();
                APEXExportV1.write("  Completed at " + now + "\n");
            }
            result.close();
            stmt.close();
        } else {
            String wkspName = null;
            PreparedStatement stmt = this.gConn.prepareStatement(this.getXMLQueries().getQuery("gStmtWorkspacesFeedback", this.gConn).getSql());
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                java.util.Date now;
                BigDecimal wkspID = result.getBigDecimal(1);
                wkspName = result.getString(2);
                APEXExportV1.write("Exporting Feedback for Workspace " + wkspID + ":'" + wkspName + "' \n");
                if (this.debug) {
                    now = new java.util.Date();
                    APEXExportV1.write(" Start " + now + "\n");
                }
                this.exportFeedback(wkspID, deploymentSystem, expFeedbackSince);
                now = new java.util.Date();
                APEXExportV1.write("  Completed at " + now + "\n");
            }
            result.close();
            stmt.close();
        }
    }

    private void exportFile(BigDecimal appID, boolean expPkgAppMapping) throws Exception {
        OracleCallableStatement cstmt = (OracleCallableStatement)this.gConn.prepareCall("begin\n    ? := wwv_flow_utilities.export_application_to_clob (\n             p_application_id            => ?,\n             p_export_ir_public_reports  => ?,\n             p_export_ir_private_reports => ?,\n             p_export_ir_notifications   => ?,\n             p_export_translations       => ?,\n             p_export_pkg_app_mapping    => ?,\n             p_with_original_ids         => case when ?='Y' then true else false end );\nend;");
        cstmt.registerOutParameter(1, 2005);
        cstmt.setBigDecimal(2, appID);
        cstmt.setString(3, this.pubReports ? "Y" : "N");
        cstmt.setString(4, this.savedReports ? "Y" : "N");
        cstmt.setString(5, this.IRNotifications ? "Y" : "N");
        cstmt.setString(6, this.expTranslations ? "Y" : "N");
        cstmt.setString(7, expPkgAppMapping ? "Y" : "N");
        cstmt.setString(8, this.expOriginalIds ? "Y" : "N");
        cstmt.execute();
        CLOB clob = cstmt.getCLOB(1);
        BigDecimal isWS = null;
        String isWSString = "1";
        PreparedStatement stmt = this.gConn.prepareStatement(this.getXMLQueries().getQuery("gStmtIsWS", this.gConn).getSql());
        stmt.setBigDecimal(1, appID);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            isWS = result.getBigDecimal(1);
            isWSString = isWS.toString();
        }
        result.close();
        stmt.close();
        String theFileName = isWSString.equals("0") ? "f" + appID + ".sql" : "ws" + appID + ".sql";
        this.writeFileorStoreClob(theFileName, (Clob)clob);
        cstmt.close();
    }

    private void exportWorkspace(BigDecimal workspaceID, boolean teamdevdata, boolean minimal) throws SQLException, IOException {
        String lstmt = null;
        lstmt = teamdevdata ? "begin ? := wwv_flow_utilities.export_workspace_to_clob(?, true" : "begin ? := wwv_flow_utilities.export_workspace_to_clob(?, false";
        lstmt = minimal ? lstmt + ",true); end;" : lstmt + "); end;";
        OracleCallableStatement cstmt = (OracleCallableStatement)this.gConn.prepareCall(lstmt);
        cstmt.setBigDecimal(2, workspaceID);
        cstmt.registerOutParameter(1, 2005);
        cstmt.execute();
        CLOB clob = cstmt.getCLOB(1);
        String theFileName = "w" + workspaceID + ".sql";
        this.writeFileorStoreClob(theFileName, (Clob)clob);
        cstmt.close();
    }

    private void exportStaticFiles(BigDecimal workspaceID) throws SQLException, IOException {
        String lstmt = null;
        lstmt = "begin ? := wwv_flow_utilities.export_files_to_clob(?); end;";
        OracleCallableStatement cstmt = (OracleCallableStatement)this.gConn.prepareCall(lstmt);
        cstmt.setBigDecimal(2, workspaceID);
        cstmt.registerOutParameter(1, 2005);
        cstmt.execute();
        CLOB clob = cstmt.getCLOB(1);
        String theFileName = "files_" + workspaceID + ".sql";
        this.writeFileorStoreClob(theFileName, (Clob)clob);
        cstmt.close();
    }

    private void exportFeedback(BigDecimal workspaceID, String deploymentSystem, Date expFeedbackSince) throws SQLException, IOException {
        String lstmt = null;
        lstmt = deploymentSystem == null ? "begin ? := wwv_flow_utilities.export_feedback_to_development(?,?); end;" : "begin ? := wwv_flow_utilities.export_feedback_to_deployment(?,?,?); end;";
        OracleCallableStatement cstmt = (OracleCallableStatement)this.gConn.prepareCall(lstmt);
        if (deploymentSystem == null) {
            cstmt.setDate(3, expFeedbackSince);
            cstmt.setBigDecimal(2, workspaceID);
            cstmt.registerOutParameter(1, 2005);
        } else {
            cstmt.setDate(4, expFeedbackSince);
            cstmt.setString(3, deploymentSystem);
            cstmt.setBigDecimal(2, workspaceID);
            cstmt.registerOutParameter(1, 2005);
        }
        cstmt.execute();
        CLOB clob = cstmt.getCLOB(1);
        String theFileName = "fb" + workspaceID + ".sql";
        this.writeFileorStoreClob(theFileName, (Clob)clob);
        cstmt.close();
    }

    @Override
    public void doCapture() throws Exception {
        if (this.expWorkspace) {
            this.exportWorkspaces(this.workspaceID, this.expTeamdevdata, this.expMinimal);
        } else if (this.expFeedback) {
            this.ExpFeed(this.workspaceID, this.deploymentSystem, this.expFeedbackSince);
        } else if (this.expFiles) {
            this.exportStaticFiles(this.workspaceID);
        } else {
            this.exportFiles(this.appID, this.workspaceID, this.userName);
        }
    }

    @Override
    public LinkedHashMap<String, Clob> getClobData() {
        return this._clobData;
    }

    private void writeFileorStoreClob(String theFileName, Clob clob) throws IOException, SQLException {
        if (this._noFileStoreClob) {
            if (this._split) {
                LinkedHashMap<String, String> map = this.getSplitter().processFile2(theFileName, clob);
                for (Map.Entry<String, String> item : map.entrySet()) {
                    String fileName = item.getKey();
                    fileName = fileName.replace(".sql", ".xml");
                    SerialClob myClob = new SerialClob(item.getValue().toCharArray());
                    this._clobData.put(this._cwd + fileName, myClob);
                }
            } else {
                this._clobData.put(this._cwd + theFileName, clob);
            }
        } else {
            boolean firstTime = true;
            Reader instream = clob.getCharacterStream();
            File theFile = new File(this._cwd + File.separator + theFileName);
            theFile.delete();
            theFile.createNewFile();
            FileOutputStream foutstream = new FileOutputStream(theFile);
            OutputStreamWriter owstream = new OutputStreamWriter((OutputStream)foutstream, "UTF-8");
            BufferedReader in = new BufferedReader(instream);
            String line = null;
            while ((line = in.readLine()) != null) {
                line = line + "\n";
                if (firstTime) {
                    if (line.indexOf("set define") != 0) continue;
                    firstTime = false;
                    owstream.write(line, 0, line.length());
                    continue;
                }
                if (this.skipDate && line.indexOf("--   Date and Time:") == 0) continue;
                owstream.write(line, 0, line.length());
            }
            owstream.flush();
            if (this.debug) {
                APEXExportV1.write(" Wrote " + theFile.length() + " bytes to " + theFile.getAbsolutePath() + "\n");
            }
            if (this._split) {
                this.getSplitter().processFile(theFile.getAbsolutePath().toString());
            }
            instream.close();
            owstream.close();
            foutstream.close();
        }
    }

    public static final void usage(OutputStream out) {
        _out = out;
        APEXExportV1.usage();
    }

    public static final void usage() {
        APEXExportV1.write(ApexMessages.getString("LB_APEX_OLD_USAGE"));
    }

    @Override
    public void processArgs(String[] args) throws InvalidParameterException {
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                APEXExportV1.usage();
                throw new InvalidParameterException("");
            }
            if (args[i].equalsIgnoreCase("-db")) {
                this.url = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-user")) {
                this.userName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-password")) {
                this.password = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-workspaceid")) {
                this.workspaceID = new BigDecimal(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-applicationid")) {
                this.appID = new BigDecimal(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-skipExportDate")) {
                this.skipDate = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expPubReports")) {
                this.pubReports = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expSavedReports")) {
                this.savedReports = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expIRNotif")) {
                this.IRNotifications = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expTranslations")) {
                this.expTranslations = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-instance")) {
                this.instance = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expWorkspace")) {
                this.expWorkspace = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expMinimal")) {
                this.expMinimal = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expFiles")) {
                this.expFiles = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expFeedback")) {
                this.expFeedback = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expTeamdevdata")) {
                this.expTeamdevdata = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-deploymentSystem")) {
                this.deploymentSystem = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-splitNoCheckSum")) {
                this._splitNoCheckSum = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-splitUpdate")) {
                this._splitUpdate = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-splitFlat")) {
                this._splitFlat = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-split")) {
                this._split = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expFeedbackSince")) {
                SimpleDateFormat dtFmt = new SimpleDateFormat("yyyyMMdd");
                try {
                    this.expFeedbackSinceU = dtFmt.parse(args[++i]);
                    this.expFeedbackSince = new Date(this.expFeedbackSinceU.getTime());
                    continue;
                }
                catch (ParseException e) {
                    throw new InvalidParameterException("Invalid date format: " + args[++i]);
                }
            }
            if (args[i].equalsIgnoreCase("-expOriginalIds")) {
                this.expOriginalIds = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expLocked")) {
                this.expLocked = true;
                continue;
            }
            throw new InvalidParameterException("ERROR: Unknown parameter " + args[i]);
        }
        if (this.debug) {
            APEXExportV1.write("url\t\t\t\t:" + this.url + "\n");
            APEXExportV1.write("userName\t\t\t:" + this.userName + "\n");
            APEXExportV1.write("password\t\t\t:" + this.password + "\n");
            APEXExportV1.write("workspaceID\t\t\t:" + this.workspaceID + "\n");
            APEXExportV1.write("appID\t\t\t\t:" + this.appID + "\n");
            APEXExportV1.write("skipDate\t\t\t:" + this.skipDate + "\n");
            APEXExportV1.write("pubReports\t\t\t:" + this.pubReports + "\n");
            APEXExportV1.write("savedReports\t\t\t:" + this.savedReports + "\n");
            APEXExportV1.write("IRNotifications\t\t\t:" + this.IRNotifications + "\n");
            APEXExportV1.write("expTranslations\t\t\t:" + this.expTranslations + "\n");
            APEXExportV1.write("instance\t\t\t:" + this.instance + "\n");
            APEXExportV1.write("expWorkspace\t\t\t:" + this.expWorkspace + "\n");
            APEXExportV1.write("expMinimal\t\t\t:" + this.expMinimal + "\n");
            APEXExportV1.write("expFiles\t\t\t:" + this.expFiles + "\n");
            APEXExportV1.write("expFeedback\t\t\t:" + this.expFeedback + "\n");
            APEXExportV1.write("expTeamdevdata\t\t\t:" + this.expTeamdevdata + "\n");
            APEXExportV1.write("deploymentSystem\t\t:" + this.deploymentSystem + "\n");
            APEXExportV1.write("expFeedbackSinceU\t\t:" + this.expFeedbackSinceU + "\n");
        }
        if (!(this.appID != null && this.appID.longValue() != 0L || this.workspaceID != null && this.workspaceID.longValue() != 0L)) {
            throw new InvalidParameterException();
        }
    }

    private void setupConnection() throws Exception {
        if (!this._noFileStoreClob) {
            this.gConn = DriverManager.getConnection("jdbc:oracle:thin:@" + this.url, this.userName, this.password);
        } else if (this.gConn == null) {
            APEXExportV1.usage();
            System.exit(1);
        }
        this.gConn.setAutoCommit(true);
    }

    public void main(String[] args) throws Exception {
        this.processArgs(args);
        DriverManager.registerDriver((Driver)new OracleDriver());
        this.setupConnection();
        this.doCapture();
        this.gConn.close();
    }
}

