/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.apex;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.LinkedHashMap;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.raptor.newscriptrunner.apex.ApexExportInterface;
import oracle.dbtools.raptor.newscriptrunner.apex.ApexMessages;
import oracle.dbtools.raptor.newscriptrunner.apex.InvalidParameterException;
import oracle.dbtools.raptor.newscriptrunner.commands.ApexCmd;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleDriver;

public class APEXExport
implements ApexExportInterface {
    public boolean _debug = false;
    public boolean _skipDate = false;
    public boolean _instance = false;
    public boolean _pubReports = false;
    public boolean _savedReports = false;
    public boolean _IRNotifications = false;
    public boolean _expWorkspace = false;
    public boolean _expMinimal = false;
    public boolean _expTeamdevdata = false;
    public boolean _expFeedback = false;
    public boolean _expTranslations = false;
    public boolean _expFiles = false;
    public boolean _expOriginalIds = false;
    public boolean _expLocked = false;
    public boolean _split = false;
    public boolean _expNoSubscriptions = false;
    public boolean _expComments = false;
    public String _expSupportingObjects = "";
    public boolean _expACLAssignments = false;
    public boolean _checksum = true;
    public boolean _list = false;
    public String _dir = "";
    public Connection _gConn;
    public String _url = null;
    public String _userName = null;
    public String _password = null;
    public String _deploymentSystem = null;
    public BigDecimal _appID = null;
    public BigDecimal _workspaceID = null;
    public java.util.Date _expFeedbackSinceU = null;
    public Date _expFeedbackSince = null;
    public String _changesSince = "";
    public String _changesBy = "";
    public String _components = "";
    public LinkedHashMap<String, Clob> _clobData = new LinkedHashMap();
    private boolean _noFileStoreClob = false;
    private QueryXMLSupport _queries = null;
    private static OutputStream _out;

    public static final void usage() {
        APEXExport.write(ApexMessages.getString("LB_APEX_NEW_USAGE"));
    }

    public static final void usage(OutputStream out) {
        _out = out;
        APEXExport.usage();
    }

    private static void write(Object o) {
        if (_out != null && o != null) {
            try {
                _out.write(o.toString().getBytes("UTF8"));
                _out.write("\n".getBytes("UTF8"));
            }
            catch (IOException e) {
                System.out.println(o.toString());
            }
        } else {
            System.out.println(o.toString());
        }
    }

    public APEXExport() {
        this._noFileStoreClob = false;
    }

    public APEXExport(boolean noFileStoreClob) {
        this._noFileStoreClob = noFileStoreClob;
    }

    @Override
    public void doCapture() throws Exception {
        if (this._expWorkspace) {
            this.ExportWorkspaces(this._workspaceID, this._expTeamdevdata, this._expMinimal);
        } else if (this._expFeedback) {
            this.ExpFeed(this._workspaceID, this._deploymentSystem, this._expFeedbackSince);
        } else if (this._expFiles) {
            this.ExportStaticFiles(this._workspaceID);
        } else if (this._list) {
            this.List(this._workspaceID, this._appID, this._changesSince, this._changesBy);
        } else {
            this.ExportFiles(this._appID, this._workspaceID, this._userName, this._components);
        }
    }

    @Override
    public LinkedHashMap<String, Clob> getClobData() {
        return this._clobData;
    }

    public void List(BigDecimal workspaceID, BigDecimal appID, String since, String by) throws SQLException, IOException {
        PreparedStatement stmt;
        if (appID != null) {
            stmt = this._gConn.prepareStatement(this.getXMLQueries().getQuery("gStmtListCompChanges", this._gConn).getSql());
            stmt.setBigDecimal(1, appID);
        } else {
            stmt = this._gConn.prepareStatement(this.getXMLQueries().getQuery("gStmtListAppChanges", this._gConn).getSql());
            stmt.setBigDecimal(1, workspaceID);
        }
        stmt.setString(2, since);
        stmt.setString(3, since);
        stmt.setString(4, by);
        stmt.setString(5, by);
        ResultSet result = stmt.executeQuery();
        APEXExport.write("Date             ID                                      Name");
        APEXExport.write("---------------- --------------------------------------- -----------------------");
        while (result.next()) {
            String d = result.getString(1);
            String id = result.getString(2);
            String name = result.getString(3);
            System.out.printf("%s %-39s %s\n", d, id, name);
        }
        stmt.close();
    }

    public void main(String[] args) throws Exception {
        this.processArgs(args);
        DriverManager.registerDriver((Driver)new OracleDriver());
        this.setupConnection();
        this.doCapture();
        this._gConn.close();
    }

    @Override
    public void processArgs(String[] args) throws InvalidParameterException {
        this._url = null;
        this._userName = null;
        this._password = null;
        this._workspaceID = null;
        this._appID = null;
        this._debug = false;
        this._skipDate = false;
        this._pubReports = false;
        this._savedReports = false;
        this._IRNotifications = false;
        this._expTranslations = false;
        this._instance = false;
        this._expWorkspace = false;
        this._expMinimal = false;
        this._expFiles = false;
        this._expFeedback = false;
        this._expTeamdevdata = false;
        this._deploymentSystem = null;
        this._expFeedbackSinceU = null;
        this._expFeedbackSince = null;
        this._expOriginalIds = false;
        this._split = false;
        this._expNoSubscriptions = false;
        this._expComments = false;
        this._expSupportingObjects = "";
        this._expACLAssignments = false;
        this._expLocked = false;
        this._checksum = true;
        this._dir = "";
        this._list = false;
        this._changesSince = "";
        this._changesBy = "";
        this._components = "";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h") || args[i].equalsIgnoreCase("-help")) {
                APEXExport.usage();
                throw new InvalidParameterException("");
            }
            if (args[i].equalsIgnoreCase("-db")) {
                this._url = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-user")) {
                this._userName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-password")) {
                this._password = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-workspaceid")) {
                this._workspaceID = new BigDecimal(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-applicationid")) {
                this._appID = new BigDecimal(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this._debug = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-skipExportDate")) {
                this._skipDate = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expPubReports")) {
                this._pubReports = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expSavedReports")) {
                this._savedReports = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expIRNotif")) {
                this._IRNotifications = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expTranslations")) {
                this._expTranslations = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-instance")) {
                this._instance = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expWorkspace")) {
                this._expWorkspace = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expMinimal")) {
                this._expMinimal = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expFiles")) {
                this._expFiles = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expFeedback")) {
                this._expFeedback = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expTeamdevdata")) {
                this._expTeamdevdata = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-deploymentSystem")) {
                this._deploymentSystem = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-expFeedbackSince")) {
                SimpleDateFormat dtFmt = new SimpleDateFormat("yyyyMMdd");
                try {
                    this._expFeedbackSinceU = dtFmt.parse(args[++i]);
                    this._expFeedbackSince = new Date(this._expFeedbackSinceU.getTime());
                    continue;
                }
                catch (ParseException e) {
                    throw new InvalidParameterException("Invalid date format: " + args[++i]);
                }
            }
            if (args[i].equalsIgnoreCase("-expOriginalIds")) {
                this._expOriginalIds = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-split")) {
                this._split = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expNoSubscriptions")) {
                this._expNoSubscriptions = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expComments")) {
                this._expComments = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expSupportingObjects")) {
                this._expSupportingObjects = args[++i];
                if (Arrays.asList("Y", "I", "N").contains(this._expSupportingObjects)) continue;
                throw new InvalidParameterException("Bad expSupportingObjects");
            }
            if (args[i].equalsIgnoreCase("-expACLAssignments")) {
                this._expACLAssignments = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expLocked")) {
                this._expLocked = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-nochecksum")) {
                this._checksum = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-dir")) {
                if (i == args.length - 1) {
                    APEXExport.usage();
                    return;
                }
                this._dir = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-list")) {
                this._list = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-changesSince")) {
                if (i == args.length - 1) {
                    APEXExport.usage();
                    return;
                }
                this._changesSince = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-changesBy")) {
                if (i == args.length - 1) {
                    APEXExport.usage();
                    return;
                }
                this._changesBy = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-expComponents")) {
                while (++i < args.length) {
                    this._components = this._components + "#" + args[i];
                }
                continue;
            }
            throw new InvalidParameterException("ERROR: Unknown parameter " + args[i]);
        }
        if (this._debug) {
            APEXExport.write("-db\t\t\t" + this._url);
            APEXExport.write("-user\t\t" + this._userName);
            APEXExport.write("-password\t" + this._password);
            APEXExport.write("workspaceid" + this._workspaceID);
            APEXExport.write("-applicationid\t" + this._appID);
            APEXExport.write("-debug\t\t" + this._debug);
            APEXExport.write("-skipExportDate\t" + this._skipDate);
            APEXExport.write("-expPubReports\t" + this._pubReports);
            APEXExport.write("-expSavedReports\t" + this._savedReports);
            APEXExport.write("-expIRNotif \t" + this._IRNotifications);
            APEXExport.write("-expTranslations \t" + this._expTranslations);
            APEXExport.write("-instance \t" + this._instance);
            APEXExport.write("-expWorkspace \t" + this._expWorkspace);
            APEXExport.write("-expMinimal \t" + this._expMinimal);
            APEXExport.write("-expFiles \t" + this._expFiles);
            APEXExport.write("-expFeedback \t" + this._expFeedback);
            APEXExport.write("-expTeamdevdata \t" + this._expTeamdevdata);
            APEXExport.write("-deploymentSystem \t" + this._deploymentSystem);
            APEXExport.write("-expFeedbackSince \t" + this._expFeedbackSinceU);
            APEXExport.write("-expOriginalIds \t" + this._expOriginalIds);
            APEXExport.write("-split \t" + this._split);
            APEXExport.write("-expNoSubscriptions \t" + this._expNoSubscriptions);
            APEXExport.write("-expComments \t" + this._expComments);
            APEXExport.write("-expSupportingObjects \t" + this._expSupportingObjects);
            APEXExport.write("-expACLAssignments \t" + this._expACLAssignments);
            APEXExport.write("-expLocked \t" + this._expLocked);
            APEXExport.write("-nochecksum \t" + this._checksum);
            APEXExport.write("-dir \t" + this._dir);
            APEXExport.write("-list \t" + this._list);
            APEXExport.write("-changesSince \t" + this._changesSince);
            APEXExport.write("-changesBy \t" + this._changesBy);
            APEXExport.write("-expComponents \t" + this._components);
        }
        if (this._appID != null && this._appID.longValue() == 0L && this._workspaceID != null && this._workspaceID.longValue() == 0L) {
            throw new InvalidParameterException();
        }
    }

    @Override
    public void setConnection(Connection conn) {
        this._gConn = conn;
    }

    @Override
    public void setCWD(String cwd) {
        if ((this._dir == null || this._dir.equals("")) && cwd != null) {
            this._dir = cwd;
        }
    }

    @Override
    public void setOutStream(OutputStream out) {
        _out = out;
    }

    private void bind_yn(OracleCallableStatement p_stmt, int p_pos, boolean p_val) throws SQLException {
        p_stmt.setString(p_pos, p_val ? "Y" : "N");
    }

    private void copyFile(File p_src, File p_dest) throws IOException {
        int l_length;
        FileInputStream l_is = new FileInputStream(p_src);
        FileOutputStream l_os = new FileOutputStream(p_dest);
        byte[] l_buffer = new byte[4096];
        while ((l_length = ((InputStream)l_is).read(l_buffer)) > 0) {
            ((OutputStream)l_os).write(l_buffer, 0, l_length);
        }
        try {
            if (l_is != null) {
                ((InputStream)l_is).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (l_os != null) {
                ((OutputStream)l_os).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void exec_and_save_files(OracleCallableStatement p_stmt) throws SQLException, IOException {
        Object[] l_result;
        java.util.Date now;
        if (this._debug) {
            now = new java.util.Date();
            APEXExport.write("  Start " + now);
        }
        p_stmt.execute();
        for (Object l_tmp : l_result = (Object[])((Array)p_stmt.getObject(1)).getArray()) {
            Struct l_rec = (Struct)l_tmp;
            if (this._debug) {
                APEXExport.write("  SQLTypeName: " + l_rec.getSQLTypeName());
                APEXExport.write("  Attr0: " + l_rec.getAttributes()[0].toString());
            }
            String l_name = (String)l_rec.getAttributes()[0];
            if (this._dir != "") {
                l_name = this._dir.replaceAll("/$", "") + "/" + l_name;
            }
            Clob l_contents = (Clob)l_rec.getAttributes()[1];
            this._clobData.put(l_name, l_contents);
        }
        p_stmt.close();
        if (this._debug) {
            now = new java.util.Date();
            APEXExport.write("  Completed at " + now);
        }
    }

    private void exec_and_write_files(OracleCallableStatement p_stmt) throws SQLException, IOException {
        Object[] l_result;
        java.util.Date now;
        if (this._debug) {
            now = new java.util.Date();
            APEXExport.write("  Start " + now);
        }
        p_stmt.execute();
        for (Object l_tmp : l_result = (Object[])((Array)p_stmt.getObject(1)).getArray()) {
            File l_target;
            String l_line;
            Struct l_rec = (Struct)l_tmp;
            if (this._debug) {
                APEXExport.write("  SQLTypeName: " + l_rec.getSQLTypeName());
                APEXExport.write("  Attr0: " + l_rec.getAttributes()[0].toString());
            }
            String l_name = (String)l_rec.getAttributes()[0];
            Clob l_contents = (Clob)l_rec.getAttributes()[1];
            if (this._dir != "") {
                l_name = this._dir.replaceAll("/$", "") + "/" + l_name;
            }
            if (this._debug) {
                APEXExport.write("  " + l_name + ": Copying from clob to temp file.");
            }
            File l_temp = File.createTempFile("apex", ".sql");
            BufferedWriter l_writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(l_temp), "UTF-8"));
            BufferedReader l_reader = new BufferedReader(l_contents.getCharacterStream());
            while ((l_line = l_reader.readLine()) != null) {
                l_line = l_line + "\n";
                l_writer.write(l_line, 0, l_line.length());
            }
            l_reader.close();
            l_writer.close();
            if (this._debug) {
                APEXExport.write("  ..Temp file written, now checking for changes.");
            }
            if (this.targetNeedsUpdate(l_temp, l_target = new File(l_name))) {
                l_target.mkdirs();
                l_target.delete();
                if (this._debug) {
                    APEXExport.write("  Copying temp file " + l_temp.getAbsolutePath());
                }
                this.copyFile(l_temp, l_target);
                l_temp.delete();
                if (!this._debug) continue;
                APEXExport.write("  Wrote " + l_target.length() + " bytes to " + l_target.getAbsolutePath());
                continue;
            }
            l_temp.delete();
            if (!this._debug) continue;
            APEXExport.write("  File " + l_target.getAbsolutePath() + " has not changed.");
        }
        p_stmt.close();
        if (this._debug) {
            now = new java.util.Date();
            APEXExport.write("  Completed at " + now);
        }
    }

    private void ExpFeed(BigDecimal workspaceID, String deploymentSystem, Date expFeedbackSince) throws SQLException, IOException {
        if (workspaceID != null && workspaceID.longValue() != 0L) {
            String wkspName = null;
            PreparedStatement stmt = this._gConn.prepareStatement(this.getXMLQueries().getQuery("gStmtWorkspace", this._gConn).getSql());
            stmt.setBigDecimal(1, workspaceID);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                wkspName = result.getString(1);
                APEXExport.write("Exporting Feedback for Workspace " + workspaceID + ":'" + wkspName + "' ");
                this.ExportFeedback(workspaceID, deploymentSystem, expFeedbackSince);
            }
            result.close();
            stmt.close();
        } else {
            String wkspName = null;
            PreparedStatement stmt = this._gConn.prepareStatement(this.getXMLQueries().getQuery("gStmtWorkspacesFeedback", this._gConn).getSql());
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                BigDecimal wkspID = result.getBigDecimal(1);
                wkspName = result.getString(2);
                APEXExport.write("Exporting Feedback for Workspace " + wkspID + ":'" + wkspName + "' ");
                this.ExportFeedback(wkspID, deploymentSystem, expFeedbackSince);
            }
            result.close();
            stmt.close();
        }
    }

    private void ExportFeedback(BigDecimal workspaceID, String deploymentSystem, Date expFeedbackSince) throws SQLException, IOException {
        OracleCallableStatement l_stmt = this.getExportStmt("begin\n    ? := apex_export.get_feedback (\n             p_workspace_id      => ?,\n             p_with_date         => ?='Y',\n             p_since             => ?,\n             p_deployment_system => ? );\nend;");
        l_stmt.setBigDecimal(2, workspaceID);
        this.bind_yn(l_stmt, 3, !this._skipDate);
        l_stmt.setDate(4, expFeedbackSince);
        l_stmt.setString(5, deploymentSystem);
        this.handle_write_or_save(l_stmt);
    }

    private void ExportFile(BigDecimal appID, boolean expPkgAppMapping, String components) throws SQLException, IOException {
        OracleCallableStatement l_stmt = this.getExportStmt("begin\n    ? := apex_export.get_application (\n             p_application_id          => ?,\n             p_split                   => ?='Y',\n             p_with_date               => ?='Y',\n             p_with_ir_public_reports  => ?='Y',\n             p_with_ir_private_reports => ?='Y',\n             p_with_ir_notifications   => ?='Y',\n             p_with_translations       => ?='Y',\n             p_with_pkg_app_mapping    => ?='Y',\n             p_with_original_ids       => ?='Y',\n             p_with_no_subscriptions   => ?='Y',\n             p_with_comments           => ?='Y',\n             p_with_supporting_objects => ?,\n             p_with_acl_assignments    => ?='Y',\n             p_components              => apex_string.split(?,'#') );\nend;");
        l_stmt.setBigDecimal(2, appID);
        this.bind_yn(l_stmt, 3, this._split);
        this.bind_yn(l_stmt, 4, !this._skipDate);
        this.bind_yn(l_stmt, 5, this._pubReports);
        this.bind_yn(l_stmt, 6, this._savedReports);
        this.bind_yn(l_stmt, 7, this._IRNotifications);
        this.bind_yn(l_stmt, 8, this._expTranslations);
        this.bind_yn(l_stmt, 9, expPkgAppMapping);
        this.bind_yn(l_stmt, 10, this._expOriginalIds);
        this.bind_yn(l_stmt, 11, this._expNoSubscriptions);
        this.bind_yn(l_stmt, 12, this._expComments);
        l_stmt.setString(13, this._expSupportingObjects);
        this.bind_yn(l_stmt, 14, this._expACLAssignments);
        l_stmt.setString(15, components);
        this.handle_write_or_save(l_stmt);
    }

    private void ExportFiles(BigDecimal appIDToExport, BigDecimal workspaceID, String userName, String components) throws SQLException, IOException {
        if (this._instance) {
            String appName = null;
            PreparedStatement stmt = this._gConn.prepareStatement(this.getXMLQueries().getQuery("gStmtInstance", this._gConn).getSql());
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                BigDecimal appID = result.getBigDecimal(1);
                appName = result.getString(2);
                System.out.println("Exporting Application " + appID + ":'" + appName + "' ");
                this.ExportFile(appID, true, components);
            }
            result.close();
            stmt.close();
        } else if (appIDToExport != null && appIDToExport.longValue() != 0L) {
            APEXExport.write("Exporting Application " + appIDToExport);
            this.ExportFile(appIDToExport, false, components);
        } else {
            BigDecimal securityGroupID = new BigDecimal(0);
            String appName = null;
            PreparedStatement stmt = this._gConn.prepareStatement(this.getXMLQueries().getQuery("gStmtSetSGID", this._gConn).getSql());
            stmt.setBigDecimal(1, workspaceID);
            stmt.executeUpdate();
            stmt.close();
            stmt = this._gConn.prepareStatement(this.getXMLQueries().getQuery("gStmtGetSGID", this._gConn).getSql());
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                securityGroupID = result.getBigDecimal(1);
            }
            result.close();
            stmt.close();
            if (!securityGroupID.equals(workspaceID)) {
                APEXExport.write("Invalid Workspace ID '" + workspaceID);
                return;
            }
            stmt = !this._expLocked ? this._gConn.prepareStatement(this.getXMLQueries().getQuery("gStmt", this._gConn).getSql()) : this._gConn.prepareStatement(this.getXMLQueries().getQuery("gStmt2", this._gConn).getSql());
            stmt.setBigDecimal(1, workspaceID);
            stmt.setBigDecimal(2, workspaceID);
            result = stmt.executeQuery();
            while (result.next()) {
                BigDecimal appID = result.getBigDecimal(1);
                appName = result.getString(2);
                System.out.println("Exporting Application " + appID + ":'" + appName + "' ");
                this.ExportFile(appID, true, components);
            }
            result.close();
            stmt.close();
        }
    }

    private void ExportStaticFiles(BigDecimal workspaceID) throws SQLException, IOException {
        OracleCallableStatement l_stmt = this.getExportStmt("begin\n    ? := apex_export.get_workspace_files (\n             p_workspace_id          => ?,\n             p_with_date             => ?='Y' );\nend;");
        l_stmt.setBigDecimal(2, workspaceID);
        this.bind_yn(l_stmt, 3, !this._skipDate);
        this.handle_write_or_save(l_stmt);
    }

    private void ExportWorkspace(BigDecimal workspaceID, boolean teamdevdata, boolean minimal) throws SQLException, IOException {
        OracleCallableStatement l_stmt = this.getExportStmt("begin\n    ? := apex_export.get_workspace (\n             p_workspace_id          => ?,\n             p_with_team_development => ?='Y',\n             p_with_misc             => ?='Y',\n             p_with_date             => ?='Y' );\nend;");
        l_stmt.setBigDecimal(2, workspaceID);
        this.bind_yn(l_stmt, 3, teamdevdata);
        this.bind_yn(l_stmt, 4, !minimal);
        this.bind_yn(l_stmt, 5, !this._skipDate);
        this.handle_write_or_save(l_stmt);
    }

    private void ExportWorkspaces(BigDecimal workspaceID, boolean teamdevdata, boolean minimal) throws SQLException, IOException {
        if (workspaceID != null && workspaceID.longValue() != 0L) {
            String wkspName = null;
            PreparedStatement stmt = this._gConn.prepareStatement(this.getXMLQueries().getQuery("gStmtWorkspace", this._gConn).getSql());
            stmt.setBigDecimal(1, workspaceID);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                wkspName = result.getString(1);
                APEXExport.write("Exporting Workspace " + workspaceID + ":'" + wkspName + "' ");
                this.ExportWorkspace(workspaceID, teamdevdata, minimal);
            }
            result.close();
            stmt.close();
        } else {
            String wkspName = null;
            PreparedStatement stmt = this._gConn.prepareStatement(this.getXMLQueries().getQuery("gStmtWorkspaces", this._gConn).getSql());
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                BigDecimal wkspID = result.getBigDecimal(1);
                wkspName = result.getString(2);
                System.out.println("Exporting Workspace " + wkspID + ":'" + wkspName + "' ");
                this.ExportWorkspace(wkspID, teamdevdata, minimal);
            }
            result.close();
            stmt.close();
        }
    }

    private OracleCallableStatement getExportStmt(String p_stmt) throws SQLException {
        if (this._debug) {
            try {
                APEXExport.write("  " + p_stmt.replace("\n", "\n  "));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OracleCallableStatement l_stmt = (OracleCallableStatement)this._gConn.prepareCall(p_stmt);
        l_stmt.registerOutParameter(1, 2003, "PUBLIC.APEX_T_EXPORT_FILES");
        return l_stmt;
    }

    private synchronized QueryXMLSupport getXMLQueries() {
        if (this._queries == null) {
            this._queries = QueryXMLSupport.getQueryXMLSupport(new MetaResource(ApexCmd.class.getClassLoader(), "oracle/dbtools/raptor/newscriptrunner/commands/commands.xml"));
        }
        return this._queries;
    }

    private void handle_write_or_save(OracleCallableStatement p_stmt) throws SQLException, IOException {
        if (this._noFileStoreClob) {
            this.exec_and_save_files(p_stmt);
        } else {
            this.exec_and_write_files(p_stmt);
        }
    }

    private void setupConnection() throws Exception {
        if (!this._noFileStoreClob) {
            this._gConn = DriverManager.getConnection("jdbc:oracle:thin:@" + this._url, this._userName, this._password);
        } else if (this._gConn == null) {
            APEXExport.usage();
            return;
        }
        this._gConn.setAutoCommit(true);
    }

    private boolean targetNeedsUpdate(File p_temp, File p_target) throws IOException {
        if (!this._checksum || !p_target.exists() || p_temp.length() != p_target.length()) {
            return true;
        }
        BufferedReader b1 = new BufferedReader(new FileReader(p_temp), Short.MAX_VALUE);
        BufferedReader b2 = new BufferedReader(new FileReader(p_target), Short.MAX_VALUE);
        boolean l_equal = true;
        boolean l_more = true;
        while (l_equal && l_more) {
            String s1 = b1.readLine();
            String s2 = b2.readLine();
            l_more = s1 != null;
            l_equal = s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2);
        }
        b1.close();
        b2.close();
        return !l_equal;
    }
}

