/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.newscriptrunner.CoreScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;

public class Substitution {
    static final int DEFAULT = 0;
    static final int ACCEPTINGSUBSTITUTION = 1;
    private ScriptRunnerContext scriptRunnerContext = null;
    boolean subStitutionMade = false;
    private String endCharacters = "?@\"'. =*-;,/~\n\r|%^()\t!<>+:&[]{}\\#$\u00a3";
    private Map<String, String> localMap = new HashMap<String, String>();

    public Substitution(ScriptRunnerContext context) {
        this.scriptRunnerContext = context;
    }

    public void replaceSubstitution(ISQLCommand cmd) throws SubstitutionException {
        if ((this.scriptRunnerContext.getSubstitutionOn() && this.scriptRunnerContext.getScanOn() || this.scriptRunnerContext.getEscape() && cmd.getSql().indexOf(this.scriptRunnerContext.getEscapeChar()) != -1) && cmd.getStmtId() != SQLCommand.StmtSubType.G_S_COMMENT_PLUS && !cmd.getStmtId().equals((Object)SQLCommand.StmtSubType.G_S_DOC_PLUS)) {
            String newLine = "\n\r";
            String in = cmd.getSql();
            this.subStitutionMade = false;
            boolean escapeNextChar = false;
            StringBuffer outStringBuffer = new StringBuffer();
            StringBuffer matchStringBuffer = new StringBuffer();
            String substitutionString = new Character(this.scriptRunnerContext.getSubstitutionChar()).toString();
            int state = 0;
            if (in.indexOf(substitutionString) == -1 && !this.scriptRunnerContext.getEscape()) {
                return;
            }
            if (cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_DOC_PLUS) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_COMMENT_PLUS)) {
                return;
            }
            if (!this.scriptRunnerContext.getSubstitutionOn() && !this.scriptRunnerContext.getEscape()) {
                return;
            }
            boolean concat = true;
            if (cmd.getProperty("STRIPPED_CONTINUATION") != null) {
                concat = false;
            }
            boolean eatspaces = false;
            int inLength = in.length();
            String intrim = in.trim();
            if (intrim.startsWith("/*") && intrim.endsWith("*/")) {
                return;
            }
            if (intrim.startsWith("--")) {
                return;
            }
            CoreScriptParser core = null;
            String splitIntoLines = intrim;
            if (splitIntoLines == null) {
                splitIntoLines = "";
            }
            int splitIndex = -1;
            int nextVal = -1;
            int maxLength = splitIntoLines.length();
            boolean exit = false;
            int j = -1;
            StringBuffer finalString = new StringBuffer();
            int lastsub = 0;
            int lastesc = 0;
            int prevIndex = 0;
            String current = null;
            while (!exit) {
                boolean shortCut = false;
                if (!(exit || state != 0 || escapeNextChar || this.scriptRunnerContext.getSubstitutionOn() && lastsub != -1 && (prevIndex != 0 && lastsub >= splitIndex + 1 || (lastsub = splitIntoLines.indexOf(this.scriptRunnerContext.getSubstitutionChar(), splitIndex + 1)) != -1) || this.scriptRunnerContext.getEscape() && this.scriptRunnerContext.getEscapeChar() != '\u0000' && lastesc != -1 && (prevIndex != 0 && lastesc >= splitIndex + 1 || (lastesc = splitIntoLines.indexOf(this.scriptRunnerContext.getEscapeChar(), splitIndex + 1)) != -1))) {
                    finalString.append(splitIntoLines.substring(splitIndex + 1));
                    exit = true;
                    continue;
                }
                if (core == null) {
                    core = new CoreScriptParser();
                }
                if ((nextVal = splitIntoLines.indexOf("\n", splitIndex + 1)) != -1) {
                    current = splitIntoLines.substring(splitIndex + 1, nextVal + 1);
                    prevIndex = splitIndex + 1;
                    splitIndex = nextVal;
                    ++j;
                } else {
                    if (splitIndex != maxLength - 1) {
                        current = splitIntoLines.substring(splitIndex + 1);
                        prevIndex = splitIndex + 1;
                        ++j;
                    }
                    exit = true;
                }
                if (!(exit || state != 0 || escapeNextChar || this.scriptRunnerContext.getSubstitutionOn() && lastsub != -1 && lastsub < nextVal + 1 && (lastsub >= prevIndex || (lastsub = splitIntoLines.indexOf(this.scriptRunnerContext.getSubstitutionChar(), prevIndex)) != -1 && lastsub < nextVal + 1) || this.scriptRunnerContext.getEscape() && this.scriptRunnerContext.getEscapeChar() != '\u0000' && lastesc != -1 && lastesc < nextVal + 1 && (lastesc >= prevIndex || (lastesc = splitIntoLines.indexOf(this.scriptRunnerContext.getEscapeChar(), prevIndex)) != -1 && lastesc < nextVal + 1))) {
                    if (current.endsWith("\n")) {
                        core.incrementalOkForSubst(current.substring(0, current.length() - 1), concat, true);
                    } else {
                        core.incrementalOkForSubst(current, concat, true);
                    }
                    finalString.append(current);
                    continue;
                }
                inLength = current.length();
                outStringBuffer.setLength(0);
                int stateUpUntil = 0;
                int stateUpUntili = 0;
                block7: for (int i = 0; i < inLength; ++i) {
                    char inChar = current.charAt(i);
                    switch (state) {
                        case 0: {
                            if (inChar == this.scriptRunnerContext.getSubstitutionChar() && !escapeNextChar) {
                                boolean reallyAmp = false;
                                reallyAmp = stateUpUntil == outStringBuffer.length() ? core.incrementalOkForSubst("", concat, false) : core.incrementalOkForSubst(outStringBuffer.substring(stateUpUntil), concat, false);
                                stateUpUntil = outStringBuffer.length();
                                stateUpUntili = i;
                                if (reallyAmp) {
                                    state = 1;
                                    eatspaces = true;
                                    matchStringBuffer = new StringBuffer();
                                    matchStringBuffer.append(inChar);
                                    continue block7;
                                }
                            }
                            if (this.scriptRunnerContext.getEscape() && inChar == this.scriptRunnerContext.getEscapeChar() && !escapeNextChar) {
                                escapeNextChar = true;
                                continue block7;
                            }
                            if (escapeNextChar) {
                                escapeNextChar = false;
                            }
                            outStringBuffer.append(inChar);
                            continue block7;
                        }
                        case 1: {
                            if (eatspaces && !Character.isWhitespace(inChar)) {
                                eatspaces = false;
                            }
                            if (this.scriptRunnerContext.getSubstitutionTerminateChar() != null && inChar == this.scriptRunnerContext.getSubstitutionTerminateChar().charValue()) {
                                if (matchStringBuffer.toString().trim().equals("")) {
                                    throw new SubstitutionException(ScriptRunnerContext.lineErr(new Integer(cmd.getStartLine() + 1), cmd.getSQLOrig(), ScriptRunnerDbArb.getString("INVALID_SUBSTITUTION"), this.scriptRunnerContext));
                                }
                                String match = this.getSubString(matchStringBuffer.toString());
                                if (match == null) {
                                    this.scriptRunnerContext.setExited(true);
                                    throw new SubstitutionException("\n" + this.getCancelled());
                                }
                                outStringBuffer.append(match);
                                state = 0;
                                continue block7;
                            }
                            if (!(this.endCharacters.indexOf(inChar) == -1 || eatspaces && Character.isWhitespace(inChar) || inChar == this.scriptRunnerContext.getSubstitutionChar() && matchStringBuffer.toString().equals(substitutionString))) {
                                if (Character.isWhitespace(inChar) && matchStringBuffer.toString().endsWith(substitutionString)) continue block7;
                                String match = this.getSubString(matchStringBuffer.toString());
                                if (match == null) {
                                    if (this.scriptRunnerContext.isSQLPlusClassic()) {
                                        this.scriptRunnerContext.setExited(true);
                                    }
                                    throw new SubstitutionException("\n" + this.getCancelled());
                                }
                                outStringBuffer.append(match);
                                --i;
                                state = 0;
                                continue block7;
                            }
                            matchStringBuffer.append(inChar);
                        }
                    }
                }
                if (exit && state == 1) {
                    String match = "";
                    if (matchStringBuffer.toString().trim().equals("")) {
                        throw new SubstitutionException(ScriptRunnerContext.lineErr(new Integer(cmd.getStartLine() + 1), cmd.getSQLOrig(), ScriptRunnerDbArb.getString("INVALID_SUBSTITUTION"), this.scriptRunnerContext));
                    }
                    match = this.getSubString(matchStringBuffer.toString());
                    if (match == null) {
                        this.scriptRunnerContext.setExited(true);
                        throw new SubstitutionException("\n" + this.getCancelled());
                    }
                    outStringBuffer.append(match);
                }
                if (outStringBuffer.length() <= stateUpUntil) {
                    core.incrementalOkForSubst("", concat, true);
                } else {
                    int olength = outStringBuffer.length();
                    if (olength > 0 && outStringBuffer.charAt(olength - 1) == '\n') {
                        core.incrementalOkForSubst(outStringBuffer.substring(stateUpUntil, olength - 1), concat, true);
                    } else {
                        core.incrementalOkForSubst(outStringBuffer.substring(stateUpUntil), concat, true);
                    }
                }
                finalString.append(outStringBuffer);
                if (!this.scriptRunnerContext.isSQLPlusClassic() || !this.scriptRunnerContext.isVerifyOn() || cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQLPLUS)) continue;
                String anewLine = outStringBuffer.toString();
                if (!(current.trim().equals(anewLine.trim()) || this.scriptRunnerContext.getEscape() && this.stripEsc(this.scriptRunnerContext, current.trim()).equals(this.stripEsc(this.scriptRunnerContext, anewLine.trim())))) {
                    this.scriptRunnerContext.write(MessageFormat.format("old  {0}: {1}\n", j + 1, current.replaceAll("\\s+$", "")));
                    this.scriptRunnerContext.write(MessageFormat.format("new  {0}: {1}\n", j + 1, anewLine.replaceAll("\\s+$", "")));
                }
                try {
                    this.scriptRunnerContext.getOutputStream().flush();
                }
                catch (IOException iOException) {}
            }
            if (this.subStitutionMade && this.scriptRunnerContext.isVerifyOn() && !cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQLPLUS) && !this.scriptRunnerContext.isSQLPlusClassic()) {
                cmd.setProperty("prop_printed_string", ScriptRunnerDbArb.getString("SUBSTITUTIONOLD") + cmd.getSql() + "\n" + ScriptRunnerDbArb.getString("SUBSTITUTIONNEW") + finalString + "\n");
            }
            if (this.subStitutionMade) {
                this.resetBooleanProperty(cmd);
            }
            cmd.setProperty("prop_post_substitution", finalString.toString());
            cmd.setSql(finalString.toString());
            return;
        }
    }

    private String stripEsc(ScriptRunnerContext ctx, String in) {
        StringBuffer inBuffer = new StringBuffer(in);
        StringBuffer outBuffer = new StringBuffer();
        char escape = ctx.getEscapeChar();
        for (int i = 0; i < inBuffer.length(); ++i) {
            char current = inBuffer.charAt(i);
            if (current == escape) continue;
            outBuffer.append(current);
        }
        return outBuffer.toString().trim();
    }

    private String getCancelled() {
        ScriptRunnerContext ctx = this.scriptRunnerContext;
        String retVal = null;
        retVal = ctx.getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(ctx.getProperty("sqlplus.classic.mode").toString()) ? ScriptRunnerDbArb.getString("SUBSTITUTION_CANCELLED_CLASSIC") : ScriptRunnerDbArb.getString("SUBSTITUTION_CANCELLED");
        return retVal;
    }

    private String getSubString(String subVal) {
        String toOrig = subVal.trim();
        boolean atAt = false;
        String contextSubString = Character.toString(this.scriptRunnerContext.getSubstitutionChar());
        String doubleSub = contextSubString + contextSubString;
        if (toOrig.equals(doubleSub) || toOrig.equals(contextSubString)) {
            return subVal;
        }
        this.subStitutionMade = true;
        String toUpper = null;
        if (toOrig.startsWith(doubleSub)) {
            atAt = true;
            toOrig = toOrig.substring(2).trim();
        } else if (toOrig.startsWith(contextSubString)) {
            toOrig = toOrig.substring(1).trim();
        }
        toUpper = toOrig.toUpperCase();
        Map<String, String> map = this.scriptRunnerContext.getMap();
        String match = null;
        try {
            ScriptRunnerContext.SqlplusVariable v = ScriptRunnerContext.SqlplusVariable.valueOf(toUpper);
            match = this.scriptRunnerContext.doPromptReplaceSqlplusVar(v.toString(), v);
        }
        catch (IllegalArgumentException iae) {
            match = map.get(toUpper);
        }
        if (match == null) {
            match = this.scriptRunnerContext.getSubstitutionFieldProvider().getPromptedField(this.scriptRunnerContext, ScriptRunnerDbArb.format("SUBST_PROMPT", toOrig), false);
            if (atAt && match != null) {
                map.put(toUpper, match);
            }
        }
        if (match != null) {
            this.localMap.put(toUpper, match);
        }
        return match;
    }

    private void resetBooleanProperty(ISQLCommand cmd) {
        String prop = (String)cmd.getProperty("prop_file_string");
        if (prop != null && prop.length() > 1 && (prop.charAt(0) == this.scriptRunnerContext.getSubstitutionChar() || Character.toString(prop.charAt(0)).toLowerCase().equals(Character.toString(this.scriptRunnerContext.getSubstitutionChar())) || Character.toString(prop.charAt(0)).toUpperCase().equals(Character.toString(this.scriptRunnerContext.getSubstitutionChar())))) {
            String lookup = prop.substring(1).trim().toUpperCase();
            int i = 0;
            for (i = 0; i < lookup.length() && !this.endCharacters.contains(Character.toString(lookup.charAt(i))); ++i) {
            }
            if (i != 0) {
                lookup = this.localMap.get(lookup.substring(0, i));
            }
            if (lookup != null && i != 0) {
                String lookupLower = lookup.toLowerCase();
                if (lookupLower.equals("off")) {
                    cmd.setProperty("prop_status_boolean", new Boolean(false));
                } else if (lookupLower.equals("on")) {
                    cmd.setProperty("prop_status_boolean", new Boolean(true));
                }
                cmd.setProperty("prop_file_string", lookup);
            }
        }
    }

    public class SubstitutionException
    extends Exception {
        SubstitutionException(String msg) {
            super(msg);
        }
    }
}

