/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONComposer;
import com.fasterxml.jackson.jr.ob.comp.ArrayComposer;
import com.fasterxml.jackson.jr.ob.comp.ObjectComposer;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.t2format.T2Metrics;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.jdbc.OracleConnection;
import oracle.sql.Datum;

public class T2Formatter
extends ResultsFormatter {
    private static final Logger LOGGER = Logger.getLogger(ResultsFormatter.class.getName());
    public static final String TYPE = "T2";
    public static final String EXT = "t2";
    public static final String METRICS = "metrics";
    public static final String METRIC_TYPE = "gauge";
    public static final Integer METRIC_COUNT = 1;
    private HashMap<String, Object> rowData = new HashMap();
    private static final String lineSeparator = System.getProperty("line.separator");
    private boolean _topLevel = true;
    private JsonGenerator jGen = null;
    private T2Metrics bean = null;
    private List<String> columns = null;
    private List<String> tables = null;
    private String appndColsData = "";
    private String json = "";

    public T2Formatter() {
        super(TYPE, Messages.getString("T2Formatter.0"), EXT);
    }

    @Override
    public void setTableName(String tName) {
    }

    public void setTopLevel(boolean b) {
        this._topLevel = b;
    }

    @Override
    public void start() throws IOException {
        try {
            String sql = this.getWrapper().getSQL();
            if (sql != null) {
                this.columns = SqlRecognizer.getColumns(sql);
                this.tables = SqlRecognizer.getTables(sql);
            }
            this.jGen = JSON.std.getStreamingFactory().createGenerator(this.getOutputStream()).useDefaultPrettyPrinter();
            ((DefaultPrettyPrinter)this.jGen.getPrettyPrinter()).indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
            this.jGen.enable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
            this.jGen.enable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
            this.jGen.writeStartObject();
            this.jGen.writeFieldName(METRICS);
            this.jGen.writeStartArray();
            this.jGen.writeRaw("\n");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
    }

    @Override
    public void startRow() throws IOException {
        long row = this.getResultsFormatterWrapper().getRowNum();
        if (row > 1L) {
            this.jGen.writeRaw(",\n");
        }
        this.appndColsData = "";
    }

    @Override
    public void printColumn(Object col, int viewIndex, int modelIndex) throws IOException {
        try {
            this.genMetricCol(col, viewIndex, modelIndex);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void genMetricCol(Object col, int viewIndex, int modelIndex) throws IOException, SQLException {
        int type = this.getDataType(viewIndex);
        this.getConnection().getMetaData();
        String database = ((OracleConnection)this.getConnection()).getProperties().getProperty("database");
        String pdb = database.split("/").length > 1 ? database.split("/")[1] : (database.split(":").length > 2 ? database.split(":")[2] : null);
        String colName = this.getColumnName(viewIndex);
        String tblName = "";
        if (this.tables.size() == 1) {
            tblName = this.tables.get(0);
            String[] strs = tblName.split("\\s");
            tblName = strs.length > 1 ? strs[0] : tblName;
            tblName = tblName.replaceAll("(?i:v\\$)", "");
        } else {
            for (String tbl : this.tables) {
                String aliasOrName = tbl.split("\\s").length > 1 ? tbl.split("\\s")[1] : tbl.split("\\s")[0];
                String[] tblstrs = tbl.split("\\s");
                String alias = tblstrs[1];
                String tlName = tblstrs[0];
                tlName = tlName.replaceAll("(?i:v\\$)", "");
                for (String cl : this.columns) {
                    String[] clstrs = cl.split("\\.");
                    if (clstrs.length <= 1 || !clstrs[0].equals(aliasOrName) || !clstrs[1].toLowerCase().equals(colName.toLowerCase())) continue;
                    tblName = tlName;
                }
            }
        }
        String value = "";
        Object val = null;
        if (type != -10) {
            if (col != null) {
                switch (type) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: {
                        value = DataTypesUtil.stringValue(col, this.getConnection());
                        break;
                    }
                    default: {
                        value = DataTypesUtil.stringValue(col, this.getConnection());
                        break;
                    }
                }
            } else {
                value = (String)col;
            }
        } else {
            value = (String)col;
        }
        Long epoch = this.getEpochSeconds();
        if (viewIndex == 2 && colName.equalsIgnoreCase("VALUE")) {
            String name = pdb + "." + tblName + "." + this.appndColsData;
            HashMap map = new HashMap();
            this.bean = new T2Metrics(name, METRIC_TYPE, map, epoch, value, METRIC_COUNT);
            String json = (String)((JSONComposer)((ObjectComposer)((ArrayComposer)((ObjectComposer)((ArrayComposer)((ObjectComposer)JSON.std.with(new JSON.Feature[]{JSON.Feature.PRETTY_PRINT_OUTPUT}).composeString().startObject().put("name", name).put("metricType", METRIC_TYPE).startObjectField("config").end()).startArrayField("series").startObject().put("second", epoch.longValue()).startArrayField("values").startObject().put("count", 1).put("value", value).end()).end()).end()).end()).end()).finish();
            this.jGen.writeRaw(json);
        } else if (value != null) {
            value = value.replaceAll("\\s+", "_");
            this.appndColsData = this.appndColsData + (this.appndColsData == "" ? value : "_" + value);
        }
    }

    private Long getEpochSeconds() throws SQLException {
        Long seconds = null;
        Statement stmt = null;
        ResultSet rs = null;
        String query = "SELECT (CAST (SYSTIMESTAMP AT TIME ZONE 'UTC' AS DATE) - DATE '1970-01-01') * 86400 FROM DUAL";
        stmt = this.getConnection().createStatement();
        rs = stmt.executeQuery(query);
        if (rs.next()) {
            seconds = rs.getLong(1);
        }
        stmt.close();
        rs.close();
        return seconds;
    }

    private void storeColData(Object col, int viewIndex, int modelIndex) throws IOException {
        int type = this.getDataType(viewIndex);
        String name = this.getColumnName(viewIndex).toLowerCase();
        this.jGen.writeFieldName(name);
        Object val = null;
        if (type != -10) {
            if (col != null) {
                try {
                    switch (type) {
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 6: 
                        case 7: 
                        case 8: {
                            this.jGen.writeNumber(((Datum)col).stringValue());
                            break;
                        }
                        default: {
                            val = this.getValue(col);
                            this.jGen.writeObject(val);
                            break;
                        }
                    }
                }
                catch (SQLException ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                }
            } else {
                val = col;
                this.jGen.writeObject(val);
            }
        } else {
            val = col;
            this.jGen.writeObject(val);
        }
    }

    @Override
    public void endRow() throws IOException {
        this.jGen.flush();
    }

    @Override
    public void end() throws IOException {
        this.jGen.writeEndArray();
        this.jGen.writeEndObject();
        this.jGen.flush();
        this.write(lineSeparator);
    }

    @Override
    public Boolean isCandidateForSpoolMax() {
        return true;
    }
}

