/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultSetFormatterWrapper;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public class JSONFormatter
extends ResultsFormatter {
    public static final String TYPE = "JSON";
    public static final String EXT = "json";
    private static final String MIME = "application/json";
    private ArrayList<Col> jsonRowData = new ArrayList();
    private boolean _topLevel = true;
    private ArrayList<String> m_colnames = null;
    private ArrayList<String> m_currRow = null;

    public JSONFormatter() {
        super(TYPE, Messages.getString("JSONFormatter.0"), EXT);
    }

    @Override
    public String getMimeType() {
        return MIME;
    }

    public void setTopLevel(boolean b) {
        this._topLevel = b;
    }

    @Override
    public void setTableName(String tName) {
    }

    @Override
    public void start() throws IOException {
        this.m_colnames = new ArrayList();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.m_colnames.add(this.getColumnName(i));
        }
        if (this._topLevel) {
            try {
                this.write(this.getColumnMetadata());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.write(",\"items\":\n");
        }
        this.write("[\n");
    }

    private String getColumnMetadata() throws SQLException {
        StringBuffer sb = new StringBuffer();
        if (this.getScriptContext() != null && this.getScriptContext().isJSONOutput()) {
            sb.append("],");
        } else {
            sb.append("{");
        }
        sb.append("\"results\":[{");
        sb.append(this.q("columns") + ":[");
        for (int i = 0; i < this.getWrapper().getColumnCount(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("{" + this.q("name") + ":" + this.q(this.getWrapper().getColumnName(i)));
            sb.append(",");
            String dataTypeName = this.getDataTypeName(i);
            sb.append(this.q("type") + ":" + this.q(dataTypeName) + "}");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void startRow() throws IOException {
        this.m_currRow = new ArrayList();
        long row = this.getResultsFormatterWrapper().getRowNum();
        this.jsonRowData.clear();
        if (row > 1L) {
            this.write(",");
        }
    }

    @Override
    public void printColumn(Object col, int viewIndex, int modelIndex) {
        int type = this.getDataType(viewIndex);
        String name = this.getColumnName(viewIndex).toLowerCase();
        Object val = null;
        if (type == 2005) {
            Integer size = null;
            if (this.getScriptContext() != null) {
                size = (Integer)this.getScriptContext().getProperty("script.runner.setlong");
            }
            String store = null;
            store = size != null ? DataTypesUtil.stringValue(col, this.getScriptContext().getCurrentConnection(), size) : DataTypesUtil.stringValue(col, this.getScriptContext().getCurrentConnection());
            val = store;
        } else if (type != -10) {
            val = this.getValue(col);
        } else if (col instanceof ResultSet) {
            JSONFormatter json = new JSONFormatter();
            ResultSet rs = (ResultSet)col;
            json.setDataProvider(new ResultSetFormatterWrapper(rs, ResultSetFormatterWrapper.ObjectType.GENERIC));
            json.setTopLevel(false);
            StringWriter writer = new StringWriter();
            json.print(writer);
            StringBuffer sb = writer.getBuffer();
            val = sb.toString();
        }
        Col c = new Col(name, val, type);
        if (val == null) {
            this.m_currRow.add("");
        } else {
            this.m_currRow.add(val.toString());
        }
        this.jsonRowData.add(c);
    }

    @Override
    public void endRow() {
        try {
            this.write("{");
            boolean first = true;
            for (Col col : this.jsonRowData) {
                if (!first && !col.isNullValue()) {
                    this.write(",");
                }
                if (col.isNullValue()) continue;
                this.write(col.getName() + ":" + col.getValue());
                first = false;
            }
            this.write("}" + System.lineSeparator());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void end() throws IOException {
        JSONFormatter.handleColumnNewVal(this.getScriptContext(), this.m_colnames, this.m_currRow);
        this.write("]");
        if (this._topLevel) {
            this.write("}");
        }
        if (this.getScriptContext() != null && this.getScriptContext().isJSONOutput()) {
            this.getScriptContext().setJSONQueryRun(true);
        } else {
            this.write("]}");
        }
    }

    public String q(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        sb.append(this.createValidJSON(string));
        sb.append('\"');
        return sb.toString();
    }

    private StringBuffer createValidJSON(String string) {
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer();
        block9: for (int i = 0; i < len; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        return sb;
    }

    @Override
    public Boolean isCandidateForSpoolMax() {
        return true;
    }

    class Col {
        private String _name;
        private Object _val;
        private int _type;

        Col(String name, Object val, int type) {
            this._name = name;
            this._val = val;
            this._type = type;
        }

        public String getName() {
            return JSONFormatter.this.q(this._name);
        }

        public Object getValue() throws IOException {
            if (this._val != null && (this._type == 4 || this._type == -5 || this._type == 6 || this._type == 7 || this._type == 8 || this._type == 2 || this._type == 2 || this._type == -6 || this._type == 3)) {
                return this._val.toString();
            }
            if (this._val != null && this._type == -10) {
                this._val.toString();
            } else if (this._val != null) {
                return JSONFormatter.this.q(this._val.toString());
            }
            return this._val;
        }

        public boolean isNullValue() {
            return this._val == null;
        }

        public int getType() {
            return this._type;
        }
    }
}

