/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.format.IContextAwareFormatter;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.SetPause;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.IListPrinter;
import oracle.dbtools.raptor.utils.ListPrinter;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.util.Logger;
import oracle.sql.NUMBER;

public class ANSIConsoleFormatter
extends ResultsFormatter
implements IContextAwareFormatter {
    public static final String TYPE = "ansiconsole";
    private List<List<?>> data = new ArrayList();
    private ArrayList<String> lastRow = null;
    private ArrayList<String> currRow = null;
    private ArrayList<String> colNames;
    private ArrayList<Boolean> numberCol = new ArrayList();
    boolean hasData = false;
    private static IListPrinter _listPrinter = new ListPrinter();
    private int _totalRows = 0;

    public ANSIConsoleFormatter() {
        super(TYPE, null, ".log");
    }

    @Override
    public void setContext(ScriptRunnerContext ctx) {
        _listPrinter.setScriptContext(ctx);
    }

    @Override
    public void start() throws IOException {
        this.data.clear();
        this.lastRow = null;
        this.hasData = false;
        this._totalRows = 0;
        this.colNames = new ArrayList();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.colNames.add(this.getColumnName(i));
            this.numberCol.add(this.getDataType(i) == 2);
        }
        this.getScriptContext().write("\n");
    }

    @Override
    public void startRow() throws IOException {
        this.lastRow = this.currRow;
        this.currRow = new ArrayList();
    }

    @Override
    public void printColumn(Object col, int viewIndex, int modelIndex) throws IOException {
        Integer size;
        this.hasData = true;
        if (col != null && col instanceof NUMBER) {
            try {
                col = ((NUMBER)col).bigDecimalValue();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        String val = null;
        String[] formatterOptions = (String[])this.getScriptContext().getProperty("sql.format.full");
        String numFormat = null;
        if (formatterOptions != null && formatterOptions.length > 3) {
            String[] opts = new String[formatterOptions.length - 3];
            System.arraycopy(formatterOptions, 3, opts, 0, formatterOptions.length - 3);
            if (opts != null) {
                for (String s : opts) {
                    if (s == null || s.startsWith("-config")) continue;
                    numFormat = (numFormat != null ? numFormat : "") + s;
                }
            }
        }
        if (col instanceof Number) {
            if (numFormat != null) {
                DecimalFormat formatter;
                if (numFormat.equalsIgnoreCase("default")) {
                    formatter = (DecimalFormat)NumberFormat.getInstance();
                    formatter.applyPattern("###,###.###########################################################################");
                    val = formatter.format((Number)col);
                } else {
                    try {
                        formatter = (DecimalFormat)NumberFormat.getInstance();
                        formatter.applyPattern(numFormat);
                        val = formatter.format((Number)col);
                    }
                    catch (Exception e) {
                        val = "INVALID FORMAT";
                    }
                }
            }
            if (val == null || numFormat == null) {
                val = NLSUtils.format(this.getConnection(), col);
            }
            this.currRow.add(val);
        } else if (col instanceof Clob) {
            size = null;
            if (this.getScriptContext() != null) {
                size = (Integer)this.getScriptContext().getProperty("script.runner.setlong");
            }
            val = size != null ? DataTypesUtil.stringValue(col, this.getConnection(), size) : DataTypesUtil.stringValue(col, this.getConnection());
            this.currRow.add(val);
        } else if (col instanceof Blob) {
            size = null;
            if (this.getScriptContext() != null) {
                size = (Integer)this.getScriptContext().getProperty("script.runner.setlong");
            }
            Blob bb = (Blob)col;
            String ss = null;
            if (bb != null) {
                byte[] bdata = null;
                try {
                    int printSize = size != null ? size : (int)bb.length();
                    bdata = bb.getBytes(1L, printSize);
                    ss = bdata == null ? "" : new String(ScriptUtils.bytesToHex(bdata)).toUpperCase();
                }
                catch (SQLException e) {
                    Logger.warn(this.getClass(), e);
                }
            }
            val = size != null ? DataTypesUtil.stringValue(ss, this.getConnection(), size) : DataTypesUtil.stringValue(ss, this.getConnection());
            this.currRow.add(val);
        } else if (col instanceof ResultSet) {
            this.currRow.add("Cursor");
        } else {
            this.currRow.add(NLSUtils.format(this.getConnection(), col));
        }
    }

    @Override
    public void endRow() throws IOException {
        this.data.add(this.data.size(), this.currRow);
        int pagesize = this.getPageSize();
        if (this.data.size() >= pagesize) {
            this.getOutputStream().flush();
            SetPause.directWriteOut(this.getScriptContext(), new OutputStreamWriter(this.getOutputStream()));
            this.printDataList(pagesize, "");
        }
    }

    @Override
    public void end() throws IOException {
        int pagesize = this.getPageSize();
        if (this.data != null && !this.data.isEmpty()) {
            this.getOutputStream().flush();
            SetPause.directWriteOut(this.getScriptContext(), new OutputStreamWriter(this.getOutputStream()));
        }
        Boolean before = (Boolean)this.getScriptContext().getProperty("ILISTPRINTER_MUTE_NEWLINE");
        try {
            this.getScriptContext().putProperty("ILISTPRINTER_MUTE_NEWLINE", Boolean.TRUE);
            this.printDataList(pagesize, "");
        }
        finally {
            if (before == null) {
                this.getScriptContext().removeProperty("ILISTPRINTER_MUTE_NEWLINE");
            } else {
                this.getScriptContext().putProperty("ILISTPRINTER_MUTE_NEWLINE", before);
            }
        }
        ArrayList<String> lastData = null;
        lastData = this.currRow != null && !this.currRow.isEmpty() ? this.currRow : this.lastRow;
        if (this.getScriptContext() != null && this.getScriptContext().getColumnMap() != null && !this.getScriptContext().getColumnMap().isEmpty() && this.colNames != null) {
            ArrayList<String> colNamesPlus1 = new ArrayList<String>();
            colNamesPlus1.add("");
            for (String colName : this.colNames) {
                colNamesPlus1.add(colName);
            }
            if (!this.hasData) {
                this.getScriptContext().updateColumn(colNamesPlus1.toArray(new String[colNamesPlus1.size()]), null, null);
            } else if (lastData != null && this.getScriptContext() != null && this.colNames.size() == lastData.size()) {
                ArrayList<String> lastDataPlus1 = new ArrayList<String>();
                lastDataPlus1.add("");
                for (String value : lastData) {
                    lastDataPlus1.add(value);
                }
                this.getScriptContext().updateColumn(colNamesPlus1.toArray(new String[colNamesPlus1.size()]), lastDataPlus1.toArray(new String[lastDataPlus1.size()]), null);
            }
        }
    }

    private void printDataList(int pagesize, String nullDisplay) throws IOException {
        this._totalRows += this.data.size();
        this.data.add(0, this.colNames);
        _listPrinter.print(this.getOutputStream(), this.getConnection(), this.data, pagesize, nullDisplay, this.numberCol);
        this.data.clear();
    }

    private int getPageSize() {
        int pagesize = 0;
        try {
            pagesize = (Integer)this.getScriptContext().getProperty("script.runner.setpagesize");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pagesize;
    }

    @Override
    public boolean allowsLobs() {
        return true;
    }

    @Override
    public void setTableName(String tName) {
    }

    @Override
    public boolean isInternalOnly() {
        return true;
    }

    public static String join(List<String> s, String delimiter) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        Iterator<String> iter = s.iterator();
        StringBuilder builder = new StringBuilder(iter.next());
        while (iter.hasNext()) {
            builder.append(delimiter).append(iter.next());
        }
        return builder.toString();
    }

    public static void setListPrinter(IListPrinter listprinter) {
        _listPrinter = listprinter;
    }

    @Override
    public Boolean isCandidateForSpoolMax() {
        return true;
    }
}

