/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.deployment;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.deployment.DeployQuery;
import oracle.dbtools.raptor.deployment.SDDeployResources;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.ToolLogger;
import oracle.dbtools.util.Logger;

public class SDDeployAPI {
    private static final String NL = "\n";
    private static final String SPACE = " ";
    private static final int TABLE_NOT_FOUND = 942;
    Connection _conn;
    String _connName;
    String _connUser;
    String _schema;
    boolean _isConnLocked;
    boolean _isSchemaConnOwner;
    ExitCode _exitCode;
    ToolLogger _tLogger;

    public SDDeployAPI(ToolLogger tLogger) {
        this._tLogger = tLogger;
    }

    public void setConnLocked(boolean isConnLocked) {
        this._isConnLocked = isConnLocked;
    }

    public void setTLogger(ToolLogger tLogger) {
        this._tLogger = tLogger;
    }

    public ExitCode startService(String connName, Connection conn, String connUser, String schema) {
        this.setExitCode(ExitCode.EXIT_SUCCESS);
        this._connName = connName;
        this._conn = conn;
        this._connUser = connUser;
        this._schema = schema;
        this._isSchemaConnOwner = this._connUser.equals(this._schema);
        return this.getExitCode();
    }

    public ExitCode restartService(String connName, Connection conn, String connUser, String schema) {
        return this.startService(connName, conn, connUser, schema);
    }

    public ExitCode getExitCode() {
        return this._exitCode;
    }

    private void setExitCodeError(Exception e) {
        this._exitCode = ExitCode.EXIT_ERROR;
        this._exitCode.setShortMessage(SDDeployResources.getString("SD_DEPLOY_STATEMENT_FAILED") + SPACE);
        String msg = this.getExitCode().getShortMessage() + e.getLocalizedMessage();
        Logger.warn(this.getClass(), msg, e);
        this.tLogException(e);
    }

    private void setExitCode(ExitCode exitCode) {
        this._exitCode = exitCode;
    }

    protected Connection getConnection() {
        return this._conn;
    }

    protected String getConnectionUser() {
        return this._connUser;
    }

    public void insert(Row row) throws SQLException {
        try {
            this.lockedExecuteUpdate(row, Row.Op.INSERT, false);
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 942) {
                if (this.createTable(row)) {
                    this.lockedExecuteUpdate(row, Row.Op.INSERT, true);
                }
                throw new SQLException(this.getExitCode().getShortMessage(), ex);
            }
            this.setExitCodeError(ex);
            throw ex;
        }
    }

    private boolean createTable(Row row) {
        String query = DeployQuery.getQuery(row.getCreateQueryId(), this.getConnection());
        if (!this.executeSql(query)) {
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setShortMessage(SDDeployResources.getString("SD_DEPLOY_STATEMENT_FAILED") + SPACE + SDDeployResources.format("SD_DEPLOY_CREATE_TABLE", row.getTableName()));
            this.setExitCode(exitCode);
            this.tLog(exitCode.getShortMessage());
            return false;
        }
        return true;
    }

    public void update(Row row) throws SQLException {
        try {
            this.lockedExecuteUpdate(row, Row.Op.UPDATE, true);
        }
        catch (SQLException ex) {
            this.setExitCodeError(ex);
            throw ex;
        }
    }

    private void lockedExecuteUpdate(Row row, Row.Op operation, boolean setExitCodeError) throws SQLException {
        if (row.needsPreparedStatement(operation)) {
            PreparedStatement stmt = row.getPreparedStatment(operation, this.getConnection());
            if (this.lock()) {
                try {
                    stmt.execute();
                }
                catch (SQLException ex) {
                    if (setExitCodeError) {
                        this.setExitCodeError(ex);
                    }
                    throw ex;
                }
                finally {
                    stmt.close();
                    this.unlock();
                }
            }
        } else {
            String query = row.getSql(operation);
            LinkedHashMap<String, Object> binds = row.getBinds(operation);
            this.lockedExecuteSql(query, binds, setExitCodeError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockedExecuteSql(String query, Map<String, Object> binds, boolean setExitCodeError) throws SQLException {
        DBUtil dbUtil = DBUtil.getInstance(this.getConnection());
        if (this.lock()) {
            try {
                dbUtil.executeUpdate(query, binds);
            }
            finally {
                this.unlock();
                SQLException ex = dbUtil.getLastException();
                if (ex != null) {
                    if (setExitCodeError) {
                        this.setExitCodeError(ex);
                    }
                    throw ex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeSql(String script) {
        Connection conn = this.getConnection();
        try {
            try {
                conn.setSchema(this._schema);
            }
            catch (Exception e) {
                this.setExitCodeError(e);
                boolean bl = false;
                if (!this._isSchemaConnOwner) {
                    try {
                        conn.setSchema(this.getConnectionUser());
                    }
                    catch (Exception e2) {
                        this.setExitCodeError(e2);
                        return false;
                    }
                }
                return bl;
            }
            String finalScript = script + NL;
            this.tLog(finalScript);
            String encoding = ScriptRunnerContext.getOutputEncoding();
            StringReader rdr = new StringReader(finalScript);
            ScriptExecutor runner = new ScriptExecutor(rdr, conn);
            ScriptRunnerContext ctx = new ScriptRunnerContext();
            ctx.putProperty("script.runner.using.systemout", true);
            runner.setScriptRunnerContext(ctx);
            ByteArrayOutputStream BaS = new ByteArrayOutputStream();
            BufferedOutputStream BoS = new BufferedOutputStream(BaS);
            runner.setOut(BoS);
            runner.run();
            BoS.flush();
            this.tLog(BaS.toString(encoding));
            boolean bl = (Boolean)ctx.getProperty("sqldev.error.any.in") == false;
            return bl;
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), e);
            this.tLogException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (!this._isSchemaConnOwner) {
                try {
                    conn.setSchema(this.getConnectionUser());
                }
                catch (Exception e) {
                    this.setExitCodeError(e);
                    return false;
                }
            }
        }
    }

    private void tLog(String msg) {
        if (this._tLogger != null) {
            this._tLogger.log(msg);
        }
    }

    private void tLogException(Exception e) {
        if (this._tLogger != null) {
            this._tLogger.logException(e);
        }
    }

    private boolean lock() throws SQLException {
        if (!this._isConnLocked) {
            if (LockManager.lock(this.getConnection())) {
                return true;
            }
            String m = SDDeployResources.format("LOCK_CONN_ERR", this._connName);
            SQLException e = new SQLException(m);
            this.setExitCodeError(e);
            throw e;
        }
        return true;
    }

    private void unlock() {
        if (!this._isConnLocked) {
            LockManager.unlock(this.getConnection());
        }
    }

    public static class DeployOperation
    extends Row {
        public String deployId;
        Integer operationSequence;
        public String operationFileName;
        public String status;
        public Timestamp startTime;
        public Timestamp stopTime;
        public String type;
        public String objectName;
        public Reader log;
        public BigDecimal operationId;
        public String objectType;
        public String badFileLocation;
        public String badFilePreview;
        public String logFileLocation;
        public String fileFormat;

        @Override
        LinkedHashMap<String, Object> getBinds(Row.Op operation) {
            LinkedHashMap<String, Object> binds = new LinkedHashMap<String, Object>();
            if (Row.Op.INSERT == operation) {
                binds.put("DEPLOY_NAME", this.deployId);
                binds.put("OPERATION_NUMBER", this.operationSequence);
            }
            if (this.operationFileName != null) {
                binds.put("OPERATION_FILE_NAME", this.operationFileName);
            }
            if (this.status != null) {
                binds.put("STATUS", this.status);
            }
            if (this.startTime != null) {
                binds.put("START_TIME", this.startTime);
            }
            if (this.stopTime != null) {
                binds.put("STOP_TIME", this.stopTime);
            }
            if (this.objectType != null) {
                binds.put("OBJECT_TYPE", this.objectType);
            }
            if (this.objectName != null) {
                binds.put("OBJECT_NAME", this.objectName);
            }
            if (this.log != null) {
                binds.put("LOG", this.log);
            }
            if (this.operationId != null) {
                binds.put("OPERATION_ID", this.operationId);
            }
            if (this.type != null) {
                binds.put("OPERATION_TYPE", this.type);
            }
            if (this.badFileLocation != null) {
                binds.put("BAD_FILE_LOCATION", this.badFileLocation);
            }
            if (this.badFilePreview != null) {
                binds.put("BAD_FILE_PREVIEW", this.badFilePreview);
            }
            if (this.logFileLocation != null) {
                binds.put("LOG_FILE_LOCATION", this.logFileLocation);
            }
            if (this.fileFormat != null) {
                binds.put("FILE_FORMAT", this.fileFormat);
            }
            if (Row.Op.UPDATE == operation) {
                binds.put("DEPLOY_NAME", this.deployId);
                binds.put("OPERATION_NUMBER", this.operationSequence);
            }
            return binds;
        }

        public DeployOperation(String deployId, Integer operationSequence) {
            assert (deployId != null);
            assert (operationSequence != null);
            this.deployId = deployId;
            this.operationSequence = operationSequence;
        }

        @Override
        String getTableName() {
            return "$SD_DEPLOY_OPERATION";
        }

        @Override
        String getCreateQueryId() {
            return "create_sd_deploy_operation";
        }

        @Override
        List<String> getKeyColumns() {
            return Arrays.asList("DEPLOY_NAME", "OPERATION_NUMBER");
        }

        List<String> getClobColumns() {
            return Arrays.asList("LOG");
        }

        public static void main(String[] args) {
            DeployOperation me = new DeployOperation("fakeId", 0);
            System.out.println(String.valueOf(me.getBinds(Row.Op.INSERT)));
            System.out.println(me.getInsertSql());
            me.status = "status";
            System.out.println(String.valueOf(me.getBinds(Row.Op.INSERT)));
            System.out.println(me.getInsertSql());
            System.out.println(String.valueOf(me.getBinds(Row.Op.UPDATE)));
            System.out.println(me.getUpdateSql());
        }
    }

    public static class Deploy
    extends Row {
        public String deployId;
        public String status;
        public Timestamp startTime;
        public Timestamp stopTime;
        public String fileLocation;
        public String type;
        public String deploySchema;
        public String cloudStorageLocation;
        public String cloudStorageCredential;
        public String requestedBy;

        @Override
        LinkedHashMap<String, Object> getBinds(Row.Op operation) {
            LinkedHashMap<String, Object> binds = new LinkedHashMap<String, Object>();
            if (Row.Op.INSERT == operation) {
                binds.put("DEPLOY_NAME", this.deployId);
            }
            if (this.status != null) {
                binds.put("STATUS", this.status);
            }
            if (this.startTime != null) {
                binds.put("START_TIME", this.startTime);
            }
            if (this.stopTime != null) {
                binds.put("STOP_TIME", this.stopTime);
            }
            if (this.fileLocation != null) {
                binds.put("FILE_LOCATION", this.fileLocation);
            }
            if (this.type != null) {
                binds.put("DEPLOYMENT_TYPE", this.type);
            }
            if (this.deploySchema != null) {
                binds.put("DEPLOY_SCHEMA", this.deploySchema);
            }
            if (this.cloudStorageLocation != null) {
                binds.put("CLOUD_STORAGE_LOCATION", this.cloudStorageLocation);
            }
            if (this.cloudStorageCredential != null) {
                binds.put("CLOUD_STORAGE_CREDENTIAL", this.cloudStorageCredential);
            }
            if (this.requestedBy != null) {
                binds.put("REQUESTED_BY", this.requestedBy);
            }
            if (Row.Op.UPDATE == operation) {
                binds.put("DEPLOY_NAME", this.deployId);
            }
            return binds;
        }

        public Deploy(String deployId) {
            assert (deployId != null);
            this.deployId = deployId;
        }

        @Override
        String getTableName() {
            return "$SD_DEPLOY";
        }

        @Override
        String getCreateQueryId() {
            return "create_sd_deploy";
        }

        @Override
        List<String> getKeyColumns() {
            return Arrays.asList("DEPLOY_NAME");
        }

        List<String> getClobColumns() {
            return Collections.emptyList();
        }

        public static void main(String[] args) {
            Deploy me = new Deploy("fakeId");
            System.out.println(String.valueOf(me.getBinds(Row.Op.INSERT)));
            System.out.println(me.getInsertSql());
            me.status = "status";
            System.out.println(String.valueOf(me.getBinds(Row.Op.INSERT)));
            System.out.println(me.getInsertSql());
            System.out.println(String.valueOf(me.getBinds(Row.Op.UPDATE)));
            System.out.println(me.getUpdateSql());
        }
    }

    public static abstract class Row {
        private static final String NL = "\n";
        private static final String SPACE = " ";
        private static final String COMMA = ",";
        private static final String COLON = ":";

        abstract String getTableName();

        abstract String getCreateQueryId();

        abstract List<String> getKeyColumns();

        abstract LinkedHashMap<String, Object> getBinds(Op var1);

        boolean needsPreparedStatement(Op operation) {
            LinkedHashMap<String, Object> binds = this.getBinds(operation);
            for (Object parameterValue : binds.values()) {
                if (!(parameterValue instanceof Reader)) continue;
                return true;
            }
            return false;
        }

        PreparedStatement getPreparedStatment(Op operation, Connection conn) throws SQLException {
            PreparedStatement stmt = conn.prepareStatement(this.getSql(operation));
            LinkedHashMap<String, Object> binds = this.getBinds(operation);
            int parameterIndex = 0;
            for (Object parameterValue : binds.values()) {
                ++parameterIndex;
                if (parameterValue instanceof String) {
                    stmt.setString(parameterIndex, (String)parameterValue);
                    continue;
                }
                if (parameterValue instanceof Timestamp) {
                    stmt.setTimestamp(parameterIndex, (Timestamp)parameterValue);
                    continue;
                }
                if (parameterValue instanceof BigDecimal) {
                    stmt.setBigDecimal(parameterIndex, (BigDecimal)parameterValue);
                    continue;
                }
                if (parameterValue instanceof Integer) {
                    stmt.setInt(parameterIndex, (Integer)parameterValue);
                    continue;
                }
                if (parameterValue instanceof Reader) {
                    stmt.setClob(parameterIndex, (Reader)parameterValue);
                    continue;
                }
                throw new SQLException("Unsupported parameter value type " + parameterValue.getClass().getCanonicalName());
            }
            return stmt;
        }

        String getSql(Op operation) {
            if (Op.INSERT == operation) {
                return this.getInsertSql();
            }
            if (Op.UPDATE == operation) {
                return this.getUpdateSql();
            }
            return null;
        }

        private String quoted(String txt) {
            return "\"" + txt + "\"";
        }

        String getInsertSql() {
            StringBuilder sql = new StringBuilder("INSERT INTO ").append(this.quoted(this.getTableName())).append(" (").append("\n");
            List<String> keyColumns = this.getKeyColumns();
            String pre = " ";
            for (String key : keyColumns) {
                sql.append(pre).append(this.quoted(key)).append("\n");
                pre = COMMA;
            }
            LinkedHashMap<String, Object> binds = this.getBinds(Op.INSERT);
            for (String column : binds.keySet()) {
                if (keyColumns.contains(column)) continue;
                sql.append(pre).append(this.quoted(column)).append("\n");
                pre = COMMA;
            }
            sql.append(") values (").append("\n");
            pre = " ";
            for (String key : keyColumns) {
                sql.append(pre).append(COLON).append(key).append("\n");
                pre = COMMA;
            }
            for (String column : binds.keySet()) {
                if (keyColumns.contains(column)) continue;
                sql.append(pre).append(COLON).append(column).append("\n");
            }
            sql.append(')');
            return sql.toString();
        }

        String getUpdateSql() {
            StringBuilder sql = new StringBuilder("UPDATE ").append(this.quoted(this.getTableName())).append(" SET").append("\n");
            List<String> keyColumns = this.getKeyColumns();
            String pre = " ";
            LinkedHashMap<String, Object> binds = this.getBinds(Op.UPDATE);
            for (String column : binds.keySet()) {
                if (keyColumns.contains(column)) continue;
                sql.append(pre).append(column).append(" = :").append(column).append("\n");
                pre = COMMA;
            }
            sql.append("WHERE").append("\n");
            pre = " ";
            for (String key : keyColumns) {
                sql.append(pre).append(key).append(" = :").append(key).append("\n");
                pre = " AND ";
            }
            return sql.toString();
        }

        public static enum Op {
            INSERT,
            UPDATE;

        }
    }
}

