/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionMutableWrapper;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionReference;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionWrapper;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeException;
import oracle.dbtools.raptor.datatypes.DataTypeExtensionObject;
import oracle.dbtools.raptor.datatypes.DataTypeFactoryExtension;
import oracle.dbtools.raptor.datatypes.PropertyChanger;
import oracle.dbtools.raptor.datatypes.impl.DataTypeConnectionWrapperDelegate;
import oracle.dbtools.util.Closeables;

public abstract class AbstractDataTypeConnectionProviderImpl<C extends Connection>
extends DataTypeExtensionObject
implements DataTypeConnectionProvider<C> {
    private final Class<C> connectionClass;
    private final DataTypeConnectionReference<C> datatypeConnection;
    private final DataTypeConnectionWrapper<C> nlsConnection;
    private final boolean supported;

    protected AbstractDataTypeConnectionProviderImpl(DataTypeFactoryExtension.ExtensionAccess extensionAccess, Class<C> connectionClass, DataTypeConnectionReference<C> datatypeConnection, boolean supported) {
        this(extensionAccess, connectionClass, datatypeConnection, null, supported);
    }

    protected AbstractDataTypeConnectionProviderImpl(DataTypeFactoryExtension.ExtensionAccess extensionAccess, Class<C> connectionClass, DataTypeConnectionReference<C> datatypeConnection, DataTypeConnectionWrapper<C> nlsConnection, boolean supported) {
        super(extensionAccess);
        this.supported = supported;
        this.connectionClass = connectionClass;
        this.datatypeConnection = datatypeConnection;
        DataTypeConnectionWrapperDelegate<C> dataTypeConnectionWrapperDelegate = this.nlsConnection = nlsConnection == null ? new DataTypeConnectionWrapperDelegate<C>(datatypeConnection) : nlsConnection;
        if (this.datatypeConnection instanceof PropertyChanger) {
            ((PropertyChanger)((Object)this.datatypeConnection)).addPropertyChangeListener("connection", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    DataTypeContext.ContextAccess contextAccess;
                    Object oldValue = evt.getOldValue();
                    Object newValue = evt.getNewValue();
                    if (newValue == null && (contextAccess = AbstractDataTypeConnectionProviderImpl.this.getConnectionProviderAccess().peekContextAccess()) != null) {
                        Closeables.close(contextAccess.getDataTypeContext());
                    }
                    AbstractDataTypeConnectionProviderImpl.this.firePropertyChange("connection", oldValue, newValue);
                }
            });
        }
    }

    protected abstract DataTypeConnectionProvider.ConnectionProviderAccess<C> getConnectionProviderAccess();

    @Override
    public abstract DataTypeContext getDataTypeContext();

    protected C releaseResources() throws DataTypeException {
        return this.datatypeConnection.releaseConnection();
    }

    @Override
    public DataTypeConnectionWrapper<C> getDataTypeConnectionWrapper() {
        return this.datatypeConnection;
    }

    @Override
    @Deprecated
    public C peekDataTypeConnection() {
        return this.datatypeConnection.peekConnection();
    }

    @Override
    @Deprecated
    public C getDataTypeConnection() {
        return this.datatypeConnection.getConnection();
    }

    @Override
    @Deprecated
    public C getValidDataTypeConnection() {
        if (this.datatypeConnection instanceof DataTypeConnectionMutableWrapper) {
            return ((DataTypeConnectionMutableWrapper)((Object)this.datatypeConnection)).getValidConnection();
        }
        return this.getDataTypeConnection();
    }

    @Override
    @Deprecated
    public void unlockDataTypeConnection() throws DataTypeConnectionException {
        this.datatypeConnection.unlockConnection();
    }

    @Override
    @Deprecated
    public C lockDataTypeConnection() throws DataTypeConnectionException {
        return this.datatypeConnection.lockConnection();
    }

    @Override
    @Deprecated
    public C lockDataTypeConnection(boolean prompt) throws DataTypeConnectionException {
        return this.datatypeConnection.lockConnection(prompt);
    }

    @Override
    public DataTypeConnectionWrapper<C> getNLSConnectionWrapper() {
        return this.nlsConnection;
    }

    @Override
    @Deprecated
    public C getNLSConnection() {
        return this.nlsConnection.getConnection();
    }

    @Override
    @Deprecated
    public C peekNLSConnection() {
        return this.nlsConnection.peekConnection();
    }

    @Override
    @Deprecated
    public C getValidNLSConnection() throws DataTypeConnectionException {
        return this.nlsConnection.getConnection();
    }

    @Override
    @Deprecated
    public void unlockNLSConnection() throws DataTypeConnectionException {
        this.nlsConnection.unlockConnection();
    }

    @Override
    @Deprecated
    public C lockNLSConnection() throws DataTypeConnectionException {
        return this.nlsConnection.lockConnection();
    }

    @Override
    @Deprecated
    public C lockNLSConnection(boolean prompt) throws DataTypeConnectionException {
        return this.nlsConnection.lockConnection(prompt);
    }

    @Override
    public final Class<C> getDataTypeConnnectionClass() {
        return this.datatypeConnection.getConnectionClass();
    }

    @Override
    public final boolean isSupported() {
        return this.supported;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    protected abstract void firePropertyChange(String var1, Object var2, Object var3);

    public static abstract class Builder<C extends Connection>
    extends DataTypeExtensionObject.Builder
    implements DataTypeConnectionProvider.Builder<C> {
        private final Class<C> connectionClass;
        private DataTypeConnectionReference<C> datatypeConnection;
        private DataTypeConnectionWrapper<C> nlsConnection;
        private boolean supported;

        protected Builder(Class<C> connectionClass) {
            this.connectionClass = connectionClass;
            this.datatypeConnection = null;
            this.nlsConnection = null;
            this.supported = true;
        }

        @Override
        public Builder setExtensionAccess(DataTypeFactoryExtension.ExtensionAccess extensionAccess) {
            super.setExtensionAccess(extensionAccess);
            return this;
        }

        @Override
        public Class<C> getConnectionClass() {
            return this.connectionClass;
        }

        @Override
        public Builder setDataTypeConnectionReference(DataTypeConnectionReference<C> connectionReference) {
            if (connectionReference != null) {
                this.connectionClass.asSubclass(connectionReference.getConnectionClass());
                this.datatypeConnection = connectionReference;
            } else {
                this.datatypeConnection = null;
            }
            return this;
        }

        @Override
        public DataTypeConnectionReference<C> getDataTypeConnectionReference() {
            return this.datatypeConnection;
        }

        @Override
        public Builder setNLSConnectionWrapper(DataTypeConnectionWrapper<C> connectionWrapper) {
            if (connectionWrapper != null) {
                this.connectionClass.asSubclass(connectionWrapper.getConnectionClass());
                this.nlsConnection = connectionWrapper;
            } else {
                this.nlsConnection = null;
            }
            return this;
        }

        @Override
        public DataTypeConnectionWrapper<C> getNLSConnectionWrapper() {
            return this.nlsConnection;
        }

        @Override
        public Builder setSupported(boolean supported) {
            this.supported = supported;
            return this;
        }

        @Override
        public boolean isSupported() {
            return this.supported;
        }
    }
}

