/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Substitutions;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.parser.plsql.doc.DocURL;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;
import oracle.dbtools.util.Service;

public class SqlRules {
    private static char[] identifiers = new char[]{'(', ')', '\'', ',', ';', ':', '=', '+', '-', '*', '/', '@', '!', '^', '~', 'e', 'f', 'd', '?'};
    private static Earley earley;
    static int bnf;
    static int rawbnf;
    static int boldrawbnf;
    static int identifier;
    static int concat;
    static int block;
    static int sqBr;
    static int curlyBr;
    static int dot;
    static int lt;
    static int gt;
    static int lbr;
    static int rbr;
    static int lcp;
    static int rcp;
    static int dbar;
    static int sbar;
    static Map<String, String> missingSymbols;
    private static final String path = "/oracle/dbtools/parser/plsql/";
    private static Set<String> toDo;
    private static Set<String> notFound;
    private static Set<String> masterRules;
    static final String masterBNFurl;
    static final String cachedBNFdir;
    static Boolean cacheExists;
    static final String htm = "html";
    private static ParseNode fixesParseTree;
    private static List<LexerToken> fixesScan;
    private static ParseNode bnfRoot;

    private static void testParseSqlBnf() throws Exception {
        System.setProperty("sun.java2d.uiScale", "1");
        String input = Service.readFile(SqlRules.class, "testsql.bnf");
        List<LexerToken> src = Lexer.parse(input);
        LexerToken.print(src);
        SqlRules.correctDots(src);
        Visual visual = null;
        visual = new Visual(src, earley);
        Matrix matrix = new Matrix(earley);
        earley.parse(src, matrix);
        ParseNode root = earley.forest(src, matrix);
        root.printTree();
        if (visual != null) {
            visual.draw(matrix);
        }
        TreeSet<RuleTuple> grammar = new TreeSet<RuleTuple>();
        String hdr = "test";
        grammar.addAll(SqlRules.bnf(root, src, hdr));
        System.out.println("-------------Optimized---------------");
        RuleTuple.printRules(grammar);
        System.out.println("-------------------------------------");
    }

    private static void bnfIdentifiers(Set<RuleTuple> rules) {
        for (char id : identifiers) {
            rules.add(new RuleTuple("identifier", new String[]{"'" + id + "'"}));
        }
    }

    private static Earley bnfParser() throws Exception {
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        String input = Service.readFile(SqlRules.class, "DocBnf.grammar");
        List<LexerToken> src = Lexer.parse(input, false, 1);
        ParseNode root = Grammar.parseGrammarFile(src, input);
        Grammar.grammar(root, src, rules);
        return new Earley(rules){

            @Override
            protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                LexerToken token = src.get(y);
                return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING;
            }
        };
    }

    static Set<RuleTuple> extractRules() throws Exception {
        TreeSet<RuleTuple> sqlRules = new TreeSet<RuleTuple>();
        SqlRules.sloppyKeyword("ABSENT");
        missingSymbols.put("access_driver_type", "identifier");
        missingSymbols.put("admin_user_name", "identifier");
        SqlRules.sloppyKeyword("ADD");
        missingSymbols.put("alias", "identifier");
        missingSymbols.put("argument", "expr");
        missingSymbols.put("attribute", "identifier");
        missingSymbols.put("attr_dim", "identifier");
        missingSymbols.put("c_alias", "identifier");
        sqlRules.add(new RuleTuple("c_alias", new String[]{"'AS'", "identifier"}));
        missingSymbols.put("category", "identifier");
        missingSymbols.put("char1", "expr");
        missingSymbols.put("char2", "expr");
        missingSymbols.put("character_set", "identifier");
        missingSymbols.put("charset", "identifier");
        missingSymbols.put("child_level", "identifier");
        missingSymbols.put("child_key_column", "column");
        missingSymbols.put("cluster", "identifier");
        missingSymbols.put("class", "literal");
        missingSymbols.put("class_value", "expr");
        missingSymbols.put("cluster", "identifier");
        missingSymbols.put("cluster_id", "identifier");
        sqlRules.add(new RuleTuple("cluster_id", new String[]{"identifier", "'.'", "identifier"}));
        missingSymbols.put("cost_value", "literal");
        missingSymbols.put("collection_item", "identifier");
        missingSymbols.put("collation_name", "identifier");
        missingSymbols.put("column_alias", "identifier");
        missingSymbols.put("column_collation_name", "identifier");
        missingSymbols.put("column_expression", "expr");
        missingSymbols.put("column_name", "identifier");
        missingSymbols.put("comparison_expr", "expr");
        missingSymbols.put("constant", "literal");
        missingSymbols.put("constraint_name", "identifier");
        missingSymbols.put("container_name", "identifier");
        missingSymbols.put("container_data_object", "identifier");
        missingSymbols.put("cpu_cost", "digits");
        missingSymbols.put("create_table_statement", "create_table");
        missingSymbols.put("create_view_statement", "create_view");
        missingSymbols.put("database", "identifier");
        missingSymbols.put("date", "expr");
        missingSymbols.put("db_user_proxy", "identifier");
        missingSymbols.put("default_selectivity", "digits");
        missingSymbols.put("dependent_column", "column");
        missingSymbols.put("dimension", "identifier");
        missingSymbols.put("dimension_column", "identifier");
        missingSymbols.put("directory_name", "identifier");
        missingSymbols.put("directory_object_name", "identifier");
        missingSymbols.put("disk_name", "identifier");
        missingSymbols.put("diskgroup_name", "identifier");
        missingSymbols.put("domain", "identifier");
        SqlRules.sloppyKeyword("DROP");
        missingSymbols.put("edition", "identifier");
        missingSymbols.put("edition_name", "identifier");
        missingSymbols.put("else_expr", "expr");
        missingSymbols.put("element", "identifier");
        missingSymbols.put("end_time_column", "identifier");
        SqlRules.sloppyKeyword("ENABLE");
        SqlRules.sloppyKeyword("EVERY");
        SqlRules.sloppyKeyword("EXTEND");
        SqlRules.sloppyKeyword("EXTERNAL");
        missingSymbols.put("esc_char", "string_literal");
        missingSymbols.put("expr1", "expr");
        missingSymbols.put("expr2", "expr");
        missingSymbols.put("expr3", "expr");
        missingSymbols.put("failgroup_name", "identifier");
        missingSymbols.put("filename", "string_literal");
        missingSymbols.put("file_number", "digits");
        missingSymbols.put("filenumber", "digits");
        missingSymbols.put("file_specification", "string_literal");
        missingSymbols.put("flashback_archive", "identifier");
        missingSymbols.put("fmt", "string_literal");
        missingSymbols.put("fractional_second_precision", "digits");
        missingSymbols.put("function_name", "identifier");
        missingSymbols.put("grant_statement", "grant");
        missingSymbols.put("hash_partition_quantity", "digits");
        missingSymbols.put("hash_subpartition_quantity", "digits");
        missingSymbols.put("hierarchy", "identifier");
        SqlRules.sloppyKeyword("HOURS");
        missingSymbols.put("HSM_auth_string", "identifier");
        missingSymbols.put("id", "identifier");
        missingSymbols.put("implementation_type", "identifier");
        missingSymbols.put("index", "identifier");
        missingSymbols.put("indextype", "identifier");
        missingSymbols.put("integer", "digits");
        missingSymbols.put("input_expr", "expr");
        missingSymbols.put("io_cost", "digits");
        missingSymbols.put("java_ext_name", "identifier");
        missingSymbols.put("JSON_object_key", "identifier");
        missingSymbols.put("JSON_column", "identifier");
        missingSymbols.put("json_column", "identifier");
        missingSymbols.put("JSON_path_expression", "string_literal");
        missingSymbols.put("JSON_basic_path_expression", "string_literal");
        missingSymbols.put("JSON_agg_returning_clause", "JSON_returning_clause");
        missingSymbols.put("pathExp", "string_literal");
        missingSymbols.put("pathExpr", "string_literal");
        missingSymbols.put("keystore_password", "identifier");
        missingSymbols.put("keystore2_password", "identifier");
        missingSymbols.put("keystore3_password", "identifier");
        missingSymbols.put("leading_field_precision", "digits");
        missingSymbols.put("len", "digits");
        missingSymbols.put("level", "identifier");
        missingSymbols.put("level_table", "identifier");
        missingSymbols.put("level_column", "identifier");
        missingSymbols.put("lib_name", "identifier");
        missingSymbols.put("library_name", "identifier");
        SqlRules.sloppyKeyword("LIMIT");
        missingSymbols.put("LOB_item", "identifier");
        missingSymbols.put("LOB_segname", "identifier");
        missingSymbols.put("log_group", "identifier");
        missingSymbols.put("main_model_name", "identifier");
        SqlRules.sloppyKeyword("MANUAL");
        missingSymbols.put("materialized_view", "identifier");
        sqlRules.add(new RuleTuple("materialized_view", new String[]{"identifier", "'.'", "identifier"}));
        missingSymbols.put("match_string", "string_literal");
        missingSymbols.put("measure_column", "identifier");
        missingSymbols.put("method", "identifier");
        missingSymbols.put("mining_model_name", "identifier");
        SqlRules.sloppyKeyword("MINUTES");
        missingSymbols.put("model", "identifier");
        missingSymbols.put("n", "digits");
        missingSymbols.put("name", "identifier");
        missingSymbols.put("namespace", "identifier");
        missingSymbols.put("nested_item", "identifier");
        missingSymbols.put("nested_table", "expr");
        missingSymbols.put("nested_table1", "expr");
        missingSymbols.put("nested_table2", "expr");
        missingSymbols.put("network_cost", "digits");
        missingSymbols.put("new_keystore_password", "identifier");
        missingSymbols.put("new_name", "identifier");
        missingSymbols.put("new_table_name", "identifier");
        SqlRules.sloppyKeyword("NOEXTEND");
        SqlRules.sloppyKeyword("NULL");
        missingSymbols.put("object", "identifier");
        missingSymbols.put("object_name", "identifier");
        missingSymbols.put("object_step", "identifier");
        missingSymbols.put("object_privilege", "identifier");
        missingSymbols.put("object_table_alias", "identifier");
        missingSymbols.put("old_name", "identifier");
        missingSymbols.put("old_password", "identifier");
        missingSymbols.put("old_keystore_password", "identifier");
        missingSymbols.put("offset", "digits");
        SqlRules.sloppyKeyword("ONLY");
        missingSymbols.put("operator", "identifier");
        missingSymbols.put("ordering_column", "identifier");
        missingSymbols.put("outline", "identifier");
        missingSymbols.put("package", "identifier");
        missingSymbols.put("package_name", "identifier");
        missingSymbols.put("parameter", "identifier");
        missingSymbols.put("parameter_name", "identifier");
        missingSymbols.put("parameter_type", "prm_spec_unconstrained_type");
        missingSymbols.put("parameter_value", "expr");
        missingSymbols.put("parent_level", "identifier");
        missingSymbols.put("parent_edition", "identifier");
        missingSymbols.put("partition", "identifier");
        missingSymbols.put("partition_name", "identifier");
        missingSymbols.put("partition_name_old", "identifier");
        missingSymbols.put("partition_key_value", "expr");
        missingSymbols.put("subpartition_key_value", "expr");
        SqlRules.sloppyKeyword("PARTITION");
        missingSymbols.put("password", "identifier");
        missingSymbols.put("pattern", "string_literal");
        missingSymbols.put("pdb_name", "identifier");
        missingSymbols.put("percent", "numeric_literal");
        missingSymbols.put("policy", "identifier");
        missingSymbols.put("position", "digits");
        sqlRules.add(new RuleTuple("precision", new String[]{"digits"}));
        sqlRules.add(new RuleTuple("precision", new String[]{"'*'"}));
        missingSymbols.put("primary_name", "identifier");
        missingSymbols.put("procedure_name", "identifier");
        missingSymbols.put("procedure", "identifier");
        missingSymbols.put("profile", "identifier");
        missingSymbols.put("query_name", "identifier");
        SqlRules.sloppyKeyword("REJECT");
        missingSymbols.put("reference_spreadsheet_name", "identifier");
        missingSymbols.put("restore_point", "identifier");
        missingSymbols.put("return_expr", "expr");
        missingSymbols.put("return_type", "func_return_prm_spec_unconstrained_type");
        missingSymbols.put("role", "identifier");
        missingSymbols.put("role_name", "identifier");
        missingSymbols.put("rollback_segment", "identifier");
        missingSymbols.put("row_pattern_measure_column", "column");
        sqlRules.add(new RuleTuple("rowcount", new String[]{"digits"}));
        sqlRules.add(new RuleTuple("rowcount", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("scale", new String[]{"digits"}));
        sqlRules.add(new RuleTuple("scale", new String[]{"'-'", "digits"}));
        missingSymbols.put("schema", "identifier");
        missingSymbols.put("schema_name", "identifier");
        missingSymbols.put("scope_table", "identifier");
        missingSymbols.put("search_string", "string_literal");
        missingSymbols.put("secret", "identifier");
        missingSymbols.put("sequence", "identifier");
        missingSymbols.put("server_file_name", "string_literal");
        missingSymbols.put("SERVICE", "'SERVICE'");
        missingSymbols.put("shardspace", "identifier");
        missingSymbols.put("sha2_512", "identifier");
        missingSymbols.put("size", "digits");
        SqlRules.sloppyKeyword("SERVICE");
        SqlRules.sloppyKeyword("SNAPSHOT");
        missingSymbols.put("software_keystore_password", "identifier");
        missingSymbols.put("source_outline", "identifier");
        missingSymbols.put("src_pdb_name", "identifier");
        missingSymbols.put("statement", "sql_stmt");
        missingSymbols.put("start_time_column", "identifier");
        missingSymbols.put("storage_table", "identifier");
        missingSymbols.put("subpartition", "identifier");
        missingSymbols.put("synonym", "identifier");
        missingSymbols.put("t_alias", "identifier");
        missingSymbols.put("table", "identifier");
        missingSymbols.put("table_alias", "identifier");
        missingSymbols.put("tablespace", "identifier");
        missingSymbols.put("tablespace_set", "identifier");
        missingSymbols.put("template_name", "identifier");
        missingSymbols.put("topN", "digits");
        SqlRules.sloppyKeyword("TO");
        SqlRules.sloppyKeyword("TOPLEVEL");
        missingSymbols.put("trigger_name", "identifier");
        missingSymbols.put("type_name", "identifier");
        missingSymbols.put("type", "identifier");
        missingSymbols.put("user", "identifier");
        missingSymbols.put("user_defined_types", "identifier");
        sqlRules.add(new RuleTuple("user_defined_types", new String[]{"identifier", "'.'", "identifier"}));
        sqlRules.add(new RuleTuple("user_defined_types", new String[]{"'REF'", "identifier"}));
        SqlRules.sloppyKeyword("USING");
        missingSymbols.put("v1", "identifier");
        missingSymbols.put("value_expr", "expr");
        missingSymbols.put("value_expression", "expr");
        missingSymbols.put("view", "identifier");
        missingSymbols.put("valid_time_column", "identifier");
        missingSymbols.put("variable_expression", "bind_var");
        missingSymbols.put("variable_name", "identifier");
        missingSymbols.put("varray_item", "identifier");
        missingSymbols.put("varray_type", "identifier");
        missingSymbols.put("window_name", "identifier");
        SqlRules.sloppyKeyword("VOLUME");
        missingSymbols.put("xml_encoding_spec", "string_literal");
        missingSymbols.put("XMLSchema_URL", "string");
        missingSymbols.put("XQuery_string", "string");
        missingSymbols.put("zonemap_name", "identifier");
        sqlRules.add(new RuleTuple("literal", new String[]{"string_literal"}));
        sqlRules.add(new RuleTuple("literal", new String[]{"number"}));
        sqlRules.add(new RuleTuple("datetime_literal", new String[]{"'TO_DATE'", "'('", "string_literal", "','", "string_literal", "')'"}));
        sqlRules.add(new RuleTuple("literal", new String[]{"datetime_literal"}));
        sqlRules.add(new RuleTuple("not_eq", new String[]{"'<'", "'>'"}));
        sqlRules.add(new RuleTuple("character_datatypes", new String[]{"'VARCHAR2'"}));
        sqlRules.add(new RuleTuple("inmemory_table_clause", new String[]{"inmemory_clause"}));
        sqlRules.add(new RuleTuple("inmemory_table_clause", new String[]{"inmemory_table_clause inmemory_clause"}));
        sqlRules.add(new RuleTuple("physical_properties[29,100)", new String[]{"'EXTERNAL'", "external_table_clause"}));
        sqlRules.add(new RuleTuple("physical_properties[29,100)", new String[]{"'EXTERNAL'", "external_table_clause", "'REJECT'", "'LIMIT'"}));
        SqlRules.addToDo("commit");
        SqlRules.addToDo("sql_statements");
        while (0 < toDo.size()) {
            String candidate = SqlRules.nextToDo();
            SqlRules.recursiveCollectBNF(sqlRules, candidate);
            toDo.remove(candidate);
        }
        for (String key : notFound) {
            if (missingSymbols.containsKey(key) || !key.contains("name")) continue;
            missingSymbols.put(key, "identifier");
        }
        for (String key : missingSymbols.keySet()) {
            sqlRules.add(new RuleTuple(key, new String[]{missingSymbols.get(key)}));
            notFound.remove(key);
        }
        sqlRules.addAll(Grammar.extractRules(SqlEarley.class, "json.ebnf"));
        RuleTransforms.eliminateEmptyProductions(sqlRules);
        RuleTransforms.injectMissingEmptyProductions(sqlRules);
        RuleTransforms.substituteSingleBinaryProductions(sqlRules);
        RuleTransforms.substituteSingleUnaryProductions(sqlRules);
        SqlRules.straightenSemicolon(sqlRules);
        System.out.println("*************NOT FOUND************");
        System.out.println(notFound);
        return sqlRules;
    }

    private static void sloppyKeyword(String string) {
    }

    private static void straightenSemicolon(Set<RuleTuple> sqlRules) {
        String[] heads;
        for (String head : heads = new String[]{"alter_session", "set_transaction"}) {
            SqlRules.straightenSemicolon(sqlRules, head);
        }
    }

    private static void straightenSemicolon(Set<RuleTuple> sqlRules, String head) {
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        for (RuleTuple rule : sqlRules) {
            if (!head.equals(rule.head)) continue;
            if (!"';'".equals(rule.rhs[rule.rhs.length - 1])) {
                throw new AssertionError((Object)"!\"';'\".equals(rule.rhs[rule.rhs.length-1])");
            }
            String[] rhs = new String[rule.rhs.length - 1];
            for (int i = 0; i < rhs.length; ++i) {
                rhs[i] = rule.rhs[i];
            }
            RuleTuple modifiedRule = new RuleTuple(head, rhs);
            rules.add(modifiedRule);
        }
        sqlRules.addAll(rules);
    }

    public static void memorizeRules() throws Exception {
        SqlRules.memorizeRules("isqlBNF.serial");
    }

    public static Set<RuleTuple> getRules() throws Exception {
        return SqlRules.getRules("sqlBNF.serial");
    }

    private static void memorizeRules(String fname) throws Exception {
        Set<RuleTuple> rules = SqlRules.extractRules();
        FileOutputStream fos = new FileOutputStream("src/oracle/dbtools/parser/plsql/" + fname);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(rules);
        out.close();
    }

    private static Set<RuleTuple> getRules(String fname) throws Exception {
        URL u = SqlRules.class.getResource(path + fname);
        if (u == null) {
            u = Service.fileNameGitResource(HarvestDoc.class, path + fname);
        }
        InputStream is = u.openStream();
        ObjectInputStream in = new ObjectInputStream(is);
        Set rules = (Set)in.readObject();
        in.close();
        return rules;
    }

    private static void addToDo(String s) {
        if (s.charAt(0) != '\'' && !notFound.contains(s) && !masterRules.contains(s)) {
            toDo.add(s);
        }
    }

    private static String nextToDo() {
        Iterator<String> iterator = toDo.iterator();
        if (iterator.hasNext()) {
            String candidate = iterator.next();
            return candidate;
        }
        throw new AssertionError((Object)"Empty toDo");
    }

    private static void recursiveCollectBNF(Set<RuleTuple> output, String masterRuleName) throws Exception {
        if (masterRules.contains(masterRuleName)) {
            return;
        }
        if (notFound.contains(masterRuleName)) {
            return;
        }
        System.out.println("searching for...  " + masterRuleName);
        if ("hint".equals(masterRuleName)) {
            return;
        }
        if ("array_step".equals(masterRuleName)) {
            return;
        }
        if ("json_transform".equals(masterRuleName)) {
            return;
        }
        if ("JSON_storage_clause".equals(masterRuleName)) {
            return;
        }
        if ("JSON_relative_object_access".equals(masterRuleName)) {
            return;
        }
        if (!SqlRules.fetchFromFixes(output, masterRuleName)) {
            SqlRules.fetchFromDocWebsite(output, masterRuleName);
        }
    }

    private static void fetchFromDocWebsite(Set<RuleTuple> output, String masterRuleName) throws Exception {
        int iQuote;
        String masterrulename = masterRuleName.toLowerCase();
        if (notFound.contains(masterrulename)) {
            return;
        }
        if (cacheExists == null) {
            File newDirectory = new File(cachedBNFdir);
            cacheExists = newDirectory.exists();
            if (cacheExists.booleanValue()) {
                System.out.println("Directory exists:" + newDirectory.getCanonicalPath());
            } else {
                boolean created = newDirectory.mkdirs();
                if (created) {
                    System.out.println("Created directory:" + newDirectory.getCanonicalPath());
                } else {
                    System.out.println("1. Unable to create directory");
                    System.exit(1);
                }
            }
        }
        if (masterrulename.contains("grouping_hint")) {
            return;
        }
        String input = null;
        if (cacheExists.booleanValue()) {
            input = SqlRules.readURL(masterrulename, "file:" + cachedBNFdir);
            if (input == null) {
                notFound.add(masterrulename);
                return;
            }
        } else {
            input = SqlRules.readURL(masterrulename, masterBNFurl);
            if (input == null) {
                if (notFound.contains(masterrulename)) {
                    return;
                }
                input = SqlRules.readURL(masterrulename, masterBNFurl);
                if (input == null) {
                    System.exit(1);
                }
            }
            File file = new File(cachedBNFdir + "/" + masterRuleName + "." + htm);
            file.createNewFile();
            System.out.println("created:" + file.getName());
            FileOutputStream o = new FileOutputStream(file);
            o.write(input.getBytes());
            o.close();
        }
        input = input.replace("<span class=\"bold\">", "<b>");
        input = input.replace("</span>", "</b>");
        int ipre = input.indexOf("<pre");
        int jpre = input.indexOf("</pre>");
        input = input.substring(ipre, jpre + "</pre>".length());
        input = input.replace("<pre class=\"oac_no_warn\" dir=\"ltr\">", "<pre>");
        input = input.replace("\",\"", ",");
        input = input.replace("\".\"", ".");
        input = input.replace("\"(\"", "(");
        input = input.replace("\")\"", ")");
        while ((iQuote = input.indexOf("'")) >= 0) {
            String literal = input.substring(iQuote, input.indexOf("'", iQuote + 1) + 1);
            input = input.replace(literal, "string_literal");
        }
        List<LexerToken> src = Lexer.parse(input, false, 2);
        SqlRules.correctDots(src);
        input = SqlRules.correctKeywords(input, src);
        src = Lexer.parse(input, false, 2);
        SqlRules.correctDots(src);
        System.out.println(masterRuleName + "...");
        Matrix matrix = new Matrix(earley);
        matrix.visual = new Visual(src, earley);
        earley.parse(src, matrix);
        ParseNode root = earley.forest(src, matrix);
        SyntaxError s = SyntaxError.checkSyntax(input, new String[]{"bnf"}, src, earley, matrix);
        if (s != null) {
            if (matrix.visual != null) {
                matrix.visual.draw(matrix);
            }
            System.out.println("Syntax Error");
            System.out.println("at line#" + s.line);
            System.out.println(s.code);
            System.out.println(s.marker);
            System.out.println("Expected:  ");
            for (String tmp : s.getSuggestions()) {
                System.out.print(tmp + ',');
            }
            System.out.println("\n\n input =\n" + input);
            throw new Exception("failed to parse >>>" + masterRuleName + "<<< to bnf");
        }
        output.addAll(SqlRules.bnf(root, src, masterRuleName));
    }

    public static String readURL(String masterRuleName, String sqlBNFfiles) {
        try {
            if ("logfile_clause".equals(masterRuleName)) {
                masterRuleName = "logfile_clause";
            }
            return SqlRules.readURL(sqlBNFfiles + "/" + masterRuleName + "." + htm);
        }
        catch (Exception e) {
            if (e.getClass().getPackage().getName().contains("java.net")) {
                System.err.println("Failed to connect to " + e.getMessage());
                return null;
            }
            if (!masterRuleName.endsWith("s")) {
                try {
                    String ret = SqlRules.readURL(sqlBNFfiles + "/" + masterRuleName + "s." + htm);
                    System.err.println("--------->>>" + masterRuleName + "s." + htm);
                    return ret;
                }
                catch (Exception ee) {
                    if (e.getClass().getPackage().getName().contains("java.net")) {
                        System.err.println("Failed to connect to " + e.getMessage());
                        return null;
                    }
                    notFound.add(masterRuleName);
                    return null;
                }
            }
            notFound.add(masterRuleName);
            return null;
        }
    }

    private static boolean contains(Set<RuleTuple> ret, String masterRuleName) {
        for (RuleTuple rule : ret) {
            if (!rule.head.equals(masterRuleName)) continue;
            return true;
        }
        return false;
    }

    private static ParseNode parseFixesFile(List<LexerToken> src, String input) throws Exception {
        SqlRules.correctDots(src);
        Matrix matrix = new Matrix(earley);
        earley.parse(src, matrix);
        SyntaxError s = SyntaxError.checkSyntax(input, new String[]{"bnflist"}, src, earley, matrix);
        if (s != null) {
            System.out.println("Syntax Error");
            System.out.println("at line#" + s.line);
            System.out.println(s.code);
            System.out.println(s.marker);
            System.out.println("Expected:  ");
            for (String tmp : s.getSuggestions()) {
                System.out.print(tmp + ',');
            }
            throw new Exception(">>>> Parse error in SqlFixes.bnf <<<<");
        }
        ParseNode root = earley.forest(src, matrix);
        return root;
    }

    private static boolean fetchFromFixes(Set<RuleTuple> output, String masterRuleName) throws Exception {
        if (fixesParseTree == null || fixesScan == null) {
            String input = Service.readFile(SqlRules.class, "SqlFixes.bnf");
            input = input.replace("<span class=\"bold\">", "<b>");
            input = input.replace("</span>", "</b>");
            fixesScan = Lexer.parse(input);
            fixesParseTree = SqlRules.parseFixesFile(fixesScan, input);
            SqlRules.bnflist(fixesParseTree, fixesScan, output);
        }
        return masterRules.contains(masterRuleName);
    }

    private static void correctDots(List<LexerToken> src) {
        int i = -1;
        for (LexerToken t : src) {
            if (!".".equals(t.content) || ++i != 0 && ".".equals(src.get((int)(i - 1)).content) || i != src.size() - 1 && ".".equals(src.get((int)(i + 1)).content)) continue;
            t.content = "'.'";
            t.type = Token.IDENTIFIER;
        }
    }

    private static String correctKeywords(String input, List<LexerToken> src) {
        Substitutions s = new Substitutions(input);
        LexerToken prior = null;
        LexerToken prior2 = null;
        LexerToken prior3 = null;
        boolean isB = false;
        for (LexerToken t : src) {
            if (!(t.type != Token.IDENTIFIER || isB || prior != null && "<".equals(prior.content) || Service.addDoubleQuote(t.content).charAt(0) == '\"')) {
                s.replace(t.begin, t.begin, " <b> ");
                s.replace(t.end, t.end, " </b> ");
            }
            if (">".equals(t.content) && prior != null && "b".equals(prior.content) && prior2 != null && "<".equals(prior2.content)) {
                isB = true;
            } else if (">".equals(t.content) && prior != null && "b".equals(prior.content) && prior2 != null && "/".equals(prior2.content) && prior3 != null && "<".equals(prior3.content)) {
                isB = false;
            }
            prior3 = prior2;
            prior2 = prior;
            prior = t;
        }
        return s.transformInput();
    }

    private static void bnflist(ParseNode root, List<LexerToken> src, Set<RuleTuple> grammar) {
        if (root.contains(bnf)) {
            grammar.addAll(SqlRules.bnf(root, src, null));
        } else {
            for (ParseNode child : root.children()) {
                SqlRules.bnflist(child, src, grammar);
            }
        }
    }

    private static Set<RuleTuple> bnf(ParseNode root, List<LexerToken> src, String header) {
        bnfRoot = root;
        TreeSet<RuleTuple> grammar = new TreeSet<RuleTuple>();
        for (ParseNode child : root.children()) {
            if (header == null && child.contains(identifier)) {
                header = child.content(src);
                continue;
            }
            if (!child.contains(rawbnf)) continue;
            grammar.addAll(SqlRules.rawbnf(child, src, header, false));
        }
        RuleTransforms.eliminateEmptyProductions(grammar);
        RuleTransforms.substituteSingleUnaryProductions(grammar);
        RuleTransforms.substituteSingleBinaryProductions(grammar);
        masterRules.add(header);
        return grammar;
    }

    private static Set<RuleTuple> rawbnf(ParseNode root, List<LexerToken> src, String header, boolean isBold) {
        if (root.contains(concat)) {
            return SqlRules.concat(root, src, header, isBold);
        }
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        for (ParseNode child : root.children()) {
            if (child.contains(identifier) && child.from + 1 == child.to) {
                String id = SqlRules.processId(child, src, isBold);
                ret.add(new RuleTuple(header, new String[]{id}));
                SqlRules.addToDo(id);
                continue;
            }
            if (!child.contains(rawbnf) && !child.contains(concat)) continue;
            ret.addAll(SqlRules.rawbnf(child, src, header, isBold));
        }
        return ret;
    }

    private static Set<RuleTuple> concat(ParseNode root, List<LexerToken> src, String header, boolean isBold) {
        if (root.contains(block)) {
            return SqlRules.block(root, src, header, isBold);
        }
        LinkedList<String> payload = new LinkedList<String>();
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        for (ParseNode child : root.children()) {
            String childHdr;
            String childInterval;
            if (child.contains(identifier) && child.from + 1 == child.to) {
                String id = SqlRules.processId(child, src, isBold);
                payload.add(id);
                SqlRules.addToDo(id);
                continue;
            }
            if (child.contains(concat)) {
                int intervalPos = header.indexOf(91);
                childInterval = "[" + (child.from - SqlRules.bnfRoot.from) + "," + (child.to - SqlRules.bnfRoot.from) + ")";
                childHdr = (0 < intervalPos ? header.substring(0, intervalPos) : header) + childInterval;
                Set<RuleTuple> childRules = SqlRules.concat(child, src, childHdr, isBold);
                TreeSet<RuleTuple> major = new TreeSet<RuleTuple>();
                for (RuleTuple candidate : childRules) {
                    if (!candidate.head.equals(childHdr)) continue;
                    major.add(candidate);
                }
                if (major.size() == 1) {
                    RuleTuple singleton = null;
                    String[] stringArray = major.iterator();
                    while (stringArray.hasNext()) {
                        RuleTuple r;
                        singleton = r = (RuleTuple)stringArray.next();
                    }
                    childRules.remove(singleton);
                    ret.addAll(childRules);
                    for (String rhs : singleton.rhs) {
                        payload.add(rhs);
                    }
                    continue;
                }
                ret.addAll(childRules);
                payload.add(childHdr);
                continue;
            }
            if (!child.contains(block)) continue;
            int intervalPos = header.indexOf(91);
            childInterval = "[" + (child.from - SqlRules.bnfRoot.from) + "," + (child.to - SqlRules.bnfRoot.from) + ")";
            childHdr = (0 < intervalPos ? header.substring(0, intervalPos) : header) + childInterval;
            ret.addAll(SqlRules.block(child, src, childHdr, isBold));
            payload.add(childHdr);
        }
        RuleTuple ct = new RuleTuple(header, payload);
        ret.add(ct);
        return ret;
    }

    private static Set<RuleTuple> block(ParseNode root, List<LexerToken> src, String header, boolean isBold) {
        if (root.contains(boldrawbnf)) {
            return SqlRules.boldrawbnf(root, src, header);
        }
        if (root.contains(identifier)) {
            String id = SqlRules.processId(root, src, isBold);
            SqlRules.addToDo(id);
            RuleTuple ct = new RuleTuple(header, new String[]{id});
            TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
            ret.add(ct);
            return ret;
        }
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        for (ParseNode child : root.children()) {
            RuleTuple empty = new RuleTuple(header, new String[0]);
            if (child.contains(sqBr)) {
                ret.add(empty);
                continue;
            }
            if (child.contains(rawbnf)) {
                ret.addAll(SqlRules.rawbnf(child, src, header, isBold));
                continue;
            }
            if (!child.contains(dot)) continue;
            for (RuleTuple t : ret) {
                if (!t.head.equals(header) || 0 >= t.rhs.length) continue;
                t.head = header + "#";
            }
            ret.add(new RuleTuple(header, new String[]{header + "#"}));
            ret.add(new RuleTuple(header, new String[]{header, header + "#"}));
            break;
        }
        return ret;
    }

    private static String processId(ParseNode root, List<LexerToken> src, boolean isBold) {
        String id = root.content(src);
        boolean isPunctuation = false;
        if (id.length() == 1) {
            for (char bnfId : identifiers) {
                if (id.charAt(0) != bnfId) continue;
                isPunctuation = true;
            }
        }
        if ("lt".equals(id)) {
            id = "'<'";
        } else if ("gt".equals(id)) {
            id = "'>'";
        } else if ("lbr".equals(id)) {
            id = "'['";
        } else if ("rbr".equals(id)) {
            id = "']'";
        } else if ("lcp".equals(id)) {
            id = "'{'";
        } else if ("rcp".equals(id)) {
            id = "'}'";
        } else if ("dbar".equals(id)) {
            id = "'||'";
        } else if ("sbar".equals(id)) {
            id = "'|'";
        } else if (isBold || isPunctuation) {
            id = "'" + id.toUpperCase() + "'";
        }
        return id;
    }

    private static Set<RuleTuple> boldrawbnf(ParseNode root, List<LexerToken> src, String header) {
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        for (ParseNode child : root.children()) {
            if (child.contains(rawbnf)) {
                ret.addAll(SqlRules.rawbnf(child, src, header, true));
                continue;
            }
            if (child.contains(lt)) {
                ret.add(new RuleTuple(header, new String[]{"'<'"}));
                continue;
            }
            if (child.contains(gt)) {
                ret.add(new RuleTuple(header, new String[]{"'>'"}));
                continue;
            }
            if (child.contains(lbr)) {
                ret.add(new RuleTuple(header, new String[]{"'['"}));
                continue;
            }
            if (child.contains(rbr)) {
                ret.add(new RuleTuple(header, new String[]{"']'"}));
                continue;
            }
            if (child.contains(lcp)) {
                ret.add(new RuleTuple(header, new String[]{"'{'"}));
                continue;
            }
            if (child.contains(rcp)) {
                ret.add(new RuleTuple(header, new String[]{"'}'"}));
                continue;
            }
            if (child.contains(dbar)) {
                ret.add(new RuleTuple(header, new String[]{"'|'", "'|'"}));
                continue;
            }
            if (!child.contains(sbar)) continue;
            ret.add(new RuleTuple(header, new String[]{"'|'"}));
        }
        if (ret.size() == 0) {
            throw new AssertionError((Object)("unexpected ret for " + header));
        }
        return ret;
    }

    static String readURL(String masterBNFurl) throws Exception {
        int i = 0;
        if (masterBNFurl.contains("alter_pluggable_database")) {
            ++i;
        }
        if (masterBNFurl.contains("prepare_clause")) {
            ++i;
        }
        byte[] bytes = new byte[4096];
        int bytesRead = 0;
        URL url = new URL(masterBNFurl);
        BufferedInputStream bin = new BufferedInputStream(url.openStream());
        StringBuffer out = new StringBuffer();
        bytesRead = bin.read(bytes, 0, bytes.length);
        StringBuffer sb = new StringBuffer();
        while (bytesRead != -1) {
            sb.append(new String(bytes).substring(0, bytesRead));
            bytesRead = bin.read(bytes, 0, bytes.length);
        }
        String ret = sb.toString();
        int ind = ret.indexOf("<p>Note:");
        if (ind > 0) {
            ret = ret.substring(0, ind);
        }
        if ((ind = ret.indexOf("Note:")) > 0) {
            ret = ret.substring(0, ind);
        }
        if ((ind = ret.indexOf("</pre>")) < 0) {
            ind = ret.indexOf("</PRE>");
        }
        if (ind < 0) {
            ret = ret + "</pre>";
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        boolean test = true;
        if (test) {
            SqlRules.testParseSqlBnf();
        } else {
            String page = SqlRules.readURL(masterBNFurl + "Calculated-Measure-Expressions.htm");
            String str = "<p class=\"subhead2\"><span class=\"italic\">";
            int pos = page.indexOf(str);
            while (0 < pos) {
                int end = page.indexOf("</span>::=</p>", pos + str.length());
                int end1 = page.indexOf("</span> ::=</p>", pos + str.length());
                if (0 < end1 && end1 < end) {
                    end = end1;
                }
                if (end < 0) break;
                if (pos + 100 >= end) {
                    String rule = page.substring(pos + str.length(), end);
                    int hrefPos = page.indexOf("<a href=\"", end);
                    int hrefEnd = page.indexOf("\">", hrefPos);
                    String guid = page.substring(hrefPos + "<a href=\"".length(), hrefEnd);
                    String ruleBNF = SqlRules.readURL(masterBNFurl + guid);
                    String ruleTag = "<pre class=\"oac_no_warn\" dir=\"ltr\">";
                    int from = ruleBNF.indexOf(ruleTag);
                    int to = ruleBNF.indexOf("</pre>", from);
                    ruleBNF = ruleBNF.substring(from + ruleTag.length(), to);
                    ruleBNF = ruleBNF.replace("<span class=\"bold\">", "<b>");
                    ruleBNF = ruleBNF.replace("</span>", "</b>");
                    System.out.println("<pre " + rule + ">");
                    System.out.println(ruleBNF);
                    System.out.println("</pre>");
                    System.out.println();
                    System.out.println();
                }
                pos = page.indexOf(str, pos + str.length());
            }
        }
    }

    static {
        try {
            earley = SqlRules.bnfParser();
            bnf = (Integer)SqlRules.earley.symbolIndexes.get("bnf");
            rawbnf = (Integer)SqlRules.earley.symbolIndexes.get("rawbnf");
            boldrawbnf = (Integer)SqlRules.earley.symbolIndexes.get("boldrawbnf");
            identifier = (Integer)SqlRules.earley.symbolIndexes.get("identifier");
            concat = (Integer)SqlRules.earley.symbolIndexes.get("concat");
            block = (Integer)SqlRules.earley.symbolIndexes.get("block");
            sqBr = (Integer)SqlRules.earley.symbolIndexes.get("'['");
            curlyBr = (Integer)SqlRules.earley.symbolIndexes.get("'{'");
            dot = (Integer)SqlRules.earley.symbolIndexes.get("'.'");
            lt = (Integer)SqlRules.earley.symbolIndexes.get("lt");
            gt = (Integer)SqlRules.earley.symbolIndexes.get("gt");
            lbr = (Integer)SqlRules.earley.symbolIndexes.get("lbr");
            rbr = (Integer)SqlRules.earley.symbolIndexes.get("rbr");
            lcp = (Integer)SqlRules.earley.symbolIndexes.get("lcp");
            rcp = (Integer)SqlRules.earley.symbolIndexes.get("rcp");
            dbar = (Integer)SqlRules.earley.symbolIndexes.get("dbar");
            sbar = (Integer)SqlRules.earley.symbolIndexes.get("sbar");
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        missingSymbols = new TreeMap<String, String>();
        toDo = new HashSet<String>();
        notFound = new HashSet<String>();
        masterRules = new HashSet<String>();
        masterBNFurl = DocURL.Manual.SQL.getBasePrivateURL() + "/img_text";
        cachedBNFdir = "/temp" + masterBNFurl.substring(masterBNFurl.indexOf("/oracle/oracle-database") + "/oracle/oracle-database".length());
        cacheExists = null;
        fixesParseTree = null;
        fixesScan = null;
        bnfRoot = null;
    }
}

