/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.dictionary;

import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.util.Service;

public class DictionaryEarley {
    static Earley instance = null;

    public static Earley getInstance() throws IOException {
        if (instance != null) {
            return instance;
        }
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        String input = Service.readFile(DictionaryEarley.class, "dictionary.grammar");
        List<LexerToken> src = LexerToken.parse(input);
        ParseNode root = Grammar.parseGrammarFile(src, input);
        Grammar.grammar(root, src, rules);
        RuleTransforms.eliminateEmptyProductions(rules);
        instance = new Earley(rules, false){

            @Override
            protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                LexerToken token = src.get(y);
                if (this.symbolIndexes.get("'TABLES'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'VIEWS'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'PACKAGES'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'PROCEDURES'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'FUNCTIONS'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'TRIGGERS'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'INDEXES'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'MATERIALIZED'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'OPERATORS'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'TYPES'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'QUEUES'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'QUEUE'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'SEQUENCES'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'SYNONYMS'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'PUBLIC'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'DATABASE'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'DIRECTORIES'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'EDITIONS'") == suspect) {
                    return false;
                }
                if (this.symbolIndexes.get("'OTHER'") == suspect) {
                    if (y + 1 < src.size() && src.get((int)(y + 1)).content.toUpperCase().equals("USERS")) {
                        return false;
                    }
                    if (y + 1 < src.size() && src.get((int)(y + 1)).content.toUpperCase().equals("DATATYPES")) {
                        return false;
                    }
                }
                return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING;
            }
        };
        DictionaryEarley.instance.isCaseSensitive = false;
        return instance;
    }

    public static void main(String[] args) throws IOException {
        String input = Service.readFile("src/test/resources/oracle/dbtools/parser/dictionary/hr.dict");
        long t1 = System.nanoTime();
        List<LexerToken> src = LexerToken.parse(input);
        long t2 = System.nanoTime();
        System.out.println("Lex time = " + (t2 - t1) / 1000000L);
        Earley earley = DictionaryEarley.getInstance();
        Visual visual = new Visual(src, earley);
        Matrix matrix = new Matrix(earley);
        long t21 = System.nanoTime();
        earley.parse(src, matrix);
        visual.draw(matrix);
        long t22 = System.nanoTime();
        System.out.println("parse time = " + (t22 - t21) / 1000000L);
        t1 = System.nanoTime();
        ParseNode root = earley.forest(src, matrix, true);
        if (src.size() < 1000) {
            root.printTree();
        }
        t2 = System.nanoTime();
        System.out.println("Reduction time = " + (t2 - t1) / 1000000L);
    }
}

