/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.dictionary;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.dictionary.Item;
import oracle.dbtools.lsp.dictionary.Registry;
import oracle.dbtools.lsp.dictionary.SymbolContext;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Substitutions;
import oracle.dbtools.util.Service;

public class Dictionary
extends Registry {
    private Connection connection;
    private String connDirName;
    private String schema;
    public static int limit = 300;
    static final String otherUsersQuery = "SELECT USERNAME object_name, null object_type, null owner from ALL_USERS where USERNAME != USER `filter` order by USERNAME";
    static final String allObjectsQuery = "select `columns` from all_objects \nwhere object_type = `objType` and owner=`schema` `filter`\norder by object_name";
    static final String AT = " ";
    static final String JDBC_PREFIX = "\"jdbc:oracle:thin:@";
    public static String dictFolder = "Dictionary";
    public static String fileName = "dbobjects.dict";
    public static String dictionaryScheleton = "\nTables: ... \n\nViews: ... \n\nPackages: ...\n\nProcedures: ... \n\nFunctions: ... \n\nTriggers: ... \n\nOther Datatypes: ... \n\nOther Users: ... \n\n";
    public static String nonessentialScheleton = "\nIndexes: ... \n\nMaterialized Views: ...\n\nMaterialized View Logs: ... \n\nOperators: ... \n\nTypes: ... \n\nQueues: ... \n\nQueue Tables: ... \n\nSequences: ... \n\nSynonyms: ... \n\nPublic Synonyms: ... \n\nDatabase Links: ... \n\nDirectories: ... \n\nEditions: ... \n\n";

    public String getSchema() {
        if (this.schema != null) {
            return this.schema;
        }
        if (this.connection != null) {
            try {
                this.schema = this.connection.getSchema();
                return this.schema;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return "N/A";
    }

    public Dictionary(BackgroundParser parser) {
        super(parser);
    }

    @Override
    public void setConnection(String connDirName, Object connection) {
        this.connection = (Connection)connection;
        this.connDirName = connDirName;
    }

    @Override
    public void copyConnection(Registry src) {
        Dictionary source = (Dictionary)src;
        this.connection = source.connection;
        this.connDirName = source.connDirName;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void closeConnection() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dissociateConnection();
    }

    @Override
    public void dissociateConnection() {
        this.connection = null;
        this.connDirName = null;
        this.cleanSymbols();
    }

    @Override
    public String getConnString() {
        return this.connDirName;
    }

    @Override
    public void recordSymbol(ParseNode symbol, String type, int declaration, BackgroundParser parser) {
        if (this.parser == null) {
            this.parser = parser;
        }
        assert (this.parser == parser);
        this.getSymbols().put(symbol.from, new SymbolContext(symbol.from, Service.handleMixedCase(parser.src.get((int)symbol.from).content), type, declaration));
    }

    @Override
    public void recordSymbol(ParseNode symbol, ParseNode type, BackgroundParser parser) {
        ParseNode grandParent;
        String schema = this.getSchema();
        List<LexerToken> src = parser.src;
        if (type.parent() != null && type.parent().parent() != null && !(grandParent = type.parent().parent()).contains("other_datatypes_node")) {
            schema = src.get((int)grandParent.from).content;
        }
        String typeName = Dictionary.plural2single(src.get((int)type.from).content);
        this.getSymbols().put(symbol.from, new SymbolContext(symbol.from, Service.handleMixedCase(src.get((int)symbol.from).content), new String[]{typeName}, schema));
    }

    public static String plural2single(String typeName) {
        if ("INDEXES".equalsIgnoreCase(typeName)) {
            return "INDEX";
        }
        if ("DICTIONARIES".equalsIgnoreCase(typeName)) {
            return "DICTIONARY";
        }
        return typeName.substring(0, typeName.length() - 1).toUpperCase();
    }

    @Override
    public void recordSymbol(ParseNode symbol, String[] types, BackgroundParser parser) {
        String schema = this.getSchema();
        List<LexerToken> src = parser.src;
        this.getSymbols().put(symbol.from, new SymbolContext(symbol.from, Service.handleMixedCase(src.get((int)symbol.from).content), types, schema));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryObjectDefinition(Item obj) throws SQLException, IOException {
        String definitionChunk = "select DBMS_METADATA.GET_DDL(?,?,?) FROM dual\n";
        StringBuilder definitionQuery = new StringBuilder("select DBMS_METADATA.GET_DDL(?,?,?) FROM dual\n");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String string;
            stmt = this.connection.prepareStatement(definitionQuery.toString());
            stmt.setString(1, obj.type);
            stmt.setString(2, obj.name);
            stmt.setString(3, obj.owner == null ? this.getSchema() : obj.owner);
            rs = stmt.executeQuery();
            StringBuilder content = new StringBuilder();
            if (rs.next()) {
                int i;
                Clob clob = rs.getClob(1);
                Reader r = clob.getCharacterStream();
                while ((i = r.read()) != -1) {
                    content.append((char)i);
                }
            }
            if (content.length() == 0) {
                string = null;
                return string;
            }
            string = content.toString();
            return string;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public Item getObject(String schema, String type, String name) throws SQLException {
        return this.getObject(schema, new String[]{type}, name);
    }

    @Override
    public Item getObject(SymbolContext symbol) throws SQLException {
        Item ret = this.getObject(symbol.owner, symbol.types, symbol.name);
        if (ret != null) {
            symbol.types = new String[]{ret.type};
            symbol.owner = ret.owner;
        }
        return ret;
    }

    @Override
    public Item getObject(String schema, String[] types, String oName) throws SQLException {
        if (this.connection == null) {
            throw new SQLWarning("Not connected");
        }
        String owner = Service.handleMixedCase(schema);
        String name = Service.handleMixedCase(oName);
        String typePredicate = "";
        if (types.length == 1 && types[0] != null) {
            typePredicate = "and object_type ='" + types[0] + "'";
        }
        if (1 < types.length) {
            StringBuilder list = new StringBuilder("'" + types[0] + "'");
            for (int i = 1; i < types.length; ++i) {
                list.append(",'");
                list.append(types[i]);
                list.append("'");
            }
            typePredicate = "and object_type in (" + list.toString() + ")";
        }
        String query = "select owner,object_type, object_name from all_objects \nwhere object_name = '" + name + "' and owner in ('" + owner + "','SYS', 'SYSTEM')\n" + typePredicate;
        LinkedList<Item> ret = this.query(query);
        Collections.sort(ret);
        if (0 < ret.size()) {
            return ret.getFirst();
        }
        return null;
    }

    public LinkedList<Item> query(String query) throws SQLException {
        if (this.connection == null) {
            return new LinkedList<Item>();
        }
        return Dictionary.query(query, this.connection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedList<Item> query(String query, Connection conn, boolean limited) throws SQLException {
        LinkedList<Item> ret = new LinkedList<Item>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String dbaVersion = query.replace("all_", "Dba_");
            dbaVersion = dbaVersion.replace("ALL_", "Dba_");
            stmt = conn.prepareStatement(dbaVersion);
            rs = stmt.executeQuery();
            int cnt = 0;
            while (rs.next()) {
                if (limited && cnt++ == limit) {
                    ret.add(Item.MORE);
                    break;
                }
                ret.add(new Item(rs.getString("OBJECT_NAME"), rs.getString("OBJECT_TYPE"), rs.getString("OWNER")));
            }
            LinkedList<Item> linkedList = ret;
            return linkedList;
        }
        catch (SQLException e) {
            try {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException cnt) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException cnt) {
                        // empty catch block
                    }
                }
                stmt = conn.prepareStatement(query);
                rs = stmt.executeQuery();
                int cnt = 0;
                while (rs.next()) {
                    if (limited && cnt++ == limit) {
                        ret.add(Item.MORE);
                        break;
                    }
                    ret.add(new Item(rs.getString("OBJECT_NAME"), rs.getString("OBJECT_TYPE"), rs.getString("OWNER")));
                }
                LinkedList<Item> linkedList = ret;
                return linkedList;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                        rs = null;
                    }
                    catch (SQLException sQLException) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                        stmt = null;
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static List<Item> queryItems(ParseNode node, List<LexerToken> src, String schema, String objType, Object conn) throws SQLException {
        String query;
        if (objType.equals("OTHER_USERS")) {
            query = otherUsersQuery;
        } else {
            query = allObjectsQuery;
            query = query.replace("`objType`", "'" + objType + "'");
            query = query.replace("`schema`", schema);
            query = query.replace("`columns`", "object_name, object_type, null owner");
        }
        String filter = Dictionary.limitedCondition(node, src);
        query = query.replace("`filter`", filter);
        LinkedList<Item> items = Dictionary.query(query, (Connection)conn, "".equals(filter));
        return items;
    }

    private static String limitedCondition(ParseNode node, List<LexerToken> src) {
        String filter = " and rownum <= " + (limit + 1) + "\n";
        for (ParseNode child : node.children()) {
            if (!child.contains("filter")) continue;
            for (ParseNode grandchild : child.children()) {
                if (!grandchild.contains("condition")) continue;
                String filterContent = grandchild.content(src);
                if (filterContent.toLowerCase().contains("rownum")) {
                    filter = "";
                }
                Substitutions subs = new Substitutions(filterContent);
                for (ParseNode descendant : grandchild.descendants()) {
                    if (!descendant.contains("'NAME'")) continue;
                    int from = src.get((int)descendant.from).begin - src.get((int)grandchild.from).begin;
                    subs.replace(from, from + "NAME".length(), "oBject_nAme");
                }
                filterContent = subs.transformInput();
                filter = " and " + filterContent + filter;
            }
        }
        return filter;
    }

    public static String indent(String input, int level) {
        String pad = Service.padln("", 4 * level);
        return input.replace("\n", "\n" + pad).replace("\r\n", "\r\n" + pad);
    }

    public static String connCmdArg(String conn, String user, String pwd) {
        if (conn.startsWith("\"")) {
            conn = conn.substring(1, conn.length() - 1);
        }
        return user.toLowerCase() + "@\"" + conn.toLowerCase() + "\"";
    }

    public static String connAlias(String conn, String user, String pwd) {
        return Dictionary.conn2dirName(Dictionary.connCmdArg(conn, user, pwd));
    }

    private static String conn2dirName(String input) {
        input = input.substring(0, input.length() - 1);
        input = input.replace(JDBC_PREFIX, "~");
        input = input.replace("@", AT);
        input = input.replace(":", "_");
        input = input.replace("/", "_");
        return input;
    }

    @Override
    public String dirName2conn(String input) {
        input = input.replace("~", JDBC_PREFIX);
        input = input.replace(AT, "@");
        int i = input.indexOf(95);
        input = input.substring(0, i) + ':' + input.substring(i + 1);
        input = input.replace("_", "/");
        return input + "\"";
    }

    private static String dirName(String connStr) {
        return dictFolder + '/' + Dictionary.conn2dirName(connStr);
    }

    public static String dirName(String conn, String user, String pwd) {
        return Dictionary.dirName(Dictionary.connCmdArg(conn, user, pwd));
    }

    public String dirName() {
        return dictFolder + '/' + this.connDirName;
    }

    public static List<String> allDatatypes() {
        LinkedList<String> ret = new LinkedList<String>();
        List<LexerToken> src = LexerToken.parse(dictionaryScheleton + nonessentialScheleton);
        String prior = "";
        for (LexerToken current : src) {
            if (":".equals(current)) {
                ret.add(prior.substring(0, prior.length() - 1).toUpperCase());
            }
            prior = current.content;
        }
        return ret;
    }
}

