/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.sql;

import java.io.OutputStream;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.commands.sql.Query;
import oracle.dbtools.parser.ParseNode;

public class RunScript
extends CodeLens {
    private int cmdCount = 0;

    public RunScript(String notUsed, BackgroundParser parser) {
        super(new ParseNode(0, 0, -1, null), "Run script", "", parser);
    }

    @Override
    public Object executeCommand(final OutputStream send) {
        this.parser.resetDiagnostics();
        new Thread(){

            @Override
            public void run() {
                String log = RunScript.iterateCodeLenses(RunScript.this.parser, send);
                String fileExt = ".log";
                String uri = ((RunScript)RunScript.this).parser.docUrl.substring(1, ((RunScript)RunScript.this).parser.languageServer.getLastUrl().length() - 1) + fileExt;
                ((RunScript)RunScript.this).parser.languageServer.getLSP().createFile(send, uri, log);
            }
        }.start();
        return "OK";
    }

    public void addCommand() {
        ++this.cmdCount;
    }

    public boolean isEmpty() {
        return 0 < this.cmdCount;
    }

    public int cmdCount() {
        return this.cmdCount;
    }

    public static String iterateCodeLenses(BackgroundParser parser, OutputStream send) {
        StringBuilder log = new StringBuilder();
        int lastPos = -1;
        boolean isFirstQuery = true;
        for (CodeLens candidate : parser.codeLens) {
            Object result;
            String cmd = "";
            if (candidate.node.to <= 0) continue;
            if (0 <= candidate.node.from) {
                cmd = parser.text.substring(parser.src.get((int)candidate.node.from).begin, parser.src.get((int)(candidate.node.to - 1)).end);
            }
            if (30 < cmd.length()) {
                cmd = cmd.substring(0, 30) + "...";
            }
            if (lastPos >= candidate.node.from) continue;
            if (candidate instanceof Query) {
                Query query = (Query)candidate;
                result = query.executeCommand(send, isFirstQuery ? Query.Mode.Script0 : Query.Mode.Script1);
                isFirstQuery = false;
            } else {
                result = candidate.executeCommand(send).toString();
            }
            log.append(cmd + "  " + result.toString() + "\n\n");
            lastPos = candidate.node.to - 1;
        }
        return log.toString();
    }
}

