/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.sql;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.GridRenderer;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.features.Position;
import oracle.dbtools.lsp.features.Range;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;

public class Query
extends CodeLens {
    static final String normalTitle = "Query:";
    static final String cancelTitle = "Cancel running query:";
    Statement stmt = null;

    public Query(ParseNode node, BackgroundParser parser) {
        super(node, normalTitle, parser);
    }

    @Override
    public Object executeCommand(OutputStream send) {
        return this.executeCommand(send, Mode.Standalone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCommand(final OutputStream send, Mode mode) {
        if (this.stmt != null) {
            try {
                this.stmt.cancel();
                this.command.title = normalTitle;
                this.parser.documentBump(send);
                String string = "OK";
                return string;
            }
            catch (SQLException e) {
                if (!(e instanceof SQLException) && !(e instanceof SQLSyntaxErrorException)) {
                    LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
                }
                ResponseError responseError = new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), this.stmt);
                return responseError;
            }
            finally {
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                        this.stmt = null;
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        String s = this.parser.text.substring(this.parser.src.get((int)this.node.from).begin, this.parser.src.get((int)(this.node.to - 1)).end);
        if (s.endsWith(";")) {
            s = s.substring(0, s.length() - 1);
        }
        final String sql = s;
        LanguageServer server = this.parser.languageServer;
        Connection conn = (Connection)server.getLastConnection();
        if (conn == null) {
            return new ResponseError(-32099, "Not connected", server.getLastUrl());
        }
        try {
            this.stmt = conn.createStatement();
            if (mode == Mode.Standalone) {
                this.command.title = cancelTitle;
                this.parser.documentBump(send);
                this.parser.resetDiagnostics();
                new Thread(){

                    @Override
                    public void run() {
                        Query.this.query(send, Mode.Script0, sql);
                    }
                }.start();
            } else {
                this.query(send, mode, sql);
            }
            return "OK";
        }
        catch (Exception e) {
            if (!(e instanceof SQLException) && !(e instanceof SQLSyntaxErrorException)) {
                LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
            return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void query(OutputStream send, Mode mode, String sql) {
        LanguageServer server = this.parser.languageServer;
        Connection conn = (Connection)server.getLastConnection();
        ResultSet rs = null;
        try {
            String fileExt;
            rs = this.stmt.executeQuery(sql);
            boolean oldSilent = server.getRenderer().isSilent;
            GridRenderer oldRenderer = server.getRenderer();
            List<LexerToken> src = LexerToken.parse(sql, true);
            if (1 < src.size()) {
                int i = 1;
                LexerToken one = src.get(i++);
                while (one.type == Token.WS) {
                    one = src.get(i++);
                }
                if (one.type == Token.COMMENT || one.type == Token.LINE_COMMENT) {
                    try {
                        String renderMode = one.content.substring(2).toLowerCase();
                        if (one.type == Token.COMMENT) {
                            renderMode = renderMode.substring(0, renderMode.length() - 2);
                        }
                        if ("silent".equalsIgnoreCase(renderMode = renderMode.trim())) {
                            server.getRenderer().isSilent = true;
                        } else if ("vocal".equalsIgnoreCase(renderMode)) {
                            server.getRenderer().isSilent = false;
                        } else {
                            server.setRenderer(GridRenderer.factory(renderMode));
                        }
                    }
                    catch (Throwable renderMode) {
                        // empty catch block
                    }
                }
            }
            if ((fileExt = server.getRenderer().getClass().getSimpleName().substring(0, 4)).endsWith("R")) {
                fileExt = fileExt.substring(0, 3);
            }
            if (fileExt.equalsIgnoreCase("INSE")) {
                fileExt = "sql";
            }
            String content = server.getRenderer().render(rs, conn);
            fileExt = ".output." + fileExt.toLowerCase();
            String lastUrl = this.parser.docUrl;
            String uri = lastUrl.substring(1, lastUrl.length() - 1) + fileExt;
            String url = '\"' + uri + '\"';
            if (mode == Mode.Script0) {
                server.getLSP().createFile(send, uri, content);
            } else {
                Position pos = new Position(999999, 0);
                server.getLSP().documentInsert(new Range(pos, pos), send, uri, "\n" + content);
            }
            server.getRenderer().isSilent = oldSilent;
            server.setRenderer(oldRenderer);
            server.logStatement(sql, send);
            if (".output.sql".equals(fileExt)) {
                String connStr = this.parser.getAssociatedConnstr();
                BackgroundParser sqlParser = server.getParser(url);
                if (sqlParser == null) {
                    sqlParser = BackgroundParser.factory(content, url, server);
                    server.parsers.put(url, sqlParser);
                }
                server.associateConnection(sqlParser, connStr);
            }
            this.parser.languageServer.getLSP().notifyClient(send, "telemetry/event", "\"Query finished\"");
        }
        catch (Exception e) {
            if (!(e instanceof SQLException) && !(e instanceof SQLSyntaxErrorException)) {
                LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
            if (e instanceof SQLException) {
                this.parser.failedCommand(this.node, e);
            }
        }
        finally {
            server.documentsBump(send);
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.stmt != null) {
                try {
                    this.stmt.close();
                    this.stmt = null;
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    static enum Mode {
        Standalone,
        Script0,
        Script1;

    }
}

