/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.sql;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.logging.Level;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;

public class ExecuteSql
extends CodeLens {
    static final String normalTitle = "Execute statement:";
    static final String cancelTitle = "Cancel running statement:";
    Statement stmt = null;

    public ExecuteSql(ParseNode node, BackgroundParser parser) {
        super(node, normalTitle, parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeCommand(final OutputStream send) {
        if (this.stmt != null) {
            try {
                this.stmt.cancel();
                this.command.title = normalTitle;
                this.parser.documentBump(send);
                String string = "OK";
                return string;
            }
            catch (SQLException e) {
                if (!(e instanceof SQLException) && !(e instanceof SQLSyntaxErrorException)) {
                    LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
                }
                ResponseError responseError = new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), this.stmt);
                return responseError;
            }
            finally {
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                        this.stmt = null;
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        String s = this.parser.text.substring(this.parser.src.get((int)this.node.from).begin, this.parser.src.get((int)(this.node.to - 1)).end);
        if (s.toUpperCase().startsWith("EXECUTE ")) {
            s = "begin \n" + s.substring("EXECUTE ".length()) + "\n end;";
        } else if (s.endsWith(";")) {
            s = s.substring(0, s.length() - 1);
        }
        final String sql = s;
        final LanguageServer server = this.parser.languageServer;
        Connection conn = (Connection)server.getLastConnection();
        if (conn == null) {
            return new ResponseError(-32099, "Not connected", server.getLastUrl());
        }
        try {
            this.stmt = conn.createStatement();
            this.command.title = cancelTitle;
            this.parser.documentBump(send);
            this.parser.resetDiagnostics();
            new Thread(){

                @Override
                public void run() {
                    try {
                        ExecuteSql.this.stmt.execute(sql);
                        server.logStatement(sql, send);
                        ((ExecuteSql)ExecuteSql.this).parser.languageServer.getLSP().notifyClient(send, "telemetry/event", "\"Statement finished\"");
                    }
                    catch (Exception e) {
                        if (!(e instanceof SQLException) && !(e instanceof SQLSyntaxErrorException)) {
                            LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
                        }
                        if (e instanceof SQLException) {
                            ExecuteSql.this.parser.failedCommand(ExecuteSql.this.node, e);
                        }
                    }
                    finally {
                        server.documentsBump(send);
                        if (ExecuteSql.this.stmt != null) {
                            try {
                                ExecuteSql.this.stmt.close();
                                ExecuteSql.this.stmt = null;
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                }
            }.start();
            return "OK";
        }
        catch (Exception e) {
            if (!(e instanceof SQLException) && !(e instanceof SQLSyntaxErrorException)) {
                LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
            return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), conn);
        }
    }
}

