/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.dictionary;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.dictionary.Dictionary;
import oracle.dbtools.lsp.dictionary.Item;
import oracle.dbtools.lsp.features.Range;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;

public class RefreshTreeNode
extends CodeLens {
    public RefreshTreeNode(ParseNode node, BackgroundParser parser) {
        super(node, "Refresh tree node", parser);
    }

    @Override
    public Object executeCommand(OutputStream send) {
        ParseNode current = null;
        for (ParseNode child : this.node.children()) {
            if (!child.contains("content") && !child.contains("users_content")) continue;
            current = child;
        }
        LanguageServer server = this.parser.languageServer;
        boolean done = this.parser.waitForParsingFinish();
        if (!done) {
            return new ResponseError(-32603, "Parsing failed to complete", server.getLastUrl());
        }
        Range range = this.parser.nodeRange(current);
        String uri = server.getLastUrl().substring(1, server.getLastUrl().length() - 1);
        if (this.node.contains("user")) {
            String indenetedDict = Dictionary.indent(Dictionary.dictionaryScheleton.replace("\n\n", "\n").replace("\n\r\n", "\n"), 2);
            server.getLSP().documentInsert(range, send, uri, indenetedDict);
            return "OK";
        }
        if (this.node.contains("other_datatypes_node")) {
            String indenetedDict = Dictionary.indent(Dictionary.nonessentialScheleton.replace("\n\n", "\n").replace("\n\r\n", "\n"), 2);
            server.getLSP().documentInsert(range, send, uri, indenetedDict);
            return "OK";
        }
        ParseNode grandParent = this.node.parent().parent();
        String schema = "USER";
        if (grandParent != null && !grandParent.contains("other_datatypes_node")) {
            schema = "'" + this.parser.src.get((int)grandParent.from).content.toUpperCase() + "'";
        }
        String symbol = this.parser.earley.allSymbols[this.node.content()[0]].toUpperCase();
        int chop = symbol.indexOf("_NODE");
        String objType = symbol.substring(0, chop);
        Connection conn = (Connection)server.getLastConnection();
        if (conn == null) {
            return new ResponseError(-32603, "Not connected", server.getLastUrl());
        }
        try {
            List<Item> items = Dictionary.queryItems(this.node, this.parser.src, schema, objType, conn);
            StringBuilder aggr = new StringBuilder();
            int level = grandParent != null ? 3 : 1;
            int cnt = -1;
            for (Item item : items) {
                ++cnt;
                String name = item.name;
                if (objType.equals("OTHER_USERS")) {
                    name = name + "...";
                }
                if (cnt < items.size() - 1) {
                    name = name + ",\n";
                }
                aggr.append(Dictionary.indent(name, level));
            }
            String ins = aggr.toString();
            server.getLSP().documentInsert(range, send, uri, ins);
            return "OK";
        }
        catch (SQLException e) {
            LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
            return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), conn);
        }
    }
}

