/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands;

import java.io.OutputStream;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.Jsonable;
import oracle.dbtools.lsp.features.Command;
import oracle.dbtools.lsp.features.Range;
import oracle.dbtools.parser.ParseNode;

public abstract class CodeLens
implements Jsonable,
Comparable<CodeLens> {
    protected BackgroundParser parser;
    public ParseNode node;
    protected Command command = null;
    protected String argument = "empty";

    public Range getRange() {
        return this.parser.nodeRange(this.node);
    }

    public String getTitle() {
        return this.command.title;
    }

    public CodeLens(ParseNode node, String title, BackgroundParser parser) {
        this.node = node;
        String cmd = Thread.currentThread().getStackTrace()[2].getClassName();
        this.command = new Command(title, "arbori.oneLinerCommand", "`" + cmd + "` `" + node.interval() + "`");
        this.parser = parser;
    }

    public CodeLens(ParseNode node, String title, String argument, BackgroundParser parser) {
        this.node = node;
        String cmd = Thread.currentThread().getStackTrace()[2].getClassName();
        this.command = new Command(title, "arbori.oneLinerCommand", "`" + cmd + "` `" + node.interval() + "` `" + argument + "`");
        this.parser = parser;
        this.argument = argument;
    }

    @Override
    public String toJson() {
        return "{ \"range\": " + this.getRange().toJson() + ", \"command\": " + this.command.toJson() + " }";
    }

    public String toString() {
        return "node=" + this.node.toString() + ", command.title=" + this.command.title + ", command.command=" + this.command.command + ", command.class=" + this.command.getClass() + ",parser=" + this.parser;
    }

    public static void print(CodeLens[] arr) {
        if (arr == null) {
            return;
        }
        for (int i = 0; i < arr.length; ++i) {
            System.out.println(arr[i].toString());
        }
    }

    public abstract Object executeCommand(OutputStream var1);

    public static CodeLens rangedCommandAt(CodeLens[] codeLens, int index) {
        int trueIndex = 0;
        for (int i = 0; i < codeLens.length; ++i) {
            if (codeLens[i].node.to < 1) continue;
            if (trueIndex == index) {
                return codeLens[i];
            }
            ++trueIndex;
        }
        throw new AssertionError((Object)("Index out of bounds: " + (codeLens.length - 1) + "<" + index));
    }

    public static CodeLens find(CodeLens[] codeLens, String classname, String interval, String argument) {
        String name = CodeLens.normalizedClassName(classname);
        for (int i = 0; i < codeLens.length; ++i) {
            if (!name.equals(CodeLens.normalizedClassName(codeLens[i].getClass().getName())) || !interval.equals(codeLens[i].node.interval()) || !argument.equals(codeLens[i].argument)) continue;
            return codeLens[i];
        }
        throw new AssertionError((Object)("Index out of bounds: " + (codeLens.length - 1)));
    }

    @Override
    public int compareTo(CodeLens o) {
        int posDiff = this.node.compareTo(o.node);
        if (posDiff != 0) {
            return posDiff;
        }
        int cmdDiff = this.command.toJson().compareTo(o.command.toJson());
        if (cmdDiff != 0) {
            return cmdDiff;
        }
        int argDiff = this.argument.compareTo(o.argument);
        if (argDiff != 0) {
            return argDiff;
        }
        return 0;
    }

    public static String normalizedClassName(String name) {
        String ret = name;
        int pos = (ret = ret.replace('_', '.')).indexOf("oracle.dbtools");
        if (0 < pos) {
            ret = ret.substring(pos);
        }
        return ret;
    }
}

