/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.Jsonable;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.Message;
import oracle.dbtools.lsp.PublishDiagnosticsParams;
import oracle.dbtools.lsp.WebSocket;
import oracle.dbtools.lsp.features.Position;
import oracle.dbtools.lsp.features.Range;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.json.Interpreter;
import oracle.dbtools.parser.json.JsonEarley;
import oracle.dbtools.parser.json.NamedValue;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;

public class LSP {
    WebSocket webSocket = null;
    static Charset UTF_8 = StandardCharsets.UTF_8;
    public static final String cancelResponce = "cancelResponce";
    int requestId = 0;
    Map<Integer, Boolean> applied = new HashMap<Integer, Boolean>();
    ArrayBlockingQueue<Message> pending = new ArrayBlockingQueue(10);
    public static Range fullRange = new Range(new Position(0, 0), new Position(999999, 0));
    public static Logger LOG = Logger.getLogger("main");
    static int port = 6011;

    private String readHeader(InputStream client) {
        StringBuilder line = new StringBuilder();
        char next = this.read(client);
        while (true) {
            if (next == '\r') {
                char last = this.read(client);
                assert (last == '\n');
                break;
            }
            line.append(next);
            next = this.read(client);
        }
        return line.toString();
    }

    private int parseHeader(String header) {
        String contentLength = "Content-Length: ";
        if (header.startsWith(contentLength)) {
            String tail = header.substring(contentLength.length());
            return Integer.parseInt(tail);
        }
        return -1;
    }

    private char read(InputStream client) {
        try {
            int c = client.read();
            if (c == -1) {
                LOG.warning("Stream from client has been closed, throwing kill exception...");
                throw new EndOfStream();
            }
            return (char)c;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            throw new EndOfStream();
        }
    }

    private String readLength(InputStream client, int byteLength) {
        char next = this.read(client);
        while (Character.isWhitespace(next)) {
            next = this.read(client);
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (true) {
            result.append(next);
            if (++i == byteLength) break;
            next = this.read(client);
        }
        return result.toString();
    }

    String nextToken(InputStream client) {
        if (this.webSocket != null) {
            return this.webSocket.unframe(client);
        }
        int contentLength = -1;
        String lastLine = null;
        while (true) {
            int maybeLength;
            String line = this.readHeader(client);
            System.out.println("line=" + line);
            if ("Connection: close".equals(line)) {
                return line;
            }
            if (line.isEmpty()) {
                if (0 < contentLength) {
                    return this.readLength(client, contentLength);
                }
                this.webSocket = new WebSocket();
                return lastLine;
            }
            if (line.startsWith("Sec-WebSocket-Key")) {
                lastLine = line;
            }
            if ((maybeLength = this.parseHeader(line)) == -1) continue;
            contentLength = maybeLength;
        }
    }

    Message parseMessage(String token) throws IOException {
        String log = token;
        if (1000 < log.length()) {
            log = log.substring(0, 1000) + "...";
        }
        System.out.println(" token = " + log);
        Message ret = new Message();
        ret.jsonrpc = token;
        NamedValue tmp = new Interpreter().eval(token);
        List<NamedValue> elements = tmp.composite;
        block0: for (NamedValue el : elements) {
            if ("\"method\"".equals(el.name)) {
                String name = el.atomic;
                if (name.charAt(0) == '\"' && name.charAt(0) == '\"') {
                    name = name.substring(1, name.length() - 1);
                }
                ret.method = name;
            }
            if ("\"params\"".equals(el.name)) {
                ret.params = el;
            }
            if ("\"result\"".equals(el.name)) {
                ret.result = el;
            }
            if ("\"id\"".equals(el.name)) {
                ret.id = Integer.parseInt(el.valueString());
            }
            if (!"\"error\"".equals(el.name)) continue;
            for (NamedValue ell : el.composite) {
                if (!"\"message\"".equals(ell.name)) continue;
                ret.error = ell.atomic;
                continue block0;
            }
        }
        if (ret.params != null && ret.params.composite != null && 0 < ret.params.composite.size()) {
            NamedValue nv = ret.params.composite.get(0);
            if ("\"id\"".equals(nv.name)) {
                ret.id = Integer.parseInt(nv.valueString());
            }
        }
        return ret;
    }

    private void writeClient(OutputStream client, String messageText) {
        if (this.webSocket != null) {
            try {
                this.webSocket.writeClient(client, messageText);
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        byte[] messageBytes = messageText.getBytes(UTF_8);
        String headerText = String.format("Content-Length: %d\r\n\r\n", messageBytes.length);
        byte[] headerBytes = headerText.getBytes(UTF_8);
        try {
            client.write(headerBytes);
            client.write(messageBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    String toJson(Object message) {
        if (message == null) {
            return null;
        }
        if (message instanceof String && ((String)message).startsWith("\"")) {
            return (String)message;
        }
        if (message instanceof String && ((String)message).startsWith("{")) {
            return (String)message;
        }
        if (message instanceof String && ((String)message).startsWith("[")) {
            return (String)message;
        }
        if (message instanceof String && "OK".equals(message)) {
            return "\"" + message + "\"";
        }
        if (message instanceof String && "null".equals(message)) {
            return null;
        }
        if (message instanceof Message) {
            return message.toString();
        }
        if (message instanceof Jsonable) {
            return ((Jsonable)message).toJson();
        }
        if (message instanceof Jsonable[]) {
            Jsonable[] array = (Jsonable[])message;
            StringBuilder ret = new StringBuilder("[");
            int pos = 0;
            for (Jsonable elem : array) {
                if (0 < pos++) {
                    ret.append(',');
                }
                ret.append(elem.toJson());
            }
            ret.append(']');
            return ret.toString();
        }
        if (message instanceof Throwable) {
            return "\"" + ((Throwable)message).getMessage() + "\"";
        }
        throw new AssertionError((Object)("VT: Unrecognized message: " + message));
    }

    void respond(OutputStream client, int requestId, Object params) {
        if (cancelResponce.equals(params)) {
            LOG.log(Level.INFO, "requestId = " + requestId + "   canceled");
            return;
        }
        if (params instanceof ResponseError) {
            throw new RuntimeException("Errors should be sent using LSP.error(...)");
        }
        String jsonText = this.toJson(params);
        String messageText = String.format("{\"jsonrpc\":\"2.0\",\"id\":%d,\"result\":%s}", requestId, jsonText);
        String log = messageText;
        if (1000 < log.length()) {
            log = log.substring(0, 1000) + "...";
        }
        System.out.println("sent to client>> " + log);
        this.writeClientSafely(client, messageText);
    }

    void error(OutputStream client, int requestId, ResponseError error) {
        this.notifyClient(client, "window/showMessage", error);
        this.respond(client, requestId, null);
    }

    protected int request(OutputStream client, String method, Object params) {
        String messageText;
        String log;
        String jsonText = this.toJson(params);
        if (1000 < (log = (messageText = String.format("{\"jsonrpc\":\"2.0\",\"id\":%d,\"method\":\"%s\",\"params\":%s}", this.requestId++, method, jsonText))).length()) {
            log = log.substring(0, 1000) + "...";
        }
        System.out.println("sent to client>> " + log);
        this.writeClientSafely(client, messageText);
        return this.requestId - 1;
    }

    public void notifyClient(OutputStream client, String method, Object params) {
        String jsonText = this.toJson(params);
        String messageText = String.format("{\"jsonrpc\":\"2.0\",\"method\":\"%s\",\"params\":%s}", method, jsonText);
        String log = messageText;
        if (1000 < log.length()) {
            log = log.substring(0, 1000) + "...";
        }
        System.out.println("sent to client>> " + log);
        this.writeClientSafely(client, messageText);
    }

    private void writeClientSafely(OutputStream client, String messageText) {
        long t1;
        block6: {
            t1 = System.currentTimeMillis();
            if (messageText.length() < 100000) {
                try {
                    List<LexerToken> src = LexerToken.parse(messageText);
                    Parsed target = new Parsed(messageText, src, JsonEarley.jsonParser(), "top");
                    if (target.getSyntaxError() != null) {
                        this.error(client, this.requestId, new ResponseError(-5, "Invalid JSON in responce", null));
                        break block6;
                    }
                    this.writeClient(client, messageText);
                }
                catch (IOException e) {
                    this.error(client, this.requestId, new ResponseError(-5, e.getMessage(), null));
                }
            } else {
                this.writeClient(client, messageText);
            }
        }
        long t2 = System.currentTimeMillis();
        if (t1 + 100L < t2) {
            System.err.println("JSON parse time = " + (t2 - t1));
        }
    }

    void connect(InputStream receive, OutputStream send) {
        LanguageServer server = this.initServer();
        this.connect(receive, send, server);
    }

    boolean hasPendingMethod(String method, int id) {
        for (Message m : this.pending) {
            if (m.id <= id || !method.equals(m.method)) continue;
            return true;
        }
        return false;
    }

    boolean hasCancelMethod(int id) {
        for (Message m : this.pending) {
            if (m.id != id || !"$/cancelRequest".equals(m.method)) continue;
            return true;
        }
        return false;
    }

    void connect(final InputStream receive, final OutputStream send, LanguageServer server) {
        this.pending = new ArrayBlockingQueue(10);
        final Message endOfStream = new Message();
        class MessageReader
        implements Runnable {
            MessageReader() {
            }

            void peek(Message message) {
                if ("$/cancelRequest".equals(message.method)) {
                    boolean removed;
                    if (-1 == message.id) {
                        message.id = -1;
                    }
                    if (removed = LSP.this.pending.removeIf(r -> r.id != -1 && r.id == message.id)) {
                        LOG.info(String.format("Cancelled request %d, which had not yet started", message.id));
                    } else {
                        LOG.info(String.format("Cannot cancel request %d because it has already started", message.id));
                    }
                } else if (message.result != null) {
                    // empty if block
                }
            }

            private boolean kill() {
                LOG.info("Read stream has been closed, putting kill message onto queue...");
                try {
                    LSP.this.pending.put(endOfStream);
                    return true;
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Failed to put kill message onto queue, will try again...", e);
                    return false;
                }
            }

            @Override
            public void run() {
                LOG.info("Placing incoming messages on queue...");
                block5: while (true) {
                    try {
                        while (true) {
                            String appliedValue;
                            String token;
                            if ("Connection: close" == (token = LSP.this.nextToken(receive)) && this.kill()) {
                                return;
                            }
                            if (token.startsWith("Sec-WebSocket-Key")) {
                                WebSocket.upgrade(token, send);
                                continue;
                            }
                            if (token.equals("pong")) {
                                LSP.this.webSocket.pong(send);
                                continue;
                            }
                            if (token.equals("ignore")) continue;
                            if (token.equals("ignorignoreAndPause")) {
                                try {
                                    Thread.sleep(50L);
                                    continue block5;
                                }
                                catch (InterruptedException interruptedException) {
                                    continue;
                                }
                            }
                            if (token.equals("closeFrame") && this.kill()) {
                                return;
                            }
                            Message message = LSP.this.parseMessage(token);
                            if (message.result != null && (appliedValue = message.result.valueString()).startsWith("{\"applied\"=")) {
                                LSP.this.applied.put(message.id, appliedValue.endsWith("true}"));
                            }
                            this.peek(message);
                            if (!message.isProcessable()) continue;
                            LSP.this.pending.put(message);
                        }
                    }
                    catch (EndOfStream e) {
                        if (!this.kill()) continue;
                        return;
                    }
                    catch (Throwable e) {
                        LOG.log(Level.SEVERE, e.getMessage(), e);
                        continue;
                    }
                    break;
                }
            }
        }
        Thread reader = new Thread((Runnable)new MessageReader(), "reader");
        reader.setDaemon(true);
        reader.start();
        LOG.info("Reading messages from queue...");
        boolean hasAsyncWork = false;
        while (true) {
            Message r = null;
            try {
                r = this.pending.poll(100L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            if (r == null) continue;
            if (r.equals(endOfStream)) {
                LOG.warning("Stream from client has been closed, exiting...");
                throw new RuntimeException("VT: exit");
            }
            if (r == null) {
                if (!hasAsyncWork) continue;
                server.doAsyncWork();
                hasAsyncWork = false;
                continue;
            }
            if (r.error != null) {
                LOG.log(Level.SEVERE, r.error);
                continue;
            }
            hasAsyncWork = true;
            try {
                PublishDiagnosticsParams diag;
                Object response;
                if (r.method.equals("initialize")) {
                    response = server.initialize(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("initialized")) {
                    server.initialized(send);
                    continue;
                }
                if (r.method.equals("shutdown")) {
                    LOG.warning("Got shutdown message");
                    this.respond(send, r.id, null);
                    continue;
                }
                if (r.method.equals("exit")) {
                    LOG.warning("Got exit message, exiting...");
                    break;
                }
                if (r.method.equals("workspace/didChangeWorkspaceFolders")) {
                    server.didChangeWorkspaceFolders(r.params);
                    continue;
                }
                if (r.method.equals("workspace/didChangeConfiguration")) {
                    server.didChangeConfiguration(r.params);
                    continue;
                }
                if (r.method.equals("workspace/didChangeWatchedFiles")) {
                    server.didChangeWatchedFiles(r.params);
                    continue;
                }
                if (r.method.equals("workspace/symbol")) {
                    response = server.workspaceSymbols(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/documentLink")) {
                    response = server.documentLink(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/didOpen")) {
                    diag = server.didOpenTextDocument(r.params, send);
                    this.notifyClient(send, "textDocument/publishDiagnostics", diag);
                    continue;
                }
                if (r.method.equals("textDocument/didChange")) {
                    diag = server.didChangeTextDocument(r.params);
                    this.notifyClient(send, "textDocument/publishDiagnostics", diag);
                    continue;
                }
                if (r.method.equals("textDocument/willSave")) {
                    server.willSaveTextDocument(r.params);
                    continue;
                }
                if (r.method.equals("textDocument/willSaveWaitUntil")) {
                    response = server.willSaveWaitUntilTextDocument(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/didSave")) {
                    server.didSaveTextDocument(r.params);
                    continue;
                }
                if (r.method.equals("textDocument/didClose")) {
                    server.didCloseTextDocument(r.params);
                    continue;
                }
                if (r.method.equals("textDocument/completion")) {
                    response = server.completion(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("completionItem/resolve")) {
                    response = server.resolveCompletionItem(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/hover")) {
                    response = server.hover(r.id, r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/signatureHelp")) {
                    response = server.signatureHelp(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/definition")) {
                    response = server.gotoDefinition(r.params, send);
                    if (response instanceof ResponseError) {
                        this.error(send, r.id, (ResponseError)response);
                        continue;
                    }
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/references")) {
                    response = server.findReferences(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/documentSymbol")) {
                    response = server.documentSymbol(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/codeAction")) {
                    response = server.codeAction(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/codeLens")) {
                    response = server.codeLens(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("codeLens/resolve")) {
                    response = server.resolveCodeLens(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/prepareRename")) {
                    response = server.prepareRename(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/rename")) {
                    response = server.rename(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/formatting")) {
                    response = server.formatting(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/foldingRange")) {
                    response = server.foldingRange(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/colorPresentation")) {
                    response = server.colorPresentation(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/documentColor")) {
                    response = server.documentColor(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/semanticTokens/full")) {
                    response = server.semanticTokensFull(r.params);
                    this.respond(send, r.id, response);
                    continue;
                }
                if (r.method.equals("workspace/executeCommand")) {
                    response = server.executeCommand(r.params, send);
                    if (response == null) {
                        this.respond(send, r.id, "OK");
                        continue;
                    }
                    if (response instanceof ResponseError) {
                        this.error(send, r.id, (ResponseError)response);
                        continue;
                    }
                    if (response instanceof String && "OK".equals(response)) {
                        this.respond(send, r.id, "OK");
                        continue;
                    }
                    LOG.severe(String.format("Unexpected class `%s`", response.getClass()));
                    continue;
                }
                if (r.method.equals("$/cancelRequest")) {
                    LOG.warning("$/cancelRequest r.id=" + r.id);
                    continue;
                }
                LOG.warning(String.format("Unrecognized method `%s`", r.method));
                this.error(send, r.id, new ResponseError(-32002, "Unrecognized method " + r.method, null));
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                if (r.id == -1) continue;
                this.error(send, r.id, new ResponseError(-32603, e.getMessage(), null));
            }
        }
    }

    protected LanguageServer initServer() {
        LanguageServer server = new LanguageServer(this);
        return server;
    }

    public void createDirectory(OutputStream send, String url) {
        String tmpFileName = "(tmp)";
        int rid = this.request(send, "workspace/applyEdit", "{\"edit\": {\"documentChanges\":[{\"kind\":\"create\",\"uri\":\"" + url + "/" + "(tmp)" + "\"}]}}");
        if (!this.messageApplied(rid)) {
            LOG.severe("Failed to create " + url + "/" + "(tmp)");
            return;
        }
        rid = this.request(send, "workspace/applyEdit", "{\"edit\": {\"documentChanges\":[{\"kind\":\"delete\",\"uri\":\"" + url + "/" + "(tmp)" + "\"}]}}");
        if (!this.messageApplied(rid)) {
            LOG.severe("Failed to delete " + url + "/" + "(tmp)");
            return;
        }
    }

    public int createFile(OutputStream send, String url, String content) {
        return this.createFile(send, url, content, true);
    }

    public int createFile(OutputStream send, String uri, String content, boolean overwrite) {
        int rid = this.request(send, "workspace/applyEdit", "{\"edit\": {\"documentChanges\":[{\"kind\":\"create\",\"uri\":\"" + uri + "\"}]}}");
        if (!this.messageApplied(rid)) {
            LOG.severe("Failed to create " + uri);
            return -1;
        }
        if (this.fileExists(rid) && !overwrite) {
            return -1;
        }
        rid = this.documentInsert(fullRange, send, uri, content);
        return rid;
    }

    public int documentInsert(Range pos, OutputStream send, String uri, String content) {
        return this.request(send, "workspace/applyEdit", "{\"edit\": {\"documentChanges\":[{\"textDocument\":{\"uri\":\"" + uri + "\",\"version\":null},\"edits\":[{\"range\":" + pos.toJson() + ",\"newText\":\"" + Util.sugarcoatText(content) + "\"}]}]}}");
    }

    public void documentInsert(Range pos1, Range pos2, OutputStream send, String uri, String content1, String content2) {
        this.request(send, "workspace/applyEdit", "{\"edit\": {\"documentChanges\":[{\"textDocument\":{\"uri\":\"" + uri + "\",\"version\":null},\"edits\":[{\"range\":" + pos1.toJson() + ",\"newText\":\"" + Util.sugarcoatText(content1) + "\"},{\"range\":" + pos2.toJson() + ",\"newText\":\"" + Util.sugarcoatText(content2) + "\"}]}]}}");
    }

    void documentBump(OutputStream send, String uri, BackgroundParser parser) {
        int line = parser.charPos2LineNo1(parser.text.length() - 1);
        int lineStart = parser.lineNo2CharPos1(line);
        Position start = new Position(line - 1, parser.text.length() - 1 - lineStart);
        Position end = new Position(line - 1, parser.text.length() - lineStart);
        Range range = null;
        String bump = "\t";
        if (parser.text.endsWith(bump)) {
            range = new Range(start, end);
            bump = "";
        } else {
            range = new Range(new Position(line, 0), new Position(line, 0));
        }
        this.request(send, "workspace/applyEdit", "{\"edit\": {\"documentChanges\":[{\"textDocument\":{\"uri\":" + uri + ",\"version\": null},\"edits\":[{\"range\":" + range.toJson() + ",\"newText\":\"" + Util.sugarcoatText(bump) + "\"}]}]}}");
    }

    private boolean messageApplied(int rid) {
        for (int i = 0; i < 20; ++i) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.applied.containsKey(rid)) continue;
            return true;
        }
        return false;
    }

    private boolean fileExists(int rid) {
        return this.applied.get(rid) == false;
    }

    public static void main(String[] args) throws Exception {
        String input = null;
        if (1 == args.length) {
            input = args[0];
        }
        if (input != null) {
            port = Integer.parseInt(input);
        }
        ServerSocket socket = new ServerSocket(port);
        while (true) {
            try {
                while (true) {
                    System.out.println("Listening port# " + port);
                    Socket connection = socket.accept();
                    new LSP().connect(connection.getInputStream(), connection.getOutputStream());
                }
            }
            catch (Throwable tri) {
                System.err.println("Error handling request: " + tri.getMessage());
                continue;
            }
            break;
        }
    }

    private class RealClient {
        OutputStream send;

        RealClient(OutputStream send) {
            this.send = send;
        }
    }

    static class EndOfStream
    extends RuntimeException {
        EndOfStream() {
        }
    }
}

