/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp;

import java.sql.Connection;
import java.sql.ResultSet;
import oracle.dbtools.lsp.CsvRenderer;
import oracle.dbtools.lsp.HtmlRenderer;
import oracle.dbtools.lsp.InsertRenderer;
import oracle.dbtools.lsp.JsonRenderer;

public abstract class GridRenderer {
    public boolean isSilent = false;

    public abstract String render(ResultSet var1, Connection var2) throws Exception;

    public static GridRenderer factory(String type) {
        if ("html".equalsIgnoreCase(type) || "xml".equalsIgnoreCase(type)) {
            return new HtmlRenderer();
        }
        if ("csv".equalsIgnoreCase(type)) {
            return new CsvRenderer();
        }
        if ("json".equalsIgnoreCase(type)) {
            return new JsonRenderer();
        }
        if ("insert".equalsIgnoreCase(type)) {
            return new InsertRenderer();
        }
        throw new AssertionError((Object)("VT: mismatching type: " + type));
    }
}

