/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.dictionary.Catalog;
import oracle.dbtools.lsp.dictionary.Registry;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;

class BackgroundArboriParser
extends BackgroundParser {
    public BackgroundArboriParser(String input, String url, LanguageServer languageServer) throws IOException {
        super(input, Program.getArboriParser(), "program", url, languageServer);
        this.initRegistry(new Catalog(this));
        this.lateInit();
    }

    @Override
    public String label(ParseNode node) {
        String label = ((LexerToken)this.src.get((int)node.from)).content;
        if (node.contains("statement")) {
            return label;
        }
        return null;
    }

    @Override
    public String semanticActionsFile() {
        return "arboriCodeLens.arbori";
    }

    @Override
    public Set<String> getOpenConnections() {
        HashSet<String> ret = new HashSet<String>();
        for (BackgroundParser parser : this.languageServer.parsers.values()) {
            String candidate;
            Registry registry = parser.getRegistry();
            if (!(registry.getConnection() instanceof BackgroundParser) || (candidate = registry.getConnString()) == null || ret.contains(candidate)) continue;
            ret.add(candidate);
        }
        return ret;
    }

    @Override
    public boolean isAlive(String connStr) {
        List<LexerToken> src = LexerToken.parse(connStr);
        try {
            String filename = src.get((int)1).content;
            Object connection = this.languageServer.getConnection(filename);
            return connection != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

