/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc.wallet;

import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.jdbc.DataSourceBuilder;
import oracle.dbtools.jdbc.DataSourceConfigurator;

public class TNSEntry
implements DataSourceConfigurator {
    private static final String ORACLE_JDBC_THIN_CONNECTION_DESCRIPTOR_PREFIX = "jdbc:oracle:thin:@";
    private final String connectionDescriptor;
    private final URI httpsProxy;

    public TNSEntry(String connectionDescriptor, URI httpsProxy) {
        this.connectionDescriptor = connectionDescriptor;
        this.httpsProxy = httpsProxy;
    }

    @Override
    public void configure(DataSourceBuilder<?> dataSourceBuilder) throws SQLException, IOException {
        StringBuilder url = new StringBuilder();
        url.append(ORACLE_JDBC_THIN_CONNECTION_DESCRIPTOR_PREFIX);
        url.append(this.connectionDescriptor);
        dataSourceBuilder.url(url);
        if (this.httpsProxy != null) {
            String host = this.httpsProxy.getHost();
            int port = this.httpsProxy.getPort();
            Properties props = new Properties();
            props.put("oracle.net.httpsProxyHost", host);
            props.put("oracle.net.httpsProxyPort", Integer.toString(port));
            dataSourceBuilder.connectionProperties(props);
        }
    }

    DataSourceConfigurator withHttpsProxy(URI httpsProxy) {
        return new TNSEntry(this.connectionDescriptor, httpsProxy);
    }

    public String getConnectionDescriptor() {
        return this.connectionDescriptor;
    }

    public URI getHttpsProxy() {
        return this.httpsProxy;
    }
}

