/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc.wallet;

import oracle.dbtools.jdbc.DataSourceBuilder;
import oracle.dbtools.jdbc.DataSourceConfigurator;
import oracle.dbtools.jdbc.wallet.WalletException;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;

class ServiceCredentials
implements DataSourceConfigurator {
    private static final String ORACLE_THIN_JDBC_PREFIX = "jdbc:oracle:thin:";
    private static final String PASSWORD = "oracle.security.client.password";
    private static final String SERVICE_NAME_SYNTAX_PREFIX = "@//";
    private static final String USER = "oracle.security.client.username";
    private final int index;
    private final transient OracleSecretStore store;

    ServiceCredentials(OracleSecretStore store, int index) {
        this.store = store;
        this.index = index;
    }

    @Override
    public void configure(DataSourceBuilder<?> dataSourceBuilder) throws WalletException {
        String serviceAlias = new String(this.secret("oracle.security.client.connect_string"));
        if (serviceAlias.startsWith(SERVICE_NAME_SYNTAX_PREFIX)) {
            StringBuilder url = new StringBuilder();
            url.append(ORACLE_THIN_JDBC_PREFIX);
            url.append(serviceAlias);
            dataSourceBuilder.url(url.toString());
        }
        String user = this.user();
        char[] password = this.password();
        if (user != null || password != null) {
            dataSourceBuilder.user(user);
            dataSourceBuilder.password(password != null ? new String(this.password()) : null);
        }
    }

    char[] password() throws WalletException {
        return this.secret(PASSWORD);
    }

    private char[] secret(String prefix) throws WalletException {
        try {
            return this.store.getSecret(prefix + this.index);
        }
        catch (OracleSecretStoreException e) {
            throw WalletException.from(e);
        }
    }

    String user() throws WalletException {
        return new String(this.secret(USER));
    }
}

