/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.Messages;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;

public class ThirdPartyUtil
extends DBUtil {
    private static QueryXMLSupport s_xml;

    private static synchronized QueryXMLSupport getXMLQueries() {
        if (s_xml == null) {
            s_xml = QueryXMLSupport.getQueryXMLSupport(new MetaResource(ThirdPartyUtil.class.getClassLoader(), "oracle/dbtools/db/dbutilsql.xml"));
        }
        return s_xml;
    }

    protected ThirdPartyUtil(ConnectionIdentifier id) {
        super(id);
    }

    @Override
    public void setDBAction(String action) {
        Query q = ThirdPartyUtil.getXMLQueries().getQuery("ACTION", this.m_conn);
        this.execute(q.getSql(), Collections.singletonList(action == null ? "" : action));
    }

    @Override
    public void setDBModuleAction(String action) {
        Query q = ThirdPartyUtil.getXMLQueries().getQuery("MODULE", this.m_conn);
        this.execute(q.getSql(), Arrays.asList(s_prodName, action == null ? "" : action));
    }

    @Override
    public String getDBMSOUTPUT() {
        return "";
    }

    @Override
    public int getErrorOffset(final String sql) {
        DBUtil.OperImpl<Integer> oper = new DBUtil.OperImpl<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws SQLException {
                Statement stmt = null;
                try {
                    Query q = ThirdPartyUtil.getXMLQueries().getQuery("ERR_SQL", ThirdPartyUtil.this.m_conn);
                    stmt = ThirdPartyUtil.this.m_conn.prepareCall(q.getSql());
                    DBUtil.LOGGER.info(Messages.getString("DBUtil.55") + q.getSql());
                    stmt.setString(1, sql);
                    stmt.setString(2, sql);
                    stmt.registerOutParameter(3, 4);
                    stmt.execute();
                    Integer n = stmt.getInt(3);
                    return n;
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        };
        return this.lockForOperation(oper, 0);
    }

    @Override
    protected boolean hasTransaction() {
        DBUtil.OperImpl<Boolean> oper = new DBUtil.OperImpl<Boolean>(){

            @Override
            public Boolean call() throws SQLException {
                if (ThirdPartyUtil.this.m_conn == null || ThirdPartyUtil.this.m_conn.isClosed()) {
                    return false;
                }
                Query q = ThirdPartyUtil.getXMLQueries().getQuery("TRANSACTION", ThirdPartyUtil.this.m_conn);
                String ret = ThirdPartyUtil.this.executeOracleReturnOneCol(q.getSql(), Collections.EMPTY_MAP);
                return ModelUtil.hasLength(ret);
            }
        };
        return this.lockForOperation(oper, Boolean.FALSE);
    }

    @Override
    protected boolean isOracleConnectionAlive() {
        return false;
    }

    @Override
    public String addDbQuotes(String value, boolean force) {
        char quoteChar = this.getQuoteCharacter();
        if (force) {
            return value.indexOf(quoteChar) >= 0 ? value : quoteChar + value + quoteChar;
        }
        return value;
    }
}

