/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.MessageLogging;

final class ResultSetHolder {
    private static final String MSG = "Unclosed ResultSetWrapper: {0}.{1} ({2}) called by {3}.{4} ({5})";
    private static final Logger s_logger = Logger.getLogger(ResultSetHolder.class.getName());
    private final UnclosedWrapperException m_ex;
    private final long m_created = System.currentTimeMillis();
    private final ResultSet m_rs;
    private final Statement m_stmt;

    ResultSetHolder(ResultSet rs, Statement stmt) {
        this.m_rs = rs;
        this.m_stmt = stmt;
        this.m_ex = DBUtil.DEBUG_BUILD ? new UnclosedWrapperException() : null;
    }

    ResultSet getResultSet() {
        return this.m_rs;
    }

    void logStack(boolean dumpStack) {
        if (this.m_ex != null) {
            StackTraceElement[] stack = this.m_ex.getStackTrace();
            for (int idx = 2; idx < stack.length; ++idx) {
                StackTraceElement callee = stack[idx - 1];
                StackTraceElement caller = stack[idx];
                String name = caller.getClassName();
                if (name.startsWith(DBUtil.class.getName())) continue;
                Object[] fmtArgs = new Object[]{callee.getClassName(), callee.getMethodName(), callee.getLineNumber(), caller.getClassName(), caller.getMethodName(), caller.getLineNumber()};
                s_logger.log(Level.SEVERE, MSG, fmtArgs);
                if (!dumpStack) break;
                MessageLogging.getInstance().reportAPIException(MessageFormat.format(MSG, fmtArgs), this.m_ex, callee.getMethodName());
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        ResultSet rs = null;
        Statement stmt = null;
        ResultSetHolder resultSetHolder = this;
        synchronized (resultSetHolder) {
            rs = this.m_rs;
            stmt = this.m_stmt;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class UnclosedWrapperException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private UnclosedWrapperException() {
        }
    }
}

