/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.db.ConnectionResolver;

public class ChameleonConnection {
    private static Map<String, Connection> connCache = new HashMap<String, Connection>();

    public static boolean isTestConnection() {
        return 0 < connCache.size();
    }

    public static Connection getConnection(String connectionName) throws Exception, ClassNotFoundException, SQLException {
        Connection conn;
        if (!connectionName.startsWith("jdbc:oracle:thin:@")) {
            conn = ConnectionResolver.getConnection(connectionName);
            if (conn == null) {
                throw new SQLException("Failed to obtain database connection");
            }
        } else {
            StringTokenizer st = new StringTokenizer(connectionName, ",");
            String url = st.nextToken();
            String user = st.nextToken();
            if (!connCache.containsKey(url + "," + user)) {
                String pwd = st.nextToken();
                Class.forName("oracle.jdbc.OracleDriver");
                conn = DriverManager.getConnection(url, user, pwd);
                connCache.put(url + "," + user, conn);
            } else {
                conn = connCache.get(url + "," + user);
            }
        }
        return conn;
    }

    public static void clearCache() {
        connCache = new HashMap<String, Connection>();
    }
}

