/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.config;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.common.config.IStorage;

public interface ICommonConfig {

    public static class Storage
    implements IStorage {
        private static IStorage INSTANCE = new Storage();
        private static IStorage storage;

        private Storage() {
        }

        public static IStorage getInstance() {
            return INSTANCE;
        }

        public static void setBackingStorage(IStorage theStorage) {
            storage = theStorage;
        }

        @Override
        public String getString(String key) {
            String retVal = null;
            if (storage != null && storage.contains(key)) {
                retVal = storage.getString(key);
            }
            if (null == retVal) {
                retVal = Defaults.getString(key);
            }
            return retVal;
        }

        @Override
        public void putString(String key, String value) {
            if (storage == null) {
                throw new IllegalAccessError("No IStorage implementation set. Cannot put values");
            }
            storage.putString(key, value);
        }

        @Override
        public int getInt(String key) {
            int retVal = 0;
            if (storage != null && storage.contains(key)) {
                retVal = storage.getInt(key);
            }
            if (0 == retVal) {
                retVal = Defaults.getInteger(key);
            }
            return retVal;
        }

        @Override
        public void putInt(String key, int value) {
            if (storage == null) {
                throw new IllegalAccessError("No IStorage implementation set. Cannot put values");
            }
            storage.putInt(key, value);
        }

        @Override
        public Boolean getBoolean(String key) {
            Boolean retVal = null;
            if (storage != null && storage.contains(key)) {
                retVal = storage.getBoolean(key);
            }
            if (null == retVal) {
                retVal = Defaults.getBoolean(key);
            }
            return retVal;
        }

        @Override
        public void putBoolean(String key, boolean value) {
            if (storage == null) {
                throw new IllegalAccessError("No IStorage implementation set. Cannot put values");
            }
            storage.putBoolean(key, value);
        }
    }

    public static class Defaults {
        private static final HashMap<String, Object> s_defaults = new HashMap();

        public static Map<String, Object> get() {
            return (Map)s_defaults.clone();
        }

        public static void put(String key, Object value) {
            Defaults.put(key, value, false);
        }

        public static void put(String key, Object value, Boolean override) {
            if (s_defaults.containsKey(key)) {
                throw new IllegalStateException(String.format("Duplicate key %s", key));
            }
            s_defaults.put(key, value);
        }

        public static Object get(String parm) {
            return s_defaults.get(parm);
        }

        static String getString(String parm) {
            Object obj = s_defaults.get(parm);
            return obj instanceof String ? (String)obj : (obj != null ? obj.toString() : null);
        }

        static Integer getInteger(String parm) {
            Object obj = s_defaults.get(parm);
            return obj instanceof Integer ? (Integer)obj : (obj != null ? Integer.valueOf(Integer.parseInt(obj.toString())) : null);
        }

        static boolean getBoolean(String parm) {
            Object obj = s_defaults.get(parm);
            return obj instanceof Boolean ? (Boolean)obj : (obj != null ? Boolean.parseBoolean(obj.toString()) : false);
        }

        static Object getObject(String parm) {
            return s_defaults.get(parm);
        }
    }
}

