/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import oracle.dbtools.arbori.GlobalMap;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class SqlProgram
extends Program {
    public SqlProgram(Class<?> dir, String file) throws IOException {
        this(dir, file, null);
    }

    public SqlProgram(Class<?> dir, String file, Object struct) throws IOException {
        this(Service.readFile(dir, file), struct);
    }

    public SqlProgram(String programText) throws IOException {
        this(programText, null);
    }

    public SqlProgram(String programText, Object struct) throws IOException {
        super(SqlEarley.getInstance(), struct);
        this.compile(programText, struct);
    }

    public SqlProgram(String programText, Object struct, ScriptEngine engine, GlobalMap globals, boolean allowJS) throws IOException {
        super(SqlEarley.getInstance(), struct, engine, globals, allowJS);
        this.compile(programText, struct);
    }

    public Map<String, MaterializedPredicate> run(String input, List<LexerToken> src, Object callback) throws IOException {
        return this.run(input, src, null, callback);
    }

    public Map<String, MaterializedPredicate> run(String input, List<LexerToken> src, String[] rootSyntax, Object callback) throws IOException {
        return this.run(input, src, rootSyntax, callback, SqlEarley.getInstance());
    }

    public Map<String, MaterializedPredicate> run(String input, List<LexerToken> src, String[] rootSyntax, Object callback, Earley parser) throws IOException {
        if (src == null) {
            src = Lexer.parse(input);
        }
        Parsed target = new Parsed(input, src, parser, rootSyntax);
        Map<String, MaterializedPredicate> predicateVectors = this.eval(target, callback);
        return predicateVectors;
    }

    public Map<String, MaterializedPredicate> run(String input, List<LexerToken> src) throws IOException {
        return this.run(input, src, null);
    }

    public Map<String, MaterializedPredicate> run(String input, Object callback) throws IOException {
        return this.run(input, null, callback);
    }

    public Map<String, MaterializedPredicate> run(String input) throws IOException {
        return this.run(input, null, null);
    }

    public static void main(String[] args) throws IOException {
        String input = "{\r\n   print('--------------------->');\r\n   var array1 = ['a', 'b', 'c'];\r\n   array1.forEach( function(item, index, array) {\r\n         print(item+'['+index+']');\r\n   });\r\n}\r\n";
        Earley arboriParser = SqlProgram.getArboriParser();
        boolean T = true;
        boolean F = false;
        arboriParser.printOrderedRules("predicate", true, true);
        Parsed prg = new Parsed(input, arboriParser, "program");
        prg.debug = true;
        prg.getRoot().printTree();
    }
}

