/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.arbori.AncestorDescendantNodes;
import oracle.dbtools.arbori.AncestorExpr;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.AttributeDefinitions;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.True;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.util.Service;

public class IndependentAttribute
extends Attribute {
    protected MaterializedPredicate content;
    private Predicate failfastFilter = null;

    public IndependentAttribute(String name) {
        this.name = name;
    }

    public MaterializedPredicate getContent() {
        return this.content;
    }

    public void initContent(ParseNode root, List<LexerToken> src, AttributeDefinitions varDefs, String predVar) {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(this.name);
        for (String candidate : varDefs.keySet()) {
            Attribute attr = (Attribute)varDefs.get(candidate);
            if (attr == null) {
                attr = null;
            }
            if (attributes.contains(candidate) || !attr.isDependent(this.name, varDefs)) continue;
            attributes.add(candidate);
        }
        MaterializedPredicate newContent = new MaterializedPredicate(attributes, src, null);
        Predicate fullPredicate = varDefs.namedPredicates.get(predVar);
        if (this.content == null) {
            for (ParseNode node = root; node != null; node = node.next()) {
                HashMap<String, ParseNode> t = new HashMap<String, ParseNode>();
                t.put(this.name, node);
                newContent.tuples.addAll(this.addTuples(root, src, varDefs, predVar, attributes, fullPredicate, t, newContent));
            }
        } else {
            for (Tuple tuple : this.content.tuples) {
                HashMap<String, ParseNode> t = new HashMap<String, ParseNode>();
                String prefix = "";
                int pos = this.content.name.indexOf("->");
                if (0 < pos) {
                    prefix = this.content.name.substring(0, pos) + '.';
                }
                for (String a : this.content.attributes) {
                    t.put(prefix + a, this.content.getAttribute(tuple, a));
                }
                newContent.tuples.addAll(this.addTuples(root, src, varDefs, predVar, attributes, fullPredicate, t, newContent));
            }
        }
        newContent.tuples = this.filterClosestAncestorDescendants(varDefs, predVar, newContent.attributePositions, newContent.tuples, root, src);
        this.content = newContent;
    }

    private Set<Tuple> addTuples(ParseNode root, List<LexerToken> src, AttributeDefinitions varDefs, String predVar, ArrayList<String> attributes, Predicate fullPredicate, Map<String, ParseNode> cells, MaterializedPredicate newContent) {
        Set<Tuple> candidates = new TreeSet<Tuple>();
        ParseNode[] t = new ParseNode[newContent.arity()];
        candidates.add(new Tuple(t));
        for (String attr : cells.keySet()) {
            Integer pos = newContent.getAttribute(attr);
            if (pos == null) {
                int p = this.name.indexOf("->");
                pos = newContent.getAttribute(this.name.substring(0, p) + '.' + attr);
            }
            if (pos == null) continue;
            t[pos.intValue()] = cells.get(attr);
            if (t[pos.intValue()].from == 20 && t[pos.intValue()].to == 23) {
                t[pos.intValue()].from = 20;
            }
            if (IndependentAttribute.unaryFilter(fullPredicate, attr).eval(newContent.attributePositions, t, src, varDefs)) continue;
            return new TreeSet<Tuple>();
        }
        for (String attr : attributes) {
            candidates = newContent.assignDependencyChain(attr, candidates, varDefs, root);
            if (candidates.size() != 0) continue;
            return new TreeSet<Tuple>();
        }
        return this.filterUnaryPredicates(varDefs, predVar, newContent.attributePositions, candidates, root, src);
    }

    int getLimits() {
        return this.content.cardinality();
    }

    void putFilter(Predicate filter) {
        this.failfastFilter = filter;
    }

    protected Set<Tuple> filterClosestAncestorDescendants(Map<String, Attribute> varDefs, String predVar, Map<String, Integer> attributePositions, Set<Tuple> candidates, ParseNode root, List<LexerToken> src) {
        if (candidates.size() < 2) {
            return candidates;
        }
        int iDesc = -1;
        int iAnc = -1;
        AncestorExpr prior = null;
        for (String a : varDefs.keySet()) {
            Attribute attr = varDefs.get(a);
            if (!(attr instanceof AncestorExpr)) continue;
            AncestorExpr ancExpr = (AncestorExpr)attr;
            if (ancExpr.type != AncestorDescendantNodes.Type.CLOSEST || !attr.isDependent(this.name, varDefs)) continue;
            if (prior == null) {
                iDesc = attributePositions.get(ancExpr.def);
                iAnc = attributePositions.get(ancExpr.name);
                prior = ancExpr;
                continue;
            }
            if (prior.name.equals(ancExpr.def)) {
                iAnc = attributePositions.get(ancExpr.name);
                break;
            }
            if (!prior.def.equals(ancExpr.name)) break;
            iDesc = attributePositions.get(ancExpr.def);
            break;
        }
        if (iDesc != -1 && iAnc != -1) {
            candidates = this.filterNested(candidates, iAnc, iDesc, iDesc);
            candidates = this.filterNested(candidates, iDesc, iAnc, iDesc);
        }
        return candidates;
    }

    private Set<Tuple> filterNested(Set<Tuple> candidates, int colA, int colB, int colC) {
        HashMap map = new HashMap();
        for (Tuple t : candidates) {
            ParseNode anc = t.values[colA];
            long pos = Service.lPair(anc.from, anc.to);
            TreeSet<Tuple> tuples = (TreeSet<Tuple>)map.get(pos);
            if (tuples == null) {
                tuples = new TreeSet<Tuple>();
                tuples.add(t);
                map.put(pos, tuples);
                continue;
            }
            ParseNode desc = t.values[colB];
            TreeSet<Tuple> delete = new TreeSet<Tuple>();
            for (Tuple tuple : tuples) {
                ParseNode desc2 = tuple.values[colC];
                if (desc2 == desc) continue;
                if (desc.from <= desc2.from && desc2.to <= desc.to) {
                    delete.add(tuple);
                }
                if (desc2.from > desc.from || desc.to > desc2.to) continue;
                delete = null;
                t = null;
                break;
            }
            if (t != null) {
                tuples.add(t);
            }
            if (delete == null) continue;
            tuples.removeAll(delete);
        }
        TreeSet<Tuple> ret = new TreeSet<Tuple>();
        for (Set ts : map.values()) {
            ret.addAll(ts);
        }
        return ret;
    }

    protected Set<Tuple> filterUnaryPredicates(AttributeDefinitions varDefs, String predVar, Map<String, Integer> attributePositions, Set<Tuple> candidates, ParseNode root, List<LexerToken> src) {
        if (this.failfastFilter == null) {
            Predicate fullPredicate = varDefs.namedPredicates.get(predVar);
            this.failfastFilter = this.unaryFilter(varDefs, fullPredicate);
        }
        TreeSet<Tuple> ret = new TreeSet<Tuple>();
        for (Tuple t : candidates) {
            if (!this.failfastFilter.eval(attributePositions, t.values, src, varDefs)) continue;
            ret.add(t);
        }
        return ret;
    }

    private Predicate unaryFilter(Map<String, Attribute> varDefs, Predicate fullPredicate) {
        LinkedList<Predicate> tmp = new LinkedList<Predicate>();
        for (String s : varDefs.keySet()) {
            Attribute attr = varDefs.get(s);
            if (!attr.isDependent(this.name, varDefs)) continue;
            tmp.add(IndependentAttribute.unaryFilter(fullPredicate, attr.name));
        }
        Predicate ret = new True();
        for (Predicate extra : tmp) {
            ret = this.appendProposition(extra, ret);
        }
        return ret;
    }

    @Override
    Set<Tuple> eval(Map<String, Integer> attributePositions, Set<Tuple> candidates, ParseNode root) {
        throw new AssertionError((Object)"or should just return candidates?");
    }

    @Override
    Attribute referredTo(Map<String, Attribute> varDefs) {
        return null;
    }

    @Override
    ParseNode lookup(Map<String, Integer> attributePositions, ParseNode[] tuple, Map<String, Attribute> varDefs) {
        Integer pos = attributePositions.get(this.name);
        if (pos == null) {
            throw new AssertionError((Object)("Missing column " + this.name));
        }
        return tuple[pos];
    }
}

