/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.IdentedPredicate;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;

class ChildNumRelation
extends IdentedPredicate {
    int size;
    String nodeVar;
    Program prog;
    boolean isReflexive;
    boolean isGT;

    public ChildNumRelation(int size, String node, boolean isReflexive, boolean isGT, Program prog) {
        this.size = size;
        this.nodeVar = node;
        this.isReflexive = isReflexive;
        this.isGT = isGT;
    }

    @Override
    public boolean eval(Map<String, Integer> attributePositions, ParseNode[] tuple, List<LexerToken> src, Map<String, Attribute> varDefs) {
        ParseNode n = this.getNode(this.nodeVar, attributePositions, tuple, varDefs);
        if (this.isReflexive && this.isGT) {
            return this.size <= n.children().size();
        }
        if (this.isReflexive && !this.isGT) {
            return this.size == n.children().size();
        }
        if (!this.isReflexive && this.isGT) {
            return this.size < n.children().size();
        }
        throw new AssertionError((Object)"!isReflexive && !isGT");
    }

    public String toString() {
        return this.size + " <" + (this.isReflexive ? "=" : "") + " #" + this.nodeVar;
    }

    @Override
    public void variables(Set<String> ret, boolean optimizeEqs) {
        ChildNumRelation.variables(this.nodeVar, ret);
    }

    @Override
    public void signature(Set<String> ret) {
        this.variables(ret, false);
    }

    @Override
    public Predicate isRelated(String var1, String var2, Map<String, Attribute> varDefs) {
        return null;
    }

    @Override
    public Map<String, Boolean> dependencies() {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        int pos = this.nodeVar.indexOf(46);
        if (0 < pos) {
            ret.put(this.nodeVar.substring(0, pos), true);
        }
        return ret;
    }
}

