/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import oracle.dbtools.app.injection.FlowFunc;
import oracle.dbtools.app.injection.Loc;
import oracle.dbtools.app.injection.PlsqlType;
import oracle.dbtools.app.injection.SqlInjectionGraph;
import oracle.dbtools.app.injection.Symbol;

class Usage {
    private static final boolean SAVEALL = false;
    static List<Usage> saveAll = null;
    private static final boolean PRINTCREATED = false;
    private static int idSequence = 0;
    private final int id = ++idSequence;
    private final Symbol symbol;
    private final Object label;
    private final Loc loc;
    private final List<Usage> sources;
    private final List<Usage> flows;
    private final List<FlowFunc.FlowFuncLink> funcLinks;
    private boolean safe;
    private boolean functionOutput;

    Usage(Symbol symbol, Loc loc, Object label) {
        this.symbol = symbol;
        this.label = label;
        this.sources = new ArrayList<Usage>();
        this.flows = new ArrayList<Usage>();
        this.funcLinks = new ArrayList<FlowFunc.FlowFuncLink>();
        this.loc = loc;
    }

    Usage(Usage usage, Loc loc, Object label) {
        this(usage.symbol, loc, label);
    }

    Usage(Usage u1, Object label) {
        this.symbol = u1.symbol;
        this.label = label;
        this.loc = u1.loc;
        this.safe = u1.safe;
        this.sources = new ArrayList<Usage>(u1.sources.size());
        for (Usage u : u1.sources) {
            this.sources.add(u);
        }
        this.flows = new ArrayList<Usage>(u1.flows.size());
        for (Usage u : u1.flows) {
            this.flows.add(u);
        }
        this.funcLinks = new ArrayList<FlowFunc.FlowFuncLink>(u1.funcLinks.size());
        for (FlowFunc.FlowFuncLink fl : u1.funcLinks) {
            this.funcLinks.add(fl);
        }
    }

    void from(Usage u) {
        if (!(u == this || this.sources.size() > 0 && this.sources.get(this.sources.size() - 1) == u || u.flows.size() > 0 && u.flows.get(u.flows.size() - 1) == this)) {
            this.sources.add(u);
            u.flows.add(this);
        }
    }

    boolean functionOutput() {
        return this.functionOutput;
    }

    void setFunctionOutput(boolean value) {
        this.functionOutput = value;
    }

    boolean isSafe() {
        return this.safe;
    }

    void setSafe(boolean safe) {
        this.safe = safe;
    }

    String getName() {
        return this.symbol.name;
    }

    List<Usage> getSources() {
        return this.sources;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public Object getLabel() {
        return this.label;
    }

    List<Usage> getFlows() {
        return this.flows;
    }

    List<FlowFunc.FlowFuncLink> getFuncLinks() {
        return this.funcLinks;
    }

    public PlsqlType getType() {
        return this.symbol.getType();
    }

    public Loc getLoc() {
        return this.loc;
    }

    public int getId() {
        return this.id;
    }

    static void dumpSaveAll(Function<Usage, String> formatter, String label, List<Usage> ... lists) {
        if (label == null) {
            label = "";
        }
        if (SqlInjectionGraph.Debug.DUMP_USAGES.debug) {
            try (PrintStream printStream = new PrintStream(new FileOutputStream((String)SqlInjectionGraph.Debug.DUMP_USAGES.parms[0], true));){
                if (saveAll == null) {
                    return;
                }
                return;
            }
            catch (IOException e) {
                throw new InternalError(e);
            }
        }
    }

    String string() {
        return this.id + "_" + this.getName() + ":" + SqlInjectionGraph.linenumDebug.apply(this.getLoc());
    }

    String stringFlows() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.string() + " <-");
        for (Usage u2 : this.getSources()) {
            sb.append(" " + u2.string());
        }
        sb.append(" ->");
        for (Usage u2 : this.getFlows()) {
            sb.append(" " + u2.string());
        }
        for (FlowFunc.FlowFuncLink ff : this.getFuncLinks()) {
            sb.append(" <> " + ff);
        }
        return sb.toString();
    }

    public String toString(boolean full) {
        StringBuilder sb = new StringBuilder(this.toString());
        sb.append(" <-");
        for (Usage u : this.sources) {
            sb.append(" " + u.toString());
        }
        sb.append(" ->");
        for (Usage u : this.flows) {
            sb.append(" " + u.toString());
        }
        return sb.toString();
    }

    public String toString() {
        return this.id + "_" + this.symbol + (SqlInjectionGraph.isFake(this.loc) ? "$F" : "$") + this.loc;
    }
}

