/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import oracle.dbtools.app.injection.Dotted;
import oracle.dbtools.app.injection.Loc;
import oracle.dbtools.app.injection.PlsqlException;
import oracle.dbtools.app.injection.PlsqlType;
import oracle.dbtools.app.injection.PredefinedConstants;
import oracle.dbtools.app.injection.SqlInjectionAnalysisFailure;
import oracle.dbtools.app.injection.SqlInjectionGraph;
import oracle.dbtools.app.injection.Symbol;
import oracle.dbtools.app.injection.Usage;
import oracle.dbtools.app.injection.ValueNode;
import oracle.dbtools.parser.ParseNode;

class SymbolTable
extends Symbol {
    private final ScopeType scopeType;
    private final SymbolTable enclosingScope;
    private final SymbolTable topScope;
    private final HashMap<String, SymbolTable> schemas;
    private String currentUser;
    private SymbolTable currentUserScope;
    private final HashMap<String, Symbol> symbols;
    private Metadata meta;
    private final Deque<Metadata> metadataStack;
    private int nSqlInjectionAnalysisFailures = 0;

    SymbolTable() {
        this("", null, ScopeType.TOPLEVEL, new Loc(new Dotted("<TOP LEVEL>")));
    }

    SymbolTable(String name, SymbolTable enclosingScope, ScopeType scopeType, Loc loc) {
        super(enclosingScope, name, new PlsqlType.Scope(), loc == null ? new Loc(new Dotted("(?)")) : loc, null);
        assert (name != null);
        assert (name.length() > 0 || scopeType != ScopeType.SCHEMA);
        this.scopeType = scopeType;
        this.enclosingScope = enclosingScope;
        this.schemas = enclosingScope == null ? new HashMap() : enclosingScope.schemas;
        this.symbols = new HashMap();
        this.metadataStack = new ArrayDeque<Metadata>();
        if (enclosingScope != null) {
            this.meta = new Metadata(enclosingScope.meta);
            this.topScope = enclosingScope.topScope == null ? enclosingScope : enclosingScope.topScope;
            this.currentUser = null;
            this.currentUserScope = null;
        } else {
            this.topScope = null;
            this.meta = new Metadata();
        }
        if (this.schemas.get(name) == null) {
            this.schemas.put(name, this);
        }
    }

    SymbolTable getMakeSchema(String schema) {
        SymbolTable ret = this.schemas.get(schema = SymbolTable.canonicalize(schema));
        if (ret == null) {
            SymbolTable top = this;
            while (top.enclosingScope != null) {
                top = top.enclosingScope;
            }
            ret = new SymbolTable(schema, top, ScopeType.SCHEMA, null);
            this.schemas.put(schema, ret);
        }
        return ret;
    }

    SymbolTable getMakeSchemaPackage(String schema, String packageName) {
        packageName = SymbolTable.canonicalize(packageName);
        SymbolTable ret = null;
        SymbolTable schemaTable = this.getMakeSchema(schema);
        Symbol packageSymbol = schemaTable.getLocalDeclaration(packageName);
        if (packageSymbol != null && !(packageSymbol instanceof SymbolTable)) {
            throw new SqlInjectionAnalysisFailure(schema + "." + packageName + " is not a package but " + packageSymbol);
        }
        ret = packageSymbol == null ? new SymbolTable(packageName, schemaTable, ScopeType.PACKAGE, null) : (SymbolTable)packageSymbol;
        return ret;
    }

    SymbolTable getMakePackage(Dotted packageDotted) {
        ResolvedSymbol rs = this.resolveDotted(packageDotted);
        if (rs == null || !(rs.symbol instanceof SymbolTable)) {
            throw new SqlInjectionAnalysisFailure(packageDotted + " is not a package but " + rs.symbol);
        }
        SymbolTable scope = (SymbolTable)rs.symbol;
        for (String name : rs.dotted) {
            Loc loc = new Loc(packageDotted, "package creation");
            SymbolTable newScope = new SymbolTable(name, scope, ScopeType.PACKAGE, loc);
            scope.define(newScope, loc);
            scope = newScope;
        }
        return scope;
    }

    void setCurrentUser(String currentUser) {
        if (this.topScope != null) {
            this.topScope.setCurrentUser(currentUser);
            return;
        }
        if (currentUser == null || currentUser.length() == 0) {
            return;
        }
        this.currentUser = currentUser;
        this.currentUserScope = this.getMakeSchema(currentUser);
    }

    String getCurrentUser() {
        if (this.topScope == null) {
            return this.currentUser;
        }
        return this.topScope.getCurrentUser();
    }

    SymbolTable getCurrentUserScope() {
        if (this.topScope == null) {
            return this.currentUserScope;
        }
        return this.topScope.getCurrentUserScope();
    }

    ScopeType getScopeType() {
        return this.scopeType;
    }

    Symbol define(Symbol symbol, Loc loc) {
        Symbol prev = this.symbols.put(symbol.name, symbol);
        if (Debug.REDEFINITIONS.debug && prev != null) {
            System.out.println("Redefined " + prev + " -> " + symbol);
        }
        if (SqlInjectionGraph.Debug.SYM_DEFINE.debug) {
            System.out.println("SymbolTable.define(" + symbol.name + " (" + symbol.getType() + ")@" + loc);
        }
        return symbol;
    }

    Usage readHook(Usage u) {
        Usage ret = this.meta.read.apply(u);
        return ret;
    }

    void writeHook(Usage u) {
        this.meta.write.accept(u);
    }

    @Deprecated
    private Usage readNoHook(String name) {
        SymbolTable table = this;
        Usage ret = null;
        do {
            Symbol entry;
            if ((entry = table.symbols.get(name)) != null) {
                ret = entry.getAssigned();
            }
            table = table.enclosingScope;
        } while (ret == null && table != null);
        return ret;
    }

    @Deprecated
    private Usage readLocal(String name) {
        Symbol entry = this.symbols.get(name);
        if (name == null) {
            return null;
        }
        return entry.getAssigned();
    }

    ResolvedSymbol resolveScopes(Dotted dotted) {
        if (dotted.size() < 1) {
            return null;
        }
        Symbol symbol = this.symbols.get(dotted.get(0));
        if (symbol == null) {
            if (this.enclosingScope != null) {
                return this.enclosingScope.resolveScopes(dotted);
            }
            SymbolTable schema = this.schemas.get(dotted.get(0));
            if (schema == null) {
                return null;
            }
            dotted = new Dotted(dotted, 1);
            return schema.resolveScopes(dotted);
        }
        dotted = new Dotted(dotted, 1);
        while (symbol instanceof SymbolTable && dotted.size() != 0) {
            this.scope = (SymbolTable)symbol;
            Symbol nextSymbol = this.scope.symbols.get(dotted.get(0));
            if (nextSymbol == null) break;
            symbol = nextSymbol;
            dotted = new Dotted(dotted, 1);
        }
        return new ResolvedSymbol(dotted, symbol);
    }

    Symbol.FunctionSym resolveFunction(Dotted dotted) throws SqlInjectionAnalysisFailure {
        ResolvedSymbol rs = this.resolveDotted(dotted);
        if (rs == null) {
            throw new SqlInjectionAnalysisFailure("Could not resolve symbol " + dotted);
        }
        if (!(rs.symbol instanceof Symbol.FunctionSym)) {
            throw new SqlInjectionAnalysisFailure("Expected PROCEDURE or FUNCTION, found " + rs.symbol);
        }
        return (Symbol.FunctionSym)rs.symbol;
    }

    ResolvedSymbol resolveDotted(Dotted dotted) throws SqlInjectionAnalysisFailure {
        if (dotted.size() == 1) {
            Symbol sym;
            ResolvedSymbol constSym = PredefinedConstants.constants.get(dotted.get(0));
            if (constSym != null) {
                return constSym;
            }
            SymbolTable standardScope = this.schemas.get("STANDARD");
            if (standardScope != null && (sym = standardScope.getLocalDeclaration(dotted.get(0))) != null) {
                return new ResolvedSymbol(dotted, sym);
            }
        }
        ResolvedSymbol rs = null;
        SymbolTable userScope = this.getCurrentUserScope();
        if (userScope != null) {
            rs = userScope.resolveScopes(dotted);
        }
        if (rs == null) {
            rs = this.resolveScopes(dotted);
        }
        if (rs == null) {
            throw new SqlInjectionAnalysisFailure("Could not resolve symbol (user " + this.getCurrentUser() + "): " + dotted);
        }
        switch (rs.symbol.getType().getTypeClass()) {
            case FUNCTION: 
            case RECORD: {
                return rs;
            }
            case COLLECTION: 
            case EXCEPTION: 
            case SCALAR: {
                if (rs.dotted.size() != 0) {
                    throw new SqlInjectionAnalysisFailure("Resolving " + dotted + " (" + rs.symbol + ") had left-over component(s) " + rs.dotted);
                }
                return rs;
            }
            case SCOPE: {
                return rs;
            }
        }
        throw new IllegalStateException("Unexpected TypeClass " + (Object)((Object)rs.symbol.getType().getTypeClass()));
    }

    Symbol getLocalDeclaration(String name) {
        Symbol symbol = this.symbols.get(name = SymbolTable.canonicalize(name));
        if (symbol == null) {
            return null;
        }
        return symbol;
    }

    void cont() {
        this.meta.cont.accept(this);
    }

    void exit() {
        this.meta.exit.accept(this);
    }

    void retrn(ValueNode.ExprNode expr) {
        this.meta.retrn.accept(expr, this);
    }

    public SymbolTable getEnclosingScope() {
        return this.enclosingScope;
    }

    public Dotted getDotted() {
        Dotted ret = this.enclosingScope == null ? new Dotted() : this.enclosingScope.getDotted();
        if (this.scopeType != ScopeType.TOPLEVEL && this.name.length() > 0) {
            ret.add(this.name);
        }
        return ret;
    }

    Map<String, Symbol> getSymbols() {
        throw new IllegalStateException("Not allowed");
    }

    public Consumer<Usage> hookWrite(Consumer<Usage> assignmentHook) {
        Consumer<Usage> old = this.meta.write;
        this.meta.write = assignmentHook;
        return old;
    }

    public BiConsumer<ValueNode.ExprNode, SymbolTable> hookRetrn(BiConsumer<ValueNode.ExprNode, SymbolTable> retrnHook) {
        BiConsumer<ValueNode.ExprNode, SymbolTable> old = this.meta.retrn;
        this.meta.retrn = retrnHook;
        return old;
    }

    public static String canonicalize(String name) {
        return name.toUpperCase();
    }

    public void setReadHook(Function<Usage, Usage> readHook) {
        this.meta.read = readHook;
    }

    public Function<Usage, Usage> getReadHook() {
        return this.meta.read;
    }

    public void setWriteHook(Consumer<Usage> writeHook) {
        this.meta.write = writeHook;
    }

    public Consumer<Usage> getWriteHook() {
        return this.meta.write;
    }

    public Consumer<SymbolTable> hookContinue(Consumer<SymbolTable> contHook) {
        Consumer<SymbolTable> old = this.meta.cont;
        this.meta.cont = contHook;
        return old;
    }

    public Consumer<SymbolTable> hookExit(Consumer<SymbolTable> exitHook) {
        Consumer<SymbolTable> old = this.meta.exit;
        this.meta.exit = exitHook;
        return old;
    }

    public BiConsumer<EnumSet<PlsqlException>, ParseNode> hookExceptions(BiConsumer<EnumSet<PlsqlException>, ParseNode> exceptionsHook) {
        BiConsumer<EnumSet<PlsqlException>, ParseNode> old = this.meta.exceptions;
        this.meta.exceptions = exceptionsHook;
        return old;
    }

    public void exceptions(EnumSet<PlsqlException> exceptions, ParseNode pos) {
        this.meta.exceptions.accept(exceptions, pos);
    }

    public void pushMetadata() {
        this.metadataStack.push(new Metadata(this.meta));
    }

    public void popMetadata() {
        this.meta = this.metadataStack.pop();
    }

    void dump(boolean global) {
        String ourName;
        if (this.enclosingScope == null) {
            ourName = "[Top]";
        } else {
            ourName = "[NOT FOUND in enclosing";
            for (Map.Entry<String, Symbol> e : this.enclosingScope.symbols.entrySet()) {
                if (!e.getValue().equals(this)) continue;
                ourName = e.getKey();
                break;
            }
        }
        System.out.println(ourName + " " + (Object)((Object)this.scopeType) + " meta[" + this.metadataStack.size() + "]");
        for (Map.Entry<String, Symbol> nameEntry : this.symbols.entrySet()) {
            String name = nameEntry.getKey();
            Symbol symbol = nameEntry.getValue();
            System.out.println(name + ": " + symbol);
        }
        if (global && this.enclosingScope != null) {
            this.enclosingScope.dump(global);
        }
        if (this.enclosingScope == null) {
            System.out.println("Schemas:");
            for (String schema : this.schemas.keySet()) {
                System.out.print(" " + schema);
            }
            System.out.println();
        }
    }

    class Metadata {
        Usage loopContinue;
        Usage loopExit;
        Consumer<Usage> write;
        Function<Usage, Usage> read;
        Consumer<SymbolTable> cont;
        Consumer<SymbolTable> exit;
        BiConsumer<ValueNode.ExprNode, SymbolTable> retrn;
        BiConsumer<EnumSet<PlsqlException>, ParseNode> exceptions;

        private Metadata() {
            this.loopContinue = null;
            this.loopExit = null;
            this.write = useage -> {};
            this.read = usage -> usage;
            this.cont = a -> {};
            this.exit = a -> {};
            this.retrn = (a, b) -> {};
            this.exceptions = (a, b) -> {};
        }

        private Metadata(Metadata meta) {
            this.loopContinue = meta.loopContinue;
            this.loopExit = meta.loopExit;
            this.write = meta.write;
            this.read = meta.read;
            this.cont = meta.cont;
            this.exit = meta.exit;
            this.retrn = meta.retrn;
            this.exceptions = meta.exceptions;
        }
    }

    static class ResolvedSymbol {
        Dotted dotted;
        Symbol symbol;

        public ResolvedSymbol(Dotted dotted, Symbol symbol) {
            this.dotted = dotted;
            this.symbol = symbol;
        }

        public String toString() {
            return "(" + this.dotted + ": " + this.symbol + ")";
        }
    }

    static enum ScopeType {
        TOPLEVEL,
        SCHEMA,
        PACKAGE,
        FUNCTION,
        BLOCK;

    }

    static enum Debug {
        REDEFINITIONS(true, new Object[0]);

        boolean debug = false;
        Object[] parms;

        private Debug(boolean debug, Object ... parms) {
            this.parms = parms;
        }
    }
}

