/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

public class SqlInjectionAnalysisFailure
extends RuntimeException {
    private static final long serialVersionUID = -7288795177855793818L;
    static final int MAX_SOURCE = 80;
    private SqlInjectionFailureTypes safType;
    private String whileParsingSource = null;

    SqlInjectionAnalysisFailure(String msg, Throwable cause) {
        super(msg, cause);
        this.safType = SqlInjectionFailureTypes.SAF_UNLABELED;
    }

    public SqlInjectionAnalysisFailure(String msg) {
        super(msg);
        this.safType = SqlInjectionFailureTypes.SAF_UNLABELED;
    }

    public SqlInjectionAnalysisFailure(SqlInjectionFailureTypes safType, Object ... args) {
        super(safType.formatMsg(args));
        this.safType = safType;
    }

    SqlInjectionFailureTypes getSafType() {
        return this.safType;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + (this.whileParsingSource == null ? "" : " at " + this.whileParsingSource);
    }

    public String getWhileParsingSource() {
        return this.whileParsingSource;
    }

    public void setWhileParsingSource(String whileParsingSource) {
        if (whileParsingSource.length() > 80) {
            whileParsingSource = whileParsingSource.substring(0, whileParsingSource.length() - 3) + "...";
        }
        this.whileParsingSource = whileParsingSource;
    }

    static enum SqlInjectionFailureTypes {
        SAF_INTERNAL_ERROR("Internal error"),
        SAF_SYNTAX_ERROR("Syntax error"),
        SAF_TOO_MANY_FAILS("Too many parsing failures, stopping"),
        SAF_RULEID("No case for grammar ruleid =", null),
        SAF_UNLABELED("", null),
        SAF_BAD_TYPE("Unable to resolve PL/SQL expression type "),
        SAF_BAD_SYMB("Unable to resolve symbol "),
        SAF_BAD_PARSE("Parsing failed. "),
        SAF_BAD_CLONE_FUNCFLOW("Attempt to clone used flow");

        String safMsg;
        String[] seps;

        private SqlInjectionFailureTypes(String msg, String[] seps) {
            this.safMsg = msg;
            this.seps = seps;
        }

        private SqlInjectionFailureTypes(String msg) {
            this.safMsg = msg;
            this.seps = new String[0];
        }

        private String getMsg() {
            return this.safMsg;
        }

        private String[] getSeps() {
            return this.seps;
        }

        private String formatMsg(Object[] args) {
            String ret = this.safMsg;
            for (int i = 0; i < args.length; ++i) {
                ret = ret + args[i].toString();
                ret = this.seps == null || this.seps.length <= i ? ret + ", " : ret + this.seps[i];
            }
            return ret;
        }
    }
}

