/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import oracle.dbtools.app.injection.Call;

public class NodeLabel {
    private final Call call;
    private final NodeLabel parent;
    final int size;
    private int hashCode = 0;

    private NodeLabel(NodeLabel parent, Call call) {
        this.call = call;
        this.parent = parent;
        this.size = parent == null ? 1 : parent.size + 1;
    }

    NodeLabel() {
        this.call = null;
        this.parent = null;
        this.size = 1;
    }

    NodeLabel labelNewCall(Call newCall) {
        NodeLabel label = this;
        while (label != null) {
            if (label.call == newCall) {
                return this;
            }
            label = label.parent;
        }
        return new NodeLabel(this, newCall);
    }

    int size() {
        return this.size;
    }

    NodeLabel parent() {
        return this.parent;
    }

    Call call() {
        return this.call;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int prime = 31;
        int hashCode = 1;
        NodeLabel label = this;
        while (label != null) {
            hashCode = 31 * hashCode + (this.call == null ? 0 : this.call.hashCode());
            label = label.parent;
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeLabel other = (NodeLabel)obj;
        if (this.size != other.size) {
            return false;
        }
        NodeLabel label = this;
        while (label != null) {
            if (this.call == null ? other.call != null : !this.call.equals(other.call)) {
                return false;
            }
            label = label.parent;
            other = other.parent;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        NodeLabel label = this;
        while (label != null) {
            sb.append(this.call);
            label = label.parent;
            if (label == null) continue;
            sb.append("<-");
        }
        return sb.toString();
    }
}

