/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import oracle.dbtools.app.injection.Loc;

public class DependencyLink {
    private final String var;
    private final Loc loc;
    private final LocationTuple locTuple;

    public DependencyLink(String var, Loc loc, LocationTuple locTuple) {
        this.var = var;
        this.loc = loc;
        this.locTuple = locTuple;
    }

    public String getVar() {
        return this.var;
    }

    public Loc getLoc() {
        return this.loc;
    }

    public LocationTuple getLocTuple() {
        return this.locTuple;
    }

    public String getFile() {
        return this.locTuple.getFile();
    }

    public int getLineNum() {
        return this.locTuple.getLinenum();
    }

    public int hashCode() {
        return this.var.toUpperCase().hashCode() + 3 * this.locTuple.getFile().toUpperCase().hashCode() + 5 * Integer.hashCode(this.locTuple.getLinenum());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DependencyLink)) {
            return false;
        }
        DependencyLink other = (DependencyLink)obj;
        if (!this.var.equalsIgnoreCase(other.var)) {
            return false;
        }
        return this.locTuple.equals(other.locTuple);
    }

    public String toString() {
        return this.var + this.locTuple;
    }

    public static class LocationTuple {
        protected String file;
        protected int linenum;

        public LocationTuple(String file, int linenum) {
            this.file = file;
            this.linenum = linenum;
        }

        public String getFile() {
            return this.file;
        }

        public int getLinenum() {
            return this.linenum;
        }

        public String toString() {
            return this.file + ":" + this.linenum;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            LocationTuple other = (LocationTuple)obj;
            if (this.getFile() == null ? other.getFile() != null : !this.getFile().equals(other.getFile())) {
                return false;
            }
            return this.getLinenum() == other.getLinenum();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getFile() == null ? 0 : this.getFile().hashCode());
            result = 31 * result + this.getLinenum();
            return result;
        }
    }
}

