/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.app.Obfuscator;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Pair;
import oracle.dbtools.util.Service;

public class SqlRecognizer {
    static final String path = "/oracle/dbtools/app/";
    static String[] builtInTypePrefixes = new String[]{"CHAR", "VARCHAR", "NCHAR", "NVARCHAR", "DATE", "TIMESTAMP", "INTERVAL", "BLOB", "CLOB", "NCLOB", "BFILE", "LONG", "RAW", "NUMBER", "FLOAT", "BINARY", "ROWID", "UROWID"};
    private List<String> tables = new LinkedList<String>();
    private Map<String, String> objects = new HashMap<String, String>();
    private LinkedList<String> names = new LinkedList();
    private List<String> references = new LinkedList<String>();

    public static void main(String[] args) throws Exception {
        String input = Service.readFile(SqlRecognizer.class, "recognition_test.sql");
        SqlEarley.main(new String[]{input});
        SqlRecognizer.test(input);
    }

    private static void test(String input) {
        System.out.println(SqlRecognizer.fragmentAtLocation(input, "return_stmt"));
        System.out.println(input.indexOf("return ;"));
    }

    public SqlRecognizer() {
    }

    public SqlRecognizer(String input) {
        input = SqlRecognizer.massage(input);
        List<LexerToken> src = Lexer.parse(input);
        this.recognize(input, src, null);
    }

    public Map<String, Set<Long>> recognize(String input, List<LexerToken> src) {
        return this.recognize(input, src, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Set<Long>> recognize(String input, List<LexerToken> src, String extraSymbol) {
        try {
            Program.debug = false;
            String recognitionPrg = Service.readFile(Obfuscator.class, "/oracle/dbtools/app/recognize.prg");
            if (extraSymbol != null) {
                List<LexerToken> tmp = Lexer.parse(recognitionPrg);
                boolean found = false;
                for (LexerToken t : tmp) {
                    if (!t.content.equals(extraSymbol)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    recognitionPrg = recognitionPrg + "\n\"" + extraSymbol + "\": [" + extraSymbol + ") " + extraSymbol + ";";
                }
            }
            SqlProgram program = new SqlProgram(recognitionPrg, (Object)this, null, null, false);
            Map<String, MaterializedPredicate> predicateVectors = program.run(input, this);
            TreeMap<String, Set<Long>> ret = new TreeMap<String, Set<Long>>();
            Iterator<String> iterator = predicateVectors.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return ret;
                }
                String key = iterator.next();
                if (!key.startsWith("\"")) continue;
                String unquotedPredicateName = key.substring(1, key.length() - 1);
                this.fetch(unquotedPredicateName, src, predicateVectors, ret);
            }
        }
        catch (SyntaxError e) {
            throw e;
        }
        catch (AssertionError e) {
            System.err.println(((Throwable)((Object)e)).getMessage());
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void fetch(String predicate, List<LexerToken> src, Map<String, MaterializedPredicate> predicateVectors, Map<String, Set<Long>> ret) {
        MaterializedPredicate symbols = predicateVectors.get("\"" + predicate + "\"");
        HashSet<Long> intervals = new HashSet<Long>();
        if (null == symbols.getAttribute(predicate)) {
            return;
        }
        ret.put(predicate, intervals);
        for (Tuple t : symbols.getTuples()) {
            ParseNode pc = symbols.getAttribute(t, predicate);
            LexerToken f = src.get(pc.from);
            LexerToken t_1 = src.get(pc.to - 1);
            intervals.add(Service.lPair(f.begin, t_1.end));
        }
    }

    public static Map<Integer, String> fragmentAtLocation(String input, String targetSymbol) {
        List<LexerToken> src = Lexer.parse(input);
        return SqlRecognizer.fragmentAtLocation(input, src, targetSymbol);
    }

    public static Map<Integer, String> fragmentAtLocation(String input, List<LexerToken> src, String targetSymbol) {
        SqlRecognizer o = new SqlRecognizer();
        TreeMap<Integer, String> ret = new TreeMap<Integer, String>();
        Map<String, Set<Long>> output = o.recognize(input, src, targetSymbol);
        for (String symbol : output.keySet()) {
            if (!targetSymbol.equals(symbol)) continue;
            for (Long interval : output.get(symbol)) {
                int from = Service.lX(interval);
                int to = Service.lY(interval);
                ret.put(from, input.substring(from, to));
            }
        }
        return ret;
    }

    public static List<String> getList(String input, String targetSymbol) {
        Map<Integer, String> tmp = SqlRecognizer.fragmentAtLocation(input, targetSymbol);
        LinkedList<String> ret = new LinkedList<String>();
        int lastPos = -1;
        for (int pos : tmp.keySet()) {
            if (pos <= lastPos) {
                throw new AssertionError((Object)"pos <= lastPos");
            }
            ret.add(tmp.get(pos));
            lastPos = pos;
        }
        return ret;
    }

    public static List<String> getColumns(String input) {
        return SqlRecognizer.getList(input, "columnSelect");
    }

    public static Map<String, String> getColumnMap(String input) {
        List<String> columns = SqlRecognizer.getColumns(input);
        HashMap<String, String> ret = new HashMap<String, String>();
        SqlEarley earley = SqlEarley.newPartialRecognizer(new String[]{"select_term"});
        for (String column : columns) {
            List<LexerToken> src = Lexer.parse(column);
            ParseNode root = earley.parse(src);
            if (root.contains("column")) {
                ret.put(column, column);
                continue;
            }
            String colexpr = null;
            String alias = null;
            for (ParseNode child : root.children()) {
                if (child.contains("column")) {
                    colexpr = column.substring(src.get((int)child.from).begin, src.get((int)(child.to - 1)).end);
                }
                if (!child.contains("as_alias")) continue;
                alias = column.substring(src.get((int)(child.to - 1)).begin, src.get((int)(child.to - 1)).end);
            }
            if (colexpr == null || alias == null) continue;
            ret.put(alias, colexpr);
        }
        return ret;
    }

    public static List<String> getTables(String input) {
        return SqlRecognizer.getList(input, "tableFrom");
    }

    public static List<String> getAllTables(String input) {
        SqlRecognizer o = new SqlRecognizer();
        o.tables = new LinkedList<String>();
        List<LexerToken> src = Lexer.parse(input);
        o.recognize(input, src);
        return o.tables;
    }

    public static List<String> getPredicates(String input) {
        return SqlRecognizer.getList(input, "predicateWhere");
    }

    public static List<String> getOrderBy(String input) {
        return SqlRecognizer.getList(input, "orderBy");
    }

    public static List<String> getGroupBy(String input) {
        return SqlRecognizer.getList(input, "groupBy");
    }

    public static List<String> getStatements(String input) {
        input = SqlRecognizer.massage(input);
        return SqlRecognizer.getList(input, "sql_statement");
    }

    public static List<String> getAssignedBinds(String input) {
        input = SqlRecognizer.massage(input);
        return SqlRecognizer.getList(input, "assignedBind");
    }

    public static int[] getMatchRecognizeProblematicSymbols(String input) {
        Map<Integer, String> map = SqlRecognizer.fragmentAtLocation(input, "matchRecognizeProblematicSymbols");
        int[] ret = new int[map.size()];
        int pos = 0;
        for (int i : map.keySet()) {
            ret[pos++] = i;
        }
        return ret;
    }

    public static Pair<Integer, Integer> getWithClauseSpan(String input) {
        SqlRecognizer o = new SqlRecognizer();
        TreeMap ret = new TreeMap();
        List<LexerToken> src = Lexer.parse(input);
        Map<String, Set<Long>> output = o.recognize(input, src, "withClause");
        for (String symbol : output.keySet()) {
            Iterator<Long> iterator;
            if (!"withClause".equals(symbol) || !(iterator = output.get(symbol).iterator()).hasNext()) continue;
            Long interval = iterator.next();
            int from = Service.lX(interval);
            int to = Service.lY(interval);
            return new Pair<Integer, Integer>(from, to);
        }
        return null;
    }

    private static String massage(String input) {
        if (2 < (input = input.trim()).length() && input.startsWith("{") && input.endsWith("}")) {
            input = input.substring(1, input.length() - 1);
        }
        return input;
    }

    public static Map<Integer, String> getUserOrRole(String input) {
        Map<Integer, String> ret = SqlRecognizer.fragmentAtLocation(input, "role");
        if (0 < ret.size()) {
            return ret;
        }
        return SqlRecognizer.fragmentAtLocation(input, "user");
    }

    public List<String> getObjectNames() {
        return this.names;
    }

    public String getObjectType(String name) {
        String ret = this.objects.get(name);
        if (ret != null) {
            return ret;
        }
        return this.objects.get(Service.handleMixedCase(name));
    }

    public List<String> getReferencedTypes() {
        LinkedList<String> ret = new LinkedList<String>();
        block0: for (String t : this.references) {
            for (String b : builtInTypePrefixes) {
                if (t.toUpperCase().startsWith(b)) continue block0;
            }
            if (ret.contains(t)) continue;
            ret.add(t);
        }
        return ret;
    }

    public static int[] getReturns(String input) {
        Map<Integer, String> map = SqlRecognizer.fragmentAtLocation(input, "return");
        int[] ret = new int[map.size()];
        int pos = 0;
        for (int i : map.keySet()) {
            ret[pos++] = i;
        }
        return ret;
    }

    public static String reductPwd(String stmt) {
        String ret = stmt;
        Map<Integer, String> map = SqlRecognizer.fragmentAtLocation(ret, "pwd");
        for (int key : map.keySet()) {
            String pwd = map.get(key);
            ret = ret.substring(0, key) + Service.identln(pwd.length(), "", "*") + ret.substring(key + pwd.length());
        }
        return ret;
    }

    public void allTables(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("tableFrom");
        String name = target.getSrc().get((int)node.from).content;
        if (!this.tables.contains(name)) {
            this.tables.add(name);
        }
    }

    public void objects(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("object_name");
        String name = target.getSrc().get((int)node.from).content;
        if (name.charAt(0) == '\'') {
            name = name.substring(1, name.length() - 1);
        }
        ParseNode t = tuple.get("object_type");
        String type = target.getSrc().get((int)t.from).content;
        if (type.charAt(0) == '\'') {
            type = type.substring(1, type.length() - 1);
        }
        if (!this.objects.containsKey(name)) {
            this.objects.put(name, type);
            this.names.add(name);
        }
    }

    public void references(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("type");
        String name = target.getSrc().get((int)node.from).content;
        if (!this.references.contains(name)) {
            this.references.add(name);
        }
    }
}

