/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.app.Format;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.test.Base;

public class FormatRegressionTest
extends Base {
    Format format;

    public FormatRegressionTest() throws FileNotFoundException, IOException {
        super("src/test/resources/oracle/dbtools/app/format.test");
        singleTest = null;
    }

    public static void main(String[] args) throws Exception {
        new FormatRegressionTest().test();
    }

    @Override
    protected boolean assertion(ParseNode root, List<LexerToken> src, String input, int testNum) throws SQLException {
        this.format = new Format();
        return super.assertion(root, src, input, testNum);
    }

    @Override
    protected void output(ParseNode root, List<LexerToken> src, String input, int testNum) throws SQLException {
        this.format = new Format();
        super.output(root, src, input, testNum);
    }

    @Override
    public List<String> output(String input, int pos) {
        String formatted;
        LinkedList<String> output = new LinkedList<String>();
        try {
            formatted = this.format.format(input);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        output.add(formatted);
        return output;
    }

    @Override
    protected void parameters(ParseNode node, List<LexerToken> src, String input) {
        String key = null;
        String value = null;
        for (ParseNode child : node.children()) {
            if (child.contains(this.parameters)) {
                this.parameters(child, src, input);
                continue;
            }
            if (child.contains(this.dotted_name)) {
                String current = child.content(src);
                if (key == null) {
                    key = current;
                    continue;
                }
                value = current;
                break;
            }
            if (!child.contains(this.digits)) continue;
            value = child.content(src);
        }
        this.set(key, value);
    }

    private void set(String attribute, String item) {
        if (this.format.kwCase.equals(attribute) || this.format.idCase.equals(attribute)) {
            this.format.options.put(attribute, (Object)("Case.UPPER".equalsIgnoreCase(item) ? Format.Case.UPPER : ("Case.lower".equalsIgnoreCase(item) ? Format.Case.lower : ("Case.initCap".equalsIgnoreCase(item) ? Format.Case.InitCap : Format.Case.NoCaseChange))));
            return;
        }
        if (this.format.singleLineComments.equals(attribute)) {
            this.format.options.put(attribute, (Object)("singleLine".equalsIgnoreCase(item) ? Format.InlineComments.SingleLine : ("multiLine".equalsIgnoreCase(item) ? Format.InlineComments.MultiLine : Format.InlineComments.CommentsUnchanged)));
            return;
        }
        if (this.format.breaksComma.equals(attribute) || this.format.breaksConcat.equals(attribute) || this.format.breaksAroundLogicalConjunctions.equals(attribute)) {
            Format.Breaks tmp = Format.Breaks.BeforeAndAfter;
            if ("Breaks.Before".equalsIgnoreCase(item)) {
                tmp = Format.Breaks.Before;
            }
            if ("Breaks.After".equalsIgnoreCase(item)) {
                tmp = Format.Breaks.After;
            }
            if ("Breaks.None".equalsIgnoreCase(item)) {
                tmp = Format.Breaks.None;
            }
            this.format.options.put(attribute, (Object)tmp);
            return;
        }
        if (this.format.breaksAroundLogicalConjunctions.equals(attribute)) {
            this.format.options.put(attribute, !item.equals("Breaks.None"));
            return;
        }
        if (this.format.extraLinesAfterSignificantStatements.equals(attribute)) {
            if ("BreaksX2.X!".equals(item)) {
                this.format.options.put(attribute, (Object)Format.BreaksX2.X1);
            } else if ("BreaksX2.X2".equals(item)) {
                this.format.options.put(attribute, (Object)Format.BreaksX2.X2);
            } else {
                this.format.options.put(attribute, (Object)Format.BreaksX2.Keep);
            }
            return;
        }
        if (this.format.useTab.equals(attribute)) {
            this.format.options.put(attribute, item.equals("true"));
            return;
        }
        if (this.format.spaceAroundBrackets.equals(attribute)) {
            if ("Space.Outside".equals(item)) {
                this.format.options.put(attribute, (Object)Format.Space.Outside);
            } else if ("Space.NoSpace".equals(item)) {
                this.format.options.put(attribute, (Object)Format.Space.NoSpace);
            } else if ("Space.Default".equals(item)) {
                this.format.options.put(attribute, (Object)Format.Space.Default);
            } else {
                this.format.options.put(attribute, (Object)Format.Space.Inside);
            }
            return;
        }
        if (this.format.flowControl.equals(attribute)) {
            if ("FlowControl.IndentedActions".equals(item)) {
                this.format.options.put(attribute, (Object)Format.FlowControl.IndentedActions);
            } else if ("FlowControl.Terse".equals(item)) {
                this.format.options.put(attribute, (Object)Format.FlowControl.Terse);
            } else if ("FlowControl.IndentedConditionsActions".equals(item)) {
                this.format.options.put(attribute, (Object)Format.FlowControl.IndentedConditionsActions);
            } else {
                this.format.options.put(attribute, (Object)Format.FlowControl.SeparateConditionsActions);
            }
            return;
        }
        try {
            int i = Integer.parseInt(item);
            this.format.options.put(attribute, i);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            if ("true".equalsIgnoreCase(item) || "false".equalsIgnoreCase(item)) {
                this.format.options.put(attribute, "true".equalsIgnoreCase(item));
            } else {
                this.format.options.put(attribute, item);
            }
            return;
        }
    }
}

