/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.util.List;
import oracle.dbtools.app.Format;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.EarleyRegressionTest;
import oracle.dbtools.util.Service;

public class FormatDocTest {
    static final int offset = 0;
    static final int start = 0;
    static int cnt = 0;

    public static void main(String[] args) throws Exception {
        FormatDocTest.test("../parser/plsql/doc/doc_plsql.test");
    }

    private static void test(String file) throws Exception {
        String input = Service.readFile(FormatDocTest.class, file);
        List<LexerToken> src = Lexer.parse(input, "`");
        Parsed parsed = new Parsed(input, src, EarleyRegressionTest.testParser, "atest");
        ParseNode root = parsed.getRoot();
        FormatDocTest.test(root, parsed.getSrc(), input);
    }

    static void test(ParseNode root, List<LexerToken> src, String input) throws Exception {
        if (cnt % 13 != 0) {
            ++cnt;
            return;
        }
        if (root.contains(EarleyRegressionTest.query)) {
            String sql = FormatDocTest.query(root, src, input);
            if (sql.length() < 200) {
                return;
            }
            if (++cnt < 0) {
                return;
            }
            String output = new Format().format(sql);
            System.out.println("============================================# " + cnt);
            System.out.println(output);
        }
        for (ParseNode child : root.children()) {
            FormatDocTest.test(child, src, input);
        }
    }

    private static String query(ParseNode root, List<LexerToken> src, String input) {
        String ret = input.substring(src.get((int)root.from).begin, src.get((int)(root.to - 1)).end);
        if (ret.charAt(0) == '\"') {
            ret = ret.substring(1, ret.length() - 1);
        }
        if (ret.charAt(0) == '`') {
            ret = ret.substring(1, ret.length() - 1);
        }
        return " " + ret + " ";
    }
}

