/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.writers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.config.ICommonConfig;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportDataFormatConfig;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.writers.IImportGenerator;
import oracle.dbtools.importer.writers.ImportGenHelper;
import oracle.dbtools.importer.writers.ImportWriteStream;
import oracle.dbtools.raptor.deployment.DbmsCloudResources;
import oracle.dbtools.raptor.utils.IToolRunMode;
import oracle.dbtools.raptor.utils.MessageHandler;
import oracle.dbtools.raptor.utils.ToolLogger;
import oracle.dbtools.util.Logger;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

public class ImportGenModel {
    private static final String DEFAULT_GROUP_QUOTE = "importgen";
    public static final String NL = "\n";
    private static STGroup _templateGroup;
    private ImportProperties _iProps;
    private IToolRunMode _runMode;
    private IImportGenerator _service;
    private GenericTable _genTable;
    private boolean _isAutoCommit = false;
    private boolean _isBatch;
    private boolean _isCancel = false;
    private boolean _isConnClone = false;
    private boolean _isConnLocked = false;
    private boolean _isExistingTable;
    private boolean _isIgnoreAllErrors;
    private boolean _isTableCreated = false;
    private Connection _baseConn;
    private String _baseUser;
    private String _schemaName;
    private String _connName;
    private StringBuffer _createTableSql = new StringBuffer();
    private ImportDataFormat _dataFormat;
    private ImportWriteStream _stream;
    private ToolLogger _eLogger;
    private ExitCode _exitCode = ExitCode.EXIT_SUCCESS;

    public ImportGenModel(ImportProperties iProps) {
        this._iProps = iProps;
    }

    public IToolRunMode getRunMode() {
        return this._runMode;
    }

    public void setRunMode(IToolRunMode iRunMode) {
        this._runMode = iRunMode;
    }

    public IImportGenerator getService() {
        return this._service;
    }

    public void setService(IImportGenerator service) {
        this._service = service;
    }

    public boolean start() {
        return this.start(false);
    }

    public boolean start(boolean isConnClone) {
        this._exitCode = ExitCode.EXIT_SUCCESS;
        this._isConnClone = isConnClone;
        Logger.info(this.getClass(), (String)ImportResources.getString("GEN_START"));
        try {
            this._stream = (ImportWriteStream)((Object)this._iProps.get(ImportKeys.IMPORT_WRITE_STREAM));
            this._isExistingTable = (Boolean)this._iProps.get(ImportKeys.IS_EXISTING_TABLE);
            this._isBatch = this._iProps.getValueBoolean(ImportKeys.IS_BATCH);
            this._genTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
            this._dataFormat = (ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
            BasicDBObject dbo = (BasicDBObject)this._iProps.get(ImportKeys.DBOBJECT);
            if (dbo != null) {
                this._connName = dbo.getConnectionName();
                this._baseConn = this._isConnClone ? ConnectionResolver.getUniqueConnection((String)this._connName) : ConnectionResolver.getConnection((String)this._connName);
                this._baseUser = this._baseConn.getMetaData().getUserName();
                this._iProps.put(ImportKeys.CONNECTION_USER, this._baseUser);
                this._schemaName = dbo.getSchemaName();
                this._iProps.put(ImportKeys.OBJECT_SCHEMA, this._schemaName);
            }
            this.loadTemplates();
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (Throwable)e);
            this._exitCode = ExitCode.EXIT_SEVERE;
            this._exitCode.setMessage(e.getMessage());
            return false;
        }
        this._exitCode = ExitCode.EXIT_SUCCESS;
        return true;
    }

    public ExitCode closeConnClone() {
        try {
            if (this._isConnClone) {
                this._baseConn.close();
                this._isConnClone = false;
            }
        }
        catch (Exception e) {
            ExitCode exitCode = ExitCode.EXIT_WARNING;
            exitCode.setMessage(e.getMessage());
            this.eLogException(e);
            return exitCode;
        }
        return ExitCode.EXIT_SUCCESS;
    }

    public void putWriteStream(ImportWriteStream stream) {
        this._stream = stream;
    }

    public boolean isCancel() {
        return this._isCancel;
    }

    public void isCancel(boolean value) {
        this._isCancel = value;
    }

    public boolean isBatch() {
        return this._isBatch;
    }

    public boolean isExistingTable() {
        return this._isExistingTable;
    }

    public boolean isExitCodeSuccess() {
        return this._exitCode == ExitCode.EXIT_SUCCESS;
    }

    public boolean isIgnoreAllErrors() {
        return this._isIgnoreAllErrors;
    }

    public void isIgnoreAllErrors(boolean value) {
        this._isIgnoreAllErrors = value;
    }

    public boolean isTableCreated() {
        return this._isTableCreated;
    }

    public void isTableCreated(boolean value) {
        this._isTableCreated = value;
    }

    public Connection getConn() {
        return this._baseConn;
    }

    public String getConnName() {
        return this._connName;
    }

    public boolean isConnLocked() {
        return this._isConnLocked;
    }

    public void isConnLocked(boolean isConnLocked) {
        this._isConnLocked = isConnLocked;
    }

    public ExitCode getExitCode() {
        return this._exitCode;
    }

    public void setExitCode(ExitCode exitCode) {
        this._exitCode = exitCode;
    }

    public ImportProperties getIProps() {
        return this._iProps;
    }

    public String getUser() {
        return this._baseUser;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public GenericTable getGenTable() {
        return this._genTable;
    }

    public ImportDataFormat getDataFormat() {
        return this._dataFormat;
    }

    public ImportWriteStream getStream() {
        return this._stream;
    }

    public void setStream(ImportWriteStream stream) {
        this._stream = stream;
    }

    public boolean lockConnection() {
        if (this.getConn() != null) {
            this._isConnLocked = LockManager.lock((Connection)this.getConn());
            return this._isConnLocked;
        }
        return false;
    }

    public void unlockConnection() {
        if (this.getConn() != null) {
            LockManager.unlock((Connection)this.getConn());
            this._isConnLocked = false;
        }
    }

    public final boolean lockConnectionForImport() {
        try {
            this._isConnLocked = LockManager.lock((Connection)this.getConn());
            if (!this._isConnLocked) {
                Logger.warn(ImportGenHelper.class, (String)ImportResources.getString("LOCK_CONN_ERR"));
                this._exitCode = ExitCode.EXIT_SEVERE;
                this._exitCode.setShortMessage(ImportResources.getString("LOCK_CONN_ERR"));
                return false;
            }
            this._isAutoCommit = this.getConn().getAutoCommit();
            this.getConn().setAutoCommit(false);
        }
        catch (Exception e) {
            Logger.warn(ImportGenHelper.class, (Throwable)e);
            this._exitCode = ExitCode.EXIT_SEVERE;
            this._exitCode.setShortMessage(e.getMessage());
            return false;
        }
        return this._isConnLocked;
    }

    public void unlockConnectionForImport() {
        try {
            if (this._isConnLocked) {
                LockManager.unlock((Connection)this.getConn());
                this.getConn().setAutoCommit(this._isAutoCommit);
                this._isConnLocked = false;
            }
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
    }

    public StringBuffer getCreateTableSql() {
        return this._createTableSql;
    }

    public void setCreateTableSql(StringBuffer value) {
        this._createTableSql = value;
    }

    public boolean doCreateTable() {
        if (!this.isExistingTable()) {
            this.streamPrintln(DbmsCloudResources.format((String)"DBMS_CLOUD_STEP_START", (Object[])new Object[]{DbmsCloudResources.getString((String)"DBMS_CLOUD_STEP_CREATE_DEST_TAB")}));
            String sql = this.getCreateTableStatementWithComments();
            sql = sql.replace(";", "");
            sql = sql.replace(NL, "  ");
            this._createTableSql.append(this.getDropTableStatement() + NL);
            this._createTableSql.append("/*\n");
            this._createTableSql.append(sql);
            this._createTableSql.append("*/\n");
            sql = this.getCreateTableStatement();
            sql = sql.replace(";", "");
            sql = sql.replace(NL, "  ");
            this.streamPrintln(sql);
            String msg = DbmsCloudResources.getString((String)"DBMS_CLOUD_SUCCESS");
            boolean isSuccess = this.pstmtExec(sql);
            if (!isSuccess) {
                this._exitCode = ExitCode.EXIT_ERROR;
                this._exitCode.setShortMessage(ImportResources.getString("STATEMENT_FAILED") + " ");
                msg = this._exitCode.getShortMessage() + this._exitCode.getMessage();
                this.streamPrintln(msg);
                this.streamPrintln(DbmsCloudResources.format((String)"DBMS_CLOUD_STEP_END", (Object[])new Object[]{DbmsCloudResources.getString((String)"DBMS_CLOUD_STEP_CREATE_DEST_TAB")}) + NL);
                return false;
            }
            this.streamPrintln(DbmsCloudResources.getString((String)"DBMS_CLOUD_SUCCESS"));
            Column[] cols = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
            for (int i = 0; i < cols.length; ++i) {
                if (cols[i] == null || cols[i].getComment() == null || cols[i].getComment().trim().length() <= 0) continue;
                sql = this.getCommentStatement(this.getTableName(), cols[i].getName(), cols[i].getComment());
                sql = sql.replace(";", "");
                this.streamPrintln(sql);
                isSuccess = this.pstmtExec(sql);
                if (!isSuccess) {
                    this._exitCode.setShortMessage(ImportResources.getString("STATEMENT_FAILED") + " ");
                    msg = this._exitCode.getShortMessage() + this._exitCode.getMessage();
                    this.streamPrintln(msg);
                    this.streamPrintln(DbmsCloudResources.format((String)"DBMS_CLOUD_STEP_END", (Object[])new Object[]{DbmsCloudResources.getString((String)"DBMS_CLOUD_STEP_CREATE_DEST_TAB")}) + NL);
                    return false;
                }
                this.streamPrintln(DbmsCloudResources.getString((String)"DBMS_CLOUD_SUCCESS"));
            }
            this.isTableCreated(true);
            this.streamPrintln(DbmsCloudResources.format((String)"DBMS_CLOUD_STEP_END", (Object[])new Object[]{DbmsCloudResources.getString((String)"DBMS_CLOUD_STEP_CREATE_DEST_TAB")}) + NL);
        }
        return true;
    }

    public boolean addComments() {
        if (!this.isExistingTable()) {
            this.streamPrintln(DbmsCloudResources.format((String)"DBMS_CLOUD_STEP_START", (Object[])new Object[]{DbmsCloudResources.getString((String)"DBMS_CLOUD_STEP_ADD_COMMENTS")}));
            boolean isSuccess = true;
            String msg = "";
            String sql = "";
            Column[] cols = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
            for (int i = 0; i < cols.length; ++i) {
                if (cols[i] == null || cols[i].getComment() == null || cols[i].getComment().trim().length() <= 0) continue;
                sql = this.getCommentStatement(this.getTableName(), cols[i].getName(), cols[i].getComment());
                sql = sql.replace(";", "");
                this.streamPrintln(sql);
                isSuccess = this.pstmtExec(sql);
                if (!isSuccess) {
                    this._exitCode.setShortMessage(ImportResources.getString("STATEMENT_FAILED") + " ");
                    msg = this._exitCode.getShortMessage() + this._exitCode.getMessage();
                    this.streamPrintln(msg);
                    this.streamPrintln(DbmsCloudResources.format((String)"DBMS_CLOUD_STEP_END", (Object[])new Object[]{DbmsCloudResources.getString((String)"DBMS_CLOUD_STEP_ADD_COMMENTS")}) + NL);
                    return false;
                }
                this.streamPrintln(DbmsCloudResources.getString((String)"DBMS_CLOUD_SUCCESS"));
            }
            this.streamPrintln(DbmsCloudResources.format((String)"DBMS_CLOUD_STEP_END", (Object[])new Object[]{DbmsCloudResources.getString((String)"DBMS_CLOUD_STEP_ADD_COMMENTS")}) + NL);
        }
        return true;
    }

    public boolean pstmtExec(String sql) {
        try {
            PreparedStatement pstmt = this.getConn().prepareStatement(sql);
            pstmt.execute();
        }
        catch (SQLException e) {
            Logger.warn(this.getClass(), (Throwable)e);
            this._exitCode = ExitCode.EXIT_ERROR;
            this._exitCode.setMessage(sql + " " + e.getMessage());
            return false;
        }
        return true;
    }

    public String getDropTableStatement() {
        ST template = this.getTemplateGroup().getInstanceOf("DropTableStatement");
        template.add("tableName", (Object)this.addUser(this.getTableName()));
        return template.render();
    }

    public String getDropTableStatementForPrepare() {
        ST template = this.getTemplateGroup().getInstanceOf("DropTableStatementForPrepare");
        template.add("tableName", (Object)this.addUser(this.getTableName()));
        return template.render();
    }

    public String getCreateTableStatementWithComments() {
        return this.getCreateTableStatementWithComments(null);
    }

    public String getCreateTableStatementWithComments(String tableName) {
        StringBuffer sql = new StringBuffer();
        Column[] cols = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        sql.append(this.getCreateTableStatement(tableName) + "\n\n");
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i] == null || cols[i].getComment() == null || cols[i].getComment().trim().length() <= 0) continue;
            sql.append(this.getCommentStatement(tableName != null ? tableName : this.getTableName(), cols[i].getName(), cols[i].getComment()) + "\n\n");
        }
        return sql.toString();
    }

    public String getCreateTableStatement() {
        return this.getCreateTableStatement(null);
    }

    public String getCreateTableStatement(String tableName) {
        String tName = tableName != null ? tableName : this.getTableName();
        String[] colList = ImportGenHelper.formatTableColumns(this._iProps);
        ST template = this.getTemplateGroup().getInstanceOf("CreateTableStatement");
        template.add("tableName", (Object)this.addUser(tName));
        template.add("colList", (Object)colList);
        return template.render();
    }

    public String getComments() {
        return this.getComments(null);
    }

    public String getComments(String tableName) {
        StringBuffer sql = new StringBuffer();
        Column[] cols = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i] == null || cols[i].getComment() == null || cols[i].getComment().trim().length() <= 0) continue;
            sql.append(this.getCommentStatement(tableName != null ? tableName : this.getTableName(), cols[i].getName(), cols[i].getComment()) + "\n\n");
        }
        return sql.toString();
    }

    public String getCommentStatement(String tableName, String colName, String comment) {
        ST template = this.getTemplateGroup().getInstanceOf("CommentOnColumnStatement");
        template.add("tableName", (Object)this.addUser(tableName));
        template.add("colName", (Object)this.addDoubleQuote(colName));
        template.add("comment", (Object)comment);
        return template.render();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOutFile(File f, String content) {
        OutputStreamWriter osw = null;
        String genEncoding = ICommonConfig.Storage.getInstance().getString("IMPORT_LDR_GEN_ENCODING");
        try {
            osw = genEncoding != null && genEncoding.length() > 0 ? new OutputStreamWriter((OutputStream)new FileOutputStream(f), genEncoding) : (this._runMode == null || this._runMode.getEncoding() == null ? new OutputStreamWriter(new FileOutputStream(f)) : new OutputStreamWriter((OutputStream)new FileOutputStream(f), this._runMode.getEncoding()));
            osw.write(content);
        }
        catch (IOException e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
        finally {
            if (osw != null) {
                try {
                    osw.flush();
                    osw.close();
                }
                catch (IOException e) {
                    Logger.warn(this.getClass(), (Throwable)e);
                }
            }
        }
    }

    public void loadTemplates() {
        this.setTemplateName(DEFAULT_GROUP_QUOTE);
    }

    public void setTemplateName(String templateName) {
        ClassLoader ctxCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.setTemplateGroup((STGroup)new STGroupFile("oracle/dbtools/importer/templates/" + templateName + ".stg"));
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxCL);
        }
    }

    public void setTemplateGroup(STGroup templateGroup) {
        _templateGroup = templateGroup;
    }

    public STGroup getTemplateGroup() {
        if (_templateGroup == null) {
            this.loadTemplates();
        }
        return _templateGroup;
    }

    public boolean isFileWritable(String in) {
        File inFile = new File(in);
        boolean doIWrite = true;
        if (inFile.exists()) {
            boolean bl = doIWrite = this._iProps.getValueBoolean(ImportKeys.IS_BATCH) == false;
            if (doIWrite) {
                AskDelete getAnswer = new AskDelete(in);
                try {
                    if (SwingUtilities.isEventDispatchThread()) {
                        getAnswer.run();
                    } else {
                        SwingUtilities.invokeAndWait(getAnswer);
                    }
                    if (getAnswer.getDeleted() != null && getAnswer.getDeleted().equals(Boolean.FALSE)) {
                        doIWrite = false;
                    }
                }
                catch (InterruptedException e) {
                    Logger.warn(this.getClass(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    Logger.warn(this.getClass(), (Throwable)e);
                }
            }
        }
        return doIWrite;
    }

    public void streamPrintln(String output) {
        try {
            this.getStream().println(output);
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
    }

    public void eLog(String msg) {
        if (this._eLogger != null) {
            this._eLogger.log(msg);
        }
    }

    public void eLogException(Throwable t) {
        if (t != null && this._eLogger != null) {
            this._eLogger.logException(t);
        }
    }

    public void eLogHref(URL url) {
        if (url != null && this._eLogger != null) {
            this._eLogger.logHref(url);
        }
    }

    public void eLogToolEnd() {
        if (this._eLogger != null) {
            this._eLogger.logToolEnd();
        }
    }

    public void eLogToolFinished() {
        if (this._eLogger != null) {
            this._eLogger.finished();
        }
    }

    public void initELogger() {
        this._eLogger = this._runMode.newToolLogger();
        this._eLogger.logToolStart(this.getELoggerName());
    }

    public void eLogImportMessages() {
        LoadFile loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        String inputFileName = this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS) != false ? (String)this._iProps.get(ImportKeys.OSS_PATH) : loadFile.getName();
        this.eLog(ImportResources.format("IMPORT_ELOG", inputFileName, ConnectionResolver.getDisplayName((String)((String)this._iProps.get(ImportKeys.CONNECTION_NAME))), ImportGenHelper.getSchema(this._iProps), this.getTableName()));
        int loadMethod = this._iProps.getValueInteger(ImportKeys.LOAD_METHOD);
        this.eLog(ImportResources.format("IMPORT_LOAD_METHOD", ImportDataFormat.getLoadMethodName(loadMethod)));
    }

    public ToolLogger getELogger() {
        return this._eLogger;
    }

    public String getELoggerName() {
        return ImportResources.getString("IMPORT_TOOL");
    }

    public void checkCanProceed() throws ExecutionException {
        if (this._runMode.getTaskProgressUpdater() != null) {
            this._runMode.getTaskProgressUpdater().checkCanProceed();
        }
    }

    public void setProgress(String msg) throws ExecutionException {
        if (this._runMode.getTaskProgressUpdater() != null) {
            this._runMode.getTaskProgressUpdater().getDescriptor().setMessage(msg);
        }
    }

    public boolean requestCancel() {
        this._isCancel = true;
        if (this._runMode.getTask() != null) {
            return this._runMode.getTask().requestCancel();
        }
        return false;
    }

    public void setMessage(String msg) {
        if (this._runMode.getTask() != null) {
            this._runMode.getTask().setMessage(msg);
        }
    }

    public String getTableName() {
        return ImportGenHelper.getTableName(this._iProps);
    }

    public String addUser(String name) {
        return ImportGenHelper.addUser(this._iProps, name);
    }

    public String addDoubleQuote(String name) {
        return ImportGenHelper.addDoubleQuote(this._iProps, name);
    }

    public String translateEOL(String content) {
        return ImportGenHelper.translateEOL(this._iProps, content);
    }

    public String dos(String content) {
        return ImportGenHelper.dos(content);
    }

    public String nix(String content) {
        return ImportGenHelper.dos(content);
    }

    public String getTaskFullName() {
        return ImportGenHelper.getTaskFullName(this._iProps);
    }

    static {
        ImportDataFormatConfig.DefaultInitializer.init();
        _templateGroup = null;
    }

    static class AskDelete
    implements Runnable {
        private Boolean deleted = Boolean.FALSE;
        private String in = null;
        private File inFile = null;

        public AskDelete(String val) {
            this.in = val;
            this.inFile = new File(this.in);
        }

        @Override
        public void run() {
            String justFile = this.in;
            int toSeperator = this.in.lastIndexOf(File.separator);
            if (toSeperator != -1) {
                justFile = this.in.substring(toSeperator + 1);
            }
            switch (MessageHandler.confirmOrCancel(null, (String)ImportResources.getString("FILE_EXISTS_OVERWRITE"), (String)justFile, null)) {
                case 1: {
                    this.inFile.delete();
                    this.deleted = Boolean.TRUE;
                    break;
                }
                default: {
                    this.deleted = Boolean.FALSE;
                }
            }
        }

        public Boolean getDeleted() {
            return this.deleted;
        }
    }
}

