/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.core;

import java.util.Vector;
import oracle.dbtools.common.config.ICommonConfig;
import oracle.dbtools.common.config.IStorage;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.importer.BaseResources;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportDataFormatConfig;
import oracle.dbtools.importer.readers.IImportFormatOptions;

public class ImportDataFormat
extends BaseDataFormat {
    public static final int HEADER_AFTER_SKIP = 0;
    public static final int HEADER_BEFORE_SKIP = 1;
    public static final int METHOD_INSERT_EXEC = 0;
    public static final int METHOD_INSERT_SCRIPT = 1;
    public static final int METHOD_EXTERNAL_TABLE = 2;
    public static final int METHOD_STAGING_EXTERNAL_TABLE = 3;
    public static final int METHOD_SQLLDR = 4;
    public static final int METHOD_CLOUD_LOAD = 5;
    public static String METHOD_INSERT_EXEC_NAME;
    public static String METHOD_INSERT_SCRIPT_NAME;
    public static String METHOD_EXTERNAL_TABLE_NAME;
    public static String METHOD_STAGING_EXTERNAL_TABLE_NAME;
    public static String METHOD_SQLLDR_NAME;
    public static String METHOD_CLOUD_LOAD_NAME;
    public static String[] NEW_METHODS;
    public static String[] EXISTING_METHODS;
    public static String[] CLOUD_METHODS;
    public static String LINE_TERMINATOR;
    public static String TRUE;
    public static String FALSE;
    private boolean _usePreviewLimit;
    private int _previewLimit;
    private boolean _useLoadLimit;
    private int _loadLimit;
    private int _skipRows;
    private boolean _useMaxLength;
    private int _maxLength;
    private boolean _useNlsNumeric;
    private String _worksheet;
    private int _pageId = 0;
    private boolean _isFileFragment = false;

    public ImportDataFormat(int usage, String format) {
        super(usage, format);
    }

    @Override
    public void setFormat(String value) {
        super.setFormat(value);
        this.initConfigFormatOptions(ICommonConfig.Storage.getInstance());
    }

    public void setFormat(String value, boolean initFormat, IStorage config) {
        super.setFormat(value);
        if (initFormat) {
            this.initConfigFormatOptions(config);
        }
    }

    public void setFormat(String value, IStorage config) {
        super.setFormat(value);
        this.initConfigFormatOptions(config);
    }

    @Override
    public Vector<String> getRecordTerminators() {
        this._recordTerminators = new Vector();
        this._recordTerminators.add(BaseResources.getString("STANDARD"));
        this._recordTerminators.add(BaseResources.getString("LF"));
        this._recordTerminators.add(BaseResources.getString("CRLF"));
        this._recordTerminators.add(BaseResources.getString("CR"));
        this._recordTerminators.add(BaseResources.getString("TERM_OTHER"));
        if (this._recordTerminators.contains(this._recTerm)) {
            return this._recordTerminators;
        }
        this._recordTerminators.add(this._recTerm);
        return this._recordTerminators;
    }

    public String getWorksneet() {
        return this._worksheet;
    }

    public void setWorksheet(String value) {
        this._worksheet = value;
    }

    public int getPageId() {
        return this._pageId;
    }

    public void setPageId(int value) {
        this._pageId = value;
    }

    public boolean isPreviewLimitSupported() {
        return ((IImportFormatOptions)this._options).isPreviewLimitSupported();
    }

    public boolean getUsePreviewLimit() {
        return this._usePreviewLimit;
    }

    public void setUsePreviewLimit(boolean value) {
        this._usePreviewLimit = value;
    }

    public int getPreviewLimit() {
        return this._previewLimit;
    }

    public void setPreviewLimit(int value) {
        this._previewLimit = value;
    }

    public boolean getUseLoadLimit() {
        return this._useLoadLimit;
    }

    public void setUseLoadLimit(boolean value) {
        this._useLoadLimit = value;
    }

    public boolean getIsFileFragment() {
        return this._isFileFragment;
    }

    public void setIsFileFragment(boolean value) {
        this._isFileFragment = value;
    }

    public int getLoadLimit() {
        return this._loadLimit;
    }

    public void setLoadLimit(int value) {
        this._loadLimit = value;
    }

    public boolean getUseMaxLength() {
        return this._useMaxLength;
    }

    public void setUseMaxLength(boolean value) {
        this._useMaxLength = value;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public void setMaxLength(int value) {
        this._maxLength = value;
    }

    public int getPreviewCharactersLimit() {
        return this._maxLength;
    }

    public void setPreviewCharactersLimit(int value) {
        this._maxLength = value;
    }

    public boolean getUseNlsNumeric() {
        return this._useNlsNumeric;
    }

    public void setUseNlsNumeric(boolean value) {
        this._useNlsNumeric = value;
    }

    public boolean isHeaderLocationSupported() {
        return ((IImportFormatOptions)this._options).isHeaderLocationSupported();
    }

    public String[] getHeaderLocations() {
        String[] headerLocations = new String[]{BaseResources.getString("AFTER"), BaseResources.getString("BEFORE")};
        return headerLocations;
    }

    public int getHeaderLocation() {
        return ((IImportFormatOptions)this._options).getHeaderLocation();
    }

    public boolean isHeaderAfter() {
        return ((IImportFormatOptions)this._options).getHeaderLocation() == 0;
    }

    public void isHeaderAfter(boolean value) {
        ((IImportFormatOptions)this._options).setHeaderLocation(value ? 0 : 1);
    }

    public void setHeaderLocation(int value) {
        ((IImportFormatOptions)this._options).setHeaderLocation(value);
    }

    public boolean isSkipSupported() {
        return ((IImportFormatOptions)this._options).isSkipSupported();
    }

    public int getSkipRows() {
        return this._skipRows;
    }

    public void setSkipRows(int value) {
        this._skipRows = value;
    }

    public static int getLoadMethodType(String loadMethodName) {
        if (loadMethodName.equals(METHOD_INSERT_EXEC_NAME)) {
            return 0;
        }
        if (loadMethodName.equals(METHOD_INSERT_SCRIPT_NAME)) {
            return 1;
        }
        if (loadMethodName.equals(METHOD_EXTERNAL_TABLE_NAME)) {
            return 2;
        }
        if (loadMethodName.equals(METHOD_STAGING_EXTERNAL_TABLE_NAME)) {
            return 3;
        }
        if (loadMethodName.equals(METHOD_CLOUD_LOAD_NAME)) {
            return 5;
        }
        return 4;
    }

    public static String getLoadMethodName(int loadMethodType) {
        if (loadMethodType == 0) {
            return METHOD_INSERT_EXEC_NAME;
        }
        if (loadMethodType == 1) {
            return METHOD_INSERT_SCRIPT_NAME;
        }
        if (loadMethodType == 2) {
            return METHOD_EXTERNAL_TABLE_NAME;
        }
        if (loadMethodType == 3) {
            return METHOD_STAGING_EXTERNAL_TABLE_NAME;
        }
        if (loadMethodType == 5) {
            return METHOD_CLOUD_LOAD_NAME;
        }
        return METHOD_SQLLDR_NAME;
    }

    public static int getDefaultNewLoadMethod(boolean isOracleLoaderReadable) {
        String[] newMethods;
        int defaultMethod = ICommonConfig.Storage.getInstance().getInt("IMPORT_NEW_MODE");
        String defaultMethodName = ImportDataFormat.getLoadMethodName(defaultMethod);
        for (String newMethod : newMethods = ImportDataFormat.getNewLoadMethods(isOracleLoaderReadable)) {
            if (!newMethod.equals(defaultMethodName)) continue;
            return defaultMethod;
        }
        return 0;
    }

    public static int getDefaultExistingLoadMethod(boolean isOracleLoaderReadable) {
        String[] newMethods;
        int defaultMethod = ICommonConfig.Storage.getInstance().getInt("IMPORT_EXISTING_MODE");
        String defaultMethodName = ImportDataFormat.getLoadMethodName(defaultMethod);
        for (String newMethod : newMethods = ImportDataFormat.getNewLoadMethods(isOracleLoaderReadable)) {
            if (!newMethod.equals(defaultMethodName)) continue;
            return defaultMethod;
        }
        return 0;
    }

    public static int getDefaultCloudMethod(boolean isOracleLoaderReadable) {
        return 5;
    }

    public static int getDefaultDwcsNewMethod(boolean isOSS) {
        if (isOSS) {
            return 5;
        }
        return 0;
    }

    public static int getDefaultDwcsExistingMethod(boolean isOSS) {
        if (isOSS) {
            return 5;
        }
        return 0;
    }

    public static String[] getNewLoadMethods(boolean isOracleLoaderReadable) {
        if (isOracleLoaderReadable) {
            return NEW_METHODS;
        }
        return new String[]{METHOD_INSERT_EXEC_NAME, METHOD_INSERT_SCRIPT_NAME};
    }

    public static String[] getExistingLoadMethods(boolean isOracleLoaderReadable) {
        if (isOracleLoaderReadable) {
            return EXISTING_METHODS;
        }
        return new String[]{METHOD_INSERT_EXEC_NAME, METHOD_INSERT_SCRIPT_NAME};
    }

    public static String[] getCloudLoadMethods(boolean isOracleLoaderReadable) {
        return new String[]{METHOD_SQLLDR_NAME};
    }

    public static String[] getDwcsExistingLoadMethods(boolean isOSS) {
        if (isOSS) {
            return new String[]{METHOD_CLOUD_LOAD_NAME};
        }
        return new String[]{METHOD_INSERT_EXEC_NAME, METHOD_INSERT_SCRIPT_NAME, METHOD_SQLLDR_NAME};
    }

    public static String[] getDwcsNewLoadMethods(boolean isOSS) {
        if (isOSS) {
            return new String[]{METHOD_CLOUD_LOAD_NAME, METHOD_EXTERNAL_TABLE_NAME};
        }
        return new String[]{METHOD_INSERT_EXEC_NAME, METHOD_INSERT_SCRIPT_NAME, METHOD_SQLLDR_NAME};
    }

    @Override
    protected void initFormat() {
        this.initConfigOptions(ICommonConfig.Storage.getInstance());
    }

    @Override
    protected void initConfigOptions(IStorage config) {
        if (this._usage == BaseDataFormat.IMPORT_WIZARD) {
            this._encoding = config.getString("IMP_ENCODING");
            Boolean x = config.getBoolean("IMPORT_USE_NLS_NUMERIC");
            this._useNlsNumeric = x;
            x = config.getBoolean("IMPORT_USE_PREVIEW_LIMIT");
            this._usePreviewLimit = x;
            this._previewLimit = config.getInt("IMPORT_PREVIEW_LIMIT");
            x = config.getBoolean("IMPORT_USE_LOAD_LIMIT");
            this._useLoadLimit = x;
            this._loadLimit = config.getInt("IMPORT_LOAD_LIMIT");
            this._maxLength = config.getInt("IMPORT_MAX_LENGTH");
            x = config.getBoolean("IMPORT_USE_MAX_LENGTH");
            this._useMaxLength = x;
        }
        super.initConfigOptions(config);
    }

    protected void initConfigFormatOptions(IStorage config) {
        super.initConfigOptions(config);
    }

    @Override
    public void saveFormatPreferences(IStorage config) {
        if (this._usage == BaseDataFormat.IMPORT_WIZARD) {
            config.putString("IMP_ENCODING", this._encoding);
            config.putBoolean("IMPORT_USE_NLS_NUMERIC", this._useNlsNumeric);
            config.putBoolean("IMPORT_USE_PREVIEW_LIMIT", this._usePreviewLimit);
            config.putInt("IMPORT_PREVIEW_LIMIT", this._previewLimit);
            config.putBoolean("IMPORT_USE_LOAD_LIMIT", this._useLoadLimit);
            config.putInt("IMPORT_LOAD_LIMIT", this._loadLimit);
            config.putInt("IMPORT_MAX_LENGTH", this._maxLength);
            config.putBoolean("IMPORT_USE_MAX_LENGTH", this._useMaxLength);
        }
        super.saveFormatPreferences(config);
    }

    static {
        ImportDataFormatConfig.DefaultInitializer.init();
        METHOD_INSERT_EXEC_NAME = ImportResources.getString("METHOD_INSERT_EXEC");
        METHOD_INSERT_SCRIPT_NAME = ImportResources.getString("METHOD_INSERT_SCRIPT");
        METHOD_EXTERNAL_TABLE_NAME = ImportResources.getString("METHOD_EXTERNAL_TABLE");
        METHOD_STAGING_EXTERNAL_TABLE_NAME = ImportResources.getString("METHOD_STAGING_EXTERNAL_TABLE");
        METHOD_SQLLDR_NAME = ImportResources.getString("METHOD_SQLLDR");
        METHOD_CLOUD_LOAD_NAME = ImportResources.getString("METHOD_CLOUD_LOAD");
        NEW_METHODS = new String[]{METHOD_INSERT_EXEC_NAME, METHOD_INSERT_SCRIPT_NAME, METHOD_EXTERNAL_TABLE_NAME, METHOD_STAGING_EXTERNAL_TABLE_NAME, METHOD_SQLLDR_NAME};
        EXISTING_METHODS = new String[]{METHOD_INSERT_EXEC_NAME, METHOD_INSERT_SCRIPT_NAME, METHOD_STAGING_EXTERNAL_TABLE_NAME, METHOD_SQLLDR_NAME};
        CLOUD_METHODS = new String[]{METHOD_SQLLDR_NAME};
        LINE_TERMINATOR = "STANDARD";
        TRUE = ": true";
        FALSE = ": false";
    }
}

