/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.export.service;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.common.utils.DBURLUtil;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.export.ExportResources;
import oracle.dbtools.export.service.ExportAPI;
import oracle.dbtools.export.service.ExportParms;
import oracle.dbtools.export.service.ImportGenLauncherCart;
import oracle.dbtools.export.service.XSCart;
import oracle.dbtools.extract.DeployJson;
import oracle.dbtools.extract.DeployPdbAPI;
import oracle.dbtools.extract.ExtractResources;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.extract.models.ExtractScript;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.writers.ImportGenDbmsCloud;
import oracle.dbtools.importer.writers.ImportGenModel;
import oracle.dbtools.raptor.deployment.DbmsCloudResources;
import oracle.dbtools.raptor.format.CSVFormatter;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.IToolRunMode;
import oracle.dbtools.raptor.utils.MessageHandler;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.ZipOutputHandler;

public class XSDeployCloudWallet
extends XSCart {
    private static final String SPACE = " ";
    private ExportParms _eParms;
    private DeployPdbAPI _deployPdbAPI;
    private ImportDataFormat _dboImportDataFormat;
    private ImportGenModel _iGenModel;
    private ZipOutputHandler _zipper;
    private String _zipFilePath;
    private String _controlFileName;
    private String _dataFileName;
    private CSVFormatter _pdbFormatter;
    public static final String countRows1 = "select count(*) from ";
    public static final String countRows2 = " where rownum < INSERT_LIMIT";

    @Override
    public ExitCode start(ExportParms eParms, IToolRunMode tRunMode) {
        this._eParms = eParms;
        this._zipFilePath = eParms.getTargetFormat().getSaveAs();
        ExitCode exitCode = super.start(eParms, tRunMode);
        return exitCode;
    }

    @Override
    public ExitCode validate() {
        return super.validate();
    }

    @Override
    public void export() throws Exception {
        ExitCode exitCode = this.startDeploy();
        if (exitCode == ExitCode.EXIT_SUCCESS || exitCode == ExitCode.EXIT_WARNING) {
            super.export();
        }
    }

    @Override
    public void initApex(String objectType) throws IOException {
        if (objectType.equals("APEX") || objectType.equals("APEX_PAGE")) {
            this.writeGenOutput(this.INIT_APEX_SQL());
        }
    }

    @Override
    public String getToolName() {
        return ExportResources.getString("DEPLOY_TOOL");
    }

    protected ExitCode startDeploy() {
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        this._deployPdbAPI = new DeployPdbAPI(this._eParms, this.getELogger());
        this._deployPdbAPI.setMonitor(this.getRunMode().getProcessMonitor());
        exitCode = this._deployPdbAPI.startDeploy(this._eParms.getName(), this._zipFilePath, this._eParms.getDestSchema(), this._eParms.getCloudStgLocation(), this._eParms.getCredential(), this.getTargetFormat().getLocationTestInfo());
        if (exitCode != ExitCode.EXIT_SEVERE) {
            if (!this._deployPdbAPI.insertDeployOperationMeta(1, new File(this._zipFilePath).getName(), "BUILD")) {
                String msg = DbmsCloudResources.getString((String)"DBMS_CLOUD_INSTALL_ERROR") + "\n" + exitCode.getShortMessage() + "\n" + exitCode.getMessage();
                MessageHandler.error(null, (String)msg, null, null, (String)this._deployPdbAPI.getLogAsText());
                this.getELogger().logError(msg);
                this.getELogger().log(this._deployPdbAPI.getLogAsText());
                return this._deployPdbAPI.getExitCode();
            }
            this._deployPdbAPI.finish();
            return this._deployPdbAPI.getExitCode();
        }
        String msg = DbmsCloudResources.getString((String)"DBMS_CLOUD_INSTALL_ERROR") + "\n" + exitCode.getShortMessage() + "\n" + exitCode.getMessage();
        MessageHandler.error(null, (String)msg, null, null, (String)this._deployPdbAPI.getLogAsText());
        this.getELogger().logError(msg);
        this.getELogger().log(this._deployPdbAPI.getLogAsText());
        if (this._deployPdbAPI != null) {
            this._deployPdbAPI.failed();
        }
        return exitCode;
    }

    @Override
    public ExitCode finish() {
        ExitCode deployExitCode = ExitCode.EXIT_ERROR;
        if (!this.isCancel()) {
            ExitCode exitCode = this._deployPdbAPI.restartDeploy();
            if (exitCode != ExitCode.EXIT_SUCCESS) {
                String msg = DbmsCloudResources.getString((String)"DBMS_CLOUD_CONNECTION_ERROR") + "\n" + exitCode.getShortMessage() + "\n" + exitCode.getMessage();
                MessageHandler.error(null, (String)msg, null, null, (String)this._deployPdbAPI.getLogAsText());
                this.getELogger().logError(msg);
                this.getELogger().log(this._deployPdbAPI.getLogAsText());
            }
            this._deployPdbAPI.setProgressUpdater(this.getRunMode().getTaskProgressUpdater());
            try {
                this.getELogger().finished();
                this._deployPdbAPI.updateDeployOperationMeta(1, "BUILD", DbmsCloudResources.getString((String)("DBMS_CLOUD_DEPLOY_" + this._deployPdbAPI.getDeployExitCode())), this.getELogger().getLogName(), null, null);
            }
            catch (Exception e) {
                Logger.warn(ExportAPI.class, (Throwable)e);
                this.eLogException(e);
            }
            deployExitCode = this._deployPdbAPI.executeDeploy();
            this._deployPdbAPI.finish();
        }
        return deployExitCode;
    }

    protected void taskCancelledProcess() {
        if (this._deployPdbAPI != null) {
            this._deployPdbAPI.cancelled();
        }
    }

    protected void taskFailedProcess() {
        if (this._deployPdbAPI != null) {
            this._deployPdbAPI.failed();
        }
    }

    @Override
    public String getDDL(ExtractObject eo, int type) {
        if (type == 2 && eo.isTypeDataFile()) {
            if (eo.isTypeDataFileExternalTable()) {
                return "";
            }
            ImportProperties iProps = eo.getImportProperties();
            iProps.put(ImportKeys.IS_CART, true);
            iProps.put(ImportKeys.IS_SOURCE_DBO, false);
            iProps.put(ImportKeys.IS_EXISTING_TABLE, true);
            ImportGenLauncherCart launcher = new ImportGenLauncherCart();
            launcher.start(iProps, this.getRunMode());
            this._iGenModel = launcher.getGenModel();
            return this._iGenModel.getCreateTableStatementWithComments(eo.getTableName()).trim();
        }
        return super.getDDL(eo, type);
    }

    @Override
    public void exportDataList(int type) {
        this._zipper = this.getGenOutput().getZipper();
        this._dboImportDataFormat = new ImportDataFormat(BaseDataFormat.CART, BaseDataFormat.CSV);
        this._dboImportDataFormat.setDelimiter(this.getDataFormat().getDelimiter());
        this._dboImportDataFormat.setEnclosureLeft(this.getDataFormat().getEnclosureLeft());
        this._dboImportDataFormat.setEnclosureRight(this.getDataFormat().getEnclosureRight());
        this._dboImportDataFormat.setRecordTerminator(this.getDataFormat().getRecordTerminator());
        this._dboImportDataFormat.setEncoding(this.getRunMode().getEncoding());
        this._dboImportDataFormat.isHeader(false);
        List<ExtractObject> eolist = this.getListModel().getList(type);
        for (ExtractObject eo : eolist) {
            try {
                String msg = ExtractResources.getString("OPERATION_BUILD") + SPACE + ExtractListModel.getListTypeName(type) + SPACE + eo.getTableName();
                this.taskProgress(msg);
                if (this.isCancel()) break;
                BasicDBObject dbo = eo.getDBObject();
                String objectName = eo.getExternalTableName();
                String objectType = eo.isTypeDataFile() ? "TABLE" : dbo.getObjectType();
                ExtractScript es = eo.getScript(112);
                this.getTargetFormat().setDataFormatExtension("csv");
                if (es == null) {
                    this.getGenOutput().startObject(objectName, "DATA_" + objectType);
                } else {
                    this.getGenOutput().startObject(objectName, "DATA_" + objectType, es.getType(), es.getPath());
                }
                this._dataFileName = this.getGenOutput().getCurrentFileName();
                this._controlFileName = this.getControlFileName();
                this._pdbFormatter = new CSVFormatter(){
                    boolean rowWritten = false;

                    public void start() throws IOException {
                        super.start();
                        this.rowWritten = false;
                    }

                    public void endRow() throws IOException {
                        super.endRow();
                        this.rowWritten = true;
                    }

                    public void end() throws IOException {
                        super.end();
                        if (!this.rowWritten) {
                            return;
                        }
                        this._zipper.closeEntry();
                    }
                };
                if (eo.isTypeDBO() && !eo.isEmptySelect()) {
                    this.doDataFile(eo);
                }
                this._zipper.openEntry(this._controlFileName);
                this.writeGenOutput(this.getControl(eo));
                this._zipper.closeEntry();
                this.exportScript(eo, 113);
            }
            catch (Exception e) {
                Logger.warn(ExportAPI.class, (Throwable)e);
                this.eLogException(e);
            }
        }
        if (eolist.size() > 0 && this._pdbFormatter != null) {
            this._pdbFormatter.finishExport();
        }
    }

    public void doDataFile(ExtractObject eo) throws Exception {
        this.taskProgress();
        try {
            this.taskProgress();
            BasicDBObject dbo = eo.getDBObject();
            String objectName = eo.getExternalTableName();
            this.initDataExport(eo, (ResultsFormatter)this._pdbFormatter);
            if (!eo.isEmptySelect()) {
                this.writeDataUsingFormatter(eo);
                this._zipper.closeEntry();
            }
            this._pdbFormatter.finishExport();
        }
        catch (IOException e) {
            Logger.warn(ExportAPI.class, (Throwable)e);
            this.eLogException(e);
        }
    }

    protected String getControl(ExtractObject eo) {
        ImportProperties iProps = null;
        ImportGenDbmsCloud gen = null;
        String whereClause = null;
        try {
            BasicDBObject dbo = eo.getDBObject();
            whereClause = eo.getFinalWhere();
            this.taskProgress(ExportResources.getString("EXTRACT_PROGRESS") + SPACE + eo.getExternalTableName());
            Boolean isOss = false;
            Boolean isLocal = false;
            Boolean isDbo = false;
            if (eo.isTypeDBO()) {
                iProps = new ImportProperties();
                iProps.put(ImportKeys.IS_SOURCE_DBO, true);
                iProps.put(ImportKeys.TABLE_NAME, dbo.getObjectName());
                isDbo = true;
            } else {
                iProps = eo.getImportProperties();
                iProps.put(ImportKeys.IS_SOURCE_DBO, false);
                iProps.put(ImportKeys.TABLE_NAME, eo.getExternalTableName());
                isOss = iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS);
                isLocal = isOss == false;
            }
            iProps.put(ImportKeys.CONNECTION_NAME, this._eParms.getDestConnName());
            iProps.put(ImportKeys.OBJECT_SCHEMA, this._eParms.getDestSchema());
            iProps.put(ImportKeys.IS_EXISTING_TABLE, true);
            GenericTable genTable = null;
            if (isDbo.booleanValue()) {
                iProps.put(ImportKeys.LOAD_METHOD, 5);
                genTable = new GenericTable(ConnectionResolver.getConnection((String)dbo.getConnectionName()), dbo.getSchemaName(), dbo.getObjectName(), true);
            } else {
                genTable = new GenericTable();
                genTable.setTableName((String)iProps.get(ImportKeys.TABLE_NAME));
            }
            URL url = DBURLUtil.getURL((String)"sqldev.nav", (String)this._eParms.getDestConnName(), null, (String)this._eParms.getDestSchema(), (String)"TABLE", (String)eo.getExternalTableName());
            BasicDBObject o = new BasicDBObject(url);
            iProps.put(ImportKeys.DBOBJECT, o);
            iProps.put(ImportKeys.IS_SOURCE_OSS, true);
            if (eo.isTypeDBO()) {
                iProps.put(ImportKeys.IMPORT_DATA_FORMAT, this._dboImportDataFormat);
                iProps.put(ImportKeys.MISSING_FIELDS, 0);
            }
            iProps.put(ImportKeys.USE_VALIDATE, false);
            iProps.put(ImportKeys.USE_VALIDATE_LIMIT, false);
            iProps.put(ImportKeys.VALIDATE_LIMIT, 0);
            iProps.put(ImportKeys.DROP_STAGING_TABLE, false);
            Boolean isCopyLog = iProps.getValueBoolean(ImportKeys.IS_COPY_LOG);
            Boolean isCopyBad = iProps.getValueBoolean(ImportKeys.IS_COPY_BAD);
            Boolean isDropBadAndLog = iProps.getValueBoolean(ImportKeys.IS_DROP_BAD_AND_LOG);
            iProps.put(ImportKeys.IS_COPY_LOG, false);
            iProps.put(ImportKeys.IS_COPY_BAD, false);
            iProps.put(ImportKeys.IS_DROP_BAD_AND_LOG, false);
            ImportGenLauncherCart launcher = new ImportGenLauncherCart();
            launcher.start(iProps, this.getRunMode());
            gen = (ImportGenDbmsCloud)launcher.getService();
            this._iGenModel = launcher.getGenModel();
            this._iGenModel.start(true);
            DeployJson ctl = new DeployJson();
            ctl.start();
            ctl.addString("isSourceDBO", isDbo.toString());
            ctl.addString("isSourceCloudFile", isOss.toString());
            ctl.addString("isSourceLocalFile", isLocal.toString());
            if (isDbo.booleanValue()) {
                ctl.addString("dataFileName", isDbo != false ? this._dataFileName : ((LoadFile)iProps.get(ImportKeys.LOAD_FILE)).getName());
                ctl.addString("dataFileCredential", this._eParms.getCredential());
            } else if (isLocal.booleanValue()) {
                LoadFile loadFile = (LoadFile)iProps.get(ImportKeys.LOAD_FILE);
                ctl.addString("dataFileName", loadFile.getShortName());
                String path = loadFile.getName();
                path = path.replace("\\", "\\\\");
                ctl.addString("dataFilePath", path);
                ctl.addString("dataFileCredential", this._eParms.getCredential());
            } else {
                ctl.addString("dataFilePath", (String)iProps.get(ImportKeys.OSS_PATH));
                ctl.addString("dataFileCredential", (String)iProps.get(ImportKeys.OSS_CREDENTIAL));
            }
            if (this._eParms.getCloudStgLocation() != null) {
                ctl.addString("targetStorageLocation", this._eParms.getCloudStgLocation());
            }
            if (this._eParms.getCredential() != null) {
                ctl.addString("targetCredential", this._eParms.getCredential());
            }
            ctl.addString("targetConnection", ConnectionResolver.getDisplayName((String)this._eParms.getDestConnName()));
            ctl.addString("targetSchema", this._eParms.getDestSchema());
            Boolean isUpLoad = isDbo != false || isLocal != false;
            ctl.addString("actionUploadPutData", isUpLoad.toString());
            int loadMethodOperation = iProps.getValueInteger(ImportKeys.LOAD_METHOD);
            if (loadMethodOperation == -1) {
                loadMethodOperation = 5;
            }
            if (loadMethodOperation == 5) {
                ctl.addString("actionCopyData", Boolean.TRUE.toString());
            } else if (loadMethodOperation == 2) {
                ctl.addString("actionExternalTable", Boolean.TRUE.toString());
                ctl.addString("actionValidateData", Boolean.TRUE.toString());
                String columns = gen.getColumnsAsString();
                ctl.addString("TargetColumns", columns);
                ctl.addString("isValidateLimit", iProps.getValueBoolean(ImportKeys.USE_VALIDATE_LIMIT).toString());
                ctl.addString("validateLimit", iProps.getValueInteger(ImportKeys.VALIDATE_LIMIT).toString());
            } else if (loadMethodOperation == 0) {
                ctl.addString("actionInsert", Boolean.TRUE.toString());
            }
            ctl.addString("dataFields", gen.getFields(SPACE, false, true));
            ctl.addString("dataCloudFormat", gen.getFormat());
            ctl.addString("targetTable", (String)iProps.get(ImportKeys.TABLE_NAME));
            ctl.addString("actionDropData", isUpLoad.toString());
            ctl.addString("actionCopyLog", isCopyLog.toString());
            ctl.addString("actionCopyBad", isCopyBad.toString());
            ctl.addString("actionDropBadAndLog", isDropBadAndLog.toString());
            ctl.addString("dataFileFormat", ((ImportDataFormat)iProps.get(ImportKeys.IMPORT_DATA_FORMAT)).getFormat());
            String fieldNames = "";
            String separator = "";
            if (isDbo.booleanValue()) {
                for (Column column : genTable.getColumns()) {
                    fieldNames = fieldNames + separator + column.getName();
                    separator = ",";
                }
            } else {
                LoadFile loadFile = (LoadFile)iProps.get(ImportKeys.LOAD_FILE);
                for (LoadField loadField : loadFile.getFields()) {
                    fieldNames = fieldNames + separator + loadField.getName();
                    separator = ",";
                }
            }
            ctl.addObject("displayFileFormat", this.getDataFormatForBad((ImportDataFormat)iProps.get(ImportKeys.IMPORT_DATA_FORMAT), fieldNames));
            this._iGenModel.closeConnClone();
            return ctl.end();
        }
        catch (Exception e) {
            Logger.warn(ExportAPI.class, (Throwable)e);
            this.eLogException(e);
            return "";
        }
    }

    private String getDataFormatForBad(ImportDataFormat dataFormat, String fields) {
        DeployJson ctl = new DeployJson();
        ctl.start();
        ctl.addString("fmtFields", fields);
        ctl.addString("dataFileFormat", dataFormat.getFormat());
        ctl.addString("fmtDelimiter", dataFormat.getDelimiter());
        ctl.addString("fmtEnclosureLeft", dataFormat.getEnclosureLeft().replace("\"", "\\\""));
        ctl.addString("fmtEnclosureRight", dataFormat.getEnclosureRight().replace("\"", "\\\""));
        ctl.addString("fmtEncoding", dataFormat.getEncoding());
        ctl.addString("fmtTerminator", dataFormat.getRecordTerminator());
        return ctl.end();
    }

    private String getControlFileName() {
        String fileName = this.getGenOutput().getCurrentFileName();
        if (fileName == null) {
            return "";
        }
        int extIndex = fileName.lastIndexOf(".");
        String baseFileName = extIndex != -1 ? fileName.substring(0, extIndex) : fileName;
        return baseFileName + ".ctl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRelativeSize(BasicDBObject dbo, String whereClause) {
        String count = "0";
        String schema = dbo.getSchemaName();
        if (schema == null) {
            schema = "";
        } else if (!schema.isEmpty()) {
            schema = schema + DBUtil.addDoubleQuote((String)schema) + ".";
        }
        String sql = countRows1 + schema + DBUtil.addDoubleQuote((String)dbo.getObjectName()) + SPACE + whereClause;
        Connection conn = dbo.getConnection();
        try {
            if (LockManager.lock((Connection)conn)) {
                count = DBUtil.getInstance((Connection)conn).executeReturnOneCol(sql, Collections.EMPTY_MAP);
            }
        }
        finally {
            if (conn != null) {
                LockManager.unlock((Connection)conn);
            }
        }
        return count != null ? Integer.valueOf(count) : 0;
    }
}

