/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.ddl.oracle;

import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.common.config.IEnvironmentConfig;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.DDLGenerator;
import oracle.dbtools.common.ddl.IObjectDDL;
import oracle.dbtools.common.ddl.oracle.OracleMetaSetup;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.common.utils.DBURLUtil;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.util.Logger;

public abstract class OracleObjectDDL
implements IObjectDDL {
    protected static final String LIST_OBJECTS = "list_objects";
    protected static final String GRANT_SQL = "grant_sql";
    protected static final String SCRIPT_DDL = "script_ddl";
    protected static final String DDL_KEY = "ddl_key";
    public Writer _out = DDLGenerator.getInstance().getWriter();
    public DDLFormat _format = DDLGenerator.getInstance().getFormating();
    private String _filter;
    protected String _EOL;

    private String getHeaderFmt() {
        String eol = this.getTerm();
        StringBuilder sb = new StringBuilder();
        sb.append(eol + "--------------------------------------------------------" + eol);
        sb.append("--  {0} for {1} {2}" + eol);
        sb.append("--------------------------------------------------------" + eol);
        return sb.toString();
    }

    protected final String getHeader(String type, String name) {
        return MessageFormat.format(this.getHeaderFmt(), "DDL", type, name);
    }

    protected final String getSubHeader(String type, String name, String subtype) {
        return MessageFormat.format(this.getHeaderFmt(), subtype, type, name);
    }

    protected String getDDLHeader(BasicDBObject obj) {
        return "";
    }

    protected String getQueryKey(String key) {
        return DDL_KEY.equals(key) ? SCRIPT_DDL : key;
    }

    protected String getQueryFile() {
        return this.getDefaultQueryFile();
    }

    private String getDefaultQueryFile() {
        return "META-INF/ddl/oracle/ObjectSql.xml";
    }

    protected final String getQuery(Connection conn, String id) {
        Query q = this.getQueryFromFile(conn, id, this.getQueryFile());
        if (q == null) {
            q = this.getQueryFromFile(conn, id, this.getDefaultQueryFile());
        }
        return q.getSql();
    }

    private Query getQueryFromFile(Connection conn, String id, String file) {
        QueryXMLSupport xml = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(this.getClass().getClassLoader(), file));
        Query q = xml.getQuery(id, conn);
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doGetDDL(BasicDBObject basicDBObject) {
        String sql = this.getQuery(basicDBObject.getConnection(), this.getQueryKey(DDL_KEY));
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.clear();
        binds.put("OWNER", basicDBObject.getSchemaName());
        binds.put("NAME", basicDBObject.getObjectName());
        ResultSet rset = null;
        Connection conn = basicDBObject.getConnection();
        if (LockManager.lock((Connection)conn)) {
            block8: {
                try {
                    DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
                    dbUtil.setRaiseError(false);
                    rset = dbUtil.executeQuery(sql, binds);
                    if (rset != null) {
                        while (rset.next()) {
                            sb.append(rset.getString(1) + this._EOL);
                        }
                        break block8;
                    }
                    this.generateOldWay(basicDBObject, sb);
                }
                catch (SQLException e) {
                    try {
                        sb = new StringBuilder();
                        this.generateOldWay(basicDBObject, sb);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(rset);
                        LockManager.unlock((Connection)conn);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)rset);
                    LockManager.unlock((Connection)conn);
                }
            }
            DBUtil.closeResultSet((ResultSet)rset);
            LockManager.unlock((Connection)conn);
        }
        String ret = sb.toString();
        if (!this._format.getSchema()) {
            ret = ret.replace("\"" + basicDBObject.getSchemaName() + "\".", "");
        }
        return ret;
    }

    @Override
    public String getDDL(BasicDBObject basicDBObject) throws Exception {
        return this.getDDL(basicDBObject, "DDL ");
    }

    @Override
    public String getDDL(BasicDBObject basicDBObject, String action) throws Exception {
        this.getTerm();
        new OracleMetaSetup(basicDBObject.getConnection(), action);
        return this.doGetDDL(basicDBObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doGetDDLScript(BasicDBObject basicDBObject) {
        String sql = this.getQuery(basicDBObject.getConnection(), this.getQueryKey(SCRIPT_DDL));
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.clear();
        binds.put("OWNER", basicDBObject.getSchemaName());
        binds.put("NAME", basicDBObject.getObjectName());
        this.addVersionBind(binds);
        StringBuilder sb = new StringBuilder();
        ResultSet rset = null;
        Connection conn = basicDBObject.getConnection();
        if (LockManager.lock((Connection)conn)) {
            block9: {
                try {
                    DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
                    dbUtil.setRaiseError(false);
                    rset = dbUtil.executeQuery(sql, binds);
                    if (rset != null) {
                        if (rset.next()) {
                            sb.append(this.getDDLHeader(basicDBObject));
                            do {
                                sb.append(rset.getString(1) + this.getTerm());
                            } while (rset.next());
                        }
                        break block9;
                    }
                    this.generateOldWay(basicDBObject, sb);
                }
                catch (SQLException e) {
                    try {
                        sb = new StringBuilder();
                        this.generateOldWay(basicDBObject, sb);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(rset);
                        LockManager.unlock((Connection)conn);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)rset);
                    LockManager.unlock((Connection)conn);
                }
            }
            DBUtil.closeResultSet((ResultSet)rset);
            LockManager.unlock((Connection)conn);
        }
        String ret = sb.toString();
        if (!this._format.getSchema()) {
            ret = ret.replace("\"" + basicDBObject.getSchemaName() + "\".", "");
        }
        return ret;
    }

    @Override
    public String getCopyDDL(BasicDBObject basicDBObject) throws Exception {
        this.getTerm();
        new OracleMetaSetup(basicDBObject.getConnection(), "COPY");
        return this.doGetDDLScript(basicDBObject);
    }

    @Override
    public String getScriptDDL(BasicDBObject basicDBObject) throws Exception {
        this.getTerm();
        new OracleMetaSetup(basicDBObject.getConnection(), "SCRIPT");
        return this.doGetDDLScript(basicDBObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getGrantsDDL(BasicDBObject basicDBObject) throws Exception {
        this.getTerm();
        new OracleMetaSetup(basicDBObject.getConnection(), "SCRIPT");
        StringBuilder sb = new StringBuilder();
        String sql = this.getQuery(basicDBObject.getConnection(), this.getQueryKey(GRANT_SQL));
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("OWNER", basicDBObject.getSchemaName());
        binds.put("NAME", basicDBObject.getObjectName());
        this.addVersionBind(binds);
        Connection conn = basicDBObject.getConnection();
        if (LockManager.lock((Connection)conn)) {
            DBUtil util = DBUtil.getInstance((Connection)conn);
            util.setRaiseError(false);
            ResultSet rset = util.executeQuery(sql, binds);
            try {
                if (rset != null) {
                    while (rset.next()) {
                        sb.append(rset.getString(1) + this._EOL);
                    }
                } else {
                    sb.append("");
                }
            }
            catch (Exception e) {
                sb.append("");
            }
            finally {
                DBUtil.closeResultSet((ResultSet)rset);
            }
            LockManager.unlock((Connection)conn);
        }
        return sb.toString();
    }

    protected Map<String, String> getObjectBinds(String schema, String type) {
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("OWNER", schema);
        binds.put("TYPE", type);
        return binds;
    }

    private void addVersionBind(Map<String, String> binds) {
        if (this._format != null) {
            binds.put("VERSION", this._format.getVersion());
        } else {
            binds.put("VERSION", DDLFormat.COMPATIBLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ArrayList<BasicDBObject> getSchemaObjects(Connection conn, String schema, String type) {
        String sql = this.getQuery(conn, this.getQueryKey(LIST_OBJECTS));
        ArrayList<BasicDBObject> objects = new ArrayList<BasicDBObject>();
        URL url = null;
        ResultSet rset = null;
        Map<String, String> binds = this.getObjectBinds(schema, type);
        rset = DBUtil.getInstance((Connection)conn).executeQuery(sql, binds);
        String dbName = ConnectionResolver.getConnectionName((Connection)conn);
        try {
            while (rset.next()) {
                url = DBURLUtil.getURL((String)"sqldev.nav", (String)dbName, null, (String)schema, (String)type, (String)rset.getString(1));
                objects.add(new BasicDBObject(url));
            }
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
        finally {
            DBUtil.closeResultSet((ResultSet)rset);
        }
        return objects;
    }

    public final String getTerm() {
        if (this._EOL == null) {
            this._EOL = IEnvironmentConfig.Storage.getInstance().getString("ENV_LINE_TERMINATOR");
        }
        return this._EOL;
    }

    @Override
    public void setFilter(String filter) {
        this._filter = filter;
    }

    public String getFilter() {
        return this._filter;
    }

    public DDLFormat getFormat() {
        return this._format;
    }

    protected void generateOldWay(BasicDBObject basicDBObject, StringBuilder sb) {
    }
}

