/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.ddl.oracle;

import java.sql.Connection;
import java.util.HashMap;
import oracle.dbtools.common.config.ICommonConfig;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.DDLFormatConfig;
import oracle.dbtools.common.ddl.DDLGenerator;
import oracle.dbtools.db.DBUtil;

public class OracleMetaSetup {
    Connection _conn = null;
    private static String META_SETUP;
    private static String META_SETUP_SCRIPT;

    public OracleMetaSetup(Connection conn, String type) {
        this._conn = conn;
        this.setup(type);
    }

    public void setConnection(Connection conn) {
        this._conn = conn;
    }

    private void setup(String type) {
        HashMap<String, Boolean> binds = new HashMap<String, Boolean>();
        DDLFormat _format = DDLGenerator.getInstance().getFormating();
        if (_format == null) {
            _format = new DDLFormat();
        }
        if (type.equals("SCRIPT")) {
            binds.put("CONSTRAINT", false);
            binds.put("REF_CONSTRAINT", false);
        } else if (type.equals("COPY")) {
            binds.put("CONSTRAINT", false);
            binds.put("REF_CONSTRAINT", false);
        } else if (type.startsWith("DDL ")) {
            binds.put("CONSTRAINT", true);
            binds.put("REF_CONSTRAINT", true);
            binds.put("ALTER", ICommonConfig.Storage.getInstance().getBoolean("DDL_ALTER"));
        }
        binds.put("SHOWSCHEMA", _format.getSchema());
        binds.put("SEGMENTS", _format.getSegments());
        binds.put("PARTITIONING", _format.getPartitioning());
        binds.put("TABLESPACE", _format.getTablespace());
        binds.put("TERMINATOR", _format.getTerminator());
        binds.put("PRETTY", _format.getPretty());
        binds.put("BYTE", _format.getByte());
        binds.put("FORCE", _format.getForce());
        DBUtil dbUtil = DBUtil.getInstance((Connection)this._conn);
        dbUtil.setRaiseError(false);
        if (type.equals("COPY") || type.equals("SCRIPT") || type.equals("DEP")) {
            dbUtil.execute(META_SETUP_SCRIPT, binds);
        } else {
            dbUtil.execute(META_SETUP, binds);
        }
    }

    static {
        DDLFormatConfig.DefaultInitializer.init();
        META_SETUP = "declare  FUNCTION ifelse (bool_in IN number)    RETURN boolean  IS  BEGIN    IF bool_in = 0    THEN      RETURN false;   ELSE      RETURN true;   END IF;  END;  begin   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'SEGMENT_ATTRIBUTES', ifelse(:SEGMENTS));   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'PARTITIONING', ifelse(:PARTITIONING));   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'TABLESPACE', ifelse(:TABLESPACE));   dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'SQLTERMINATOR', ifelse(:TERMINATOR));  dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'PRETTY', ifelse(:PRETTY));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'SIZE_BYTE_KEYWORD', ifelse(:BYTE));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'FORCE', ifelse(:FORCE));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'CONSTRAINTS_AS_ALTER', ifelse(:ALTER));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'EMIT_SCHEMA', ifelse(:SHOWSCHEMA));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'CONSTRAINTS', ifelse(:CONSTRAINT));   DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'REF_CONSTRAINTS', ifelse(:REF_CONSTRAINT)); end;";
        META_SETUP_SCRIPT = "declare  FUNCTION ifelse (bool_in IN number)    RETURN boolean  IS  BEGIN    IF bool_in = 0    THEN      RETURN false;   ELSE      RETURN true;   END IF;  END;  begin   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'SEGMENT_ATTRIBUTES', ifelse(:SEGMENTS));   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'PARTITIONING', ifelse(:PARTITIONING));   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'TABLESPACE', ifelse(:TABLESPACE));   dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM, 'SQLTERMINATOR',  ifelse(:TERMINATOR));  dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM, 'PRETTY',  ifelse(:PRETTY));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'SIZE_BYTE_KEYWORD',  ifelse(:BYTE));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'FORCE',  ifelse(:FORCE));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'EMIT_SCHEMA',  ifelse(:SHOWSCHEMA));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'CONSTRAINTS', ifelse(:CONSTRAINT));   DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'REF_CONSTRAINTS', ifelse(:REF_CONSTRAINT));   DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'CONSTRAINTS_AS_ALTER', false);  end;";
    }
}

