/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.ddl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.common.ddl.DDLResources;
import oracle.dbtools.common.utils.DBURLUtil;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.util.Logger;

public final class DDLTypes {
    public static final String DROP = "DROP";
    public static final String DATA = "DATA";
    public static final String TRUNCATE = "TRUNCATE";
    public static final String APEX_PAGE = "APEX_PAGE";
    public static final String APEX = "APEX";
    public static final String QUEUETABLE = "QUEUE TABLE";
    public static final String REFCONSTRAINT = "REFCONSTRAINT";
    public static final String CONSTRAINT = "CONSTRAINT";
    public static final String QUEUE = "QUEUE";
    public static final String DIRECTORY = "DIRECTORY";
    public static final String MATVIEWLOG = "MATERIALIZED VIEW LOG";
    public static final String SYNONYM = "SYNONYM";
    public static final String DBLINK = "DATABASE LINK";
    public static final String FUNCTION = "FUNCTION";
    public static final String OPERATOR = "OPERATOR";
    public static final String INDEX = "INDEX";
    public static final String MATVIEW = "MATERIALIZED VIEW";
    public static final String PACKSPEC = "PACKAGE";
    public static final String PACKBODY = "PACKAGE BODY";
    public static final String PROCEDURE = "PROCEDURE";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String TABLE = "TABLE";
    public static final String TRIGGER = "TRIGGER";
    public static final String TYPE = "TYPE";
    public static final String EDITION_VIEW = "EDITION_VIEW";
    public static final String VIEW = "VIEW";
    public static final String[] DATA_OBJECT_URL_TYPES = new String[]{"TABLE", "VIEW", "EDITION_VIEW", "MATERIALIZED+VIEW"};
    public static final String[] DATA_OBJECT_TYPES = new String[]{"TABLE", "VIEW", "MATERIALIZED VIEW", "EDITION_VIEW"};
    public static final LinkedHashMap<String, String> ret = new LinkedHashMap();
    public static final ArrayList<String> standardTypes = new ArrayList();
    public static final ArrayList<String> extensionTypes = new ArrayList();
    private static final Set<DDLTypeDef> sTypeList = new LinkedHashSet<DDLTypeDef>();
    private final Map<String, State> mStates = new HashMap<String, State>();
    private boolean _doTabDeps = false;
    private boolean _showTabDeps = false;
    private static final String[] TYPES_WITH_DATA;
    private static final String[] TYPES_WITH_DATA_XVIEW;

    public static void registerDDLType(String type, boolean createPreData, boolean canDrop, boolean defaultState, boolean defaultShow) {
        sTypeList.add(new DDLTypeDef(type, DDLTypes.initCap(type), createPreData, canDrop, defaultState, defaultShow));
        extensionTypes.add(type);
    }

    public static void registerDDLType(String type, String label, boolean createPreData, boolean canDrop, boolean defaultState, boolean defaultShow) {
        sTypeList.add(new DDLTypeDef(type, label, createPreData, canDrop, defaultState, defaultShow));
        extensionTypes.add(type);
    }

    public static void registerDDLType(String type, boolean createPreData) {
        sTypeList.add(new DDLTypeDef(type, DDLTypes.initCap(type), createPreData));
        extensionTypes.add(type);
    }

    public static void registerDDLType(String type, String label, boolean createPreData) {
        sTypeList.add(new DDLTypeDef(type, label, createPreData));
        extensionTypes.add(type);
    }

    private static void registerDDLTypeStandard(String type, String label, boolean createPreData) {
        sTypeList.add(new DDLTypeDef(type, label, createPreData));
        standardTypes.add(type);
    }

    private static void registerDDLTypeStandard(String type, boolean createPreData, boolean canDrop, boolean defaultState, boolean defaultShow) {
        sTypeList.add(new DDLTypeDef(type, type, createPreData, canDrop, defaultState, defaultShow));
        standardTypes.add(type);
    }

    private static void registerDDLTypeStandard(String type, String label, boolean createPreData, boolean canDrop, boolean defaultState, boolean defaultShow) {
        sTypeList.add(new DDLTypeDef(type, label, createPreData, canDrop, defaultState, defaultShow));
        standardTypes.add(type);
    }

    public DDLTypes() {
        for (DDLTypeDef def : sTypeList) {
            State s = new State(def.label, def.defaultState, def.defaultShown);
            this.mStates.put(def.type, s);
        }
    }

    public void setEnable(boolean value) {
        for (Map.Entry<String, State> e : this.mStates.entrySet()) {
            State oldState = e.getValue();
            if (oldState.enable == value) continue;
            e.setValue(new State(oldState.label, value, oldState.show));
        }
        this._doTabDeps = value;
    }

    public void setShow(boolean value) {
        for (Map.Entry<String, State> e : this.mStates.entrySet()) {
            State oldState = e.getValue();
            if (oldState.show == value) continue;
            e.setValue(new State(oldState.label, oldState.enable, value));
        }
        this._showTabDeps = value;
    }

    public void setTypeState(String type, boolean value) {
        State s = this.mStates.get(type);
        if (s == null) {
            Logger.warn(DDLTypes.class, (String)("DDL type " + type + " not registered."));
            this.mStates.put(type, new State(type, value, false));
        } else if (s.enable != value) {
            this.mStates.put(type, new State(s.label, value, s.show));
        }
    }

    public boolean getTypeState(String type) {
        State s = this.mStates.get(type);
        return s != null && s.enable && s.show;
    }

    public void setTypeShown(String type, boolean value) {
        State s = this.mStates.get(type);
        if (s == null) {
            Logger.warn(DDLTypes.class, (String)("DDL type " + type + " not registered."));
            this.mStates.put(type, new State(type, false, value));
        } else if (s.show != value) {
            this.mStates.put(type, new State(s.label, s.enable, value));
        }
    }

    public boolean isTypeShown(String type) {
        State s = this.mStates.get(type);
        return s != null && s.show;
    }

    public String getTypeLabel(String type) {
        State s = this.mStates.get(type);
        return s != null ? s.label : type;
    }

    public void setView(boolean value) {
        this.setTypeState(VIEW, value);
    }

    public void setType(boolean value) {
        this.setTypeState(TYPE, value);
    }

    public void setTrigger(boolean value) {
        this.setTypeState(TRIGGER, value);
    }

    public void setTable(boolean value) {
        this.setTypeState(TABLE, value);
    }

    public void setSequence(boolean value) {
        this.setTypeState(SEQUENCE, value);
    }

    public void setProcedure(boolean value) {
        this.setTypeState(PROCEDURE, value);
    }

    public void setPackBody(boolean value) {
        this.setTypeState(PACKBODY, value);
    }

    public void setPackSpec(boolean value) {
        this.setTypeState(PACKSPEC, value);
    }

    public void setMatView(boolean value) {
        this.setTypeState(MATVIEW, value);
    }

    public void setIndex(boolean value) {
        this.setTypeState(INDEX, value);
    }

    public void setFunction(boolean value) {
        this.setTypeState(FUNCTION, value);
    }

    public void setOperator(boolean value) {
        this.setTypeState(OPERATOR, value);
    }

    public void setDbLink(boolean value) {
        this.setTypeState(DBLINK, value);
    }

    public void setConstraint(boolean value) {
        this.setTypeState(CONSTRAINT, value);
    }

    public void setRefConstraint(boolean value) {
        this.setTypeState(REFCONSTRAINT, value);
    }

    public void setSynonymn(boolean value) {
        this.setTypeState(SYNONYM, value);
    }

    public void setMatViewLog(boolean value) {
        this.setTypeState(MATVIEWLOG, value);
    }

    public void setTableDeps(boolean value) {
        this._doTabDeps = value;
    }

    public void setDirectory(boolean value) {
        this.setTypeState(DIRECTORY, value);
    }

    public void setQueue(boolean value) {
        this.setTypeState(QUEUE, value);
    }

    public void setQueueTable(boolean value) {
        this.setTypeState(QUEUETABLE, value);
    }

    public void setApex(boolean value) {
        this.setTypeState(APEX, value);
    }

    public void setApexPage(boolean value) {
        this.setTypeState(APEX_PAGE, value);
    }

    public boolean getView() {
        return this.getTypeState(VIEW);
    }

    public boolean getType() {
        return this.getTypeState(TYPE);
    }

    public boolean getTrigger() {
        return this.getTypeState(TRIGGER);
    }

    public boolean getTable() {
        return this.getTypeState(TABLE);
    }

    public boolean getSequence() {
        return this.getTypeState(SEQUENCE);
    }

    public boolean getProcedure() {
        return this.getTypeState(PROCEDURE);
    }

    public boolean getPackBody() {
        return this.getTypeState(PACKBODY);
    }

    public boolean getPackSpec() {
        return this.getTypeState(PACKSPEC);
    }

    public boolean getMatView() {
        return this.getTypeState(MATVIEW);
    }

    public boolean getIndex() {
        return this.getTypeState(INDEX);
    }

    public boolean getFunction() {
        return this.getTypeState(FUNCTION);
    }

    public boolean getOperator() {
        return this.getTypeState(OPERATOR);
    }

    public boolean getDbLink() {
        return this.getTypeState(DBLINK);
    }

    public boolean getConstraint() {
        return this.getTypeState(CONSTRAINT);
    }

    public boolean getRefConstraint() {
        if (!this.isTypeShown(REFCONSTRAINT)) {
            return this.getTypeState(CONSTRAINT);
        }
        return this.getTypeState(REFCONSTRAINT);
    }

    public boolean getSynonymn() {
        return this.getTypeState(SYNONYM);
    }

    public boolean getMatViewLog() {
        return this.getTypeState(MATVIEWLOG);
    }

    public boolean getTableDeps() {
        return this._showTabDeps && this._doTabDeps;
    }

    public boolean getDirectory() {
        return this.getTypeState(DIRECTORY);
    }

    public boolean getQueue() {
        return this.getTypeState(QUEUE);
    }

    public boolean getQueueTable() {
        return this.getTypeState(QUEUETABLE);
    }

    public boolean getApex() {
        return this.getTypeState(APEX);
    }

    public boolean getApexPage() {
        return this.getTypeState(APEX_PAGE);
    }

    public void setShowView(boolean value) {
        this.setTypeShown(VIEW, value);
    }

    public void setShowType(boolean value) {
        this.setTypeShown(TYPE, value);
    }

    public void setShowTrigger(boolean value) {
        this.setTypeShown(TRIGGER, value);
    }

    public void setShowTable(boolean value) {
        this.setTypeShown(TABLE, value);
    }

    public void setShowSequence(boolean value) {
        this.setTypeShown(SEQUENCE, value);
    }

    public void setShowProcedure(boolean value) {
        this.setTypeShown(PROCEDURE, value);
    }

    public void setShowPackBody(boolean value) {
        this.setTypeShown(PACKBODY, value);
    }

    public void setShowPackSpec(boolean value) {
        this.setTypeShown(PACKSPEC, value);
    }

    public void setShowMatView(boolean value) {
        this.setTypeShown(MATVIEW, value);
    }

    public void setShowIndex(boolean value) {
        this.setTypeShown(INDEX, value);
    }

    public void setShowFunction(boolean value) {
        this.setTypeShown(FUNCTION, value);
    }

    public void setShowOperator(boolean value) {
        this.setTypeShown(OPERATOR, value);
    }

    public void setShowDbLink(boolean value) {
        this.setTypeShown(DBLINK, value);
    }

    public void setShowData(boolean value) {
    }

    public void setShowConstraint(boolean value) {
        this.setTypeShown(CONSTRAINT, value);
    }

    public void setShowRefConstraint(boolean value) {
        this.setTypeShown(REFCONSTRAINT, value);
    }

    public void setShowSynonymn(boolean value) {
        this.setTypeShown(SYNONYM, value);
    }

    public void setShowMatViewLog(boolean value) {
        this.setTypeShown(MATVIEWLOG, value);
    }

    public void setShowTableDeps(boolean value) {
        this._showTabDeps = value;
    }

    public void setShowDirectory(boolean value) {
        this.setTypeShown(DIRECTORY, value);
    }

    public void setShowQueue(boolean value) {
        this.setTypeShown(QUEUE, value);
    }

    public void setShowQueueTable(boolean value) {
        this.setTypeShown(QUEUETABLE, value);
    }

    public void setShowApex(boolean value) {
        this.setTypeShown(APEX, value);
    }

    public void setShowApexPage(boolean value) {
        this.setTypeShown(APEX_PAGE, value);
    }

    public boolean getShowView() {
        return this.isTypeShown(VIEW);
    }

    public boolean getShowType() {
        return this.isTypeShown(TYPE);
    }

    public boolean getShowTrigger() {
        return this.isTypeShown(TRIGGER);
    }

    public boolean getShowTable() {
        return this.isTypeShown(TABLE);
    }

    public boolean getShowSequence() {
        return this.isTypeShown(SEQUENCE);
    }

    public boolean getShowProcedure() {
        return this.isTypeShown(PROCEDURE);
    }

    public boolean getShowPackBody() {
        return this.isTypeShown(PACKBODY);
    }

    public boolean getShowPackSpec() {
        return this.isTypeShown(PACKSPEC);
    }

    public boolean getShowMatView() {
        return this.isTypeShown(MATVIEW);
    }

    public boolean getShowIndex() {
        return this.isTypeShown(INDEX);
    }

    public boolean getShowFunction() {
        return this.isTypeShown(FUNCTION);
    }

    public boolean getShowOperator() {
        return this.isTypeShown(OPERATOR);
    }

    public boolean getShowDbLink() {
        return this.isTypeShown(DBLINK);
    }

    public boolean getShowConstraint() {
        return this.isTypeShown(CONSTRAINT);
    }

    public boolean getShowRefConstraint() {
        return this.isTypeShown(REFCONSTRAINT);
    }

    public boolean getShowSynonymn() {
        return this.isTypeShown(SYNONYM);
    }

    public boolean getShowMatViewLog() {
        return this.isTypeShown(MATVIEWLOG);
    }

    public boolean getShowTableDeps() {
        return this._showTabDeps;
    }

    public boolean getShowDirectory() {
        return this.isTypeShown(DIRECTORY);
    }

    public boolean getShowQueue() {
        return this.isTypeShown(QUEUE);
    }

    public boolean getShowQueueTable() {
        return this.isTypeShown(QUEUETABLE);
    }

    public boolean getShowApex() {
        return this.isTypeShown(APEX);
    }

    public boolean getShowApexPage() {
        return this.isTypeShown(APEX_PAGE);
    }

    public List<String> getTypes(int listType) {
        switch (listType) {
            case 1: {
                return this.getCreateTypes();
            }
            case 2: {
                return this.getCreatePreDataTypes();
            }
            case 3: {
                return this.getCreatePostDataTypes();
            }
            case 4: {
                return this.getDropTypes();
            }
            case 5: {
                return this.getTableType();
            }
            case 6: {
                return this.getTableType();
            }
            case 7: {
                return this.getTableType();
            }
        }
        return null;
    }

    public List<String> getCreateTypes() {
        ArrayList<String> ret = new ArrayList<String>();
        for (DDLTypeDef def : sTypeList) {
            if (!this.getTypeState(def.type)) continue;
            ret.add(def.type);
        }
        return ret;
    }

    public List<String> getCreatePreDataTypes() {
        ArrayList<String> ret = new ArrayList<String>();
        for (DDLTypeDef def : sTypeList) {
            if (!def.createPreData || !this.getTypeState(def.type)) continue;
            ret.add(def.type);
        }
        return ret;
    }

    public List<String> getCreatePostDataTypes() {
        ArrayList<String> ret = new ArrayList<String>();
        for (DDLTypeDef def : sTypeList) {
            if (def.createPreData || !this.getTypeState(def.type)) continue;
            ret.add(def.type);
        }
        return ret;
    }

    public List<String> getDropTypes() {
        ArrayList<String> ret = new ArrayList<String>();
        for (DDLTypeDef def : sTypeList) {
            if (!def.canDrop || !this.getTypeState(def.type)) continue;
            ret.add(def.type);
        }
        if (ret.contains(TABLE)) {
            ret.remove(TRIGGER);
            ret.remove(INDEX);
        }
        return new ArrayList<String>(ret);
    }

    public List<String> getTableType() {
        return this.getTypeState(TABLE) ? Collections.singletonList(TABLE) : Collections.emptyList();
    }

    public Map<String, String> getTypes(boolean isDataEnabled) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        for (DDLTypeDef def : sTypeList) {
            if (!this.getTypeState(def.type)) continue;
            ret.put(def.type, def.key);
        }
        if (isDataEnabled) {
            ret.put(DATA, "Oracle#DATA");
        }
        return ret;
    }

    public String getTypeKey(String type) {
        for (DDLTypeDef def : sTypeList) {
            if (!def.type.equals(type)) continue;
            return def.key;
        }
        return "";
    }

    public boolean isSupportedType(String type) {
        return DATA.equals(type) || this.getTypeState(type);
    }

    public boolean isSupportedFolderType(String type) {
        if (type.endsWith("_FOLDER")) {
            String folderType = type.substring(0, type.length() - 7);
            return this.getTypeState(folderType);
        }
        return false;
    }

    public List<String> getTypeList() {
        ArrayList<String> ret = new ArrayList<String>();
        for (DDLTypeDef def : sTypeList) {
            if (CONSTRAINT.equals(def.type) || REFCONSTRAINT.equals(def.type) || !this.getTypeState(def.type)) continue;
            ret.add(def.type);
        }
        return ret;
    }

    public List<String> getTypeListForData() {
        return this.getTypeListForData(true);
    }

    public List<String> getTypeListForData(boolean includeViews) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String type : includeViews ? TYPES_WITH_DATA : TYPES_WITH_DATA_XVIEW) {
            if (!this.getTypeState(type)) continue;
            ret.add(type);
        }
        return ret;
    }

    public String getAllTypes() {
        String ret = "";
        for (String s : this.getTypeList()) {
            ret = s + ":" + ret;
        }
        return ret;
    }

    public void setTypes(List<ExtractObject> EOList) {
        this.setTypes(EOList, true);
    }

    public void setTypes(List<ExtractObject> EOList, boolean tableComplete) {
        this.setEnable(false);
        for (ExtractObject EO : EOList) {
            if (EO.getType() == 0) {
                URL u = EO.getDBObject().getURL();
                String baseType = DBURLUtil.getParsedURL((URL)u).getObjectType();
                if (u == null) continue;
                if (EDITION_VIEW.equals(baseType)) {
                    baseType = VIEW;
                }
                if (!this.mStates.containsKey(baseType)) continue;
                this.setTypeState(baseType, true);
                if (TABLE.equals(baseType) && tableComplete) {
                    this.setTypeState(CONSTRAINT, true);
                    this.setTypeState(REFCONSTRAINT, true);
                    this.setTypeState(INDEX, true);
                    this.setTypeState(TRIGGER, true);
                    continue;
                }
                if (VIEW.equals(baseType) && tableComplete) {
                    this.setTypeState(TRIGGER, true);
                    continue;
                }
                if (!APEX.equals(baseType) && !APEX_PAGE.equals(baseType)) continue;
                this.setTypeShown(baseType, true);
                continue;
            }
            if (EO.getType() != 4) continue;
            this.setTypeState(TABLE, true);
            if (!tableComplete) continue;
            this.setTypeState(CONSTRAINT, true);
            this.setTypeState(REFCONSTRAINT, true);
            this.setTypeState(INDEX, true);
            this.setTypeState(TRIGGER, true);
        }
    }

    public static String getFolderName(String type) {
        String key = type.replaceAll(" ", "_") + "_FOLDER_LABEL";
        return DDLResources.getString(key);
    }

    public static String initCap(String in) {
        if (in == null || in.length() == 0) {
            return in;
        }
        boolean capitalize = true;
        char[] data = in.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == ' ' || Character.isWhitespace(data[i])) {
                capitalize = true;
                continue;
            }
            if (capitalize) {
                data[i] = Character.toUpperCase(data[i]);
                capitalize = false;
                continue;
            }
            data[i] = Character.toLowerCase(data[i]);
        }
        return new String(data);
    }

    static {
        DDLTypes.registerDDLTypeStandard(DBLINK, DDLResources.getString("DB_LINK"), true);
        DDLTypes.registerDDLTypeStandard(TYPE, DDLResources.getString(TYPE), true);
        DDLTypes.registerDDLTypeStandard(SEQUENCE, DDLResources.getString("SEQ"), true);
        DDLTypes.registerDDLTypeStandard(TABLE, DDLResources.getString("TAB"), true);
        DDLTypes.registerDDLTypeStandard(VIEW, DDLResources.getString(VIEW), true);
        DDLTypes.registerDDLTypeStandard(MATVIEW, DDLResources.getString("MAT_VIEW"), true);
        DDLTypes.registerDDLTypeStandard(INDEX, DDLResources.getString("IND"), false);
        DDLTypes.registerDDLTypeStandard(TRIGGER, DDLResources.getString("TRIG"), false);
        DDLTypes.registerDDLTypeStandard(MATVIEWLOG, DDLResources.getString("MAT_VIEW_LOG"), false);
        DDLTypes.registerDDLTypeStandard(PROCEDURE, DDLResources.getString("PROC"), false);
        DDLTypes.registerDDLTypeStandard(PACKSPEC, DDLResources.getString("PACKS"), false);
        DDLTypes.registerDDLTypeStandard(PACKBODY, DDLResources.getString("PACKB"), false);
        DDLTypes.registerDDLTypeStandard(FUNCTION, DDLResources.getString("FUN"), false);
        DDLTypes.registerDDLTypeStandard(OPERATOR, DDLResources.getString("OPER"), false);
        DDLTypes.registerDDLTypeStandard(SYNONYM, DDLResources.getString("SYN"), false);
        DDLTypes.registerDDLTypeStandard(QUEUE, DDLResources.getString("QUEUE_TABLE"), false);
        DDLTypes.registerDDLTypeStandard(QUEUETABLE, DDLResources.getString("QUEUE_TABLE"), false);
        DDLTypes.registerDDLTypeStandard(CONSTRAINT, DDLResources.getString("CONS"), false, false, true, true);
        DDLTypes.registerDDLTypeStandard(REFCONSTRAINT, DDLResources.getString("REF_CONS"), false, false, true, true);
        DDLTypes.registerDDLTypeStandard(DIRECTORY, DDLResources.getString(DIRECTORY), false, true, false, false);
        DDLTypes.registerDDLTypeStandard(APEX, false, false, false, false);
        DDLTypes.registerDDLTypeStandard(APEX_PAGE, false, false, false, false);
        TYPES_WITH_DATA = new String[]{TABLE, VIEW, MATVIEW};
        TYPES_WITH_DATA_XVIEW = new String[]{TABLE};
    }

    private static final class DDLTypeDef {
        private final String type;
        private final String label;
        private final String key;
        private final boolean createPreData;
        private final boolean canDrop;
        private final boolean defaultState;
        private final boolean defaultShown;

        public DDLTypeDef(String type, boolean createPreData) {
            this(type, createPreData, true, true, true);
        }

        public DDLTypeDef(String type, String label, boolean createPreData) {
            this(type, label, createPreData, true, true, true);
        }

        DDLTypeDef(String type, boolean createPreData, boolean canDrop, boolean defaultState, boolean defaultShown) {
            this(type, type, createPreData, true, true, true);
        }

        public DDLTypeDef(String type, String label, boolean createPreData, boolean canDrop, boolean defaultState, boolean defaultShown) {
            this.type = type;
            this.label = label;
            this.createPreData = createPreData;
            this.canDrop = canDrop;
            this.defaultState = defaultState;
            this.defaultShown = defaultShown;
            this.key = "Oracle#" + type.replace(' ', '_');
        }
    }

    private static final class State {
        final String label;
        final boolean enable;
        final boolean show;

        State(String label, boolean enable, boolean show) {
            this.label = label;
            this.enable = enable;
            this.show = show;
        }
    }
}

