/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.common.format;

import java.util.Locale;

public abstract class IntegerFormatter<E extends Exception> {
    private static final byte MODIFIER_ORDINAL = 1;
    private static final byte MODIFIER_TRADITIONAL = 2;
    private static String[] NUMBER_WORDS = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen"};
    private static String[] NUMBER_TENS = new String[]{"Twent", "Thirt", "Fort", "Fift", "Sixt", "Sevent", "Eight", "Ninet"};
    private static String[] NUMBER_WORDS_ORD = new String[]{"Zeroth", "First", "Second", "Third", "Fourth", "Fifth", "Sixth", "Seventh", "Eighth", "Ninth", "Tenth", "Eleventh", "Twelfth", "Thirteenth", "Fourteenth", "Fifteenth", "Sixteenth", "Seventeenth", "Eighteenth", "Nineteenth"};

    protected abstract E createInvalidPictureStringException(String var1);

    protected abstract E notSupported(String var1);

    public void formatInteger(long l, String string, StringBuilder stringBuilder) throws E {
        byte by;
        int n;
        int n2 = string.length();
        boolean bl = false;
        for (by = 0; by < string.length(); by += Character.charCount(n)) {
            n = string.codePointAt(by);
            if (n == 59) {
                n2 = by;
                if (by != 0) continue;
                throw this.createInvalidPictureStringException(string);
            }
            if (!Character.isDigit(n)) continue;
            bl = true;
        }
        if (n2 == 0) {
            throw this.createInvalidPictureStringException(string);
        }
        by = this.parseModifier(string, n2 + 1);
        if (l < 0L) {
            l = Math.abs(l);
            stringBuilder.append("-");
        }
        if (bl) {
            this.formatPattern(l, string, 0, n2 - 1, stringBuilder);
            if (IntegerFormatter.ordinal(by)) {
                IntegerFormatter.formatNumberOrdinal(l, stringBuilder);
            }
            return;
        }
        n = string.charAt(0);
        switch (n) {
            case 65: {
                IntegerFormatter.formatNumberA(l, true, stringBuilder);
                return;
            }
            case 97: {
                IntegerFormatter.formatNumberA(l, false, stringBuilder);
                return;
            }
            case 73: {
                IntegerFormatter.formatRoman(l, true, stringBuilder);
                return;
            }
            case 105: {
                IntegerFormatter.formatRoman(l, false, stringBuilder);
                return;
            }
            case 87: {
                if (string.length() > 1 && string.charAt(1) == 'w') {
                    this.formatNumberName(l, IntegerFormatter.ordinal(by), null, stringBuilder);
                } else {
                    this.formatNumberName(l, IntegerFormatter.ordinal(by), true, stringBuilder);
                }
                return;
            }
            case 119: {
                this.formatNumberName(l, IntegerFormatter.ordinal(by), false, stringBuilder);
                return;
            }
        }
        stringBuilder.append(Long.toString(l));
        if (IntegerFormatter.ordinal(by)) {
            IntegerFormatter.formatNumberOrdinal(l, stringBuilder);
        }
    }

    private static boolean ordinal(byte by) {
        return (by & 1) != 0;
    }

    private byte parseModifier(String string, int n) throws E {
        if (n >= string.length()) {
            return 0;
        }
        byte by = 0;
        char c = string.charAt(n);
        if (c == 'c' || c == 'o') {
            if (c == 'o') {
                by = (byte)(by | 1);
            }
            if (++n >= string.length()) {
                return by;
            }
            c = string.charAt(n);
            if (c == '(') {
                int n2;
                for (n2 = ++n; n2 < string.length() && string.charAt(n2) != ')'; ++n2) {
                }
                if (n2 == string.length()) {
                    throw this.createInvalidPictureStringException(string);
                }
                String string2 = string.substring(n, n2);
                if (!"".equals(string2) && !"-en".equals(string2)) {
                    throw this.createInvalidPictureStringException(string);
                }
                n = n2 + 1;
                if (n >= string.length()) {
                    return by;
                }
                c = string.charAt(n);
            }
        }
        if (c == 't' || c == 'a') {
            if (c == 't') {
                by = (byte)(by | 2);
            }
            if (++n == string.length()) {
                return by;
            }
        }
        throw this.createInvalidPictureStringException(string);
    }

    protected void formatNumberName(long l, boolean bl, Boolean bl2, StringBuilder stringBuilder) throws E {
        long l2 = 0L;
        boolean bl3 = false;
        if (l == 0L) {
            if (bl) {
                stringBuilder.append(IntegerFormatter.upper(NUMBER_WORDS_ORD[0], bl2));
            } else {
                stringBuilder.append(IntegerFormatter.upper(NUMBER_WORDS[0], bl2));
            }
            return;
        }
        long l3 = stringBuilder.length();
        if (l >= 1000L) {
            l2 = l / 1000L;
            if (l2 > (long)NUMBER_WORDS.length) {
                throw this.notSupported(String.valueOf(l));
            }
            stringBuilder.append(IntegerFormatter.upper(NUMBER_WORDS[(int)l2], bl2)).append(' ').append(IntegerFormatter.upper("Thousand", bl2));
            if ((l %= 1000L) == 0L && bl) {
                stringBuilder.append(IntegerFormatter.upper("th", bl2));
            }
            bl3 = true;
        }
        if (l >= 100L) {
            l2 = l / 100L;
            if ((long)stringBuilder.length() > l3) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(IntegerFormatter.upper(NUMBER_WORDS[(int)l2], bl2)).append(IntegerFormatter.upper(" Hundred", bl2));
            if ((l %= 100L) == 0L && bl) {
                stringBuilder.append(IntegerFormatter.upper("th", bl2));
            }
            bl3 = true;
        }
        if (l >= 20L) {
            if (bl3) {
                stringBuilder.append(IntegerFormatter.upper(" and", bl2));
            }
            l2 = l / 10L;
            if ((long)stringBuilder.length() > l3) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(IntegerFormatter.upper(NUMBER_TENS[(int)(l2 - 2L)], bl2));
            if ((l %= 10L) == 0L && bl) {
                stringBuilder.append(IntegerFormatter.upper("ieth", bl2));
            } else {
                stringBuilder.append(IntegerFormatter.upper("y", bl2));
            }
            bl3 = false;
        }
        if (l == 0L) {
            return;
        }
        if (!bl) {
            if (bl3) {
                stringBuilder.append(IntegerFormatter.upper(" and", bl2));
            }
            if ((long)stringBuilder.length() > l3) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(IntegerFormatter.upper(NUMBER_WORDS[(int)l], bl2));
        } else {
            if (bl3) {
                stringBuilder.append(IntegerFormatter.upper(" and", bl2));
            }
            if ((long)stringBuilder.length() > l3) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(IntegerFormatter.upper(NUMBER_WORDS_ORD[(int)l], bl2));
        }
    }

    private static Object upper(String string, Boolean bl) {
        if (bl == null) {
            return string;
        }
        if (bl.booleanValue()) {
            return string.toUpperCase(Locale.US);
        }
        return string.toLowerCase(Locale.US);
    }

    protected static void formatNumberOrdinal(long l, StringBuilder stringBuilder) {
        long l2 = l % 10L;
        long l3 = l % 100L;
        if (l2 == 1L && l3 != 11L) {
            stringBuilder.append("st");
        } else if (l2 == 2L && l3 != 12L) {
            stringBuilder.append("nd");
        } else if (l2 == 3L && l3 != 13L) {
            stringBuilder.append("rd");
        } else {
            stringBuilder.append("th");
        }
    }

    protected static void formatRoman(long l, boolean bl, StringBuilder stringBuilder) {
        while (l > 0L) {
            if (l >= 1000L) {
                stringBuilder.append(bl ? "M" : "m");
                l -= 1000L;
                continue;
            }
            if (l >= 900L) {
                stringBuilder.append(bl ? "CM" : "cm");
                l -= 900L;
                continue;
            }
            if (l >= 500L) {
                stringBuilder.append(bl ? "D" : "d");
                l -= 500L;
                continue;
            }
            if (l >= 400L) {
                stringBuilder.append(bl ? "CD" : "cd");
                l -= 400L;
                continue;
            }
            if (l >= 100L) {
                stringBuilder.append(bl ? "C" : "c");
                l -= 100L;
                continue;
            }
            if (l >= 90L) {
                stringBuilder.append(bl ? "XC" : "xc");
                l -= 90L;
                continue;
            }
            if (l >= 50L) {
                stringBuilder.append(bl ? "L" : "l");
                l -= 50L;
                continue;
            }
            if (l >= 40L) {
                stringBuilder.append(bl ? "XL" : "xl");
                l -= 40L;
                continue;
            }
            if (l >= 10L) {
                stringBuilder.append(bl ? "X" : "x");
                l -= 10L;
                continue;
            }
            if (l >= 9L) {
                stringBuilder.append(bl ? "IX" : "ix");
                l -= 9L;
                continue;
            }
            if (l >= 5L) {
                stringBuilder.append(bl ? "V" : "v");
                l -= 5L;
                continue;
            }
            if (l >= 4L) {
                stringBuilder.append(bl ? "IV" : "iv");
                l -= 4L;
                continue;
            }
            stringBuilder.append(bl ? "I" : "i");
            --l;
        }
    }

    protected static void formatNumberA(long l, boolean bl, StringBuilder stringBuilder) {
        int n;
        if (l == 0L) {
            stringBuilder.append("0");
            return;
        }
        int n2 = stringBuilder.length();
        int n3 = n = bl ? 65 : 97;
        while (l > 0L) {
            char c;
            long l2 = l % 26L;
            l /= 26L;
            if (l2 > 0L) {
                c = (char)((long)n + (l2 - 1L));
            } else {
                c = (char)(n + 25);
                --l;
            }
            stringBuilder.append(c);
        }
        int n4 = n2;
        for (int i = stringBuilder.length() - 1; n4 < i; ++n4, --i) {
            char c = stringBuilder.charAt(n4);
            char c2 = stringBuilder.charAt(i);
            stringBuilder.setCharAt(n4, c2);
            stringBuilder.setCharAt(i, c);
        }
    }

    protected void formatPattern(long l, String string, int n, int n2, StringBuilder stringBuilder) throws E {
        char c;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        String string2 = Long.toString(l);
        int n8 = string2.length() - 1;
        int n9 = stringBuilder.length();
        int n10 = -1;
        int n11 = -1;
        int n12 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n13 = -1;
        for (int i = n2; i >= n; --i) {
            if (Character.isLowSurrogate(string.charAt(i)) && --i < 0) {
                throw this.createInvalidPictureStringException(string);
            }
            n7 = string.codePointAt(i);
            if (Character.isDigit(n7)) {
                if (bl2) {
                    throw this.createInvalidPictureStringException(string);
                }
                bl = false;
                n6 = Character.getNumericValue(n7);
                n5 = n7 - n6;
                if (n13 == -1) {
                    n13 = n5;
                } else if (n13 != n5) {
                    throw this.createInvalidPictureStringException(string);
                }
                ++n12;
                if (n8 >= 0) {
                    n4 = string2.codePointAt(n8);
                    stringBuilder.appendCodePoint(Character.getNumericValue(n4) + n5);
                    --n8;
                    continue;
                }
                stringBuilder.appendCodePoint(n5);
                continue;
            }
            if (n7 == 35) {
                bl2 = true;
                bl = false;
                if (n8 < 0) break;
                n6 = string2.codePointAt(n8);
                n5 = n13 == -1 ? 0 : n13;
                stringBuilder.appendCodePoint(n5 + Character.getNumericValue(n6));
                --n8;
                if (++n12 <= n11) continue;
                n10 = -2;
                continue;
            }
            if (this.ignoreWhitespace() && IntegerFormatter.isWhitespace(n7)) continue;
            if (IntegerFormatter.isGroupingSeparator(n7)) {
                if (i == n2 || i == n || bl) {
                    throw this.createInvalidPictureStringException(string);
                }
                bl = true;
                if (n8 < 0 && !this.hasRemainingDigits(string, i, n)) break;
                stringBuilder.appendCodePoint(n7);
                if (n10 == -1) {
                    n10 = n7;
                    n11 = n12;
                } else if (n10 == n7) {
                    if (n11 == -1) {
                        n11 = n12;
                    } else if (n11 != n12) {
                        n10 = -2;
                    }
                } else {
                    n10 = -2;
                }
                n12 = 0;
                continue;
            }
            throw this.createInvalidPictureStringException(string);
        }
        int n14 = n7 = n13 == -1 ? 0 : n13;
        while (n8 >= 0) {
            if (n10 > 0 && n12 == n11) {
                stringBuilder.appendCodePoint(n10);
                n12 = 0;
            }
            n6 = string2.codePointAt(n8);
            stringBuilder.appendCodePoint(Character.getNumericValue(n6) + n7);
            ++n12;
            --n8;
        }
        n6 = n9;
        n4 = 0;
        for (n5 = stringBuilder.length() - 1; n6 < n5; ++n6, --n5) {
            n3 = stringBuilder.charAt(n6);
            c = stringBuilder.charAt(n5);
            stringBuilder.setCharAt(n5, (char)n3);
            stringBuilder.setCharAt(n6, c);
            if (!IntegerFormatter.isSurrogate(n3) && !IntegerFormatter.isSurrogate(c)) continue;
            n4 = 1;
        }
        if (n4 != 0) {
            for (n3 = n9; n3 < stringBuilder.length() - 1; ++n3) {
                c = stringBuilder.charAt(n3);
                char c2 = stringBuilder.charAt(n3 + '\u0001');
                if (!Character.isSurrogatePair(c2, c)) continue;
                stringBuilder.setCharAt(n3, c2);
                stringBuilder.setCharAt(++n3, c);
            }
        }
    }

    boolean ignoreWhitespace() {
        return false;
    }

    private boolean hasRemainingDigits(String string, int n, int n2) {
        int n3;
        for (int i = n2; i < n; i += Character.charCount(n3)) {
            n3 = string.codePointAt(i);
            if (!Character.isDigit(n3)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSurrogate(int n) {
        return n >= 55296 && n < 57344;
    }

    static boolean isGroupingSeparator(int n) {
        int n2 = Character.getType(n);
        return n2 != 9 && n2 != 10 && n2 != 11 && n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4 && n2 != 5;
    }

    static boolean isWhitespace(int n) {
        return n == 9 || n == 10 || n == 13 || n == 32;
    }
}

