/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.logical;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVLabel;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.logical.TVArc;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVEntityView;
import oracle.dbtools.crest.swingui.logical.TVInheritanceRelation;
import oracle.dbtools.crest.swingui.logical.TVRelation;

public class DPVLogical
extends DesignPartView {
    private static final Dimension TOPVIEW_SIZE = new Dimension(280, 320);

    public DPVLogical(DesignPart desPart) {
        super(desPart);
    }

    public TopView createViewFor(DesignObject object) {
        return this.createTopViewFor(object);
    }

    public Collection getTVTypeSubstitutions() {
        ArrayList col = new ArrayList();
        return col;
    }

    @Override
    public DesignPartView createSubordinateView(DesignPart desPart) {
        return new DPVLogical(this.getDesignPart());
    }

    public boolean canCreateDisplays() {
        return true;
    }

    @Override
    public TopView createTopViewFor(DesignObject object) {
        TopView view = null;
        if (object instanceof Entity) {
            TVEntity tve = new TVEntity(this);
            tve.setModel(object);
            view = tve;
        } else if (object instanceof EntityView) {
            TVEntityView tvev = new TVEntityView(this);
            tvev.setModel(object);
            view = tvev;
        } else if (object instanceof InheritanceRelation) {
            TVInheritanceRelation tvr = new TVInheritanceRelation(this);
            tvr.setModel(object);
            view = tvr;
        } else if (object instanceof Relation) {
            TVRelation tvr = new TVRelation(this);
            tvr.setModel(object);
            view = tvr;
        } else if (object instanceof Arc) {
            TVArc tva = new TVArc(this);
            tva.setModel(object);
            view = tva;
        } else {
            if (object instanceof Note) {
                TVNote tvv = new TVNote(this);
                tvv.setModel(object);
                tvv.setSize(new Dimension(TOPVIEW_SIZE));
                return tvv;
            }
            if (object instanceof Label) {
                TVLabel tvv = new TVLabel(this);
                tvv.setModel(object);
                tvv.setSize(new Dimension(new Dimension(40, 20)));
                return tvv;
            }
            return null;
        }
        view.setSize(new Dimension(TOPVIEW_SIZE));
        this.registerForTreemodel(view);
        return view;
    }

    public Collection getTVEntities() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVEntity)) continue;
            col.add(tv);
        }
        return col;
    }

    public List getTVEntitiesOrderedByHierarchy() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        Iterator tit = ((LogicalDesign)this.getDesignPart()).getEntitySet().iterator();
        while (tit.hasNext()) {
            Entity entity = (Entity)tit.next();
            if (!entity.isHierarchicalEntityType()) continue;
            TopViewCollection tvc = entity.getViewsForDPV(this);
            for (TopView tv : tvc) {
                if (tv == null) continue;
                col.add(tv);
            }
        }
        return col;
    }

    public Collection getTVEntities_HierRoots() {
        HashMap<Entity, Entity> map = new HashMap<Entity, Entity>();
        ArrayList<TopView> col = new ArrayList<TopView>();
        Iterator tit = ((LogicalDesign)this.getDesignPart()).getEntitySet().iterator();
        while (tit.hasNext()) {
            Entity entity = (Entity)tit.next();
            if (entity.isHierarchicalEntityType() && this.isBoxInBox()) {
                TopView tv = this.getTopVisisbleParent(entity);
                if (tv == null || map.get(entity = (Entity)tv.getModel()) != null) continue;
                map.put(entity, entity);
                col.add(tv);
                continue;
            }
            TopViewCollection tvc = entity.getViewsForDPV(this);
            for (TopView tv : tvc) {
                if (tv == null) continue;
                col.add(tv);
            }
        }
        return col;
    }

    private TopView getTopVisisbleParent(Entity ent) {
        if (ent.isHierarchicalEntityType()) {
            TopView rtv = ent.getFirstViewForDPV(this);
            while (ent.getHierarchicalParent() != null) {
                TopView tv = (ent = ent.getHierarchicalParent()).getFirstViewForDPV(this);
                if (tv == null) continue;
                rtv = tv;
            }
            return rtv;
        }
        return ent.getFirstViewForDPV(this);
    }

    public List getEntities() {
        Map map = this.getEntitiesMap();
        if (map.size() > 0) {
            return Arrays.asList(map.values().toArray());
        }
        return Collections.EMPTY_LIST;
    }

    private Map getEntitiesMap() {
        HashMap<DesignObject, DesignObject> map = new HashMap<DesignObject, DesignObject>();
        for (TopView tv : this.getTVShapes()) {
            DesignObject dobj = tv.getModel();
            if (dobj == null || !(dobj instanceof Entity)) continue;
            map.put(dobj, dobj);
        }
        return map;
    }

    public List getPossibleConnectors() {
        ArrayList<Relation> list = new ArrayList<Relation>();
        Map map = this.getEntitiesMap();
        Iterator it = ((LogicalDesign)this.getDesignPart()).getRelationSet().iterator();
        while (it.hasNext()) {
            Relation rel = (Relation)it.next();
            DesignObject source = rel.getSourceObject();
            DesignObject target = rel.getTargetObject();
            if (source == null || target == null || map.get(target) == null || map.get(source) == null) continue;
            list.add(rel);
        }
        return list;
    }

    public Collection getTVFKRelations() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        Iterator fit = ((LogicalDesign)this.getDesignPart()).getRelationSet().iterator();
        while (fit.hasNext()) {
            Relation fk = (Relation)fit.next();
            TopView tv = fk.getViewFor(this);
            if (tv == null) continue;
            col.add(tv);
        }
        return col;
    }

    public Collection getTVEntityViews() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        Iterator it = ((LogicalDesign)this.getDesignPart()).getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView entityView = (EntityView)it.next();
            TopViewCollection tvCollection = entityView.getViewsForDPV(this);
            for (TopView tv : tvCollection) {
                if (tv == null) continue;
                col.add(tv);
            }
        }
        return col;
    }

    public Collection getTVEntitiesAndTVViews() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVEntity) && !(tv instanceof TVEntityView)) continue;
            col.add(tv);
        }
        return col;
    }

    public Collection getTVViews() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        Iterator it = ((LogicalDesign)this.getDesignPart()).getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView view = (EntityView)it.next();
            TopViewCollection tvCollection = view.getViewsForDPV(this);
            for (TopView tv : tvCollection) {
                if (tv == null) continue;
                col.add(tv);
            }
        }
        return col;
    }

    protected String getDataType(ContainedObjectWithDomain element) {
        String formulaDesc = element.getFormulaDesc();
        if (formulaDesc != null && formulaDesc.length() > 0 && ("Derived".equalsIgnoreCase(element.getSourceType()) || "Aggregate".equalsIgnoreCase(element.getSourceType()) || element instanceof Column && ((Column)element).isComputed().booleanValue())) {
            return formulaDesc;
        }
        if (element instanceof Attribute) {
            return ((Attribute)element).getLogicalRepresentationName();
        }
        if (element.isReference() && element.getDataType() instanceof StructuredType) {
            return "REF " + element.getDataType().toString();
        }
        Datatype datatype = element.getDataType();
        if (datatype != null) {
            return datatype.toString();
        }
        return "";
    }

    public boolean isSupportLineHiding() {
        return true;
    }

    @Override
    public void setShowRelAttributes(boolean showRelAttributes) {
        super.setShowRelAttributes(showRelAttributes);
        this.displayRelationAttributes();
    }

    public void displayRelationAttributes() {
        Object[] cellViews = this.getTopviewsList().toArray();
        for (int j = 0; j < cellViews.length; ++j) {
            TopView tv = (TopView)cellViews[j];
            if (!tv.isConnection() || !(tv instanceof TVRelation)) continue;
            ((TVRelation)tv).displayRelationAttributes();
        }
    }
}

