/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v12c;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;

public class TableProxyOraclev12c
extends TableProxyOraclev11g {
    public static final String NO_MEMCOMPRESS = "NO MEMCOMPRESS";
    public static final String FOR_DML = "FOR DML";
    public static final String FOR_QUERY = "FOR QUERY";
    public static final String FOR_QUERY_LOW = "FOR QUERY LOW";
    public static final String FOR_QUERY_HIGH = "FOR QUERY HIGH";
    public static final String FOR_CAPACITY = "FOR CAPACITY";
    public static final String FOR_CAPACITY_LOW = "FOR CAPACITY LOW";
    public static final String FOR_CAPACITY_HIGH = "FOR CAPACITY HIGH";
    private static final String[] INMEMORY_COMPRESSION_CHOICES = new String[]{"", "NO MEMCOMPRESS", "FOR DML", "FOR QUERY", "FOR QUERY LOW", "FOR QUERY HIGH", "FOR CAPACITY", "FOR CAPACITY LOW", "FOR CAPACITY HIGH"};
    public static final String NONE = "NONE";
    public static final String LOW = "LOW";
    public static final String MEDIUM = "MEDIUM";
    public static final String HIGH = "HIGH";
    public static final String CRITICAL = "CRITICAL";
    private static final String[] INMEMORY_PRIORITY_CHOICES = new String[]{"", "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"};
    public static final String AUTO = "AUTO";
    public static final String BY_ROWID_RANGE = "BY ROWID RANGE";
    public static final String BY_PARTITION = "BY PARTITION";
    public static final String BY_SUBPARTITION = "BY SUBPARTITION";
    private static final String[] INMEMORY_DISTRIBUTE_CHOICES = new String[]{"", "AUTO", "BY ROWID RANGE", "BY PARTITION", "BY SUBPARTITION"};
    public static final String NO_DUPLICATE = "NO DUPLICATE";
    public static final String DUPLICATE = "DUPLICATE";
    public static final String DUPLICATE_ALL = "DUPLICATE ALL";
    private static final String[] INMEMORY_DUPLICATE_CHOICES = new String[]{"", "NO DUPLICATE", "DUPLICATE", "DUPLICATE ALL"};
    private static Set inMemoryCompressionSet = null;
    private static Set inMemoryPrioritySet = null;
    private static Set inMemoryDistributeSet = null;
    private static Set inMemoryDuplicateSet = null;
    private String inMemory = "";
    private String inMemoryCompression = "";
    private String inMemoryPriority = "";
    private String inMemoryDistribute = "";
    private String inMemoryDuplicate = "";

    public TableProxyOraclev12c(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
    }

    public TableProxyOraclev12c(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public String getInMemory() {
        return this.inMemory;
    }

    public void setInMemory(String value) {
        if (!this.inMemory.equals(value) && (ConstantsOracle.checkYesNo(value) || "".equals(value))) {
            this.inMemory = value;
            this.fireDataFieldChange();
        }
    }

    public String getInMemoryCompression() {
        return this.inMemoryCompression;
    }

    public void setInMemoryCompression(String inMemoryCompression) {
        if (!this.inMemoryCompression.equals(inMemoryCompression) && this.checkInMemoryCompression(inMemoryCompression)) {
            this.inMemoryCompression = inMemoryCompression;
            this.fireDataFieldChange();
        }
    }

    private boolean checkInMemoryCompression(String value) {
        if (inMemoryCompressionSet == null) {
            inMemoryCompressionSet = new HashSet();
            inMemoryCompressionSet.addAll(Arrays.asList(TableProxyOraclev12c.getInMemoryCompressionValues()));
        }
        return inMemoryCompressionSet.contains(value);
    }

    public static String[] getInMemoryCompressionValues() {
        return INMEMORY_COMPRESSION_CHOICES;
    }

    public String getInMemoryPriority() {
        return this.inMemoryPriority;
    }

    public void setInMemoryPriority(String inMemoryPriority) {
        if (!this.inMemoryPriority.equals(inMemoryPriority) && this.checkInMemoryPriority(inMemoryPriority)) {
            this.inMemoryPriority = inMemoryPriority;
            this.fireDataFieldChange();
        }
    }

    private boolean checkInMemoryPriority(String value) {
        if (inMemoryPrioritySet == null) {
            inMemoryPrioritySet = new HashSet();
            inMemoryPrioritySet.addAll(Arrays.asList(TableProxyOraclev12c.getInMemoryPriorityValues()));
        }
        return inMemoryPrioritySet.contains(value);
    }

    public static String[] getInMemoryPriorityValues() {
        return INMEMORY_PRIORITY_CHOICES;
    }

    public String getInMemoryDistribute() {
        return this.inMemoryDistribute;
    }

    public void setInMemoryDistribute(String inMemoryDistribute) {
        if (!this.inMemoryDistribute.equals(inMemoryDistribute) && this.checkInMemoryDistribute(inMemoryDistribute)) {
            this.inMemoryDistribute = inMemoryDistribute;
            this.fireDataFieldChange();
        }
    }

    private boolean checkInMemoryDistribute(String value) {
        if (inMemoryDistributeSet == null) {
            inMemoryDistributeSet = new HashSet();
            inMemoryDistributeSet.addAll(Arrays.asList(TableProxyOraclev12c.getInMemoryDistributeValues()));
        }
        return inMemoryDistributeSet.contains(value);
    }

    public static String[] getInMemoryDistributeValues() {
        return INMEMORY_DISTRIBUTE_CHOICES;
    }

    public String getInMemoryDuplicate() {
        return this.inMemoryDuplicate;
    }

    public void setInMemoryDuplicate(String inMemoryDuplicate) {
        if (!this.inMemoryDuplicate.equals(inMemoryDuplicate) && this.checkInMemoryDuplicate(inMemoryDuplicate)) {
            this.inMemoryDuplicate = inMemoryDuplicate;
            this.fireDataFieldChange();
        }
    }

    private boolean checkInMemoryDuplicate(String value) {
        if (inMemoryDuplicateSet == null) {
            inMemoryDuplicateSet = new HashSet();
            inMemoryDuplicateSet.addAll(Arrays.asList(TableProxyOraclev12c.getInMemoryDuplicateValues()));
        }
        return inMemoryDuplicateSet.contains(value);
    }

    public static String[] getInMemoryDuplicateValues() {
        return INMEMORY_DUPLICATE_CHOICES;
    }
}

