/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.crest.model.IDReplacer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.util.GUID;

public class SupplementalLogGroup
implements IDReplacer {
    String id;
    String columns = "";
    String columnsNoLog = "";
    String name;
    String condition = TableProxyOraclev10g.ON_UPDATE;
    StorageDesign storageDesign;

    public SupplementalLogGroup(StorageDesign storageDesign) {
        this.id = new GUID().toString();
        this.storageDesign = storageDesign;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getColumns() {
        if (this.columns == null) {
            return "";
        }
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public String getColumnsNoLog() {
        if (this.columnsNoLog == null) {
            return "";
        }
        return this.columnsNoLog;
    }

    public void setColumnsNoLog(String columnsNoLog) {
        this.columnsNoLog = columnsNoLog;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    @Override
    public String replaceIDsInValue(String value) {
        return this.storageDesign.getDesign().replaceIDsInValue(value);
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public void setStorageDesign(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    public String toString() {
        return this.getName();
    }

    private List<String> getNamesFromIDs(String names) {
        if (!names.isEmpty()) {
            String[] parts;
            ArrayList<String> list = new ArrayList<String>();
            for (String p : parts = names.split(",")) {
                StorageObject so = this.storageDesign.getStorageObject(p.trim());
                list.add(so.getName());
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public List<String> getColumsNames() {
        return this.getNamesFromIDs(this.columns);
    }

    public List<String> getColumsNoLogNames() {
        return this.getNamesFromIDs(this.columnsNoLog);
    }

    public String getColumnsDDLPresentation() {
        String spp1 = this.storageDesign.getFormatedNamesFromIDs(this.getColumns(), this.storageDesign.getColumnProxySet());
        String spp2 = this.storageDesign.getFormatedNamesNoLogFromIDs(this.getColumnsNoLog(), this.storageDesign.getColumnProxySet());
        if (!spp1.isEmpty() && !spp2.isEmpty()) {
            spp1 = spp1 + "," + spp2;
        } else if (!spp2.isEmpty()) {
            spp1 = spp2;
        }
        return "(" + spp1 + ")";
    }

    public String getComparatorPresentation() {
        String cpres = this.getColumnsDDLPresentation();
        if (TableProxyOraclev10g.ALWAYS.equals(this.getCondition())) {
            return this.getName() + cpres + TableProxyOraclev10g.ALWAYS;
        }
        return this.getName() + cpres;
    }

    public boolean equivelentTo(SupplementalLogGroup sg) {
        if (!this.name.equalsIgnoreCase(sg.getName())) {
            return false;
        }
        if (!this.condition.equalsIgnoreCase(sg.getCondition())) {
            return false;
        }
        List<String> l1 = this.getColumsNames();
        List<String> l2 = sg.getColumsNames();
        if (l1.size() != l2.size()) {
            return false;
        }
        l1.removeAll(l2);
        if (l1.size() > 0) {
            return false;
        }
        l1 = this.getColumsNoLogNames();
        l2 = sg.getColumsNoLogNames();
        if (l1.size() != l2.size()) {
            return false;
        }
        l1.removeAll(l2);
        return l1.size() <= 0;
    }

    public static SupplementalLogGroup getByName(List<SupplementalLogGroup> list, String name) {
        for (SupplementalLogGroup sg : list) {
            if (!name.equalsIgnoreCase(sg.getName())) continue;
            return sg;
        }
        return null;
    }
}

